/*
 * Decompiled with CFR 0.152.
 */
package com.edb.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class StreamWrapper {
    private final InputStream stream;
    private final byte[] rawData;
    private final int offset;
    private final int length;

    public StreamWrapper(byte[] data, int offset, int length) {
        this.stream = null;
        this.rawData = data;
        this.offset = offset;
        this.length = length;
    }

    public StreamWrapper(InputStream stream, int length) {
        this.stream = stream;
        this.rawData = null;
        this.offset = 0;
        this.length = length;
    }

    public InputStream getStream() {
        if (this.stream != null) {
            return this.stream;
        }
        return new ByteArrayInputStream(this.rawData, this.offset, this.length);
    }

    public int getLength() {
        return this.length;
    }

    public int getOffset() {
        return this.offset;
    }

    public byte[] getBytes() {
        return this.rawData;
    }

    public String toString() {
        return "<stream of " + this.length + " bytes>";
    }
}

