/*
 * Decompiled with CFR 0.152.
 */
package com.edb.jdbc2;

import com.edb.Driver;
import com.edb.PGNotification;
import com.edb.copy.CopyManager;
import com.edb.core.BaseConnection;
import com.edb.core.BaseStatement;
import com.edb.core.ConnectionFactory;
import com.edb.core.Encoding;
import com.edb.core.Field;
import com.edb.core.Logger;
import com.edb.core.Oid;
import com.edb.core.ProtocolConnection;
import com.edb.core.Query;
import com.edb.core.QueryExecutor;
import com.edb.core.ResultCursor;
import com.edb.core.ResultHandler;
import com.edb.core.TypeInfo;
import com.edb.core.Utils;
import com.edb.fastpath.Fastpath;
import com.edb.geometric.PGbox;
import com.edb.geometric.PGcircle;
import com.edb.geometric.PGline;
import com.edb.geometric.PGlseg;
import com.edb.geometric.PGpath;
import com.edb.geometric.PGpoint;
import com.edb.geometric.PGpolygon;
import com.edb.jdbc2.AbstractJdbc2Statement;
import com.edb.jdbc2.TimestampUtils;
import com.edb.jdbc2.TypeInfoCache;
import com.edb.largeobject.LargeObjectManager;
import com.edb.util.GT;
import com.edb.util.HostSpec;
import com.edb.util.PGBinaryObject;
import com.edb.util.PGInterval;
import com.edb.util.PGmoney;
import com.edb.util.PGobject;
import com.edb.util.PSQLException;
import com.edb.util.PSQLState;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.CallableStatement;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;

public abstract class AbstractJdbc2Connection
implements BaseConnection {
    private static int nextConnectionID = 1;
    private final Logger logger;
    private final String creatingURL;
    private Throwable openStackTrace;
    private final ProtocolConnection protoConnection;
    private final String compatible;
    private final String dbVersionNumber;
    private final Query commitQuery;
    private final Query rollbackQuery;
    private TypeInfo _typeCache;
    private boolean disableColumnSanitiser = false;
    protected int prepareThreshold;
    public boolean autoCommit = true;
    public boolean readOnly = false;
    public final boolean bindStringAsVarchar;
    public SQLWarning firstWarning = null;
    private Set useBinarySendForOids;
    private Set useBinaryReceiveForOids;
    private final TimestampUtils timestampUtils;
    protected Map typemap;
    private Fastpath fastpath = null;
    private LargeObjectManager largeobject = null;
    protected DatabaseMetaData metadata;
    private CopyManager copyManager = null;
    private String serverName;
    static final String[] jdbc2Types = new String[]{"int2", "int4", "oid", "int8", "cash", "money", "numeric", "float4", "float8", "bpchar", "char", "char2", "char4", "char8", "char16", "varchar,varchar2", "text", "name", "filename", "bytea", "bool", "bit", "date", "time", "timetz", "abstime", "timestamp", "timestamptz", "_bool", "_char", "_int2", "_int4", "_text", "_oid", "_varchar", "_int8", "_float4", "_float8", "_abstime", "_date", "_time", "_timestamp", "_numeric", "_bytea"};
    static final int[] jdbc2Typei = new int[]{5, 4, 4, -5, 8, 8, 2, 7, 8, 1, 1, 1, 1, 1, 1, 12, 12, 12, 12, 12, -2, -7, -7, 91, 92, 92, 93, 93, 93, 2003, 2003, 2003, 2003, 2003, 2003, 2003, 2003, 2003, 2003, 2003, 2003, 2003, 2003, 2003, 2003};

    @Override
    public abstract DatabaseMetaData getMetaData() throws SQLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected AbstractJdbc2Connection(HostSpec[] hostSpecs, String user, String database, Properties info, String url) throws SQLException {
        this.creatingURL = url;
        int logLevel = Driver.getLogLevel();
        String connectionLogLevel = info.getProperty("loglevel");
        if (connectionLogLevel != null) {
            try {
                logLevel = Integer.parseInt(connectionLogLevel);
            }
            catch (Exception l_e) {
                // empty catch block
            }
        }
        Class<AbstractJdbc2Connection> l_e = AbstractJdbc2Connection.class;
        synchronized (AbstractJdbc2Connection.class) {
            String stringType;
            this.logger = new Logger(nextConnectionID++);
            this.logger.setLogLevel(logLevel);
            // ** MonitorExit[l_e] (shouldn't be in output)
            if (logLevel > 0) {
                this.enableDriverManagerLogging();
            }
            this.prepareThreshold = 5;
            try {
                this.prepareThreshold = Integer.parseInt(info.getProperty("prepareThreshold", "5"));
                if (this.prepareThreshold < 0) {
                    this.prepareThreshold = 0;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            boolean binaryTransfer = true;
            try {
                binaryTransfer = Boolean.valueOf(info.getProperty("binaryTransfer", "true"));
            }
            catch (Exception e) {
                // empty catch block
            }
            if (this.logger.logInfo()) {
                this.logger.info(Driver.getVersion());
            }
            this.protoConnection = ConnectionFactory.openConnection(hostSpecs, user, database, info, this.logger);
            this.dbVersionNumber = this.protoConnection.getServerVersion();
            this.serverName = this.protoConnection.getServerName();
            this.compatible = info.getProperty("compatible", "9.3");
            if (Boolean.valueOf(info.getProperty("readOnly", "false")).booleanValue()) {
                this.setReadOnly(true);
            }
            HashSet<Integer> binaryOids = new HashSet<Integer>();
            if (binaryTransfer && this.protoConnection.getProtocolVersion() >= 3) {
                binaryOids.add(new Integer(17));
                binaryOids.add(new Integer(21));
                binaryOids.add(new Integer(23));
                binaryOids.add(new Integer(20));
                binaryOids.add(new Integer(700));
                binaryOids.add(new Integer(701));
                binaryOids.add(new Integer(1083));
                binaryOids.add(new Integer(1082));
                binaryOids.add(new Integer(1266));
                binaryOids.add(new Integer(1114));
                binaryOids.add(new Integer(1184));
                binaryOids.add(new Integer(1005));
                binaryOids.add(new Integer(1007));
                binaryOids.add(new Integer(1016));
                binaryOids.add(new Integer(1021));
                binaryOids.add(new Integer(1022));
                binaryOids.add(new Integer(1022));
                binaryOids.add(new Integer(1015));
                binaryOids.add(new Integer(1009));
                binaryOids.add(new Integer(600));
                binaryOids.add(new Integer(603));
                binaryOids.add(new Integer(2950));
            }
            if (!this.haveMinimumCompatibleVersion("8.0")) {
                binaryOids.remove(new Integer(1083));
                binaryOids.remove(new Integer(1266));
                binaryOids.remove(new Integer(1114));
                binaryOids.remove(new Integer(1184));
            }
            if (!this.haveMinimumCompatibleVersion("8.3")) {
                binaryOids.remove(new Integer(1005));
                binaryOids.remove(new Integer(1007));
                binaryOids.remove(new Integer(1016));
                binaryOids.remove(new Integer(1021));
                binaryOids.remove(new Integer(1022));
                binaryOids.remove(new Integer(1022));
                binaryOids.remove(new Integer(1015));
                binaryOids.remove(new Integer(1009));
            }
            binaryOids.addAll(this.getOidSet(info.getProperty("binaryTransferEnable", "")));
            binaryOids.removeAll(this.getOidSet(info.getProperty("binaryTransferDisable", "")));
            this.useBinarySendForOids = new HashSet();
            this.useBinarySendForOids.addAll(binaryOids);
            this.useBinaryReceiveForOids = new HashSet();
            this.useBinaryReceiveForOids.addAll(binaryOids);
            this.useBinarySendForOids.remove(new Integer(1082));
            this.protoConnection.setBinaryReceiveOids(this.useBinaryReceiveForOids);
            boolean oracleCase = Boolean.valueOf(info.getProperty("oracleCase"));
            if (oracleCase) {
                System.setProperty("oracleCase", "true");
            }
            if (this.logger.logDebug()) {
                this.logger.debug("    compatible = " + this.compatible);
                this.logger.debug("    loglevel = " + logLevel);
                this.logger.debug("    prepare threshold = " + this.prepareThreshold);
                this.logger.debug("    types using binary send = " + this.oidsToString(this.useBinarySendForOids));
                this.logger.debug("    types using binary receive = " + this.oidsToString(this.useBinaryReceiveForOids));
                this.logger.debug("    integer date/time = " + this.protoConnection.getIntegerDateTimes());
                this.logger.debug("    oracleCase = " + System.getProperty("oracleCase"));
            }
            if ((stringType = info.getProperty("stringtype")) != null) {
                if (stringType.equalsIgnoreCase("unspecified")) {
                    this.bindStringAsVarchar = false;
                } else {
                    if (!stringType.equalsIgnoreCase("varchar")) throw new PSQLException(GT.tr("Unsupported value for stringtype parameter: {0}", stringType), PSQLState.INVALID_PARAMETER_VALUE);
                    this.bindStringAsVarchar = true;
                }
            } else {
                this.bindStringAsVarchar = this.haveMinimumCompatibleVersion("8.0");
            }
            this.timestampUtils = new TimestampUtils(this.haveMinimumServerVersion("7.4"), this.haveMinimumServerVersion("8.2"), !this.protoConnection.getIntegerDateTimes());
            this.commitQuery = this.getQueryExecutor().createSimpleQuery("COMMIT");
            this.rollbackQuery = this.getQueryExecutor().createSimpleQuery("ROLLBACK");
            int unknownLength = Integer.MAX_VALUE;
            String strLength = info.getProperty("unknownLength");
            if (strLength != null) {
                try {
                    unknownLength = Integer.parseInt(strLength);
                }
                catch (NumberFormatException nfe) {
                    throw new PSQLException(GT.tr("unknownLength parameter value must be an integer"), PSQLState.INVALID_PARAMETER_VALUE, (Throwable)nfe);
                }
            }
            this._typeCache = this.createTypeInfo(this, unknownLength);
            this.initObjectTypes(info);
            if (Boolean.valueOf(info.getProperty("logUnclosedConnections")).booleanValue()) {
                this.openStackTrace = new Throwable("Connection was created at this point:");
                this.enableDriverManagerLogging();
            }
            this.disableColumnSanitiser = Boolean.valueOf(info.getProperty("disableColumnSanitiser", Boolean.FALSE.toString()));
            return;
        }
    }

    private Set getOidSet(String oidList) throws PSQLException {
        HashSet<Integer> oids = new HashSet<Integer>();
        StringTokenizer tokenizer = new StringTokenizer(oidList, ",");
        while (tokenizer.hasMoreTokens()) {
            String oid = tokenizer.nextToken();
            oids.add(new Integer(Oid.valueOf(oid)));
        }
        return oids;
    }

    private String oidsToString(Set oids) {
        StringBuffer sb = new StringBuffer();
        for (Integer oid : oids) {
            sb.append(Oid.toString(oid));
            sb.append(',');
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        } else {
            sb.append(" <none>");
        }
        return sb.toString();
    }

    @Override
    public TimestampUtils getTimestampUtils() {
        return this.timestampUtils;
    }

    @Override
    public Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007);
    }

    @Override
    public abstract Statement createStatement(int var1, int var2) throws SQLException;

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, 1003, 1007);
    }

    @Override
    public abstract PreparedStatement prepareStatement(String var1, int var2, int var3) throws SQLException;

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        return this.prepareCall(sql, 1003, 1007);
    }

    @Override
    public abstract CallableStatement prepareCall(String var1, int var2, int var3) throws SQLException;

    public Map getTypeMap() throws SQLException {
        this.checkClosed();
        return this.typemap;
    }

    @Override
    public QueryExecutor getQueryExecutor() {
        return this.protoConnection.getQueryExecutor();
    }

    public void addWarning(SQLWarning warn) {
        if (this.firstWarning != null) {
            this.firstWarning.setNextWarning(warn);
        } else {
            this.firstWarning = warn;
        }
    }

    @Override
    public ResultSet execSQLQuery(String s) throws SQLException {
        return this.execSQLQuery(s, 1003, 1007);
    }

    @Override
    public ResultSet execSQLQuery(String s, int resultSetType, int resultSetConcurrency) throws SQLException {
        BaseStatement stat = (BaseStatement)this.createStatement(resultSetType, resultSetConcurrency);
        boolean hasResultSet = stat.executeWithFlags(s, 16);
        while (!hasResultSet && stat.getUpdateCount() != -1) {
            hasResultSet = stat.getMoreResults();
        }
        if (!hasResultSet) {
            throw new PSQLException(GT.tr("No results were returned by the query."), PSQLState.NO_DATA);
        }
        SQLWarning warnings = stat.getWarnings();
        if (warnings != null) {
            this.addWarning(warnings);
        }
        return stat.getResultSet();
    }

    @Override
    public void execSQLUpdate(String s) throws SQLException {
        BaseStatement stmt = (BaseStatement)this.createStatement();
        if (stmt.executeWithFlags(s, 22)) {
            throw new PSQLException(GT.tr("A result was returned when none was expected."), PSQLState.TOO_MANY_RESULTS);
        }
        SQLWarning warnings = stmt.getWarnings();
        if (warnings != null) {
            this.addWarning(warnings);
        }
        stmt.close();
    }

    public void setCursorName(String cursor) throws SQLException {
        this.checkClosed();
    }

    public String getCursorName() throws SQLException {
        this.checkClosed();
        return null;
    }

    public String getURL() throws SQLException {
        return this.creatingURL;
    }

    public String getUserName() throws SQLException {
        return this.protoConnection.getUser();
    }

    @Override
    public Fastpath getFastpathAPI() throws SQLException {
        this.checkClosed();
        if (this.fastpath == null) {
            this.fastpath = new Fastpath(this);
        }
        return this.fastpath;
    }

    @Override
    public LargeObjectManager getLargeObjectAPI() throws SQLException {
        this.checkClosed();
        if (this.largeobject == null) {
            this.largeobject = new LargeObjectManager(this);
        }
        return this.largeobject;
    }

    @Override
    public Object getObject(String type, String value, byte[] byteValue) throws SQLException {
        Class c;
        if (this.typemap != null && (c = (Class)this.typemap.get(type)) != null) {
            throw new PSQLException(GT.tr("Custom type maps are not supported."), PSQLState.NOT_IMPLEMENTED);
        }
        PGobject obj = null;
        if (this.logger.logDebug()) {
            this.logger.debug("Constructing object from type=" + type + " value=<" + value + ">");
        }
        try {
            Class klass = this._typeCache.getPGobject(type);
            if (klass != null) {
                obj = (PGobject)klass.newInstance();
                obj.setType(type);
                if (byteValue != null && obj instanceof PGBinaryObject) {
                    PGBinaryObject binObj = (PGBinaryObject)((Object)obj);
                    binObj.setByteValue(byteValue, 0);
                } else {
                    obj.setValue(value);
                }
            } else {
                obj = new PGobject();
                obj.setType(type);
                obj.setValue(value);
            }
            return obj;
        }
        catch (SQLException sx) {
            throw sx;
        }
        catch (Exception ex) {
            throw new PSQLException(GT.tr("Failed to create object for: {0}.", type), PSQLState.CONNECTION_FAILURE, (Throwable)ex);
        }
    }

    protected TypeInfo createTypeInfo(BaseConnection conn, int unknownLength) {
        return new TypeInfoCache(conn, unknownLength);
    }

    @Override
    public TypeInfo getTypeInfo() {
        return this._typeCache;
    }

    @Override
    public void addDataType(String type, String name) {
        try {
            this.addDataType(type, Class.forName(name));
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot register new type: " + e);
        }
    }

    @Override
    public void addDataType(String type, Class klass) throws SQLException {
        this.checkClosed();
        this._typeCache.addDataType(type, klass);
    }

    private void initObjectTypes(Properties info) throws SQLException {
        this.addDataType("box", PGbox.class);
        this.addDataType("circle", PGcircle.class);
        this.addDataType("line", PGline.class);
        this.addDataType("lseg", PGlseg.class);
        this.addDataType("path", PGpath.class);
        this.addDataType("point", PGpoint.class);
        this.addDataType("polygon", PGpolygon.class);
        this.addDataType("money", PGmoney.class);
        this.addDataType("interval", PGInterval.class);
        Enumeration<?> e = info.propertyNames();
        while (e.hasMoreElements()) {
            Class<?> klass;
            String propertyName = (String)e.nextElement();
            if (!propertyName.startsWith("datatype.")) continue;
            String typeName = propertyName.substring(9);
            String className = info.getProperty(propertyName);
            try {
                klass = Class.forName(className);
            }
            catch (ClassNotFoundException cnfe) {
                throw new PSQLException(GT.tr("Unable to load the class {0} responsible for the datatype {1}", new Object[]{className, typeName}), PSQLState.SYSTEM_ERROR, (Throwable)cnfe);
            }
            this.addDataType(typeName, klass);
        }
    }

    @Override
    public void close() {
        this.protoConnection.close();
        this.openStackTrace = null;
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.checkClosed();
        StringBuffer buf = new StringBuffer(sql.length());
        AbstractJdbc2Statement.parseSql(sql, 0, buf, false, this.getStandardConformingStrings());
        return buf.toString();
    }

    @Override
    public synchronized SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        SQLWarning newWarnings = this.protoConnection.getWarnings();
        if (this.firstWarning == null) {
            this.firstWarning = newWarnings;
        } else {
            this.firstWarning.setNextWarning(newWarnings);
        }
        return this.firstWarning;
    }

    @Override
    public synchronized void clearWarnings() throws SQLException {
        this.checkClosed();
        this.protoConnection.getWarnings();
        this.firstWarning = null;
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.checkClosed();
        if (this.protoConnection.getTransactionState() != 0) {
            throw new PSQLException(GT.tr("Cannot change transaction read-only property in the middle of a transaction."), PSQLState.ACTIVE_SQL_TRANSACTION);
        }
        if (this.haveMinimumServerVersion("7.4") && readOnly != this.readOnly) {
            String readOnlySql = "SET SESSION CHARACTERISTICS AS TRANSACTION " + (readOnly ? "READ ONLY" : "READ WRITE");
            this.execSQLUpdate(readOnlySql);
        }
        this.readOnly = readOnly;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.checkClosed();
        return this.readOnly;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkClosed();
        if (this.autoCommit == autoCommit) {
            return;
        }
        if (!this.autoCommit) {
            this.commit();
        }
        this.autoCommit = autoCommit;
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.checkClosed();
        return this.autoCommit;
    }

    private void executeTransactionCommand(Query query) throws SQLException {
        int flags = 22;
        if (this.prepareThreshold == 0) {
            flags |= 1;
        }
        this.getQueryExecutor().execute(query, null, new TransactionCommandHandler(), 0, 0, flags);
    }

    @Override
    public void commit() throws SQLException {
        this.checkClosed();
        if (this.autoCommit) {
            throw new PSQLException(GT.tr("Cannot commit when autoCommit is enabled."), PSQLState.NO_ACTIVE_SQL_TRANSACTION);
        }
        if (this.protoConnection.getTransactionState() != 0) {
            this.executeTransactionCommand(this.commitQuery);
        }
    }

    protected void checkClosed() throws SQLException {
        if (this.isClosed()) {
            throw new PSQLException(GT.tr("This connection has been closed."), PSQLState.CONNECTION_DOES_NOT_EXIST);
        }
    }

    @Override
    public void rollback() throws SQLException {
        this.checkClosed();
        if (this.autoCommit) {
            throw new PSQLException(GT.tr("Cannot rollback when autoCommit is enabled."), PSQLState.NO_ACTIVE_SQL_TRANSACTION);
        }
        if (this.protoConnection.getTransactionState() != 0) {
            this.executeTransactionCommand(this.rollbackQuery);
        }
    }

    @Override
    public int getTransactionState() {
        return this.protoConnection.getTransactionState();
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.checkClosed();
        String level = null;
        if (this.haveMinimumServerVersion("7.3")) {
            ResultSet rs = this.execSQLQuery("SHOW TRANSACTION ISOLATION LEVEL");
            if (rs.next()) {
                level = rs.getString(1);
            }
            rs.close();
        } else {
            SQLWarning saveWarnings = this.getWarnings();
            this.clearWarnings();
            this.execSQLUpdate("SHOW TRANSACTION ISOLATION LEVEL");
            SQLWarning warning = this.getWarnings();
            if (warning != null) {
                level = warning.getMessage();
            }
            this.clearWarnings();
            if (saveWarnings != null) {
                this.addWarning(saveWarnings);
            }
        }
        if (level == null) {
            return 2;
        }
        if ((level = level.toUpperCase(Locale.US)).indexOf("READ COMMITTED") != -1) {
            return 2;
        }
        if (level.indexOf("READ UNCOMMITTED") != -1) {
            return 1;
        }
        if (level.indexOf("REPEATABLE READ") != -1) {
            return 4;
        }
        if (level.indexOf("SERIALIZABLE") != -1) {
            return 8;
        }
        return 2;
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.checkClosed();
        if (this.protoConnection.getTransactionState() != 0) {
            throw new PSQLException(GT.tr("Cannot change transaction isolation level in the middle of a transaction."), PSQLState.ACTIVE_SQL_TRANSACTION);
        }
        String isolationLevelName = this.getIsolationLevelName(level);
        if (isolationLevelName == null) {
            throw new PSQLException(GT.tr("Transaction isolation level {0} not supported.", new Integer(level)), PSQLState.NOT_IMPLEMENTED);
        }
        String isolationLevelSQL = "SET SESSION CHARACTERISTICS AS TRANSACTION ISOLATION LEVEL " + isolationLevelName;
        this.execSQLUpdate(isolationLevelSQL);
    }

    protected String getIsolationLevelName(int level) {
        boolean pg80 = this.haveMinimumServerVersion("8.0");
        if (level == 2) {
            return "READ COMMITTED";
        }
        if (level == 8) {
            return "SERIALIZABLE";
        }
        if (pg80 && level == 1) {
            return "READ UNCOMMITTED";
        }
        if (pg80 && level == 4) {
            return "REPEATABLE READ";
        }
        return null;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.checkClosed();
    }

    @Override
    public String getCatalog() throws SQLException {
        this.checkClosed();
        return this.protoConnection.getDatabase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.openStackTrace != null) {
                this.logger.log(GT.tr("Finalizing a Connection that was never closed:"), this.openStackTrace);
            }
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    public String getDBVersionNumber() {
        return this.dbVersionNumber;
    }

    private static int integerPart(String dirtyString) {
        int end;
        int start;
        for (start = 0; start < dirtyString.length() && !Character.isDigit(dirtyString.charAt(start)); ++start) {
        }
        for (end = start; end < dirtyString.length() && Character.isDigit(dirtyString.charAt(end)); ++end) {
        }
        if (start == end) {
            return 0;
        }
        return Integer.parseInt(dirtyString.substring(start, end));
    }

    public int getServerMajorVersion() {
        try {
            StringTokenizer versionTokens = new StringTokenizer(this.dbVersionNumber, ".");
            return AbstractJdbc2Connection.integerPart(versionTokens.nextToken());
        }
        catch (NoSuchElementException e) {
            return 0;
        }
    }

    public int getServerMinorVersion() {
        try {
            StringTokenizer versionTokens = new StringTokenizer(this.dbVersionNumber, ".");
            versionTokens.nextToken();
            return AbstractJdbc2Connection.integerPart(versionTokens.nextToken());
        }
        catch (NoSuchElementException e) {
            return 0;
        }
    }

    @Override
    public boolean haveMinimumServerVersion(String ver) {
        return this.dbVersionNumber.compareTo(ver) >= 0;
    }

    @Override
    public boolean haveMinimumCompatibleVersion(String ver) {
        return this.compatible.compareTo(ver) >= 0;
    }

    @Override
    public Encoding getEncoding() {
        return this.protoConnection.getEncoding();
    }

    @Override
    public byte[] encodeString(String str) throws SQLException {
        try {
            return this.getEncoding().encode(str);
        }
        catch (IOException ioe) {
            throw new PSQLException(GT.tr("Unable to translate data into the desired encoding."), PSQLState.DATA_ERROR, (Throwable)ioe);
        }
    }

    @Override
    public String escapeString(String str) throws SQLException {
        return Utils.appendEscapedLiteral(null, str, this.protoConnection.getStandardConformingStrings()).toString();
    }

    @Override
    public boolean getStandardConformingStrings() {
        return this.protoConnection.getStandardConformingStrings();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.protoConnection.isClosed();
    }

    @Override
    public void cancelQuery() throws SQLException {
        this.checkClosed();
        this.protoConnection.sendQueryCancel();
    }

    @Override
    public PGNotification[] getNotifications() throws SQLException {
        this.checkClosed();
        this.getQueryExecutor().processNotifies();
        PGNotification[] notifications = this.protoConnection.getNotifications();
        return notifications.length == 0 ? null : notifications;
    }

    @Override
    public int getPrepareThreshold() {
        return this.prepareThreshold;
    }

    @Override
    public void setPrepareThreshold(int newThreshold) {
        this.prepareThreshold = newThreshold <= 0 ? 0 : newThreshold;
    }

    public void setTypeMapImpl(Map map) throws SQLException {
        this.typemap = map;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    protected void enableDriverManagerLogging() {
        if (DriverManager.getLogWriter() == null && (Driver.getLogLevel() != 1 || Logger.needPrintInfo())) {
            DriverManager.setLogWriter(new PrintWriter(System.out, true));
        }
    }

    public int getProtocolVersion() {
        return this.protoConnection.getProtocolVersion();
    }

    @Override
    public boolean getStringVarcharFlag() {
        return this.bindStringAsVarchar;
    }

    @Override
    public CopyManager getCopyAPI() throws SQLException {
        this.checkClosed();
        if (this.copyManager == null) {
            this.copyManager = new CopyManager(this);
        }
        return this.copyManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readServerName() {
        String name = "EnterpriseDB";
        ResultSet rs = null;
        try {
            String version;
            StringTokenizer tokenizer;
            rs = this.execSQLQuery("select version()");
            if (rs.next() && (tokenizer = new StringTokenizer(version = rs.getString(1))).hasMoreTokens()) {
                String token;
                name = tokenizer.nextToken();
                if (tokenizer.hasMoreTokens() && (token = tokenizer.nextToken()).indexOf(".") < 0) {
                    name = name + " " + token;
                }
            }
        }
        catch (Exception exp) {
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ex) {}
        }
        return name;
    }

    public String getServerName() {
        if (this.serverName == null) {
            this.serverName = this.readServerName();
        }
        return this.serverName;
    }

    @Override
    public boolean binaryTransferSend(int oid, boolean isCallable) {
        return !isCallable && this.useBinarySendForOids.contains(new Integer(oid));
    }

    @Override
    public int getBackendPID() {
        return this.protoConnection.getBackendPID();
    }

    @Override
    public boolean isColumnSanitiserDisabled() {
        return this.disableColumnSanitiser;
    }

    public void setDisableColumnSanitiser(boolean disableColumnSanitiser) {
        this.disableColumnSanitiser = disableColumnSanitiser;
    }

    private class TransactionCommandHandler
    implements ResultHandler {
        private SQLException error;

        private TransactionCommandHandler() {
        }

        @Override
        public void handleResultRows(Query fromQuery, Field[] fields, List tuples, ResultCursor cursor) {
        }

        @Override
        public void handleCommandStatus(String status, int updateCount, long insertOID) {
        }

        @Override
        public void notifyCommandStatus(String message) {
        }

        @Override
        public void handleWarning(SQLWarning warning) {
            AbstractJdbc2Connection.this.addWarning(warning);
        }

        @Override
        public void handleError(SQLException newError) {
            if (this.error == null) {
                this.error = newError;
            } else {
                this.error.setNextException(newError);
            }
        }

        @Override
        public void handleCompletion() throws SQLException {
            if (this.error != null) {
                throw this.error;
            }
        }
    }
}

