/*
 * Decompiled with CFR 0.152.
 */
package dm.sql;

import dm.jdbc.dataConvertion.CType2JType;
import dm.jdbc.dbaccess.Const;
import dm.jdbc.dbaccess.DBError;
import dm.jdbc.innerData.DmdbConnAgent;
import dm.sql.StructDescriptor;
import dm.sql.TypeData;
import dm.sql.TypeDescriptor;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.Map;

public class STRUCT
extends TypeData
implements Struct {
    StructDescriptor m_strctDesc;
    TypeData[] m_attribs;
    int m_objCount;
    int m_strCount;

    public STRUCT(TypeData[] atData, TypeDescriptor desc) {
        super(null, null);
        this.m_strctDesc = new StructDescriptor(desc);
        this.m_attribs = atData;
    }

    public TypeData[] getAttribsTypeData() {
        return this.m_attribs;
    }

    public STRUCT(StructDescriptor desc, DmdbConnAgent connAgent, Object[] objArr) throws SQLException {
        super(null, null);
        if (desc == null || objArr == null) {
            DBError.throwSQLException(6036);
        }
        if (connAgent == null || connAgent.getRealConn().isClosed()) {
            throw new SQLException(Const.res.getString("error.connectionClosedOrNotBuild"));
        }
        if (desc.getSize() != objArr.length && desc.getObjId() != 4) {
            throw new SQLException(Const.res.getString("error.structMemNotMatch"));
        }
        this.m_strctDesc = desc;
        this.m_attribs = TypeData.toStruct(objArr, this.m_strctDesc.m_typeDesc);
    }

    public String getSQLTypeName() throws SQLException {
        return this.m_strctDesc.m_typeDesc.getFulName();
    }

    public Object[] getAttributes() throws SQLException {
        return this.toJavaArray(this);
    }

    public Object[] getAttributes(Map map) throws SQLException {
        Object[] objs = this.getAttributes();
        if (map == null || map.size() == 0) {
            return objs;
        }
        int i = 0;
        while (i < objs.length) {
            if (objs[i] instanceof STRUCT) {
                STRUCT struct = (STRUCT)objs[i];
                objs[i] = CType2JType.getStruct_SQLData(map, struct, struct.getSQLTypeName());
            }
            ++i;
        }
        return objs;
    }

    private void checkCol(int col) throws SQLException {
        if (col < 1 || col > this.m_attribs.length) {
            DBError.throwSQLException(6032);
        }
    }

    TypeData getAttrValue(int col) throws SQLException {
        this.checkCol(col);
        return this.m_attribs[col - 1];
    }
}

