/*
 * Decompiled with CFR 0.152.
 */
package dm.sql;

import dm.jdbc.dataConvertion.Convertion;
import dm.jdbc.dbaccess.DBError;
import dm.jdbc.util.StringUtil;
import java.sql.SQLException;

public class DmdbTimeZone
implements Cloneable {
    byte[] value = new byte[12];
    byte[] value_timestamp_tz = new byte[9];
    int ctype;
    String str;
    int prec = 0;

    public int getTzType() {
        if (this.ctype == 1) {
            return 22;
        }
        return 23;
    }

    public int getScale() {
        return this.prec;
    }

    public byte[] getValueBytes() {
        return this.value;
    }

    public final Object clone() {
        DmdbTimeZone o = null;
        try {
            o = (DmdbTimeZone)super.clone();
            if (this.value != null) {
                o.value = (byte[])this.value.clone();
            }
            if (this.value_timestamp_tz != null) {
                o.value_timestamp_tz = (byte[])this.value_timestamp_tz.clone();
            }
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return o;
    }

    public DmdbTimeZone(String str, int ctype, short defaultTz) throws SQLException {
        this.str = str;
        this.ctype = ctype;
        this.value = this.getValueFromTZ(defaultTz);
    }

    public DmdbTimeZone(byte[] dt, int prec, int ctype) {
        this.value = dt;
        this.ctype = ctype;
        this.prec = prec;
    }

    public int hashCode() {
        return this.getStrFromTZ().hashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof DmdbTimeZone)) {
            return false;
        }
        DmdbTimeZone tm = (DmdbTimeZone)o;
        byte[] bs = tm.value;
        int i = 0;
        while (i < 12) {
            if (this.value[i] != bs[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String getStrFromTZ() {
        int year = 0;
        short month = 0;
        short day = 0;
        short hour = 0;
        int min = 0;
        int sec = 0;
        int msec = 0;
        int tz = 0;
        String str = "";
        if (this.ctype == 1) {
            hour = (short)(this.value[0] & 0x1F);
            min = (short)((this.value[0] >> 5 & 7) + ((this.value[1] & 7) << 3));
            sec = (short)((this.value[1] >> 3 & 0x1F) + ((this.value[2] & 1) << 5));
            msec = (this.value[2] >> 1 & 0x7F) + ((this.value[3] & 0xFF) << 7) + ((this.value[4] & 0x1F) << 15);
            tz = Convertion.getShort(this.value, 5);
        } else if (this.ctype == 2) {
            year = Convertion.getShort(this.value, 0);
            if ((year &= Short.MAX_VALUE) > 9999) {
                year = (short)((short)year | 0x8000);
            }
            month = (short)((this.value[1] >> 7 & 1) + ((this.value[2] & 7) << 1));
            day = (short)((this.value[2] & 0xF8) >> 3 & 0x1F);
            hour = (short)(this.value[3] & 0x1F);
            min = (short)((this.value[3] >> 5 & 7) + ((this.value[4] & 7) << 3));
            sec = (short)((this.value[4] >> 3 & 0x1F) + ((this.value[5] & 1) << 5));
            msec = (this.value[5] >> 1 & 0x7F) + ((this.value[6] & 0xFF) << 7) + ((this.value[7] & 0x1F) << 15);
            tz = Convertion.getShort(this.value, 8);
        }
        String h = "" + hour;
        String m = "" + min;
        String s = "" + sec;
        String n = "" + msec;
        if (h.length() < 2) {
            h = "0" + h;
        }
        if (m.length() < 2) {
            m = "0" + m;
        }
        if (s.length() < 2) {
            s = "0" + s;
        }
        if (this.prec > 0) {
            int nlen = n.length();
            if (nlen < 6) {
                int i = 0;
                while (i < 6 - nlen) {
                    n = "0" + n;
                    ++i;
                }
            }
            if (n.length() > this.prec) {
                n = n.substring(0, this.prec);
            }
        }
        if (this.ctype == 2) {
            String d;
            str = String.valueOf(str) + year;
            String mon = "" + month;
            if (mon.length() < 2) {
                mon = "0" + mon;
            }
            if ((d = "" + day).length() < 2) {
                d = "0" + d;
            }
            str = String.valueOf(str) + "-" + mon + "-" + d + " ";
        }
        str = this.prec == 0 ? String.valueOf(str) + h + ":" + m + ":" + s : String.valueOf(str) + h + ":" + m + ":" + s + "." + n;
        str = tz >= 0 ? String.valueOf(str) + " +" : String.valueOf(str) + " -";
        int tz_hour = Math.abs(tz / 60);
        int tz_min = Math.abs(tz % 60);
        String tz_hour_s = "" + tz_hour;
        String tz_min_s = "" + tz_min;
        if (tz_hour_s.length() < 2) {
            tz_hour_s = "0" + tz_hour_s;
        }
        if (tz_min_s.length() < 2) {
            tz_min_s = "0" + tz_min_s;
        }
        str = String.valueOf(str) + tz_hour_s + ":" + tz_min_s;
        return str;
    }

    public byte[] getValueFromTZ(short tz) throws SQLException {
        int i;
        int tz_min = 0;
        byte[] dt_tz = new byte[12];
        if (this.ctype == 1) {
            dt_tz[0] = 0;
            dt_tz[1] = 0;
            dt_tz[2] = 0;
            dt_tz[3] = 0;
        }
        if (this.ctype == 2) {
            boolean sign = false;
            if (this.str.startsWith("-")) {
                this.str = this.str.substring(1).trim();
                sign = true;
            } else if (this.str.startsWith("+")) {
                this.str = this.str.substring(1).trim();
                sign = false;
            }
            String[] subStr = StringUtil.split(this.str, "-: .");
            short year = Short.parseShort(subStr[0]);
            if (sign) {
                year = (short)(0 - year);
            }
            byte month = Byte.parseByte(subStr[1]);
            byte day = Byte.parseByte(subStr[2]);
            byte[] y = Convertion.shortToByteArray(year);
            dt_tz[0] = y[0];
            dt_tz[1] = y[1];
            dt_tz[2] = month;
            dt_tz[3] = day;
            int ind = this.str.indexOf(" ");
            this.str = this.str.substring(ind + 1, this.str.length()).trim();
        }
        String[] subs = StringUtil.split(this.str, ":. +-");
        byte hour = Byte.parseByte(subs[0]);
        byte minute = Byte.parseByte(subs[1]);
        byte sec = Byte.parseByte(subs[2]);
        dt_tz[4] = hour;
        dt_tz[5] = minute;
        dt_tz[6] = sec;
        if (this.str.indexOf(".") != -1) {
            StringBuffer strNano = new StringBuffer(10);
            strNano.append("0");
            strNano.append(".");
            strNano.append(subs[3]);
            double d_v = Double.valueOf(strNano.toString());
            int nano = (int)(d_v * 1000000.0);
            byte[] msec = Convertion.IntToByteArray(nano);
            System.arraycopy(msec, 0, dt_tz, 7, 3);
            i = 4;
        } else {
            dt_tz[7] = 0;
            dt_tz[8] = 0;
            dt_tz[9] = 0;
            i = 3;
        }
        while (subs.length > i && subs[i].equals("")) {
            ++i;
        }
        if (subs.length > i) {
            byte tz_hour;
            if (this.str.indexOf("-") != -1) {
                tz_hour = Byte.parseByte("-" + subs[i++]);
                if (subs.length > i) {
                    tz_min = Byte.parseByte("-" + subs[i++]);
                }
            } else {
                tz_hour = Byte.parseByte(subs[i++]);
                if (subs.length > i) {
                    tz_min = Byte.parseByte(subs[i++]);
                }
            }
            tz = (short)(tz_hour * 60 + tz_min);
        }
        if (tz > 780 || tz < -720) {
            DBError.throwSQLException(6014);
        }
        byte[] tz_bs = Convertion.shortToByteArray(tz);
        dt_tz[10] = tz_bs[0];
        dt_tz[11] = tz_bs[1];
        return dt_tz;
    }

    public static byte[] timeZoneEncodeFast(byte[] dt) {
        byte[] ret = new byte[7];
        byte hour = dt[4];
        byte min = dt[5];
        byte sec = dt[6];
        int msec = (0xFF & dt[7]) + ((dt[8] & 0xFF) << 8) + ((dt[9] & 0xFF) << 16);
        ret[0] = (byte)(hour | (min & 7) << 5);
        ret[1] = (byte)((min & 0x38) >> 3 | (sec & 0x1F) << 3);
        ret[2] = (byte)((sec & 0x20) >> 5 | (msec & 0x7F) << 1);
        ret[3] = (byte)(msec >> 7 & 0xFF);
        ret[4] = (byte)(msec >> 15 & 0xFF);
        System.arraycopy(dt, 10, ret, 5, 2);
        return ret;
    }

    public static byte[] datetimeZoneEncodeFast(byte[] dt) {
        byte[] ret = new byte[10];
        short year = Convertion.getShort(dt, 0);
        byte month = dt[2];
        byte day = dt[3];
        ret[0] = dt[0];
        ret[1] = (byte)(year >> 8 | (month & 1) << 7);
        ret[2] = (byte)((month & 0xE) >> 1 | day << 3);
        byte hour = dt[4];
        byte min = dt[5];
        byte sec = dt[6];
        int msec = (0xFF & dt[7]) + ((dt[8] & 0xFF) << 8) + ((dt[9] & 0xFF) << 16);
        ret[3] = (byte)(hour | (min & 7) << 5);
        ret[4] = (byte)((min & 0x38) >> 3 | (sec & 0x1F) << 3);
        ret[5] = (byte)((sec & 0x20) >> 5 | (msec & 0x7F) << 1);
        ret[6] = (byte)(msec >> 7 & 0xFF);
        ret[7] = (byte)(msec >> 15 & 0xFF);
        System.arraycopy(dt, 10, ret, 8, 2);
        return ret;
    }

    public String toString() {
        return this.getStrFromTZ();
    }
}

