/*
 * Decompiled with CFR 0.152.
 */
package dm.sql;

import dm.jdbc.dataConvertion.Convertion;
import dm.jdbc.dbaccess.Const;
import dm.jdbc.dbaccess.DBError;
import dm.jdbc.util.StringUtil;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

public class DmdbTime
implements Cloneable {
    final int DMDT_HOUR_POS = 0;
    final int DMDT_HOUR_LEN = 5;
    final int DMDT_MIN_POS = 5;
    final int DMDT_MIN_LEN = 6;
    final int DMDT_SEC_POS = 11;
    final int DMDT_SEC_LEN = 6;
    final int DMDT_MSEC_POS = 17;
    final int DMDT_MSEC_LEN = 20;
    byte[] times = new byte[5];
    int prec = 0;

    public DmdbTime() {
    }

    public final Object clone() {
        DmdbTime o = null;
        try {
            o = (DmdbTime)super.clone();
            if (this.times != null) {
                o.times = (byte[])this.times.clone();
            }
            o.prec = this.prec;
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return o;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof DmdbTime)) {
            return false;
        }
        DmdbTime dbtm = (DmdbTime)o;
        byte[] bs = dbtm.times;
        int i = 0;
        while (i < 5) {
            if (this.times[i] != bs[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public DmdbTime(byte[] bt, int prec) {
        this.times = bt;
        this.prec = prec;
    }

    public DmdbTime(String str, int prec) throws SQLException {
        this.prec = prec;
        String[] tmp = str.split(" ");
        if (tmp.length == 2) {
            str = tmp[1];
        }
        String[] subStr = StringUtil.split(str, ":.");
        try {
            byte h = Byte.parseByte(subStr[0]);
            byte m = Byte.parseByte(subStr[1]);
            byte s = Byte.parseByte(subStr[2]);
            int nano = 0;
            if (subStr.length > 3) {
                StringBuffer strNano = new StringBuffer(10);
                strNano.append("0");
                strNano.append(".");
                strNano.append(subStr[3]);
                double d_v = Double.valueOf(strNano.toString());
                nano = (int)(d_v * 1000000.0);
            }
            this.setBit(this.times, 0, 5, h);
            this.setBit(this.times, 5, 6, m);
            this.setBit(this.times, 11, 6, s);
            this.setBit(this.times, 17, 20, nano);
        }
        catch (Exception e) {
            DBError.throwSQLException(6007);
        }
    }

    public final byte[] getByteArrayValue() throws SQLException {
        String str = this.getTimeWithNano();
        byte[] dt = new byte[12];
        String[] subStr = StringUtil.split(str, ":.");
        byte hour = Byte.parseByte(subStr[0]);
        byte minute = Byte.parseByte(subStr[1]);
        byte sec = Byte.parseByte(subStr[2]);
        if (hour > 24 || hour < 0 || minute > 60 || minute < 0 || sec > 60 || sec < 0) {
            throw new SQLException(Const.res.getString("error.invalidDateTimeTypeFormat"));
        }
        dt[4] = hour;
        dt[5] = minute;
        dt[6] = sec;
        int nano = 0;
        if (subStr.length > 3) {
            StringBuffer strNano = new StringBuffer(10);
            strNano.append("0");
            strNano.append(".");
            strNano.append(subStr[3]);
            double d_v = Double.valueOf(strNano.toString());
            nano = (int)(d_v * 1000000.0);
        }
        byte[] msec = Convertion.IntToByteArray(nano);
        System.arraycopy(msec, 0, dt, 7, 3);
        return dt;
    }

    public final byte getHour() {
        int b = this.getBit(this.times, 0, 5);
        return (byte)b;
    }

    public final byte getMinute() {
        int b = this.getBit(this.times, 5, 6);
        return (byte)b;
    }

    public final byte getSecond() {
        int b = this.getBit(this.times, 11, 6);
        return (byte)b;
    }

    public final int getNano() {
        int b = this.getBit(this.times, 17, 20);
        return b;
    }

    public final Time getTime() {
        return new Time(this.getHour(), this.getMinute(), this.getSecond());
    }

    public final String getTimeWithoutNano() {
        byte hour = this.getHour();
        byte min = this.getMinute();
        byte sec = this.getSecond();
        StringBuffer sb = new StringBuffer(15);
        String h = new Integer(hour).toString();
        String m = new Integer(min).toString();
        String s = new Integer(sec).toString();
        if (h.length() < 2) {
            h = "0" + h;
        }
        if (m.length() < 2) {
            m = "0" + m;
        }
        if (s.length() < 2) {
            s = "0" + s;
        }
        sb.append(h).append(":").append(m).append(":").append(s);
        return sb.toString();
    }

    public final String getTimeWithNano() {
        int nano = this.getNano();
        StringBuffer sb = new StringBuffer(15);
        String n = new Integer(nano).toString();
        String naro = "";
        int i = 0;
        while (i < this.prec - n.length()) {
            naro = naro.concat("0");
            ++i;
        }
        n = naro.concat(n);
        sb.append(this.getTimeWithoutNano()).append(".").append(n);
        return sb.toString();
    }

    public final String toString() {
        if (this.prec == 0) {
            return this.getTimeWithoutNano();
        }
        return this.getTimeWithNano();
    }

    public final Timestamp getTimestamp() {
        long t = this.getTime().getTime();
        Timestamp ts = new Timestamp(t);
        ts.setNanos(this.getNano() * 1000);
        return ts;
    }

    int getBit(byte[] x, int start, int len) {
        int xx0 = 0;
        int start_bit = start & 7;
        int s = start >> 3;
        int e = (start + len - 1 >> 3) + 1;
        int n = e - s;
        int p = start >> 3;
        if (n == 1) {
            byte[] t1 = new byte[4];
            System.arraycopy(x, p, t1, 0, 1);
            xx0 = Convertion.fourByteToInt(t1);
        } else if (n == 2) {
            byte[] t1 = new byte[4];
            System.arraycopy(x, p, t1, 0, 1);
            int x1 = Convertion.fourByteToInt(t1);
            System.arraycopy(x, p + 1, t1, 0, 1);
            int x2 = Convertion.fourByteToInt(t1);
            x2 = x2 << 8 & 0xFFFFFFFF;
            xx0 = x1 + x2;
        } else if (n == 3) {
            byte[] t1 = new byte[4];
            System.arraycopy(x, p, t1, 0, 1);
            int x1 = Convertion.fourByteToInt(t1);
            System.arraycopy(x, p + 1, t1, 0, 1);
            int x2 = Convertion.fourByteToInt(t1);
            x2 = x2 << 8 & 0xFFFFFFFF;
            System.arraycopy(x, p + 2, t1, 0, 1);
            int x3 = Convertion.fourByteToInt(t1);
            x3 = x3 << 16 & 0xFFFFFFFF;
            xx0 = x1 + x2 + x3;
        }
        return xx0 >> start_bit & -1 >>> 32 - len;
    }

    void setBit(byte[] x, int start, int len, int data) {
        int start_bit = start & 7;
        int last_bit = start + len & 7;
        int s = start >> 3;
        int e = (start + len - 1 >> 3) + 1;
        byte[] p = Convertion.IntToByteArray(data <<= start_bit);
        int n = s;
        while (n < e) {
            if (n == s) {
                x[n] = (byte)(x[n] & 255 >>> 8 - start_bit);
                x[n] = (byte)(x[n] | p[n - s]);
            } else if (n == e - 1) {
                x[n] = (byte)(x[n] & 255 << last_bit);
                x[n] = (byte)(x[n] | p[n - s]);
            } else {
                x[n] = p[n - s];
            }
            ++n;
        }
    }

    public static byte[] TimeEncodeFast(byte[] dt) {
        byte[] ret = new byte[5];
        byte hour = dt[4];
        byte min = dt[5];
        byte sec = dt[6];
        int msec = (0xFF & dt[7]) + ((dt[8] & 0xFF) << 8) + ((dt[9] & 0xFF) << 16);
        ret[0] = (byte)(hour | (min & 7) << 5);
        ret[1] = (byte)((min & 0x38) >> 3 | (sec & 0x1F) << 3);
        ret[2] = (byte)((sec & 0x20) >> 5 | (msec & 0x7F) << 1);
        ret[3] = (byte)(msec >> 7 & 0xFF);
        ret[4] = (byte)(msec >> 15 & 0xFF);
        return ret;
    }
}

