/*
 * Decompiled with CFR 0.152.
 */
package dm.sql;

import dm.jdbc.dataConvertion.CType2JType;
import dm.jdbc.dbaccess.DBError;
import dm.sql.STRUCT;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Map;

public class DmdbSQLInput
implements SQLInput {
    private Object[] m_attribs;
    private int index = 0;
    private boolean isNull = false;
    private Map map;

    public DmdbSQLInput(Map map, Object[] attributes) {
        this.m_attribs = attributes;
        this.index = 0;
        this.isNull = false;
        this.map = map;
    }

    public String readString() throws SQLException {
        String retVal;
        this.checkIndex(this.index);
        Object obj = this.m_attribs[this.index];
        ++this.index;
        if (obj == null) {
            this.isNull = true;
            retVal = null;
        } else {
            this.isNull = false;
            if (obj instanceof Array || obj instanceof Struct || obj instanceof Clob || obj instanceof Blob || obj instanceof byte[]) {
                DBError.throwSQLException(6007);
            }
            retVal = obj.toString();
        }
        return retVal;
    }

    public boolean readBoolean() throws SQLException {
        boolean retVal;
        this.checkIndex(this.index);
        Object obj = this.m_attribs[this.index];
        ++this.index;
        if (obj == null) {
            this.isNull = true;
            retVal = false;
        } else {
            this.isNull = false;
            retVal = (Boolean)obj;
        }
        return retVal;
    }

    public byte readByte() throws SQLException {
        byte retVal = 0;
        this.checkIndex(this.index);
        Object obj = this.m_attribs[this.index];
        ++this.index;
        if (obj == null) {
            this.isNull = true;
        } else {
            this.isNull = false;
            retVal = (Byte)obj;
        }
        return retVal;
    }

    public short readShort() throws SQLException {
        short retVal = 0;
        this.checkIndex(this.index);
        Object obj = this.m_attribs[this.index];
        ++this.index;
        if (obj == null) {
            this.isNull = true;
        } else {
            this.isNull = false;
            if (!(obj instanceof Number) && !(obj instanceof String)) {
                DBError.throwSQLException(6007);
            }
            retVal = Short.parseShort(obj.toString());
        }
        return retVal;
    }

    public int readInt() throws SQLException {
        int retVal = 0;
        this.checkIndex(this.index);
        Object obj = this.m_attribs[this.index];
        ++this.index;
        if (obj == null) {
            this.isNull = true;
        } else {
            this.isNull = false;
            if (!(obj instanceof Number) && !(obj instanceof String)) {
                DBError.throwSQLException(6007);
            }
            retVal = Integer.parseInt(obj.toString());
        }
        return retVal;
    }

    public long readLong() throws SQLException {
        long retVal = 0L;
        this.checkIndex(this.index);
        Object obj = this.m_attribs[this.index];
        ++this.index;
        if (obj == null) {
            this.isNull = true;
        } else {
            this.isNull = false;
            if (!(obj instanceof Number) && !(obj instanceof String)) {
                DBError.throwSQLException(6007);
            }
            retVal = Long.parseLong(obj.toString());
        }
        return retVal;
    }

    public float readFloat() throws SQLException {
        float retVal = 0.0f;
        this.checkIndex(this.index);
        Object obj = this.m_attribs[this.index];
        ++this.index;
        if (obj == null) {
            this.isNull = true;
        } else {
            this.isNull = false;
            if (!(obj instanceof Number) && !(obj instanceof String)) {
                DBError.throwSQLException(6007);
            }
            retVal = Float.parseFloat(obj.toString());
        }
        return retVal;
    }

    public double readDouble() throws SQLException {
        double retVal = 0.0;
        this.checkIndex(this.index);
        Object obj = this.m_attribs[this.index];
        ++this.index;
        if (obj == null) {
            this.isNull = true;
        } else {
            this.isNull = false;
            if (!(obj instanceof Number) && !(obj instanceof String)) {
                DBError.throwSQLException(6007);
            }
            retVal = Double.parseDouble(obj.toString());
        }
        return retVal;
    }

    public BigDecimal readBigDecimal() throws SQLException {
        BigDecimal retVal = null;
        this.checkIndex(this.index);
        Object obj = this.m_attribs[this.index];
        ++this.index;
        if (obj == null) {
            this.isNull = true;
        } else {
            this.isNull = false;
            if (obj instanceof BigDecimal) {
                retVal = (BigDecimal)obj;
            } else {
                if (!(obj instanceof Number) && !(obj instanceof String)) {
                    DBError.throwSQLException(6007);
                }
                retVal = new BigDecimal(obj.toString());
            }
        }
        return retVal;
    }

    public byte[] readBytes() throws SQLException {
        byte[] retVal = null;
        this.checkIndex(this.index);
        Object obj = this.m_attribs[this.index];
        ++this.index;
        if (obj == null) {
            this.isNull = true;
        } else {
            this.isNull = false;
            retVal = (byte[])obj;
        }
        return retVal;
    }

    public Date readDate() throws SQLException {
        Date retVal = null;
        this.checkIndex(this.index);
        Object obj = this.m_attribs[this.index];
        ++this.index;
        if (obj == null) {
            this.isNull = true;
        } else {
            this.isNull = false;
            retVal = (Date)obj;
        }
        return retVal;
    }

    public Time readTime() throws SQLException {
        Time retVal = null;
        this.checkIndex(this.index);
        Object obj = this.m_attribs[this.index];
        ++this.index;
        if (obj == null) {
            this.isNull = true;
        } else {
            this.isNull = false;
            retVal = (Time)obj;
        }
        return retVal;
    }

    public Timestamp readTimestamp() throws SQLException {
        Timestamp retVal = null;
        this.checkIndex(this.index);
        Object obj = this.m_attribs[this.index];
        ++this.index;
        if (obj == null) {
            this.isNull = true;
        } else {
            this.isNull = false;
            retVal = (Timestamp)obj;
        }
        return retVal;
    }

    public Reader readCharacterStream() throws SQLException {
        DBError.throwUnsupportedSQLException();
        return null;
    }

    public InputStream readAsciiStream() throws SQLException {
        DBError.throwUnsupportedSQLException();
        return null;
    }

    public InputStream readBinaryStream() throws SQLException {
        DBError.throwUnsupportedSQLException();
        return null;
    }

    public Object readObject() throws SQLException {
        Object retVal = null;
        this.checkIndex(this.index);
        Object obj = this.m_attribs[this.index];
        ++this.index;
        if (obj == null) {
            this.isNull = true;
        } else {
            this.isNull = false;
            if (obj instanceof STRUCT) {
                STRUCT struct = (STRUCT)obj;
                retVal = CType2JType.getStruct_SQLData(this.map, struct, struct.getSQLTypeName());
            } else {
                retVal = obj;
            }
        }
        return retVal;
    }

    public Ref readRef() throws SQLException {
        DBError.throwUnsupportedSQLException();
        return null;
    }

    public Blob readBlob() throws SQLException {
        Blob retVal = null;
        this.checkIndex(this.index);
        Object obj = this.m_attribs[this.index];
        ++this.index;
        if (obj == null) {
            this.isNull = true;
        } else {
            this.isNull = false;
            retVal = (Blob)obj;
        }
        return retVal;
    }

    public Clob readClob() throws SQLException {
        Clob retVal = null;
        this.checkIndex(this.index);
        Object obj = this.m_attribs[this.index];
        ++this.index;
        if (obj == null) {
            this.isNull = true;
        } else {
            this.isNull = false;
            retVal = (Clob)obj;
        }
        return retVal;
    }

    public Array readArray() throws SQLException {
        Array retVal = null;
        this.checkIndex(this.index);
        Object obj = this.m_attribs[this.index];
        ++this.index;
        if (obj == null) {
            this.isNull = true;
        } else {
            this.isNull = false;
            retVal = (Array)obj;
        }
        return retVal;
    }

    public boolean wasNull() throws SQLException {
        return this.isNull;
    }

    public URL readURL() throws SQLException {
        DBError.throwUnsupportedSQLException();
        return null;
    }

    private void checkIndex(int index) throws SQLException {
        if (index < 0 || index >= this.m_attribs.length) {
            DBError.throwSQLException(6032);
        }
    }
}

