/*
 * Decompiled with CFR 0.152.
 */
package dm.sql;

import dm.jdbc.dataConvertion.Convertion;
import dm.jdbc.dbaccess.DBError;
import java.sql.SQLException;

public class DmdbIntervalYM
implements Cloneable {
    private byte[] ym = new byte[12];
    public static final byte QUA_Y = 0;
    public static final byte QUA_YM = 1;
    public static final byte QUA_MO = 2;
    private int prec = 0;
    private boolean isPrecSet = false;
    public byte type = 0;
    public int years = 0;
    public int months = 0;
    private int precForSvr = 0;

    public final Object clone() {
        DmdbIntervalYM o = null;
        try {
            o = (DmdbIntervalYM)super.clone();
            if (this.ym != null) {
                o.ym = (byte[])this.ym.clone();
            }
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return o;
    }

    public DmdbIntervalYM(byte[] bs) {
        this.ym = bs;
        this.precForSvr = Convertion.getInt(this.ym, 8);
        this.prec = this.precForSvr >> 4 & 0xF;
        this.type = this.ym[9];
        switch (this.type) {
            case 0: {
                this.years = this.getYear();
                break;
            }
            case 1: {
                this.years = this.getYear();
                this.months = this.getMonth();
                break;
            }
            case 2: {
                this.months = this.getMonth();
            }
        }
    }

    public int hashCode() {
        return this.getYMString().hashCode();
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof DmdbIntervalYM) {
            DmdbIntervalYM tm = (DmdbIntervalYM)o;
            if (tm.type == this.type) {
                switch (this.type) {
                    case 0: {
                        if (this.years != tm.years) break;
                        return true;
                    }
                    case 1: {
                        if (this.years != tm.years || this.months != tm.months) break;
                        return true;
                    }
                    case 2: {
                        if (this.months != tm.months) break;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public DmdbIntervalYM(String str) throws SQLException {
        this.isPrecSet = false;
        this.parseIntervYMString(str);
    }

    public DmdbIntervalYM(String str, int pre) throws SQLException {
        this.isPrecSet = true;
        this.prec = pre;
        this.parseIntervYMString(str);
    }

    public final int getYear() {
        byte[] bs = new byte[4];
        System.arraycopy(this.ym, 0, bs, 0, 4);
        int y = Convertion.fourByteToInt(bs);
        return y;
    }

    public final int getMonth() {
        byte[] bs = new byte[4];
        System.arraycopy(this.ym, 4, bs, 0, 4);
        int mon = Convertion.fourByteToInt(bs);
        return mon;
    }

    public final byte getYMType() {
        return this.type;
    }

    public final int getLoadPrec() {
        return this.prec;
    }

    public final byte[] getByteArrayValue() {
        return this.ym;
    }

    public final int abs(int i) {
        if (i < 0) {
            i = -i;
        }
        return i;
    }

    public final String getYMString() {
        String str = "INTERVAL ";
        switch (this.type) {
            case 0: {
                String year = String.valueOf(this.abs(this.years));
                if (this.years < 0) {
                    str = String.valueOf(str) + "-";
                }
                if (this.prec > year.length()) {
                    int len = year.length();
                    int destLen = this.prec;
                    while (destLen-- > len) {
                        year = "0" + year;
                    }
                }
                str = String.valueOf(str) + "'" + year + "' YEAR(" + this.prec + ")";
                break;
            }
            case 1: {
                String year = String.valueOf(this.abs(this.years));
                String month = String.valueOf(this.abs(this.months));
                if (this.years < 0 || this.months < 0) {
                    str = String.valueOf(str) + "-";
                }
                if (this.prec > year.length()) {
                    int len = year.length();
                    int destLen = this.prec;
                    while (destLen-- > len) {
                        year = "0" + year;
                    }
                }
                if (month.length() < 2) {
                    month = "0" + month;
                }
                str = String.valueOf(str) + "'" + year + "-" + month + "' YEAR(" + this.prec + ") TO MONTH";
                break;
            }
            case 2: {
                String month = String.valueOf(this.abs(this.months));
                if (this.months < 0) {
                    str = String.valueOf(str) + "-";
                }
                if (this.prec > month.length()) {
                    int len = month.length();
                    int destLen = this.prec;
                    while (destLen-- > len) {
                        month = "0" + month;
                    }
                }
                str = String.valueOf(str) + "'" + month + "' MONTH(" + this.prec + ")";
            }
        }
        return str;
    }

    public final String toString() {
        return this.getYMString();
    }

    public byte[] convertStrToBs(int prec) throws SQLException {
        int leadPrec = prec >> 4 & 0xF;
        this.checkPrec(leadPrec);
        byte[] ym = new byte[12];
        System.arraycopy(Convertion.IntToByteArray(this.years), 0, ym, 0, 4);
        System.arraycopy(Convertion.IntToByteArray(this.months), 0, ym, 4, 4);
        System.arraycopy(Convertion.IntToByteArray(prec), 0, ym, 8, 4);
        return ym;
    }

    public void clear() {
        this.years = 0;
        this.months = 0;
    }

    private int getLeadPrec(String str, int startIndex) throws SQLException {
        if (this.isPrecSet) {
            return this.prec;
        }
        int leftBtId = -1;
        int rightBtId = -1;
        int leadPrec = 0;
        leftBtId = str.indexOf("(", startIndex);
        rightBtId = str.indexOf(")", startIndex);
        if (rightBtId == -1 && leftBtId == -1) {
            leadPrec = 2;
        } else if (rightBtId != -1 && leftBtId != -1 && rightBtId > leftBtId + 1) {
            String strPrec = str.substring(leftBtId + 1, rightBtId).trim();
            leadPrec = Integer.parseInt(strPrec);
        } else {
            DBError.throwSQLException(6005);
        }
        return leadPrec;
    }

    private int[] getTimeValue(String subStr, int type) throws SQLException {
        int monthVal;
        int yearVal;
        boolean negative = false;
        if (subStr.startsWith("-")) {
            negative = true;
            subStr = subStr.substring(1);
        } else if (subStr.startsWith("+")) {
            negative = false;
            subStr = subStr.substring(1);
        }
        String tmpStr = subStr.substring(1, subStr.length() - 1).trim();
        int lastSignIndex = tmpStr.lastIndexOf("-");
        String[] list = new String[2];
        if (lastSignIndex == -1 || lastSignIndex == 0) {
            list[0] = tmpStr;
            list[1] = "";
        } else {
            list[0] = tmpStr.substring(0, lastSignIndex);
            list[1] = tmpStr.substring(lastSignIndex + 1);
        }
        if (type == 1) {
            if (list[1].equalsIgnoreCase("")) {
                DBError.throwSQLException(6005);
            }
            yearVal = Integer.parseInt(list[0]);
            monthVal = Integer.parseInt(list[1]);
            if (negative) {
                yearVal *= -1;
            }
            if ((double)yearVal > Math.pow(10.0, this.prec) - 1.0 || (double)yearVal < 1.0 - Math.pow(10.0, this.prec)) {
                DBError.throwSQLException(6005);
            }
        } else if (type == 0) {
            yearVal = Integer.parseInt(list[0]);
            monthVal = 0;
            if (negative) {
                yearVal *= -1;
            }
            if ((double)yearVal > Math.pow(10.0, this.prec) - 1.0 || (double)yearVal < 1.0 - Math.pow(10.0, this.prec)) {
                DBError.throwSQLException(6005);
            }
        } else {
            yearVal = 0;
            monthVal = Integer.parseInt(list[0]);
            if (negative) {
                monthVal *= -1;
            }
            if ((double)monthVal > Math.pow(10.0, this.prec) - 1.0 || (double)monthVal < 1.0 - Math.pow(10.0, this.prec)) {
                DBError.throwSQLException(6005);
            }
        }
        int[] ret = new int[]{yearVal, monthVal};
        return ret;
    }

    private void parseIntervYMString(String str) throws SQLException {
        String[] ret;
        int length;
        if (str == null) {
            DBError.throwSQLException(6005);
        }
        if ((length = (ret = (str = str.toUpperCase()).split(" ")).length) < 3 || !ret[0].equalsIgnoreCase("INTERVAL") || !ret[2].startsWith("YEAR") && !ret[2].startsWith("MONTH")) {
            DBError.throwSQLException(6005);
        }
        this.type = 1;
        int yearId = str.indexOf("YEAR");
        int monthId = str.indexOf("MONTH");
        int toId = str.indexOf("TO");
        if (toId == -1) {
            if (yearId != -1 && monthId == -1) {
                this.type = 0;
                this.prec = this.getLeadPrec(str, yearId);
            } else if (monthId != -1 && yearId == -1) {
                this.type = (byte)2;
                this.prec = this.getLeadPrec(str, monthId);
            } else {
                DBError.throwSQLException(6005);
            }
        } else {
            if (yearId == -1 || monthId == -1) {
                DBError.throwSQLException(6005);
            }
            this.type = 1;
            this.prec = this.getLeadPrec(str, yearId);
        }
        this.precForSvr = (this.type << 8) + (this.prec << 4) + 0;
        int[] timeVals = this.getTimeValue(ret[1], this.type);
        this.years = timeVals[0];
        this.months = timeVals[1];
        this.checkPrec(this.prec);
    }

    private void checkPrec(int prec) throws SQLException {
        switch (this.type) {
            case 0: {
                if (prec >= String.valueOf(this.abs(this.years)).length()) break;
                DBError.throwSQLException(6005);
                break;
            }
            case 1: {
                if (prec < String.valueOf(this.abs(this.years)).length()) {
                    DBError.throwSQLException(6005);
                }
                if (this.months >= 1 && this.months <= 12) break;
                DBError.throwSQLException(6005);
                break;
            }
            case 2: {
                if (prec >= String.valueOf(this.abs(this.months)).length()) break;
                DBError.throwSQLException(6005);
            }
        }
    }

    public int getPrecForSvr() {
        return this.precForSvr;
    }
}

