/*
 * Decompiled with CFR 0.152.
 */
package dm.sql;

import dm.jdbc.dataConvertion.Convertion;
import dm.jdbc.dbaccess.Const;
import dm.jdbc.dbaccess.DBError;
import dm.jdbc.driver.DmdbType;
import dm.jdbc.util.StringUtil;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

public class DmdbDateTime
implements Cloneable {
    final int DMDT_YEAR_POS = 0;
    final int DMDT_YEAR_LEN = 15;
    final int DMDT_MONTH_POS = 15;
    final int DMDT_MONTH_LEN = 4;
    final int DMDT_DAY_POS = 19;
    final int DMDT_DAY_LEN = 5;
    final int DMDT_DATE_SIZE = 24;
    final int DMDT_HOUR_POS = 0;
    final int DMDT_HOUR_LEN = 5;
    final int DMDT_MIN_POS = 5;
    final int DMDT_MIN_LEN = 6;
    final int DMDT_SEC_POS = 11;
    final int DMDT_SEC_LEN = 6;
    final int DMDT_MSEC_POS = 17;
    final int DMDT_MSEC_LEN = 20;
    byte[] dateTime = new byte[3];
    public static final int DMDT_DATE = 0;
    public static final int DMDT_TIME = 1;
    public static final int DMDT_TIMESTAMP = 2;
    private int prec;

    public DmdbDateTime(byte[] dt, int dtype, int scale, short dbTz, short lTz) throws SQLException {
        this.prec = scale;
        this.dateTime = dt;
        if (dtype == 16 && DmdbType.isLocalTimeZone(dtype, scale)) {
            byte[] temp = this.dmdtDecodeFast();
            this.dateTime = DmdbDateTime.dmdtAddByFmt(temp, 5, lTz - dbTz);
            this.prec = DmdbType.localTimeZoneRealPrec(this.prec);
        }
    }

    public int hashCode() {
        String strVal = String.valueOf(this.getDateInString()) + " " + this.getTimeInString();
        return strVal.hashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof DmdbDateTime)) {
            return false;
        }
        DmdbDateTime tm = (DmdbDateTime)o;
        byte[] bs = tm.dateTime;
        if (this.dateTime.length != bs.length) {
            return false;
        }
        int len = this.dateTime.length;
        int i = 0;
        while (i < len) {
            if (this.dateTime[i] != bs[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public DmdbDateTime(String str, int prec, int flag) throws SQLException {
        this.prec = prec;
        this.dateTime = new byte[12];
        if (flag == 0) {
            String[] subStr = StringUtil.split(str, "-");
            short year = Short.parseShort(subStr[0]);
            if (year > 9999) {
                DBError.throwSQLException(6007);
            }
            byte month = Byte.parseByte(subStr[1]);
            byte day = Byte.parseByte(subStr[2]);
            byte[] y = Convertion.shortToByteArray(year);
            this.dateTime[0] = y[0];
            this.dateTime[1] = y[1];
            this.dateTime[2] = month;
            this.dateTime[3] = day;
        } else if (flag == 2) {
            String[] subStr = StringUtil.split(str, "-: .");
            short year = Short.parseShort(subStr[0]);
            if (year > 9999) {
                DBError.throwSQLException(6007);
            }
            byte month = Byte.parseByte(subStr[1]);
            byte day = Byte.parseByte(subStr[2]);
            byte[] y = Convertion.shortToByteArray(year);
            this.dateTime[0] = y[0];
            this.dateTime[1] = y[1];
            this.dateTime[2] = month;
            this.dateTime[3] = day;
            byte hour = Byte.parseByte(subStr[3]);
            byte minute = Byte.parseByte(subStr[4]);
            byte sec = Byte.parseByte(subStr[5]);
            this.dateTime[4] = hour;
            this.dateTime[5] = minute;
            this.dateTime[6] = sec;
            if (subStr.length > 6) {
                StringBuffer strNano = new StringBuffer(10);
                strNano.append("0");
                strNano.append(".");
                strNano.append(subStr[6]);
                double d_v = Double.valueOf(strNano.toString());
                int nano = (int)(d_v * 1000000.0);
                byte[] msec = Convertion.IntToByteArray(nano);
                System.arraycopy(msec, 0, this.dateTime, 7, 3);
            }
        } else if (flag == 1) {
            int year = 1900;
            if (year > 9999) {
                DBError.throwSQLException(6007);
            }
            byte[] y = Convertion.shortToByteArray(year);
            this.dateTime[0] = y[0];
            this.dateTime[1] = y[1];
            this.dateTime[2] = 1;
            this.dateTime[3] = 1;
            String[] subStr = StringUtil.split(str, ": .");
            byte hour = Byte.parseByte(subStr[0]);
            byte minute = Byte.parseByte(subStr[1]);
            byte sec = Byte.parseByte(subStr[2]);
            this.dateTime[4] = hour;
            this.dateTime[5] = minute;
            this.dateTime[6] = sec;
            if (subStr.length > 3) {
                StringBuffer strNano = new StringBuffer(10);
                strNano.append("0");
                strNano.append(".");
                strNano.append(subStr[3]);
                double d_v = Double.valueOf(strNano.toString());
                int nano = (int)(d_v * 1000000.0);
                byte[] msec = Convertion.IntToByteArray(nano);
                System.arraycopy(msec, 0, this.dateTime, 7, 3);
            }
        }
    }

    public DmdbDateTime(int[] dt, int prec, int flag) throws SQLException {
        this.prec = prec;
        this.dateTime = new byte[12];
        if (flag == 0) {
            short year = (short)dt[0];
            if (year > 9999) {
                DBError.throwSQLException(6007);
            }
            byte month = Byte.parseByte(String.valueOf(dt[1]));
            byte day = Byte.parseByte(String.valueOf(dt[2]));
            byte[] y = Convertion.shortToByteArray(year);
            this.dateTime[0] = y[0];
            this.dateTime[1] = y[1];
            this.dateTime[2] = month;
            this.dateTime[3] = day;
        } else if (flag == 2) {
            short year = (short)dt[0];
            if (year > 9999) {
                DBError.throwSQLException(6007);
            }
            byte month = Byte.parseByte(String.valueOf(dt[1]));
            byte day = Byte.parseByte(String.valueOf(dt[2]));
            byte[] y = Convertion.shortToByteArray(year);
            this.dateTime[0] = y[0];
            this.dateTime[1] = y[1];
            this.dateTime[2] = month;
            this.dateTime[3] = day;
            byte hour = Byte.parseByte(String.valueOf(dt[3]));
            byte minute = Byte.parseByte(String.valueOf(dt[4]));
            byte sec = Byte.parseByte(String.valueOf(dt[5]));
            this.dateTime[4] = hour;
            this.dateTime[5] = minute;
            this.dateTime[6] = sec;
            int nano = dt[6];
            byte[] msec = Convertion.IntToByteArray(nano);
            System.arraycopy(msec, 0, this.dateTime, 7, 3);
        }
    }

    public byte[] getByteArrayValue() {
        return this.dateTime;
    }

    short getYear() {
        int y;
        if (this.dateTime.length == 12) {
            byte[] byte_tmp = new byte[]{this.dateTime[0], this.dateTime[1]};
            y = Convertion.twoByteToShort(byte_tmp);
        } else {
            y = this.getBit_ex(this.dateTime);
        }
        return (short)y;
    }

    byte getMonth() {
        int b = this.dateTime.length == 12 ? this.dateTime[2] : this.getBit(this.dateTime, 15, 4);
        return (byte)b;
    }

    byte getDay() {
        int b1 = this.dateTime.length == 12 ? this.dateTime[3] : this.getBit(this.dateTime, 19, 5);
        return (byte)b1;
    }

    byte getHour(int offset) {
        int b = this.dateTime.length == 12 ? this.dateTime[4] : this.getBit(this.dateTime, offset + 0, 5);
        return (byte)b;
    }

    byte getMinute(int offset) {
        int b = this.dateTime.length == 12 ? this.dateTime[5] : this.getBit(this.dateTime, offset + 5, 6);
        return (byte)b;
    }

    byte getSecond(int offset) {
        int b = this.dateTime.length == 12 ? this.dateTime[6] : this.getBit(this.dateTime, offset + 11, 6);
        return (byte)b;
    }

    int getNano(int offset) {
        int b;
        if (this.dateTime.length == 12) {
            byte[] msec = new byte[4];
            System.arraycopy(this.dateTime, 7, msec, 0, 3);
            b = Convertion.fourByteToInt(msec);
        } else {
            b = this.getBit(this.dateTime, offset + 17, 20);
        }
        return b;
    }

    public final Date getDate() {
        return new Date(this.getYear() - 1900, this.getMonth() - 1, this.getDay());
    }

    public final Time getTime() {
        return new Time(this.getHour(0), this.getMinute(0), this.getSecond(0));
    }

    public final String getTimeInString() {
        int nanoLen;
        byte hour = this.getHour(0);
        byte min = this.getMinute(0);
        byte sec = this.getSecond(0);
        int nano = this.getNano(0);
        String h = "" + hour;
        String m = "" + min;
        String s = "" + sec;
        String n = "" + nano;
        if (h.length() < 2) {
            h = "0" + h;
        }
        if (m.length() < 2) {
            m = "0" + m;
        }
        if (s.length() < 2) {
            s = "0" + s;
        }
        if ((nanoLen = n.length()) < this.prec) {
            int addLen = this.prec - nanoLen;
            int i = 0;
            while (i < addLen) {
                n = "0" + n;
                ++i;
            }
        }
        if (this.prec > 0 && this.prec < 6 && n.length() > this.prec) {
            n = n.substring(0, this.prec);
        }
        if (this.prec == 0) {
            return String.valueOf(h) + ":" + m + ":" + s;
        }
        return String.valueOf(h) + ":" + m + ":" + s + "." + n;
    }

    public final String getDateInString() {
        int year = this.getYear();
        byte month = this.getMonth();
        byte day = this.getDay();
        boolean sign = false;
        if (year < 0) {
            sign = true;
            year = Math.abs(year);
        }
        String y = "" + year;
        String m = "" + month;
        String d = "" + day;
        if (y.length() < 4) {
            y = String.valueOf("0000".substring(0, 4 - y.length())) + y;
        }
        if (m.length() < 2) {
            m = "0" + m;
        }
        if (d.length() < 2) {
            d = "0" + d;
        }
        if (sign) {
            y = "-" + y;
        }
        String strDate = String.valueOf(y) + "-" + m + "-" + d;
        return strDate;
    }

    public final String getTimeOfTimestamp() {
        byte hour = this.getHour(24);
        byte min = this.getMinute(24);
        byte sec = this.getSecond(24);
        String h = "" + hour;
        String m = "" + min;
        String s = "" + sec;
        if (h.length() < 2) {
            h = "0" + h;
        }
        if (m.length() < 2) {
            m = "0" + m;
        }
        if (s.length() < 2) {
            s = "0" + s;
        }
        return String.valueOf(h) + ":" + m + ":" + s;
    }

    public final Timestamp getTimestamp() {
        String str = String.valueOf(String.valueOf(this.getDate())) + " " + this.getTimeOfTimestamp();
        Timestamp ts = Timestamp.valueOf(str);
        int x = 6 - this.prec;
        int nanos = this.getNano(24);
        String n = "" + nanos;
        if (x > 0 && n.length() > x) {
            nanos = this.getNano(24) / (int)Math.pow(10.0, x) * (int)Math.pow(10.0, x);
        } else if (x > 0) {
            nanos = 0;
        }
        ts.setNanos(nanos * 1000);
        return ts;
    }

    public static Date getDateByString(String s) throws SQLException {
        if (s == null) {
            throw new IllegalArgumentException();
        }
        int dividingSpace = s.indexOf(32);
        if (dividingSpace > 0) {
            s = s.substring(0, dividingSpace);
        }
        int firstDash = s.indexOf(45);
        int secondDash = s.indexOf(45, firstDash + 1);
        if (firstDash < 0 || secondDash < 0) {
            firstDash = s.indexOf(46);
            secondDash = s.indexOf(46, firstDash + 1);
        }
        if (firstDash < 0 || secondDash < 0) {
            firstDash = s.indexOf(47);
            secondDash = s.indexOf(47, firstDash + 1);
        }
        if (!(firstDash > 0 & secondDash > 0 & secondDash < s.length() - 1)) {
            throw new SQLException(Const.res.getString("error.invalidDateTimeTypeFormat"));
        }
        int year = Integer.parseInt(s.substring(0, firstDash)) - 1900;
        int month = Integer.parseInt(s.substring(firstDash + 1, secondDash)) - 1;
        int day = Integer.parseInt(s.substring(secondDash + 1));
        if (!DmdbDateTime.checkDate(year + 1900, month + 1, day)) {
            throw new SQLException(Const.res.getString("error.invalidDateTimeTypeFormat"));
        }
        return new Date(year, month, day);
    }

    public static boolean dmdt_is_leap_year(int year) {
        if (year < 0) {
            year = -year;
        }
        if (year % 4 == 0) {
            return year % 100 != 0 || year % 400 == 0;
        }
        return false;
    }

    public static boolean checkDate(int year, int month, int day) {
        if (year > 9999 || month > 12 || month < 1) {
            return false;
        }
        switch (month) {
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                if (day <= 31 && day >= 1) break;
                return false;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                if (day <= 30 && day >= 1) break;
                return false;
            }
            case 2: {
                if (!(DmdbDateTime.dmdt_is_leap_year(year) ? day > 29 || day < 1 : day > 28 || day < 1)) break;
                return false;
            }
        }
        return true;
    }

    public static boolean checkTime(int hour, int min, int sec, int msec) {
        return hour <= 23 && min <= 59 && sec <= 59 && msec <= 999999;
    }

    public static boolean checkTimezone(short tz) {
        return tz >= -779 && tz <= 780 || tz == 1000;
    }

    public static Timestamp getTimestampByString(String s, int dtype, int scale, int ltz) throws SQLException {
        int[] dt = DmdbDateTime.stringToDT(s, dtype, scale, ltz);
        return new Timestamp(dt[0] - 1900, dt[1] - 1, dt[2], dt[3], dt[4], dt[5], dt[6]);
    }

    public static int[] stringToDT(String s, int dtype, int scale, int ltz) throws SQLException {
        int a_nanos;
        int second;
        int minute;
        int hour;
        int day;
        int month;
        int year;
        String tz_s;
        block39: {
            String[] comps;
            String date_s = null;
            String time_s = null;
            String nanos_s = null;
            tz_s = null;
            year = 0;
            month = 0;
            day = 0;
            hour = 0;
            minute = 0;
            second = 0;
            a_nanos = 0;
            int firstColon = 0;
            int secondColon = 0;
            int period = 0;
            boolean sign = false;
            String zeros = "000000000";
            if (s == null) {
                throw new IllegalArgumentException("null string");
            }
            if ((s = s.trim()).startsWith("-", 0)) {
                s = s.substring(1).trim();
                sign = true;
            }
            if ((comps = s.split(" ")).length > 1) {
                switch (comps.length) {
                    case 3: {
                        date_s = comps[0];
                        time_s = comps[1];
                        tz_s = comps[2];
                        break;
                    }
                    case 2: {
                        date_s = comps[0];
                        time_s = comps[1];
                        break;
                    }
                    default: {
                        throw new SQLException(Const.res.getString("error.invalidDateTimeTypeFormat"));
                    }
                }
                int firstDash = date_s.indexOf(45);
                int secondDash = date_s.indexOf(45, firstDash + 1);
                if (firstDash < 0 || secondDash < 0) {
                    firstDash = s.indexOf(46);
                    secondDash = s.indexOf(46, firstDash + 1);
                }
                if (firstDash < 0 || secondDash < 0) {
                    firstDash = s.indexOf(47);
                    secondDash = s.indexOf(47, firstDash + 1);
                }
                if (time_s == null) {
                    throw new SQLException(Const.res.getString("error.invalidDateTimeTypeFormat"));
                }
                firstColon = time_s.indexOf(58);
                secondColon = time_s.indexOf(58, firstColon + 1);
                period = time_s.indexOf(46, secondColon + 1);
                if (!(firstDash > 0 & secondDash > 0 & secondDash < date_s.length() - 1)) {
                    throw new SQLException(Const.res.getString("error.invalidDateTimeTypeFormat"));
                }
                year = sign ? 0 - Integer.parseInt(date_s.substring(0, firstDash)) - 1900 : Integer.parseInt(date_s.substring(0, firstDash)) - 1900;
                month = Integer.parseInt(date_s.substring(firstDash + 1, secondDash)) - 1;
                day = Integer.parseInt(date_s.substring(secondDash + 1));
                if (firstColon > 0 & secondColon > 0 & secondColon < time_s.length() - 1) {
                    hour = Integer.parseInt(time_s.substring(0, firstColon));
                    minute = Integer.parseInt(time_s.substring(firstColon + 1, secondColon));
                    if (period > 0 & period < time_s.length() - 1) {
                        second = Integer.parseInt(time_s.substring(secondColon + 1, period));
                        nanos_s = time_s.substring(period + 1);
                        if (nanos_s.length() > 9) {
                            throw new SQLException(Const.res.getString("error.invalidDateTimeTypeFormat"));
                        }
                        if (!Character.isDigit(nanos_s.charAt(0))) {
                            throw new SQLException(Const.res.getString("error.invalidDateTimeTypeFormat"));
                        }
                        nanos_s = String.valueOf(nanos_s) + zeros.substring(0, 9 - nanos_s.length());
                        a_nanos = Integer.valueOf(nanos_s.substring(0, 6));
                    } else {
                        if (period > 0) {
                            throw new SQLException(Const.res.getString("error.invalidDateTimeTypeFormat"));
                        }
                        second = Integer.parseInt(time_s.substring(secondColon + 1));
                    }
                } else {
                    throw new SQLException(Const.res.getString("error.invalidDateTimeTypeFormat"));
                }
                if (!DmdbDateTime.checkDate(year + 1900, month + 1, day)) {
                    throw new SQLException(Const.res.getString("error.invalidDateTimeTypeFormat"));
                }
                if (hour > 24 || hour < 0 || minute > 60 || minute < 0 || second > 60 || second < 0) {
                    throw new SQLException(Const.res.getString("error.invalidDateTimeTypeFormat"));
                }
            } else {
                int dividingSpace = s.indexOf(45);
                int dividingSpace1 = s.indexOf(46);
                int dividingSpace2 = s.indexOf(47);
                if (dividingSpace > 0 || dividingSpace1 > 0 || dividingSpace2 > 0) {
                    try {
                        int firstDash = s.indexOf(45);
                        int secondDash = s.indexOf(45, firstDash + 1);
                        if (firstDash < 0 || secondDash < 0) {
                            firstDash = s.indexOf(46);
                            secondDash = s.indexOf(46, firstDash + 1);
                        }
                        if (firstDash < 0 || secondDash < 0) {
                            firstDash = s.indexOf(47);
                            secondDash = s.indexOf(47, firstDash + 1);
                        }
                        if (!(firstDash > 0 & secondDash > 0 & secondDash < s.length() - 1)) {
                            throw new SQLException(Const.res.getString("error.invalidDateTimeTypeFormat"));
                        }
                        year = sign ? 0 - Integer.parseInt(s.substring(0, firstDash)) - 1900 : Integer.parseInt(s.substring(0, firstDash)) - 1900;
                        month = Integer.parseInt(s.substring(firstDash + 1, secondDash)) - 1;
                        day = Integer.parseInt(s.substring(secondDash + 1));
                        if (!DmdbDateTime.checkDate(year + 1900, month + 1, day)) {
                            throw new SQLException(Const.res.getString("error.invalidDateTimeTypeFormat"));
                        }
                        break block39;
                    }
                    catch (Exception ex) {
                        throw new SQLException(Const.res.getString("error.invalidDateTimeTypeFormat"));
                    }
                }
                try {
                    Time t = Time.valueOf(s);
                    hour = t.getHours();
                    minute = t.getMinutes();
                    second = t.getSeconds();
                    day = 1;
                }
                catch (Exception ex) {
                    throw new SQLException(Const.res.getString("error.invalidDateTimeTypeFormat"));
                }
            }
        }
        if (tz_s != null && DmdbType.isLocalTimeZone(dtype, scale)) {
            boolean neg = false;
            if (tz_s.startsWith("-")) {
                neg = true;
            }
            if (tz_s.startsWith("-") || tz_s.startsWith("+")) {
                tz_s = tz_s.substring(1).trim();
            }
            String[] hm = tz_s.split(":");
            short tzh = 0;
            short tzm = 0;
            switch (hm.length) {
                case 2: {
                    tzh = Short.parseShort(hm[0].trim());
                    tzm = Short.parseShort(hm[1].trim());
                    break;
                }
                case 1: {
                    tzh = Short.parseShort(hm[0].trim());
                    break;
                }
                default: {
                    throw new SQLException(Const.res.getString("error.invalidDateTimeTypeFormat"));
                }
            }
            short ownTz = (short)(tzh * 60 + tzm);
            if (ownTz < 0) {
                throw new SQLException(Const.res.getString("error.invalidDateTimeTypeFormat"));
            }
            if (neg) {
                ownTz = (short)(ownTz * -1);
            }
            byte[] org = DmdbDateTime.dmdtEncodeTz(year, month, day, hour, minute, second, a_nanos, ownTz);
            byte[] lorg = DmdbDateTime.dmdtAddByFmt(org, 5, ltz - ownTz);
            year = Convertion.getShort(lorg, 0);
            month = Convertion.getByte(lorg, 2);
            day = Convertion.getByte(lorg, 3);
            hour = Convertion.getByte(lorg, 4);
            minute = Convertion.getByte(lorg, 5);
            second = Convertion.getByte(lorg, 6);
            a_nanos = Convertion.getByte(lorg, 7) + Convertion.getByte(lorg, 8) << 8 + Convertion.getByte(lorg, 9) << 16;
        }
        int[] dt = new int[]{year + 1900, month + 1, day, hour, minute, second, a_nanos};
        return dt;
    }

    public static String getTimeFromTimestamp(Timestamp ts) {
        int hour = ts.getHours();
        int min = ts.getMinutes();
        int sec = ts.getSeconds();
        int msec = ts.getNanos();
        String h = "" + hour;
        String m = "" + min;
        String s = "" + sec;
        if (h.length() < 2) {
            h = "0" + h;
        }
        if (m.length() < 2) {
            m = "0" + m;
        }
        if (s.length() < 2) {
            s = "0" + s;
        }
        return String.valueOf(h) + ":" + m + ":" + s + "." + msec;
    }

    public String getStringFromTimestamp(Timestamp ts) {
        String nanosString;
        String yearString;
        int year = ts.getYear();
        int month = ts.getMonth();
        int day = ts.getDate();
        int hour = ts.getHours();
        int minute = ts.getMinutes();
        int second = ts.getSeconds();
        int nanos = ts.getNanos();
        String zeros = "000000000";
        String yearZeros = "0000";
        if (year < 1000) {
            yearString = "" + year;
            yearString = String.valueOf(yearZeros.substring(0, 4 - yearString.length())) + yearString;
        } else {
            yearString = "" + year;
        }
        String monthString = month < 10 ? "0" + month : Integer.toString(month);
        String dayString = day < 10 ? "0" + day : Integer.toString(day);
        String hourString = hour < 10 ? "0" + hour : Integer.toString(hour);
        String minuteString = minute < 10 ? "0" + minute : Integer.toString(minute);
        String secondString = second < 10 ? "0" + second : Integer.toString(second);
        if (nanos == 0) {
            nanosString = "0";
        } else {
            nanosString = Integer.toString(nanos);
            nanosString = String.valueOf(zeros.substring(0, 9 - nanosString.length())) + nanosString;
            char[] nanosChar = new char[nanosString.length()];
            nanosString.getChars(0, nanosString.length(), nanosChar, 0);
            int truncIndex = 8;
            while (nanosChar[truncIndex] == '0') {
                --truncIndex;
            }
            nanosString = new String(nanosChar, 0, truncIndex + 1);
        }
        StringBuffer timestampBuf = new StringBuffer();
        timestampBuf.append(yearString);
        timestampBuf.append("-");
        timestampBuf.append(monthString);
        timestampBuf.append("-");
        timestampBuf.append(dayString);
        timestampBuf.append(" ");
        timestampBuf.append(hourString);
        timestampBuf.append(":");
        timestampBuf.append(minuteString);
        timestampBuf.append(":");
        timestampBuf.append(secondString);
        timestampBuf.append(".");
        timestampBuf.append(nanosString);
        return timestampBuf.toString();
    }

    int getBit(byte[] x, int start, int len) {
        int xx0 = 0;
        int start_bit = start & 7;
        int s = start >> 3;
        int e = (start + len - 1 >> 3) + 1;
        int n = e - s;
        int p = start >> 3;
        if (n == 1) {
            byte[] t1 = new byte[4];
            System.arraycopy(x, p, t1, 0, 1);
            xx0 = Convertion.fourByteToInt(t1);
        } else if (n == 2) {
            byte[] t1 = new byte[4];
            System.arraycopy(x, p, t1, 0, 1);
            int x1 = Convertion.fourByteToInt(t1);
            System.arraycopy(x, p + 1, t1, 0, 1);
            int x2 = Convertion.fourByteToInt(t1);
            x2 = x2 << 8 & 0xFFFFFFFF;
            xx0 = x1 + x2;
        } else if (n == 3) {
            byte[] t1 = new byte[4];
            System.arraycopy(x, p, t1, 0, 1);
            int x1 = Convertion.fourByteToInt(t1);
            System.arraycopy(x, p + 1, t1, 0, 1);
            int x2 = Convertion.fourByteToInt(t1);
            x2 = x2 << 8 & 0xFFFFFFFF;
            System.arraycopy(x, p + 2, t1, 0, 1);
            int x3 = Convertion.fourByteToInt(t1);
            x3 = x3 << 16 & 0xFFFFFFFF;
            xx0 = x1 + x2 + x3;
        }
        return xx0 >> start_bit & -1 >>> 32 - len;
    }

    int getBit_ex(byte[] x) {
        int len = 15;
        byte[] t1 = new byte[4];
        System.arraycopy(x, 0, t1, 0, 1);
        int x1 = Convertion.fourByteToInt(t1);
        System.arraycopy(x, 1, t1, 0, 1);
        int x2 = Convertion.fourByteToInt(t1);
        x2 = x2 << 8 & 0xFFFFFFFF;
        int xx0 = x1 + x2;
        int year = xx0 >> 0 & -1 >>> 32 - len;
        if (year > 9999) {
            year = (short)((short)xx0 | 0x8000);
        }
        return year;
    }

    public static byte[] dmdtEncodeFast(byte[] dateTime) {
        if (dateTime.length == 8) {
            return dateTime;
        }
        byte[] ret = new byte[8];
        short year = Convertion.getShort(dateTime, 0);
        byte month = dateTime[2];
        byte day = dateTime[3];
        ret[0] = dateTime[0];
        ret[1] = (byte)(year >> 8 | (month & 1) << 7);
        ret[2] = (byte)((month & 0xE) >> 1 | day << 3);
        byte hour = dateTime[4];
        byte min = dateTime[5];
        byte sec = dateTime[6];
        int msec = (dateTime[7] & 0xFF) + ((dateTime[8] & 0xFF) << 8) + ((dateTime[9] & 0xFF) << 16);
        ret[3] = (byte)(hour | (min & 7) << 5);
        ret[4] = (byte)((min & 0x38) >> 3 | (sec & 0x1F) << 3);
        ret[5] = (byte)((sec & 0x20) >> 5 | (msec & 0x7F) << 1);
        ret[6] = (byte)(msec >> 7 & 0xFF);
        ret[7] = (byte)(msec >> 15 & 0xFF);
        return ret;
    }

    byte[] dmdtDecodeFast() {
        byte[] datetime = new byte[12];
        short year = this.getYear();
        Convertion.setShort(datetime, 0, year);
        byte month = this.getMonth();
        Convertion.setByte(datetime, 2, month);
        byte day = this.getDay();
        Convertion.setByte(datetime, 3, day);
        byte hour = this.getHour(24);
        Convertion.setByte(datetime, 4, hour);
        byte min = this.getMinute(24);
        Convertion.setByte(datetime, 5, min);
        byte sec = this.getSecond(24);
        Convertion.setByte(datetime, 6, sec);
        int msec = this.getNano(24);
        Convertion.setByte(datetime, 7, (byte)(msec & 0xFF));
        Convertion.setByte(datetime, 8, (byte)(msec >> 8 & 0xFF));
        Convertion.setByte(datetime, 9, (byte)(msec >> 16 & 0xFF));
        Convertion.setShort(datetime, 10, (short)0);
        return datetime;
    }

    public static byte[] dateEncodeFast(byte[] dateTime) {
        byte[] ret = new byte[3];
        if (dateTime.length == 3) {
            return dateTime;
        }
        short year = Convertion.getShort(dateTime, 0);
        byte month = dateTime[2];
        byte day = dateTime[3];
        ret[0] = dateTime[0];
        ret[1] = (byte)(year >> 8 | (month & 1) << 7);
        ret[2] = (byte)((month & 0xE) >> 1 | day << 3);
        return ret;
    }

    static byte[] dmdtEncodeTz(int year, int month, int day, int hour, int min, int sec, int msec, short tz) throws SQLException {
        if (!DmdbDateTime.checkDate(year, month, day)) {
            if (year == 0 && month == 0 && day == 0) {
                Timestamp ts = new Timestamp(System.currentTimeMillis());
                year = ts.getYear() + 1900;
                month = ts.getMonth() + 1;
                day = ts.getDay();
            } else {
                DBError.throwSQLException(-2512);
                return null;
            }
        }
        if (!DmdbDateTime.checkTime(hour, min, sec, msec)) {
            DBError.throwSQLException(-2512);
            return null;
        }
        if (!DmdbDateTime.checkTimezone(tz)) {
            DBError.throwSQLException(-2512);
            return null;
        }
        byte[] dt = new byte[12];
        Convertion.setShort(dt, 0, (short)year);
        Convertion.setByte(dt, 2, (byte)month);
        Convertion.setByte(dt, 3, (byte)day);
        Convertion.setByte(dt, 4, (byte)hour);
        Convertion.setByte(dt, 5, (byte)min);
        Convertion.setByte(dt, 6, (byte)sec);
        Convertion.setByte(dt, 7, (byte)(msec & 0xFF));
        Convertion.setByte(dt, 8, (byte)(msec >> 8 & 0xFF));
        Convertion.setByte(dt, 9, (byte)(msec >> 16 & 0xFF));
        Convertion.setShort(dt, 10, tz);
        return dt;
    }

    public static byte[] dmdtAddByFmt(byte[] dt, int fmt, int n) throws SQLException {
        if (dt == null || dt.length != 12) {
            DBError.throwSQLException(-2512);
        }
        int year = Convertion.getShort(dt, 0);
        int month = Convertion.getByte(dt, 2);
        int day = Convertion.getByte(dt, 3);
        int hour = Convertion.getByte(dt, 4);
        int min = Convertion.getByte(dt, 5);
        int sec = Convertion.getByte(dt, 6);
        int msec = Convertion.getByte(dt, 7) & 0xFF | (Convertion.getByte(dt, 8) & 0xFF) << 8 | (Convertion.getByte(dt, 9) & 0xFF) << 16;
        short tz = Convertion.getShort(dt, 10);
        int[] rets = null;
        switch (fmt) {
            case 1: {
                year += n;
                break;
            }
            case 8: {
                n *= 3;
            }
            case 2: {
                year += (month += n) / 12;
                if ((month %= 12) < 1) {
                    month += 12;
                    --year;
                }
                if (day <= Const.global_day_by_month[month]) break;
                day = Const.global_day_by_month[month];
                if (month != 2 || !DmdbDateTime.dmdt_is_leap_year(year)) break;
                ++day;
                break;
            }
            case 7: {
                msec = msec / 1000 + n;
                n = msec / 1000;
                msec %= 1000;
                while (msec < 0) {
                    msec += 1000;
                    --n;
                }
                msec *= 1000;
                if (n == 0) break;
            }
            case 6: {
                int tmp = sec + n;
                n = tmp / 60;
                sec = tmp % 60;
                if (sec < 0) {
                    sec += 60;
                    --n;
                }
                if (n == 0) break;
            }
            case 5: {
                int tmp = min + n;
                n = tmp / 60;
                min = tmp % 60;
                if (min < 0) {
                    min += 60;
                    --n;
                }
                if (n == 0) break;
            }
            case 4: {
                int tmp = hour + n;
                n = tmp / 24;
                hour = tmp % 24;
                if (hour < 0) {
                    hour += 24;
                    --n;
                }
                if (n == 0) break;
            }
            case 3: 
            case 9: {
                rets = DmdbDateTime.dmdtDateAdd(year, month, day, n);
                year = rets[0];
                month = rets[1];
                day = rets[2];
                break;
            }
            case 10: {
                rets = DmdbDateTime.dmdtDateAdd(year, month, day, n * 7);
                year = rets[0];
                month = rets[1];
                day = rets[2];
                break;
            }
        }
        if (year > 9999) {
            DBError.throwSQLException(-2512);
        }
        return DmdbDateTime.dmdtEncodeTz(year, month, day, hour, min, sec, msec, tz);
    }

    static int dmdt_calc_n_days_from_zero(int year, int month, int day) {
        if (year <= 0 && month <= 0 && day <= 0) {
            return 0;
        }
        int ndays = year * 365 + Const.global_days_befor_month[month - 1] + day;
        if (month <= 2) {
            --year;
        }
        int leap_days = year / 4 - year / 100 + year / 400;
        return ndays += leap_days;
    }

    static int[] dmdt_get_date_by_ndays_from_zero(int ndays) {
        int[] retVals = new int[3];
        if (ndays <= 365 || ndays > 3652424) {
            retVals[2] = 99;
            retVals[1] = 99;
            retVals[0] = 99;
            return retVals;
        }
        int year = ndays * 100 / 36525;
        int tmp = ((year - 1) / 100 + 1) * 3 / 4;
        int days_left = ndays - year * 365 - (year - 1) / 4 + tmp;
        int days_in_year = DmdbDateTime.dmdt_is_leap_year(year) ? 366 : 365;
        while (days_left > days_in_year) {
            days_left -= days_in_year;
            int n = days_in_year = DmdbDateTime.dmdt_is_leap_year(++year) ? 366 : 365;
        }
        if (days_in_year == 366 && days_left > 59 && --days_left == 59) {
            retVals[0] = year;
            retVals[1] = 2;
            retVals[2] = 29;
            return retVals;
        }
        int month = 1;
        while (days_left > Const.global_day_by_month[month]) {
            days_left -= Const.global_day_by_month[month];
            ++month;
        }
        retVals[0] = year;
        retVals[1] = month;
        retVals[2] = days_left;
        return retVals;
    }

    static int[] dmdtDateAdd(int year, int month, int day, int n) {
        int ndays = DmdbDateTime.dmdt_calc_n_days_from_zero(year, month, day);
        return DmdbDateTime.dmdt_get_date_by_ndays_from_zero(ndays += n);
    }

    public String getTimestampInString() {
        String str = String.valueOf(this.getDateInString()) + " " + this.getTimeOfTimestamp();
        String n = "" + this.getNano(24);
        int nanoLen = n.length();
        if (this.prec == 0) {
            return str;
        }
        if (nanoLen < this.prec) {
            int addLen = this.prec - nanoLen;
            int i = 0;
            while (i < addLen) {
                n = "0" + n;
                ++i;
            }
        }
        if (this.prec > 0 && this.prec < 6 && nanoLen > this.prec) {
            n = n.substring(0, this.prec);
        }
        return String.valueOf(str) + "." + n;
    }
}

