/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.rowset;

import dm.jdbc.dbaccess.Const;
import dm.jdbc.dbaccess.DBError;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.SQLException;

public class DmdbSerialBlob
implements Serializable,
Cloneable,
Blob {
    private byte[] m_buffer;
    private long m_length;

    DmdbSerialBlob(byte[] buf) {
        this.m_length = buf != null ? (long)buf.length : 0L;
        if (this.m_length <= 0L) {
            return;
        }
        this.m_buffer = new byte[(int)this.m_length];
        System.arraycopy(buf, 0, this.m_buffer, 0, (int)this.m_length);
    }

    DmdbSerialBlob(Blob blob) throws SQLException {
        if (blob == null) {
            return;
        }
        this.m_length = blob.length();
        if (this.m_length > Integer.MAX_VALUE) {
            throw new SQLException(Const.res.getString("error.dataTooLarge"));
        }
        this.m_buffer = blob.getBytes(1L, (int)this.m_length);
    }

    public long length() throws SQLException {
        return this.m_length;
    }

    public byte[] getBytes(long pos, int length) throws SQLException {
        if (pos < 1L || (long)length > this.m_length || pos + (long)length > this.m_length) {
            DBError.throwSQLException(6057);
        }
        byte[] dest = new byte[length];
        System.arraycopy(this.m_buffer, (int)pos - 1, dest, 0, length);
        return dest;
    }

    public InputStream getBinaryStream() throws SQLException {
        return new ByteArrayInputStream(this.m_buffer);
    }

    public long position(byte[] pattern, long start) throws SQLException {
        if (pattern == null || start > this.m_length || start < 1L) {
            return -1L;
        }
        long posRet = -1L;
        int ptnsize = pattern.length;
        int i = (int)(start - 1L);
        while ((long)i < this.m_length) {
            int j = 0;
            while (j < ptnsize) {
                if (this.m_buffer[i] != pattern[j]) break;
                ++i;
                ++j;
            }
            if (j == ptnsize) {
                posRet = i + 1;
                break;
            }
            j = 0;
            ++i;
        }
        return posRet;
    }

    public long position(Blob pattern, long start) throws SQLException {
        if (pattern == null || start < 1L || start > this.m_length) {
            return -1L;
        }
        return this.position(pattern.getBytes(0L, (int)pattern.length()), start);
    }

    public int setBytes(long pos, byte[] bytes) throws SQLException {
        DBError.throwUnsupportedSQLException();
        return -1;
    }

    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        DBError.throwUnsupportedSQLException();
        return -1;
    }

    public OutputStream setBinaryStream(long pos) throws SQLException {
        DBError.throwUnsupportedSQLException();
        return null;
    }

    public void truncate(long len) throws SQLException {
        DBError.throwUnsupportedSQLException();
    }

    public void free() throws SQLException {
        if (this.m_buffer != null || this.m_length > 0L) {
            this.m_buffer = null;
            this.m_length = 0L;
        }
    }
}

