/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.rowset;

import dm.jdbc.dataConvertion.CType2JType;
import dm.jdbc.dataConvertion.Convertion;
import dm.jdbc.dataConvertion.ReaderToInputStream;
import dm.jdbc.dbaccess.Const;
import dm.jdbc.dbaccess.DBError;
import dm.jdbc.driver.DmdbConnection_bs;
import dm.jdbc.driver.DmdbResultSetMetaData_bs;
import dm.jdbc.driver.DmdbResultSet_bs;
import dm.jdbc.rowset.DmdbCachedRowSetReaderInner;
import dm.jdbc.rowset.DmdbCachedRowSetWriterInner;
import dm.jdbc.rowset.DmdbParameter;
import dm.jdbc.rowset.DmdbRow;
import dm.jdbc.rowset.DmdbRowSetInner;
import dm.jdbc.rowset.DmdbSerialBlob;
import dm.jdbc.rowset.DmdbSerialClob;
import dm.sql.DmdbDateTime;
import dm.sql.DmdbIntervalDT;
import dm.sql.DmdbIntervalYM;
import dm.sql.DmdbTime;
import dm.sql.STRUCT;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringBufferInputStream;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.sql.RowSetListener;
import javax.sql.RowSetReader;
import javax.sql.RowSetWriter;
import javax.sql.rowset.RowSetWarning;
import javax.sql.rowset.serial.SerialBlob;
import javax.sql.rowset.serial.SerialClob;
import javax.sql.rowset.spi.SyncFactory;
import javax.sql.rowset.spi.SyncFactoryException;
import javax.sql.rowset.spi.SyncProvider;
import javax.sql.rowset.spi.SyncProviderException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DmdbCachedRowSet_bs
extends DmdbRowSetInner {
    private static transient DmdbConnection_bs m_conn_bs = null;
    protected DmdbResultSet_bs m_resultSet_bs = null;
    protected String m_serverEncoding = null;
    protected int m_currentRow = 0;
    protected boolean m_previousColNull;
    protected int m_currentPage = 1;
    protected int m_pageCount = 0;
    private int m_pageSize = 0;
    private boolean m_populatedDone = false;
    protected int m_columnCount = 0;
    protected int m_rowCount = 0;
    protected Vector<DmdbRow> m_rows = null;
    private DmdbRow m_insertRow = null;
    private int m_insertRowPos = 0;
    private int m_updateRowPos = 0;
    private boolean m_insertFlag = false;
    private boolean m_updateFlag = false;
    private Vector<DmdbParameter> m_params = null;
    private SQLWarning m_sqlWarning = null;
    private RowSetWarning m_rowsetWarning;
    protected DmdbResultSetMetaData_bs m_rsmd = null;
    private String[] m_columnNames = null;
    private String m_tableName = null;
    private int[] m_keyColumns;
    private DmdbCachedRowSetReaderInner m_reader;
    private DmdbCachedRowSetWriterInner m_writer;
    private static final String DEFAULT_SYNCPROVIDER = "com.sun.rowset.providers.RIOptimisticProvider";
    private SyncProvider m_syncProvider = null;
    protected boolean m_closed = false;
    private boolean m_KeepConnecting = false;

    DmdbCachedRowSet_bs() throws SQLException {
        this.initialize();
    }

    private void initialize() throws SQLException {
        this.m_currentRow = 0;
        this.m_columnCount = 0;
        this.m_previousColNull = false;
        this.m_currentPage = 1;
        this.m_pageSize = 0;
        this.m_resultSet_bs = null;
        this.m_populatedDone = false;
        this.m_rowCount = 0;
        if (this.m_rows == null) {
            this.m_rows = new Vector(50);
        } else {
            this.m_rows.clear();
        }
        this.m_showDeleted = false;
        this.m_insertRow = null;
        this.m_insertRowPos = 0;
        this.m_insertFlag = false;
        this.m_updateFlag = false;
        this.m_params = new Vector(10);
        this.m_sqlWarning = new SQLWarning();
        this.m_rowsetWarning = new RowSetWarning();
        this.m_rsmd = null;
        this.m_columnNames = null;
        this.m_tableName = null;
        this.m_keyColumns = new int[0];
        this.m_reader = new DmdbCachedRowSetReaderInner();
        this.m_writer = new DmdbCachedRowSetWriterInner();
        this.m_closed = false;
        this.m_KeepConnecting = false;
        try {
            this.m_syncProvider = SyncFactory.getInstance(DEFAULT_SYNCPROVIDER);
        }
        catch (SyncFactoryException syncfactoryexception) {
            throw new SQLException("SyncProvider instance not constructed.");
        }
    }

    private void uninitialize() {
        this.m_currentRow = 0;
        this.m_columnCount = 0;
        this.m_currentPage = 1;
        this.m_resultSet_bs = null;
        this.m_populatedDone = false;
        this.m_rowCount = 0;
        this.m_rows = null;
        this.m_showDeleted = false;
        this.m_insertRow = null;
        this.m_insertRowPos = 0;
        this.m_insertFlag = false;
        this.m_updateFlag = false;
    }

    protected DmdbRow getCurrentRow() throws SQLException {
        if (this.m_currentRow < 1 || this.m_currentRow > this.m_rowCount) {
            throw new SQLException(Const.res.getString("error.cursorNotInResultSet"));
        }
        return this.m_rows.elementAt(this.m_currentRow - 1);
    }

    protected synchronized Object getObjectInner(int col) throws SQLException {
        this.checkColumn(col);
        DmdbRow row = this.getCurrentRow();
        Object obj = null;
        obj = row.isColumnChanged(col - 1) ? row.getChangedColumn(col - 1) : row.getColumn(col - 1);
        boolean bl = this.m_previousColNull = obj == null;
        if (!this.m_previousColNull && obj instanceof STRUCT) {
            STRUCT struct = (STRUCT)obj;
            obj = CType2JType.getStruct_SQLData(this.getTypeMap(), struct, struct.getSQLTypeName());
        }
        return obj;
    }

    protected synchronized Object getObjectInner(int col, Map<String, Class<?>> map) throws SQLException {
        this.checkColumn(col);
        DmdbRow row = this.getCurrentRow();
        Object obj = null;
        obj = row.isColumnChanged(col - 1) ? row.getChangedColumn(col - 1) : row.getColumn(col - 1);
        boolean bl = this.m_previousColNull = obj == null;
        if (!this.m_previousColNull && obj instanceof STRUCT) {
            STRUCT struct = (STRUCT)obj;
            obj = CType2JType.getStruct_SQLData(map, struct, struct.getSQLTypeName());
        }
        return obj;
    }

    protected synchronized InputStream getStreamInner(int col) throws SQLException {
        Object obj = this.getObjectInner(col);
        if (obj == null) {
            return null;
        }
        if (obj instanceof InputStream) {
            return (InputStream)obj;
        }
        if (obj instanceof byte[]) {
            return new ByteArrayInputStream((byte[])obj);
        }
        if (obj instanceof Byte) {
            byte[] bs = new byte[]{};
            bs[0] = (Byte)obj;
            return new ByteArrayInputStream(bs);
        }
        if (obj instanceof String) {
            return new ByteArrayInputStream(Convertion.getBytes((String)obj, this.m_serverEncoding));
        }
        if (obj instanceof Blob) {
            return ((SerialBlob)obj).getBinaryStream();
        }
        if (obj instanceof Clob) {
            return ((SerialClob)obj).getAsciiStream();
        }
        if (obj instanceof Reader) {
            BufferedReader breader = new BufferedReader((Reader)obj);
            ReaderToInputStream chgTemp = new ReaderToInputStream();
            InputStream in = chgTemp.ReaderTo(breader, this.m_serverEncoding);
            return in;
        }
        throw new SQLException(Const.res.getString("error.dataConvertionError"));
    }

    protected synchronized void updateObjectInner(int i, Object obj) throws SQLException {
        this.checkColumn(i);
        if (this.m_insertFlag) {
            this.m_insertRow.updateColumnValue(i - 1, obj);
            return;
        }
        if (this.isBeforeFirst() || this.isAfterLast()) {
            throw new SQLException(Const.res.getString("error.cursorNotInResultSet"));
        }
        this.m_updateFlag = true;
        this.m_updateRowPos = this.m_currentRow;
        this.getCurrentRow().updateColumnValue(i - 1, obj);
    }

    protected synchronized Number getNumber(int i) throws SQLException {
        Object obj = this.getObjectInner(i);
        if (obj == null) {
            return null;
        }
        if (obj instanceof Number) {
            return (Number)obj;
        }
        if (obj instanceof Boolean) {
            return new Integer((Boolean)obj != false ? 1 : 0);
        }
        if (obj instanceof String) {
            return new BigDecimal((String)obj);
        }
        throw new SQLException(Const.res.getString("error.dataConvertionError"));
    }

    private boolean setOriginalRowInner(int rowIndex) {
        DmdbRow row = this.m_rows.get(rowIndex);
        if (row.isRowDeleted()) {
            this.m_rows.removeElementAt(rowIndex);
            --this.m_rowCount;
            return true;
        }
        if (row.isRowInserted()) {
            row.setRowInserted(false);
        } else if (row.isRowUpdated()) {
            row.setUpdatesOriginal();
        }
        return false;
    }

    protected void setOriginal() {
        int i = 0;
        while (i < this.m_rowCount) {
            if (this.setOriginalRowInner(i)) {
                --i;
            }
            ++i;
        }
    }

    protected synchronized void notifyCursorMoved() throws SQLException {
        if (this.m_insertFlag) {
            this.m_insertFlag = false;
            this.m_insertRow.setRowUpdated(false);
            DBError.addSQLWarning(this.m_sqlWarning, 20020);
        } else if (this.m_updateFlag) {
            this.m_updateFlag = false;
            int i = this.m_currentRow;
            this.m_currentRow = this.m_updateRowPos;
            this.getCurrentRow().setRowUpdated(false);
            this.m_currentRow = i;
            DBError.addSQLWarning(this.m_sqlWarning, 20020);
        }
    }

    protected void checkCurrentRow() throws SQLException {
        if (this.m_insertFlag) {
            throw new SQLException(Const.res.getString("error.resultsetInInsertStatus"));
        }
        if (this.isBeforeFirst() || this.isAfterLast()) {
            throw new SQLException(Const.res.getString("error.cursorNotInResultSet"));
        }
    }

    protected void checkColumn(int idx) throws SQLException {
        if (idx < 1 || idx > this.m_columnCount) {
            DBError.throwSQLException(6032);
        }
    }

    private void checkRowSet() throws SQLException {
        if (this.m_rows == null || this.m_rows.size() == 0) {
            throw new SQLException(Const.res.getString("error.cachedRowSetNull"));
        }
    }

    private void putParamToVector(Object col, DmdbParameter param) {
        boolean exist = false;
        int len = this.m_params.size();
        String pName = null;
        int pIndex = -1;
        int i = 0;
        while (i < len) {
            DmdbParameter parameter = this.m_params.elementAt(i);
            pName = parameter.getParamName();
            pIndex = parameter.getParamIndex();
            if (pName != null && pName.equalsIgnoreCase((String)col) || pName == null && pIndex == (Integer)col) {
                this.m_params.set(i, param);
                exist = true;
                break;
            }
            ++i;
        }
        if (!exist) {
            this.m_params.add(param);
        }
    }

    protected void setObjectInner(Object col, Object obj) throws SQLException {
        Object[] params = new Object[]{obj};
        this.putParamToVector(col, new DmdbParameter(col, params));
    }

    protected void setObjectInner(Object col, Object obj, int i, boolean bySetObject) throws SQLException {
        Object[] params = new Object[]{obj, i};
        DmdbParameter param = new DmdbParameter(col, params);
        param.setBySetObject(bySetObject);
        this.putParamToVector(col, param);
    }

    protected void setObjectInner(Object col, Object obj, long l) throws SQLException {
        Object[] params = new Object[]{obj, l};
        DmdbParameter param = new DmdbParameter(col, params);
        this.putParamToVector(col, param);
    }

    protected void setObjectInner(Object col, Object obj, Calendar cal) throws SQLException {
        Object[] params = new Object[]{obj, cal};
        this.putParamToVector(col, new DmdbParameter(col, params));
    }

    protected void setObjectInner(Object col, Object obj, int i, String str) throws SQLException {
        Object[] params = new Object[]{obj, i, str};
        DmdbParameter param = new DmdbParameter(col, params);
        param.setBySetObject(true);
        this.putParamToVector(col, param);
    }

    protected void setObjectInner(Object col, Object obj, int i, int j) throws SQLException {
        Object[] params = new Object[]{obj, i, j};
        DmdbParameter param = new DmdbParameter(col, params);
        param.setBySetObject(true);
        this.putParamToVector(col, param);
    }

    Vector<DmdbParameter> getParamsInner() throws SQLException {
        return this.m_params;
    }

    boolean keepConnecting() {
        return this.m_KeepConnecting;
    }

    public boolean next() throws SQLException {
        if (this.m_rowCount <= 0) {
            return false;
        }
        int fetchDirection = this.getFetchDirection();
        if (fetchDirection == 1000 || fetchDirection == 1002) {
            if (this.m_currentRow < this.m_rowCount) {
                ++this.m_currentRow;
                DmdbRow row = this.getCurrentRow();
                if (!this.m_showDeleted && row.isRowDeleted()) {
                    return this.next();
                }
                this.notifyCursorMoved();
                return true;
            }
            this.m_currentRow = this.m_rowCount + 1;
            return false;
        }
        if (fetchDirection == 1001) {
            if (this.m_currentRow > 1) {
                --this.m_currentRow;
                DmdbRow row = this.getCurrentRow();
                if (!this.m_showDeleted && row.isRowDeleted()) {
                    return this.next();
                }
                this.notifyCursorMoved();
                return true;
            }
            this.m_currentRow = 0;
            return false;
        }
        return false;
    }

    public void beforeFirst() throws SQLException {
        this.m_currentRow = 0;
    }

    public boolean isBeforeFirst() throws SQLException {
        return this.m_rowCount > 0 && this.m_currentRow == 0;
    }

    public boolean isAfterLast() throws SQLException {
        return this.m_rowCount > 0 && this.m_currentRow == this.m_rowCount + 1;
    }

    public boolean isFirst() throws SQLException {
        return this.m_rowCount > 0 && this.m_currentRow == 1;
    }

    public boolean isLast() throws SQLException {
        return this.m_rowCount > 0 && this.m_currentRow == this.m_rowCount;
    }

    public void afterLast() throws SQLException {
        this.m_currentRow = this.m_rowCount + 1;
    }

    public boolean first() throws SQLException {
        return this.absolute(1);
    }

    public boolean last() throws SQLException {
        return this.absolute(-1);
    }

    public boolean absolute(int row) throws SQLException {
        if (this.getType() == 1003) {
            DBError.throwSQLException(6019);
        }
        if (row == 0 || this.m_rowCount == 0) {
            return false;
        }
        if (this.m_currentRow == row) {
            return true;
        }
        if (row > 0 && Math.abs(row) > this.m_rowCount) {
            this.m_currentRow = this.m_rowCount + 1;
            this.notifyCursorMoved();
            return false;
        }
        if (row < 0 && Math.abs(row) > this.m_rowCount) {
            this.m_currentRow = 0;
            this.notifyCursorMoved();
            return false;
        }
        this.m_currentRow = row > 0 ? row : this.m_rowCount + row + 1;
        this.notifyCursorMoved();
        return true;
    }

    public boolean relative(int rows) throws SQLException {
        return this.absolute(this.m_currentRow + rows);
    }

    public boolean previous() throws SQLException {
        int fetchDirection;
        if (this.getType() == 1003) {
            DBError.throwSQLException(6019);
        }
        if ((fetchDirection = this.getFetchDirection()) == 1001) {
            if (this.m_currentRow < this.m_columnCount) {
                ++this.m_currentRow;
                if (!this.m_showDeleted && this.getCurrentRow().isRowDeleted()) {
                    return this.previous();
                }
                this.notifyCursorMoved();
                return true;
            }
            this.m_currentRow = this.m_columnCount + 1;
            this.notifyCursorMoved();
            return false;
        }
        if (fetchDirection == 1000 || fetchDirection == 1002) {
            if (this.m_currentRow > 1) {
                --this.m_currentRow;
                if (!this.m_showDeleted && this.getCurrentRow().isRowDeleted()) {
                    return this.previous();
                }
                this.notifyCursorMoved();
                return true;
            }
            this.m_currentRow = 0;
            this.notifyCursorMoved();
            return false;
        }
        return false;
    }

    public boolean nextPage() throws SQLException {
        if (this.getFetchDirection() == 1001 && this.m_resultSet_bs != null && this.m_resultSet_bs.getType() == 1003) {
            DBError.throwSQLException(20021);
        }
        if (this.m_rows == null || this.m_rows.size() == 0 && !this.m_populatedDone) {
            DBError.throwSQLException(20022);
        }
        if (this.m_currentPage >= this.m_pageCount) {
            return false;
        }
        this.populate(this.m_resultSet_bs);
        ++this.m_currentPage;
        return true;
    }

    public boolean previousPage() throws SQLException {
        if (this.m_resultSet_bs != null && this.m_resultSet_bs.getType() == 1003) {
            DBError.throwSQLException(20021);
        }
        if (this.m_rows == null || this.m_rows.size() == 0 && !this.m_populatedDone) {
            DBError.throwSQLException(20022);
        }
        if (this.m_currentPage <= 1) {
            return false;
        }
        this.m_resultSet_bs.relative(-(this.m_pageSize + this.m_rowCount) - 1);
        this.populate(this.m_resultSet_bs);
        --this.m_currentPage;
        return true;
    }

    protected DmdbResultSetMetaData_bs getMetaDataInner() throws SQLException {
        return this.m_rsmd;
    }

    public boolean rowUpdated() throws SQLException {
        return this.getCurrentRow().isRowUpdated();
    }

    public boolean rowInserted() throws SQLException {
        return this.getCurrentRow().isRowInserted();
    }

    public boolean rowDeleted() throws SQLException {
        return this.getCurrentRow().isRowDeleted();
    }

    public void insertRow() throws SQLException {
        if (!this.m_insertFlag) {
            DBError.throwSQLException(6026);
        }
        if (!this.m_insertRow.isRowFullyPopulated()) {
            DBError.throwSQLException(20023);
        }
        this.m_insertRow.insertRow();
        this.m_rows.insertElementAt(this.m_insertRow, this.m_insertRowPos - 1);
        ++this.m_rowCount;
        this.notifyRowChanged();
    }

    public void updateRow() throws SQLException {
        if (!this.m_updateFlag) {
            DBError.throwSQLException(6026);
        }
        this.getCurrentRow().setRowUpdated(true);
        this.m_updateFlag = false;
        this.notifyRowChanged();
    }

    public void deleteRow() throws SQLException {
        if (this.m_insertFlag) {
            throw new SQLException(Const.res.getString("error.resultsetInInsertStatus"));
        }
        this.getCurrentRow().setRowDeleted(true);
        this.notifyRowChanged();
    }

    public void refreshRow() throws SQLException {
        this.cancelRowUpdates();
    }

    public void cancelRowUpdates() throws SQLException {
        DmdbRow row = this.getCurrentRow();
        if (row.isRowUpdated()) {
            this.m_updateFlag = false;
            row.setRowUpdated(false);
            this.notifyRowChanged();
        }
    }

    public void cancelRowInsert() throws SQLException {
        if (this.m_insertRow != null) {
            this.m_rows.remove(this.m_insertRowPos - 1);
            --this.m_rowCount;
            this.m_insertRow = null;
            this.notifyRowChanged();
        }
    }

    public void cancelRowDelete() throws SQLException {
        DmdbRow row = this.getCurrentRow();
        if (row.isRowDeleted()) {
            row.setRowDeleted(false);
            this.notifyRowChanged();
        }
    }

    public void moveToInsertRow() throws SQLException {
        this.m_insertRow = new DmdbRow(this.m_columnCount, true);
        this.m_insertFlag = true;
        this.m_insertRowPos = this.isAfterLast() ? this.m_currentRow : this.m_currentRow + 1;
    }

    public void moveToCurrentRow() throws SQLException {
        if (this.m_insertFlag) {
            this.m_insertFlag = false;
            this.m_updateFlag = false;
            this.absolute(this.m_currentRow);
        }
    }

    protected void populate(DmdbResultSet_bs data) throws SQLException {
        if (data == null) {
            DBError.throwSQLException(20025);
        }
        this.m_resultSet_bs = data;
        this.m_rsmd = (DmdbResultSetMetaData_bs)this.m_resultSet_bs.getMetaData();
        this.m_columnCount = this.m_rsmd.getColumnCount();
        this.m_columnNames = new String[this.m_columnCount];
        int i = 0;
        while (i < this.m_columnCount) {
            this.m_columnNames[i] = this.m_rsmd.getColumnName(i + 1);
            ++i;
        }
        if (this.m_columnCount < 1) {
            return;
        }
        this.m_tableName = this.m_rsmd.getTableName(1);
        long rowSize = 0L;
        long maxRows = this.getMaxRows();
        rowSize = maxRows == 0L && this.m_pageSize == 0 ? Long.MAX_VALUE : (maxRows == 0L || this.m_pageSize == 0 ? Math.max(maxRows, (long)this.m_pageSize) : Math.min(maxRows, (long)this.m_pageSize));
        int fetchDirect = this.getFetchDirection();
        boolean fetchForward = fetchDirect == 1000 || fetchDirect == 1002;
        long rowTotal = this.m_resultSet_bs.getRowCount();
        this.m_pageCount = (int)(rowTotal / rowSize);
        if (rowTotal % rowSize > 0L) {
            ++this.m_pageCount;
        }
        if (1 == this.m_currentPage && !fetchForward && this.m_resultSet_bs.getType() != 1003) {
            this.m_resultSet_bs.afterLast();
            this.m_currentPage = this.m_pageCount + 1;
        }
        if (this.m_rows == null) {
            this.m_rows = new Vector(50);
        } else {
            this.m_rows.clear();
        }
        this.m_currentRow = 0;
        this.m_rowCount = 0;
        while ((long)this.m_rowCount < rowSize && !(fetchForward ? !this.m_resultSet_bs.next() : !this.m_resultSet_bs.previous())) {
            DmdbRow row = new DmdbRow(this.m_columnCount);
            int i2 = 0;
            while (i2 < this.m_columnCount) {
                Object obj = this.m_resultSet_bs.getObject(i2 + 1, (Map)this.getTypeMap());
                if (obj instanceof Clob) {
                    DmdbSerialClob clob = new DmdbSerialClob((Clob)obj);
                    row.setColumnValue(i2, clob);
                } else if (obj instanceof Blob) {
                    DmdbSerialBlob blob = new DmdbSerialBlob((Blob)obj);
                    row.setColumnValue(i2, blob);
                } else {
                    row.setColumnValue(i2, obj);
                    row.setOriginalNull(i2, this.m_resultSet_bs.wasNull());
                }
                ++i2;
            }
            if (fetchForward) {
                this.m_rows.add(row);
            } else {
                this.m_rows.add(0, row);
            }
            ++this.m_rowCount;
        }
        if (fetchForward && this.m_resultSet_bs.isAfterLast() || !fetchForward && this.m_resultSet_bs.isBeforeFirst()) {
            this.m_populatedDone = true;
        }
        this.notifyRowSetChanged();
    }

    protected void populate(DmdbResultSet_bs rs, int startRow) throws SQLException {
        boolean fetchForward;
        if (startRow < 0) {
            DBError.throwSQLException(20024);
        }
        if (rs == null) {
            DBError.throwSQLException(20025);
        }
        if (rs.getRowCount() < (long)startRow) {
            DBError.throwSQLException(20026);
        }
        rs.absolute(startRow);
        int fetchDirect = rs.getFetchDirection();
        boolean bl = fetchForward = fetchDirect == 1000 || fetchDirect == 1002;
        if (fetchForward) {
            rs.previous();
        } else {
            rs.next();
        }
        this.populate(rs);
    }

    protected void execute() throws SQLException {
        this.m_reader.readData(this);
    }

    protected void execute(DmdbConnection_bs conn) throws SQLException {
        this.m_KeepConnecting = true;
        m_conn_bs = conn;
        this.m_reader.readData(this);
    }

    protected void acceptChanges() throws SyncProviderException {
        try {
            this.m_writer.writeData(this);
        }
        catch (SQLException sqlexception) {
            throw new SyncProviderException(sqlexception.getMessage());
        }
    }

    protected void acceptChanges(DmdbConnection_bs con) throws SyncProviderException {
        this.m_KeepConnecting = true;
        m_conn_bs = con;
        this.acceptChanges();
    }

    public void restoreOriginal() throws SQLException {
        int i = 0;
        while (i < this.m_rowCount) {
            DmdbRow row = this.m_rows.elementAt(i);
            if (row.isRowInserted()) {
                this.m_rows.remove(i);
                --this.m_rowCount;
                --i;
            } else if (row.isRowUpdated()) {
                row.setRowUpdated(false);
            } else if (row.isRowDeleted()) {
                row.setRowDeleted(false);
            }
            ++i;
        }
        this.notifyRowSetChanged();
    }

    public void release() throws SQLException {
        this.uninitialize();
        this.notifyRowSetChanged();
    }

    public void close() throws SQLException {
        if (this.m_closed) {
            return;
        }
        if (m_conn_bs != null && !m_conn_bs.isClosed()) {
            m_conn_bs.close();
            m_conn_bs = null;
        }
        this.release();
        this.m_closed = true;
    }

    public void undoDelete() throws SQLException {
        if (this.m_insertFlag) {
            throw new SQLException(Const.res.getString("error.resultsetInInsertStatus"));
        }
        if (this.isBeforeFirst() || this.isAfterLast()) {
            throw new SQLException(Const.res.getString("error.cursorNotInResultSet"));
        }
        DmdbRow row = this.getCurrentRow();
        if (!row.isRowDeleted()) {
            throw new SQLException(Const.res.getString("error.cachedRowSetCRowNDel"));
        }
        row.setRowDeleted(false);
        this.notifyRowChanged();
    }

    public void undoInsert() throws SQLException {
        if (this.m_insertFlag) {
            throw new SQLException(Const.res.getString("error.resultsetInInsertStatus"));
        }
        if (this.isBeforeFirst() || this.isAfterLast()) {
            throw new SQLException(Const.res.getString("error.cursorNotInResultSet"));
        }
        DmdbRow row = this.getCurrentRow();
        if (!row.isRowInserted()) {
            throw new SQLException(Const.res.getString("error.cachedRowSetCRowNIns"));
        }
        this.m_rows.remove(--this.m_currentRow);
        --this.m_rowCount;
        this.notifyRowChanged();
    }

    public void undoUpdate() throws SQLException {
        if (this.m_insertFlag) {
            throw new SQLException(Const.res.getString("error.resultsetInInsertStatus"));
        }
        if (this.isBeforeFirst() || this.isAfterLast()) {
            throw new SQLException(Const.res.getString("error.cursorNotInResultSet"));
        }
        DmdbRow row = this.getCurrentRow();
        if (!row.isRowUpdated()) {
            throw new SQLException(Const.res.getString("error.cachedRowSetCRowNUpd"));
        }
        row.setRowUpdated(false);
        this.notifyRowChanged();
    }

    public boolean columnUpdated(int idx) throws SQLException {
        this.checkColumn(idx);
        this.checkCurrentRow();
        return this.getCurrentRow().isColumnChanged(idx - 1);
    }

    public boolean columnUpdated(String columnName) throws SQLException {
        int idx = this.findColumn(columnName);
        return this.columnUpdated(idx);
    }

    public Collection<?> toCollection() throws SQLException {
        Map<Integer, Collection> map = Collections.synchronizedMap(new TreeMap());
        try {
            int i = 0;
            while (i < this.m_rowCount) {
                map.put(new Integer(i), this.m_rows.elementAt(i).toCollection());
                ++i;
            }
        }
        catch (Exception exception) {
            map = null;
            throw new SQLException(Const.res.getString("error.cachedRowSetToClcFailed"));
        }
        return map.values();
    }

    public Collection<?> toCollection(int column) throws SQLException {
        this.checkColumn(column);
        Vector<Object> cols = new Vector<Object>(this.m_rowCount);
        int i = 0;
        while (i < this.m_rowCount) {
            DmdbRow row = this.m_rows.elementAt(i);
            Object obj = row.isColumnChanged(column - 1) ? row.getChangedColumn(column - 1) : row.getColumn(column - 1);
            cols.add(obj);
            ++i;
        }
        return cols;
    }

    public Collection<?> toCollection(String column) throws SQLException {
        int idx = this.findColumn(column);
        return this.toCollection(idx);
    }

    public SyncProvider getSyncProvider() throws SQLException {
        return this.m_syncProvider;
    }

    public void setSyncProvider(String provider) throws SQLException {
        try {
            this.m_syncProvider = SyncFactory.getInstance(provider);
        }
        catch (SyncFactoryException syncfactoryexception) {
            throw new SQLException("SyncProvider instance not constructed.");
        }
    }

    public int size() {
        return this.m_rowCount;
    }

    public void setMetaData(DmdbResultSetMetaData_bs md) throws SQLException {
        this.m_rsmd = md;
        if (this.m_rsmd != null) {
            this.m_columnCount = this.m_rsmd.getColumnCount();
            this.m_columnNames = new String[this.m_columnCount];
            int i = 0;
            while (i < this.m_columnCount) {
                this.m_columnNames[i] = this.m_rsmd.getColumnName(i + 1);
                ++i;
            }
        }
    }

    protected DmdbRow getOriginalRowData() throws SQLException {
        return new DmdbRow(this.m_columnCount, this.getCurrentRow().getOriginalRow());
    }

    public void setOriginalRow() throws SQLException {
        this.checkCurrentRow();
        this.setOriginalRowInner(this.m_currentRow);
    }

    public String getTableName() throws SQLException {
        return this.m_tableName;
    }

    public void setTableName(String tabName) throws SQLException {
        if (tabName == null) {
            throw new SQLException(Const.res.getString("error.cachedRowSetTabNameNull"));
        }
        this.m_tableName = tabName;
    }

    public int[] getKeyColumns() throws SQLException {
        this.checkRowSet();
        return this.m_keyColumns;
    }

    public void setKeyColumns(int[] keys) throws SQLException {
        boolean valid = true;
        if (keys == null) {
            valid = false;
        } else {
            int i = 0;
            while (i < keys.length) {
                if (keys[i] < 1 || keys[i] > this.m_columnCount) {
                    valid = false;
                    break;
                }
                ++i;
            }
        }
        if (!valid) {
            throw new SQLException(Const.res.getString("error.cachedRowSetColKeyInvalid"));
        }
        this.m_keyColumns = keys;
    }

    public RowSetWarning getRowSetWarnings() throws SQLException {
        return this.m_rowsetWarning;
    }

    public void setPageSize(int size) throws SQLException {
        if (size < 1 || this.getMaxRows() > 0 && size > this.getMaxRows()) {
            throw new SQLException(Const.res.getString("error.cachedRowSetPageSizeInvalid"));
        }
        this.m_pageSize = size;
    }

    public int getPageSize() {
        return this.m_pageSize;
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        if (this.m_columnNames == null) {
            DBError.throwSQLException(6017);
        }
        int ret = -1;
        int i = 0;
        while (i < this.m_columnNames.length) {
            if (this.m_columnNames[i].equalsIgnoreCase(columnName)) {
                ret = i + 1;
                break;
            }
            ++i;
        }
        if (ret < 1) {
            DBError.throwSQLException(6017);
        }
        return ret;
    }

    public Object[] getParams() throws SQLException {
        Vector<DmdbParameter> params = this.getParamsInner();
        int size = params.size();
        Object[] objs = new Object[size];
        int i = 0;
        while (i < size) {
            objs[i] = params.elementAt(i).getParams()[0];
            ++i;
        }
        return objs;
    }

    public void setReader(RowSetReader reader) {
        this.m_reader = (DmdbCachedRowSetReaderInner)((Object)reader);
    }

    public void setWriter(RowSetWriter writer) {
        this.m_writer = (DmdbCachedRowSetWriterInner)((Object)writer);
    }

    protected void rowsetShared(DmdbCachedRowSet_bs cachedrowset) throws SQLException {
        cachedrowset.m_rows = this.m_rows;
        cachedrowset.setDataSourceName(this.getDataSourceName());
        cachedrowset.setUsername(this.getUsername());
        cachedrowset.setPassword(this.getPassword());
        cachedrowset.setUrl(this.getUrl());
        cachedrowset.setTypeMap(this.getTypeMap());
        cachedrowset.setMaxFieldSize(this.getMaxFieldSize());
        cachedrowset.setMaxRows(this.getMaxRows());
        cachedrowset.setQueryTimeout(this.getQueryTimeout());
        cachedrowset.setFetchSize(this.getFetchSize());
        cachedrowset.setEscapeProcessing(this.getEscapeProcessing());
        cachedrowset.setConcurrency(this.getConcurrency());
        cachedrowset.setReadOnly(this.isReadOnly());
        cachedrowset.setType(this.getType());
        cachedrowset.setFetchDirection(this.getFetchDirection());
        cachedrowset.setCommand(this.getCommand());
        cachedrowset.setTransactionIsolation(this.getTransactionIsolation());
        cachedrowset.m_currentRow = this.m_currentRow;
        cachedrowset.m_columnCount = this.m_columnCount;
        cachedrowset.m_rowCount = this.m_rowCount;
        cachedrowset.m_showDeleted = this.m_showDeleted;
        cachedrowset.m_syncProvider = this.m_syncProvider;
        cachedrowset.m_currentPage = this.m_currentPage;
        cachedrowset.m_pageSize = this.m_pageSize;
        cachedrowset.m_tableName = this.m_tableName;
        cachedrowset.m_keyColumns = this.m_keyColumns != null ? (int[])this.m_keyColumns.clone() : null;
        int i = this.m_listeners.size();
        int j = 0;
        while (j < i) {
            cachedrowset.m_listeners.add((RowSetListener)this.m_listeners.elementAt(j));
            ++j;
        }
        cachedrowset.m_rsmd = this.m_rsmd;
        i = this.m_params.size();
        int k = 0;
        while (k < i) {
            cachedrowset.m_params.add(this.m_params.elementAt(k));
            ++k;
        }
        if (this.m_columnNames != null) {
            cachedrowset.m_columnNames = new String[this.m_columnNames.length];
            System.arraycopy(this.m_columnNames, 0, cachedrowset.m_columnNames, 0, this.m_columnNames.length);
        }
    }

    protected void rowsetCopy(DmdbCachedRowSet_bs rowset) throws SQLException {
        this.rowsetShared(rowset);
        rowset.m_rows = new Vector(rowset.m_rowCount);
        int j = 0;
        while (j < this.m_rowCount) {
            rowset.m_rows.add(this.m_rows.elementAt(j).createCopy());
            ++j;
        }
    }

    public void setTIME(int parameterIndex, DmdbTime dt) throws SQLException {
        this.setObjectInner(parameterIndex, dt);
    }

    public void setTIME(String parameterName, DmdbTime dt) throws SQLException {
        this.setObjectInner(parameterName, dt);
    }

    public void setINTERVALDT(int parameterIndex, DmdbIntervalDT dt) throws SQLException {
        this.setObjectInner(parameterIndex, dt);
    }

    public void setINTERVALDT(String parameterName, DmdbIntervalDT dt) throws SQLException {
        this.setObjectInner(parameterName, dt);
    }

    public void setINTERVALYM(int parameterIndex, DmdbIntervalYM ym) throws SQLException {
        this.setObjectInner(parameterIndex, ym);
    }

    public void setINTERVALYM(String parameterName, DmdbIntervalYM ym) throws SQLException {
        this.setObjectInner(parameterName, ym);
    }

    public void updateINTERVALYM(int i, DmdbIntervalYM ym) throws SQLException {
        this.updateObjectInner(i, ym);
    }

    public void updateINTERVALYM(String s, DmdbIntervalYM ym) throws SQLException {
        this.updateINTERVALYM(this.findColumn(s), ym);
    }

    public void updateINTERVALDT(int i, DmdbIntervalDT dt) throws SQLException {
        this.updateObjectInner(i, dt);
    }

    public void updateINTERVALDT(String s, DmdbIntervalDT dt) throws SQLException {
        this.updateINTERVALDT(this.findColumn(s), dt);
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.setObjectInner((Object)parameterIndex, null, sqlType, false);
    }

    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        this.setObjectInner((Object)paramIndex, null, sqlType, typeName);
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.setObjectInner(parameterIndex, x);
    }

    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.setObjectInner(parameterIndex, x);
    }

    public void setShort(int parameterIndex, short x) throws SQLException {
        this.setObjectInner(parameterIndex, x);
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        this.setObjectInner(parameterIndex, x);
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        this.setObjectInner(parameterIndex, x);
    }

    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.setObjectInner(parameterIndex, Float.valueOf(x));
    }

    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.setObjectInner(parameterIndex, x);
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.setObjectInner(parameterIndex, x);
    }

    public void setString(int parameterIndex, String x) throws SQLException {
        this.setObjectInner(parameterIndex, x);
    }

    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.setObjectInner(parameterIndex, x);
    }

    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.setObjectInner(parameterIndex, x);
    }

    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.setObjectInner(parameterIndex, x);
    }

    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.setObjectInner(parameterIndex, x);
    }

    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setObjectInner((Object)parameterIndex, (Object)x, length, false);
    }

    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setObjectInner((Object)parameterIndex, (Object)x, length, false);
    }

    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.setObjectInner((Object)parameterIndex, (Object)reader, length, false);
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        this.setObjectInner((Object)parameterIndex, x, targetSqlType, scale);
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.setObjectInner((Object)parameterIndex, x, targetSqlType, true);
    }

    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.setObjectInner(parameterIndex, x);
    }

    public void setRef(int i, Ref x) throws SQLException {
        DBError.throwUnsupportedSQLException();
    }

    public void setBlob(int i, Blob x) throws SQLException {
        this.setObjectInner(i, x);
    }

    public void setClob(int i, Clob x) throws SQLException {
        this.setObjectInner(i, x);
    }

    public void setArray(int i, Array x) throws SQLException {
        DBError.throwUnsupportedSQLException();
    }

    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.setObjectInner((Object)parameterIndex, (Object)x, cal);
    }

    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.setObjectInner((Object)parameterIndex, (Object)x, cal);
    }

    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.setObjectInner((Object)parameterIndex, (Object)x, cal);
    }

    public void clearParameters() throws SQLException {
        this.m_params.clear();
    }

    public boolean wasNull() throws SQLException {
        return this.m_previousColNull;
    }

    public boolean getBoolean(int columnIndex) throws SQLException {
        Object obj = this.getObjectInner(columnIndex);
        if (obj == null) {
            return false;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        if (obj instanceof Number) {
            return ((Number)obj).doubleValue() != 0.0;
        }
        throw new SQLException(Const.res.getString("error.dataConvertionError"));
    }

    public short getShort(int columnIndex) throws SQLException {
        Number num = this.getNumber(columnIndex);
        return num == null ? (short)0 : num.shortValue();
    }

    public int getInt(int columnIndex) throws SQLException {
        Number num = this.getNumber(columnIndex);
        return num == null ? 0 : num.intValue();
    }

    public long getLong(int columnIndex) throws SQLException {
        Number num = this.getNumber(columnIndex);
        return num == null ? 0L : num.longValue();
    }

    public float getFloat(int columnIndex) throws SQLException {
        Number num = this.getNumber(columnIndex);
        return num == null ? 0.0f : num.floatValue();
    }

    public double getDouble(int columnIndex) throws SQLException {
        Number num = this.getNumber(columnIndex);
        return num == null ? 0.0 : num.doubleValue();
    }

    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        Number num = this.getNumber(columnIndex);
        if (num == null) {
            return null;
        }
        BigDecimal bd = null;
        bd = num instanceof BigDecimal ? (BigDecimal)num : new BigDecimal(num.doubleValue());
        bd.setScale(scale);
        return bd;
    }

    public Date getDate(int columnIndex) throws SQLException {
        Object obj = this.getObjectInner(columnIndex);
        if (obj == null) {
            return null;
        }
        if (obj instanceof Date) {
            return (Date)obj;
        }
        if (obj instanceof Time) {
            Time time = (Time)obj;
            return new Date(time.getTime());
        }
        if (obj instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)obj;
            return new Date(timestamp.getYear(), timestamp.getMonth(), timestamp.getDay());
        }
        if (obj instanceof String) {
            return DmdbDateTime.getDateByString((String)obj);
        }
        throw new SQLException(Const.res.getString("error.dataConvertionError"));
    }

    public Time getTime(int columnIndex) throws SQLException {
        Object obj = this.getObjectInner(columnIndex);
        if (obj == null) {
            return null;
        }
        if (obj instanceof Time) {
            return (Time)obj;
        }
        if (obj instanceof Date) {
            Date date = (Date)obj;
            return new Time(date.getTime());
        }
        if (obj instanceof Timestamp) {
            Timestamp timstamp = (Timestamp)obj;
            return new Time(timstamp.getTime());
        }
        if (obj instanceof String) {
            Timestamp timstamp = DmdbDateTime.getTimestampByString((String)obj, 0, 0, 0);
            return new Time(timstamp.getTime());
        }
        throw new SQLException(Const.res.getString("error.dataConvertionError"));
    }

    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        Object obj = this.getObjectInner(columnIndex);
        if (obj == null) {
            return null;
        }
        if (obj instanceof Timestamp) {
            return (Timestamp)obj;
        }
        if (obj instanceof Time) {
            return new Timestamp(((Time)obj).getTime());
        }
        if (obj instanceof Date) {
            return new Timestamp(((Date)obj).getTime());
        }
        if (obj instanceof String) {
            return DmdbDateTime.getTimestampByString((String)obj, 0, 0, 0);
        }
        throw new SQLException(Const.res.getString("error.dataConvertionError"));
    }

    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        return this.getStreamInner(columnIndex);
    }

    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        Object obj = this.getObjectInner(columnIndex);
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return new StringBufferInputStream((String)obj);
        }
        throw new SQLException(Const.res.getString("error.dataConvertionError"));
    }

    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        return this.getStreamInner(columnIndex);
    }

    public boolean getBoolean(String columnName) throws SQLException {
        return this.getBoolean(this.findColumn(columnName));
    }

    public short getShort(String columnName) throws SQLException {
        return this.getShort(this.findColumn(columnName));
    }

    public int getInt(String columnName) throws SQLException {
        return this.getInt(this.findColumn(columnName));
    }

    public long getLong(String columnName) throws SQLException {
        return this.getLong(this.findColumn(columnName));
    }

    public float getFloat(String columnName) throws SQLException {
        return this.getFloat(this.findColumn(columnName));
    }

    public double getDouble(String columnName) throws SQLException {
        return this.getDouble(this.findColumn(columnName));
    }

    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName), scale);
    }

    public Date getDate(String columnName) throws SQLException {
        return this.getDate(this.findColumn(columnName));
    }

    public Time getTime(String columnName) throws SQLException {
        return this.getTime(this.findColumn(columnName));
    }

    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName));
    }

    public InputStream getAsciiStream(String columnName) throws SQLException {
        return this.getAsciiStream(this.findColumn(columnName));
    }

    public InputStream getUnicodeStream(String columnName) throws SQLException {
        return this.getUnicodeStream(this.findColumn(columnName));
    }

    public InputStream getBinaryStream(String columnName) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnName));
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.m_sqlWarning;
    }

    public void clearWarnings() throws SQLException {
        this.m_sqlWarning = null;
    }

    public String getCursorName() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Object getObject(int columnIndex) throws SQLException {
        return this.getObjectInner(columnIndex, this.getTypeMap());
    }

    public Object getObject(String columnName) throws SQLException {
        return this.getObject(this.findColumn(columnName));
    }

    public Reader getCharacterStream(int columnIndex) throws SQLException {
        Object obj = this.getObjectInner(columnIndex);
        if (obj == null) {
            return null;
        }
        if (obj instanceof byte[]) {
            return new InputStreamReader(new ByteArrayInputStream((byte[])obj));
        }
        if (obj instanceof Byte) {
            byte[] bs = new byte[]{(Byte)obj};
            return new InputStreamReader(new ByteArrayInputStream(bs));
        }
        if (obj instanceof String) {
            return new StringReader((String)obj);
        }
        if (obj instanceof Blob) {
            return new InputStreamReader(((SerialBlob)obj).getBinaryStream());
        }
        if (obj instanceof Clob) {
            return ((SerialClob)obj).getCharacterStream();
        }
        throw new SQLException(Const.res.getString("error.dataConvertionError"));
    }

    public Reader getCharacterStream(String columnName) throws SQLException {
        return this.getCharacterStream(this.findColumn(columnName));
    }

    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        Number num = this.getNumber(columnIndex);
        if (num == null) {
            return null;
        }
        if (num instanceof BigDecimal) {
            return (BigDecimal)num;
        }
        return new BigDecimal(num.doubleValue());
    }

    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName));
    }

    public int getRow() throws SQLException {
        return this.m_currentRow;
    }

    public void updateNull(int columnIndex) throws SQLException {
        this.updateObjectInner(columnIndex, null);
    }

    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        this.updateObjectInner(columnIndex, x);
    }

    public void updateByte(int columnIndex, byte x) throws SQLException {
        this.updateObjectInner(columnIndex, x);
    }

    public void updateShort(int columnIndex, short x) throws SQLException {
        this.updateObjectInner(columnIndex, x);
    }

    public void updateInt(int columnIndex, int x) throws SQLException {
        this.updateObjectInner(columnIndex, x);
    }

    public void updateLong(int columnIndex, long x) throws SQLException {
        this.updateObjectInner(columnIndex, x);
    }

    public void updateFloat(int columnIndex, float x) throws SQLException {
        this.updateObjectInner(columnIndex, Float.valueOf(x));
    }

    public void updateDouble(int columnIndex, double x) throws SQLException {
        this.updateObjectInner(columnIndex, x);
    }

    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        this.updateObjectInner(columnIndex, x);
    }

    public void updateString(int columnIndex, String x) throws SQLException {
        this.updateObjectInner(columnIndex, x);
    }

    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        this.updateObjectInner(columnIndex, x);
    }

    public void updateDate(int columnIndex, Date x) throws SQLException {
        this.updateObjectInner(columnIndex, x);
    }

    public void updateTime(int columnIndex, Time x) throws SQLException {
        this.updateObjectInner(columnIndex, x);
    }

    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        this.updateObjectInner(columnIndex, x);
    }

    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.updateObjectInner(columnIndex, x);
    }

    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.updateObjectInner(columnIndex, x);
    }

    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        this.updateObjectInner(columnIndex, x);
    }

    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        this.updateObjectInner(columnIndex, x);
    }

    public void updateObject(int columnIndex, Object x) throws SQLException {
        this.updateObjectInner(columnIndex, x);
    }

    public void updateNull(String columnName) throws SQLException {
        this.updateNull(this.findColumn(columnName));
    }

    public void updateBoolean(String columnName, boolean x) throws SQLException {
        this.updateBoolean(this.findColumn(columnName), x);
    }

    public void updateByte(String columnName, byte x) throws SQLException {
        this.updateByte(this.findColumn(columnName), x);
    }

    public void updateShort(String columnName, short x) throws SQLException {
        this.updateShort(this.findColumn(columnName), x);
    }

    public void updateInt(String columnName, int x) throws SQLException {
        this.updateInt(this.findColumn(columnName), x);
    }

    public void updateLong(String columnName, long x) throws SQLException {
        this.updateLong(this.findColumn(columnName), x);
    }

    public void updateFloat(String columnName, float x) throws SQLException {
        this.updateFloat(this.findColumn(columnName), x);
    }

    public void updateDouble(String columnName, double x) throws SQLException {
        this.updateDouble(this.findColumn(columnName), x);
    }

    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        this.updateBigDecimal(this.findColumn(columnName), x);
    }

    public void updateString(String columnName, String x) throws SQLException {
        this.updateString(this.findColumn(columnName), x);
    }

    public void updateBytes(String columnName, byte[] x) throws SQLException {
        this.updateBytes(this.findColumn(columnName), x);
    }

    public void updateDate(String columnName, Date x) throws SQLException {
        this.updateDate(this.findColumn(columnName), x);
    }

    public void updateTime(String columnName, Time x) throws SQLException {
        this.updateTime(this.findColumn(columnName), x);
    }

    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        this.updateTimestamp(this.findColumn(columnName), x);
    }

    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        this.updateAsciiStream(this.findColumn(columnName), x, length);
    }

    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        this.updateBinaryStream(this.findColumn(columnName), x, length);
    }

    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnName), reader, length);
    }

    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        this.updateObject(columnName, x);
    }

    public void updateObject(String columnName, Object x) throws SQLException {
        this.updateObjectInner(this.findColumn(columnName), x);
    }

    public Object getObject(int i, Map<String, Class<?>> map) throws SQLException {
        return this.getObjectInner(i, map);
    }

    public Ref getRef(int i) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Blob getBlob(int i) throws SQLException {
        Object obj = this.getObjectInner(i);
        if (obj == null) {
            return null;
        }
        if (obj instanceof DmdbSerialBlob) {
            return (Blob)obj;
        }
        throw new SQLException(Const.res.getString("error.dataConvertionError"));
    }

    public Clob getClob(int i) throws SQLException {
        Object obj = this.getObjectInner(i);
        if (obj == null) {
            return null;
        }
        if (obj instanceof DmdbSerialClob) {
            return (Clob)obj;
        }
        throw new SQLException(Const.res.getString("error.dataConvertionError"));
    }

    public Array getArray(int i) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Object getObject(String colName, Map<String, Class<?>> map) throws SQLException {
        return this.getObjectInner(this.findColumn(colName), map);
    }

    public Ref getRef(String colName) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Blob getBlob(String colName) throws SQLException {
        return this.getBlob(this.findColumn(colName));
    }

    public Clob getClob(String colName) throws SQLException {
        return this.getClob(this.findColumn(colName));
    }

    public Array getArray(String colName) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        Date date = this.getDate(columnIndex);
        if (cal == null) {
            cal = Calendar.getInstance();
        }
        cal.clear();
        cal.setTimeInMillis(date.getTime());
        return new Date(cal.getTimeInMillis());
    }

    public Date getDate(String columnName, Calendar cal) throws SQLException {
        return this.getDate(this.findColumn(columnName), cal);
    }

    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        Time time = this.getTime(columnIndex);
        if (cal == null) {
            cal = Calendar.getInstance();
        }
        cal.clear();
        cal.setTimeInMillis(time.getTime());
        return new Time(cal.getTimeInMillis());
    }

    public Time getTime(String columnName, Calendar cal) throws SQLException {
        return this.getTime(this.findColumn(columnName), cal);
    }

    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        Timestamp timestamp = this.getTimestamp(columnIndex);
        if (cal == null) {
            cal = Calendar.getInstance();
        }
        cal.clear();
        cal.setTimeInMillis(timestamp.getTime());
        return new Timestamp(cal.getTimeInMillis());
    }

    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName), cal);
    }

    public URL getURL(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public URL getURL(String columnName) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateRef(String columnName, Ref x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        this.updateObjectInner(columnIndex, x);
    }

    public void updateBlob(String columnName, Blob x) throws SQLException {
        this.updateBlob(this.findColumn(columnName), x);
    }

    public void updateClob(int columnIndex, Clob x) throws SQLException {
        this.updateObjectInner(columnIndex, x);
    }

    public void updateClob(String columnName, Clob x) throws SQLException {
        this.updateClob(this.findColumn(columnName), x);
    }

    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateArray(String columnName, Array x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void commit() throws SQLException {
        this.getConnectionInner().commit();
    }

    public void rollback() throws SQLException {
        this.getConnectionInner().rollback();
    }

    public void rollback(Savepoint s) throws SQLException {
        this.getConnectionInner().rollback(s);
    }

    abstract DmdbConnection_bs getConnectionInner() throws SQLException;
}

