/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.innerData;

import dm.jdbc.dataConvertion.Convertion;
import dm.jdbc.dbaccess.DBError;
import java.sql.SQLException;

public class DmdbBdta {
    public static final int BDTA3_PACKAGE_NROWS = 0;
    public static final int BDTA3_PACKAGE_NFLDS = 4;
    public static final int BDTA3_PACKAGE_LENGTH = 6;
    public static final int BDTA3_PACKAGE_ORG_LEN = 10;
    public static final int BDTA3_PACKAGE_COMPRESS = 14;
    public static final int BDTA3_PACKAGE_HEAD_LEN = 15;
    private static final int VAR_DATA_LEN_STR = -2;
    private static final int VAR_DATA_LEN_DEC = -3;
    public int len;
    public int rownum;
    private int nflds;
    private int[] col_sql_type;
    private int[] col_offset;
    private int[] row_offset;
    private boolean[] col_is_all_not_null;
    private int curpos;
    private byte[] rowbuf;
    private int start_offset = 0;

    public DmdbBdta(byte[] rowbuf, int offset) throws SQLException {
        this.rowbuf = rowbuf;
        this.start_offset = offset;
        this.bdta3_unpack();
    }

    public void bdta3_unpack() throws SQLException {
        int offset = this.start_offset;
        byte[] buffer = this.rowbuf;
        this.len = (int)Convertion.getUInt(buffer, offset + 6);
        this.rownum = (int)Convertion.getUInt(buffer, offset + 0);
        this.nflds = Convertion.getUShort(buffer, offset + 4);
        offset += 15;
        this.col_sql_type = new int[this.nflds];
        int i = 0;
        while (i < this.nflds) {
            this.col_sql_type[i] = Convertion.getUShort(buffer, offset);
            offset += 2;
            ++i;
        }
        this.col_offset = new int[this.nflds];
        this.row_offset = new int[this.nflds];
        this.col_is_all_not_null = new boolean[this.nflds];
        i = 0;
        while (i < this.nflds) {
            this.col_offset[i] = this.start_offset + (int)Convertion.getUInt(buffer, offset);
            offset += 4;
            int tmp_off = this.col_offset[i];
            this.col_is_all_not_null[i] = Convertion.getUInt(buffer, tmp_off) == 1L;
            tmp_off += 4;
            if (!this.col_is_all_not_null[i]) {
                tmp_off += this.rownum * 1;
            }
            this.row_offset[i] = tmp_off;
            ++i;
        }
    }

    public boolean next() throws SQLException {
        if (this.curpos >= this.rownum - 1) {
            return false;
        }
        int colIndex = 0;
        while (colIndex < this.nflds) {
            if (!this.isNull(this.curpos, colIndex)) {
                int dtype_data_len = this.get_dtype_data_len(this.col_sql_type[colIndex]);
                if (dtype_data_len == -2) {
                    int offset = this.row_offset[colIndex] + 4;
                    int data_len = (int)Convertion.getUInt(this.rowbuf, offset);
                    this.row_offset[colIndex] = (offset += 4) + data_len;
                } else if (dtype_data_len == -3) {
                    int data_len = (int)Convertion.getUInt(this.rowbuf, this.row_offset[colIndex]);
                    int n = colIndex;
                    this.row_offset[n] = this.row_offset[n] + (data_len + 4);
                } else {
                    int n = colIndex;
                    this.row_offset[n] = this.row_offset[n] + dtype_data_len;
                }
            }
            ++colIndex;
        }
        ++this.curpos;
        return true;
    }

    private boolean isNull(int rowIndex, int colIndex) {
        if (this.col_is_all_not_null[colIndex]) {
            return false;
        }
        int temp = this.col_offset[colIndex] + 4 + rowIndex * 1;
        return this.rowbuf[temp] != 1;
    }

    private int get_dtype_data_len(int dtype) throws SQLException {
        int datalen = 0;
        switch (dtype) {
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 13: 
            case 25: {
                datalen = 4;
                break;
            }
            case 8: 
            case 24: {
                datalen = 8;
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 12: 
            case 17: 
            case 18: 
            case 19: {
                datalen = -2;
                break;
            }
            case 9: {
                datalen = -3;
                break;
            }
            case 10: {
                datalen = 4;
                break;
            }
            case 11: {
                datalen = 8;
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 22: 
            case 23: {
                datalen = 12;
                break;
            }
            case 20: {
                datalen = 12;
                break;
            }
            case 21: {
                datalen = 24;
                break;
            }
            default: {
                DBError.throwSQLException(6016);
            }
        }
        return datalen;
    }

    public boolean absolute(int position) throws SQLException {
        if (position < 0) {
            position = 0;
        }
        if (position >= this.rownum) {
            position = this.rownum - 1;
        }
        if (position != 0 || this.curpos != 0) {
            this.absolute_row_offset(position);
        }
        this.curpos = position;
        return true;
    }

    private void absolute_row_offset(int position) throws SQLException {
        int colIndex = 0;
        while (colIndex < this.nflds) {
            int offset = this.col_offset[colIndex] + 4;
            byte[] null_arr = null;
            if (!this.col_is_all_not_null[colIndex]) {
                null_arr = new byte[this.rownum];
                System.arraycopy(this.rowbuf, offset, null_arr, 0, this.rownum);
                offset += this.rownum * 1;
            }
            this.row_offset[colIndex] = position <= 0 ? offset : this.bdta3_unpack_col_offset(this.rowbuf, offset, colIndex, null_arr, position);
            ++colIndex;
        }
    }

    private int bdta3_unpack_col_offset(byte[] buffer, int offset, int colIndex, byte[] null_arr, int rows) throws SQLException {
        int dtype_data_len = this.get_dtype_data_len(this.col_sql_type[colIndex]);
        if (dtype_data_len == -2) {
            offset = this.bdta3_unpack_col_offset_str(buffer, offset, this.col_is_all_not_null[colIndex], null_arr, rows);
        } else if (dtype_data_len == -3) {
            offset = this.bdta3_unpack_col_offset_dec(buffer, offset, this.col_is_all_not_null[colIndex], null_arr, rows);
        } else if (this.col_is_all_not_null[colIndex]) {
            offset += rows * dtype_data_len;
        } else {
            int nullcount = 0;
            int j = 0;
            while (j < rows) {
                if (null_arr[j] == 0) {
                    ++nullcount;
                }
                ++j;
            }
            offset += (rows - nullcount) * dtype_data_len;
        }
        return offset;
    }

    private int bdta3_unpack_col_offset_str(byte[] buffer, int offset, boolean is_all_not_null, byte[] null_arr, int rowcount) {
        int data_len = 0;
        if (is_all_not_null) {
            int i = 0;
            while (i < rowcount) {
                data_len = (int)Convertion.getUInt(buffer, offset += 4);
                offset += 4;
                offset += data_len;
                ++i;
            }
        } else {
            int i = 0;
            while (i < rowcount) {
                if (null_arr[i] == 1) {
                    data_len = (int)Convertion.getUInt(buffer, offset += 4);
                    offset += 4;
                    offset += data_len;
                }
                ++i;
            }
        }
        return offset;
    }

    private int bdta3_unpack_col_offset_dec(byte[] buffer, int offset, boolean is_all_not_null, byte[] null_arr, int rowcount) {
        int data_len = 0;
        if (is_all_not_null) {
            int i = 0;
            while (i < rowcount) {
                data_len = (int)Convertion.getUInt(buffer, offset);
                offset += 4;
                offset += data_len;
                ++i;
            }
        } else {
            int i = 0;
            while (i < rowcount) {
                if (null_arr[i] == 1) {
                    data_len = (int)Convertion.getUInt(buffer, offset);
                    offset += 4;
                    offset += data_len;
                }
                ++i;
            }
        }
        return offset;
    }

    public boolean previous() throws SQLException {
        if (this.curpos <= 0) {
            return false;
        }
        this.previous_row_offset();
        --this.curpos;
        return true;
    }

    private void previous_row_offset() throws SQLException {
        int colIndex = 0;
        while (colIndex < this.nflds) {
            if (!this.isNull(this.curpos - 1, colIndex)) {
                int dtype_data_len = this.get_dtype_data_len(this.col_sql_type[colIndex]);
                if (dtype_data_len == -2 || dtype_data_len == -3) {
                    int offset = this.col_offset[colIndex] + 4;
                    byte[] null_arr = null;
                    if (!this.col_is_all_not_null[colIndex]) {
                        null_arr = new byte[this.rownum];
                        System.arraycopy(this.rowbuf, offset, null_arr, 0, this.rownum);
                        offset += this.rownum * 1;
                    }
                    this.row_offset[colIndex] = dtype_data_len == -2 ? this.bdta3_unpack_col_offset_str(this.rowbuf, offset, this.col_is_all_not_null[colIndex], null_arr, this.curpos - 1) : this.bdta3_unpack_col_offset_dec(this.rowbuf, offset, this.col_is_all_not_null[colIndex], null_arr, this.curpos - 1);
                } else {
                    int n = colIndex;
                    this.row_offset[n] = this.row_offset[n] - dtype_data_len;
                }
            }
            ++colIndex;
        }
    }

    public byte[] getBytes(short columnNo) throws SQLException {
        if (this.isNull(this.curpos, columnNo)) {
            return null;
        }
        int data_len = this.get_dtype_data_len(this.col_sql_type[columnNo]);
        int offset = this.row_offset[columnNo];
        if (data_len == -2) {
            data_len = (int)Convertion.getUInt(this.rowbuf, offset += 4);
            offset += 4;
        } else if (data_len == -3) {
            data_len = (int)Convertion.getUInt(this.rowbuf, offset);
            offset += 4;
        }
        byte[] value = new byte[data_len];
        System.arraycopy(this.rowbuf, offset, value, 0, data_len);
        return value;
    }

    public long rec_get_rowid(int rowidCol) {
        try {
            byte[] rowid_bytes = this.getBytes((short)rowidCol);
            long rowid = Convertion.bytesToLong(rowid_bytes);
            return rowid;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return -1L;
        }
    }
}

