/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.dbaccess.DBError;
import dm.jdbc.dbaccess.DbAccess;
import dm.jdbc.desc.DmServerInfo;
import dm.jdbc.desc.GlobalControlCfg;
import dm.jdbc.driver.DmdbCSI;
import dm.jdbc.driver.DmdbConnection_bs;
import java.io.IOException;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.ArrayList;

public class DmdbSwitch {
    private DmdbConnection_bs m_conn = null;

    public DmdbSwitch(DmdbConnection_bs conn) {
        this.m_conn = conn;
    }

    public void close() {
        this.m_conn = null;
    }

    private void svrSwitchTo(DmServerInfo servInfo) throws UnknownHostException, IOException, SQLException {
        this.m_conn.setHostName(servInfo.getSvrName());
        if (servInfo.hasPort()) {
            this.m_conn.setHostPort(servInfo.getSvrPort());
        } else {
            this.m_conn.setHostPort(Integer.valueOf(this.m_conn.getProperties().getProperty("port", "5236")));
        }
        this.m_conn.setStandbyInfo(null, 0);
        this.setSocketInfo();
        DmdbCSI.connToServerTry(this.m_conn, true);
    }

    public boolean hasOneSvr() {
        return this.m_conn.hasOneSvr();
    }

    private void setSocketInfo() throws UnknownHostException, IOException {
        DbAccess dbaccess = new DbAccess(this.m_conn);
        dbaccess.setSoTimeout(this.m_conn.getSocketTimeout());
        this.m_conn.setDbAccess(dbaccess);
        this.m_conn.setNetworkPacketSize(dbaccess.getNetPacketSize());
    }

    void loginSuccSwitch() throws SQLException {
        ArrayList servList = this.m_conn.getHosts();
        int curSvr = this.m_conn.getServPos();
        int stat1 = this.svrStatModeChk();
        if (!this.needSwitch(stat1)) {
            return;
        }
        int nextSvr = curSvr + 1;
        int dstSvr = curSvr;
        int stat2 = Integer.MAX_VALUE;
        int i = 0;
        while (i < servList.size() - 1) {
            if (nextSvr == servList.size()) {
                nextSvr = 0;
            }
            try {
                this.m_conn.closeSimple();
                this.svrSwitchTo((DmServerInfo)servList.get(nextSvr));
                this.m_conn.resetCloseFlag();
                stat2 = this.svrStatModeChk();
                if (!this.needSwitch(stat2)) {
                    this.m_conn.setServPos(nextSvr);
                    return;
                }
                if (this.getDestSvr(stat1, stat2) == 2) {
                    dstSvr = nextSvr;
                    stat1 = stat2;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ++nextSvr;
            ++i;
        }
        if (GlobalControlCfg.getLoginPrimary()) {
            this.m_conn.closeSimple();
            DBError.throwSQLException(6001);
        }
        if (dstSvr == nextSvr - 1) {
            this.m_conn.setServPos(dstSvr);
            return;
        }
        try {
            this.m_conn.closeSimple();
            this.svrSwitchTo((DmServerInfo)servList.get(dstSvr));
            this.m_conn.resetCloseFlag();
        }
        catch (IOException ioex) {
            DBError.throwSQLException(6001);
        }
        this.m_conn.setServPos(dstSvr);
    }

    void loginFailedSwitch() throws SQLException {
        ArrayList servList = this.m_conn.getHosts();
        int curSvr = this.m_conn.getServPos();
        int nextSvr = curSvr + 1;
        int i = 0;
        while (i < servList.size()) {
            block4: {
                if (nextSvr == servList.size()) {
                    nextSvr = 0;
                }
                try {
                    this.svrSwitchTo((DmServerInfo)servList.get(nextSvr));
                    this.m_conn.setServPos(nextSvr);
                    this.loginSuccSwitch();
                }
                catch (IOException ioex) {
                    if (i != servList.size() - 1) break block4;
                    DBError.throwSQLException(6001);
                }
            }
            ++nextSvr;
            ++i;
        }
    }

    private int svrStatModeChk() {
        int svrStat = this.m_conn.getSvrStat();
        int svrMode = this.m_conn.getSvrMode();
        switch (svrStat) {
            case 5: {
                if (svrMode == 1) {
                    return 1;
                }
                if (svrMode == 2) {
                    return 2;
                }
                return 3;
            }
            case 3: {
                if (svrMode == 1) {
                    return 4;
                }
                if (svrMode == 2) {
                    return 5;
                }
                return 6;
            }
            case 4: {
                if (svrMode == 1) {
                    return 7;
                }
                if (svrMode == 2) {
                    return 8;
                }
                return 9;
            }
        }
        return 0;
    }

    private int getDestSvr(int stat1, int stat2) {
        switch (stat1) {
            case 1: {
                switch (stat2) {
                    case 1: 
                    case 3: 
                    case 6: 
                    case 7: 
                    case 9: 
                    case 0x7FFFFFFF: {
                        return 2;
                    }
                    case 4: 
                    case 5: 
                    case 8: {
                        return Integer.MIN_VALUE;
                    }
                }
                break;
            }
            case 4: {
                switch (stat2) {
                    case 1: 
                    case 5: 
                    case 8: {
                        return 1;
                    }
                    case 3: 
                    case 4: 
                    case 6: 
                    case 7: 
                    case 9: 
                    case 0x7FFFFFFF: {
                        return 2;
                    }
                }
                break;
            }
            case 7: {
                return 1;
            }
            case 5: {
                return 2;
            }
            case 8: {
                switch (stat2) {
                    case 1: 
                    case 3: 
                    case 4: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 0x7FFFFFFF: {
                        return 2;
                    }
                    case 5: {
                        return 1;
                    }
                }
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                return 1;
            }
        }
        return 0;
    }

    public void doSwitch() throws SQLException, IOException {
        int svrStat;
        ArrayList servList = this.m_conn.getHosts();
        int curSvr = this.m_conn.getServPos();
        int nextSvr = curSvr + 1;
        long times = GlobalControlCfg.getSwitchTimes() * (long)servList.size();
        int i = 0;
        while ((long)i < times) {
            if (nextSvr == servList.size()) {
                nextSvr = 0;
            }
            try {
                Thread.sleep(GlobalControlCfg.getSwitchInterv());
                this.m_conn.closeSimple();
                this.svrSwitchTo((DmServerInfo)servList.get(nextSvr));
                this.m_conn.resetCloseFlag();
                svrStat = this.svrStatModeChk();
                if (!this.needSwitch(svrStat)) {
                    this.m_conn.setServPos(nextSvr);
                    break;
                }
            }
            catch (IOException ex) {
                if ((long)i == times - 1L) {
                    throw ex;
                }
            }
            catch (InterruptedException e) {
                throw new IOException();
            }
            ++i;
            ++nextSvr;
        }
        svrStat = this.svrStatModeChk();
        if (this.needSwitch(svrStat)) {
            this.m_conn.closeSimple();
            DBError.throwSQLException(20001);
        } else {
            DmdbCSI.connToStandby(this.m_conn);
            this.m_conn.replaceStatments();
        }
    }

    private boolean needSwitch(int stat) {
        return 7 != stat && 3 != stat && 6 != stat && 9 != stat;
    }
}

