/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.dbaccess.DBError;
import dm.jdbc.driver.DmdbColumn;
import dm.jdbc.driver.DmdbResultSetCache;
import dm.jdbc.driver.DmdbStatement_bs;
import dm.jdbc.innerData.DmdbBdta;
import java.sql.SQLException;
import java.util.ArrayList;

public class DmdbResultSetCache_v
extends DmdbResultSetCache {
    byte[] rowbuf = null;
    private int rowidCol;
    ArrayList bdta_list;
    private int bdtaIndex = 0;
    DmdbBdta cur_bdta;
    private int start_off = 0;
    private int offset;

    public DmdbResultSetCache_v(DmdbStatement_bs stmt, DmdbColumn[] colsInfo, int rowidCol) {
        super(stmt, colsInfo);
        this.rowidCol = rowidCol;
    }

    public void fillBuffer(byte[] buffer, int len, int rows) throws SQLException {
        this.env_stmt_init_curbuf();
        this.rowbuf = buffer;
        this.rownum = rows;
        this.realLen = len;
        this.start_off = 0;
        if (rows > 0) {
            while (this.offset < this.start_off + this.realLen) {
                DmdbBdta tmp = new DmdbBdta(this.rowbuf, this.offset);
                this.bdta_list.add(tmp);
                this.offset += tmp.len;
            }
            this.bdtaIndex = 0;
            this.cur_bdta = (DmdbBdta)this.bdta_list.get(this.bdtaIndex);
        }
    }

    public void fillBuffer2(byte[] buffer, int off, int len, int fetched_rows) throws SQLException {
        this.env_stmt_init_curbuf();
        this.rowbuf = buffer;
        this.rownum = fetched_rows;
        this.realLen = len;
        this.offset = this.start_off = off;
        if (fetched_rows > 0) {
            while (this.offset < this.start_off + this.realLen) {
                DmdbBdta tmp = new DmdbBdta(this.rowbuf, this.offset);
                this.bdta_list.add(tmp);
                this.offset += tmp.len;
            }
            this.bdtaIndex = 0;
            this.cur_bdta = (DmdbBdta)this.bdta_list.get(this.bdtaIndex);
        }
    }

    private void env_stmt_init_curbuf() {
        this.rownum = 0;
        this.curpos = 0;
        this.offset = 0;
        this.cur_bdta = null;
        this.bdtaIndex = 0;
        this.bdta_list = new ArrayList();
    }

    public void addBuffer(byte[] buffer, int len, int rows) throws SQLException {
        byte[] tmp = new byte[this.realLen + this.start_off + len];
        System.arraycopy(this.rowbuf, 0, tmp, 0, this.realLen + this.start_off);
        System.arraycopy(buffer, 0, tmp, this.realLen + this.start_off, len);
        this.rowbuf = tmp;
        this.rownum += rows;
        this.realLen += len;
        if (rows > 0) {
            while (this.offset < this.start_off + this.realLen) {
                DmdbBdta bdta_tmp = new DmdbBdta(this.rowbuf, this.offset);
                this.bdta_list.add(bdta_tmp);
                this.offset += bdta_tmp.len;
            }
        }
    }

    public boolean next() throws SQLException {
        if (this.curpos >= this.rownum - 1) {
            return false;
        }
        if (!this.cur_bdta.next()) {
            ++this.bdtaIndex;
            this.cur_bdta = (DmdbBdta)this.bdta_list.get(this.bdtaIndex);
            this.cur_bdta.absolute(0);
        }
        ++this.curpos;
        return true;
    }

    public boolean previous() throws SQLException {
        if (this.curpos <= 0) {
            return false;
        }
        if (!this.cur_bdta.previous()) {
            --this.bdtaIndex;
            this.cur_bdta = (DmdbBdta)this.bdta_list.get(this.bdtaIndex);
            this.cur_bdta.absolute(this.cur_bdta.rownum - 1);
        }
        --this.curpos;
        return true;
    }

    public boolean absolute(int position) throws SQLException {
        if (position < 0) {
            position = 0;
        }
        if (position >= this.rownum) {
            position = this.rownum - 1;
        }
        if (position == 0) {
            this.bdtaIndex = 0;
            this.cur_bdta = (DmdbBdta)this.bdta_list.get(this.bdtaIndex);
            this.cur_bdta.absolute(0);
        } else if (position == this.rownum - 1) {
            this.bdtaIndex = this.bdta_list.size() - 1;
            this.cur_bdta = (DmdbBdta)this.bdta_list.get(this.bdtaIndex);
            this.cur_bdta.absolute(this.cur_bdta.rownum - 1);
        } else {
            int rows = 0;
            int i = 0;
            while (i < this.bdta_list.size()) {
                this.bdtaIndex = i++;
                DmdbBdta tmp = (DmdbBdta)this.bdta_list.get(this.bdtaIndex);
                if (rows + tmp.rownum > position) {
                    this.cur_bdta = tmp;
                    this.cur_bdta.absolute(position - rows);
                    break;
                }
                rows += tmp.rownum;
            }
        }
        this.curpos = position;
        return true;
    }

    public byte[] getBytes(short columnNo) throws SQLException {
        return this.cur_bdta.getBytes(columnNo);
    }

    public final Object clone() {
        DmdbResultSetCache_v rsCache = null;
        rsCache = (DmdbResultSetCache_v)super.clone();
        rsCache.statement = null;
        rsCache.curpos = 0;
        rsCache.bdtaIndex = 0;
        if (this.bdta_list != null && this.bdta_list.size() > 0) {
            rsCache.bdta_list = (ArrayList)this.bdta_list.clone();
            this.cur_bdta = (DmdbBdta)rsCache.bdta_list.get(0);
        }
        if (this.rowbuf != null) {
            rsCache.rowbuf = (byte[])this.rowbuf.clone();
        }
        return rsCache;
    }

    long rec_get_rowid() {
        if (this.rowbuf == null) {
            try {
                DBError.throwSQLException(6021);
            }
            catch (SQLException e) {
                e.printStackTrace();
                return 0L;
            }
        }
        if (this.rowidCol != -1) {
            return this.cur_bdta.rec_get_rowid(this.rowidCol);
        }
        return -1L;
    }
}

