/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.dbaccess.DBError;
import dm.jdbc.driver.DmdbBlob;
import dm.jdbc.driver.DmdbClob;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbParameterMetaData;
import dm.jdbc.driver.DmdbParameterMetaData_bs;
import dm.jdbc.driver.DmdbPreparedStatement_bs;
import dm.jdbc.driver.DmdbResultSet;
import dm.jdbc.driver.DmdbResultSetMetaData;
import dm.jdbc.driver.DmdbResultSetMetaData_bs;
import dm.jdbc.driver.DmdbResultSet_bs;
import dm.jdbc.driver.DmdbRowId;
import dm.jdbc.driver.DmdbStatement;
import dm.jdbc.pool.DmdbPooledConnection;
import dm.sql.DmdbIntervalDT;
import dm.sql.DmdbIntervalYM;
import dm.sql.DmdbTime;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class DmdbPreparedStatement
extends DmdbStatement
implements PreparedStatement {
    private DmdbPreparedStatement_bs rpstmt = null;
    private DmdbPooledConnection curPoolConn = null;

    DmdbPreparedStatement(DmdbPreparedStatement_bs pstmt, DmdbConnection curConn) {
        this.rpstmt = pstmt;
        super.setRealStmt(pstmt, curConn);
    }

    DmdbPreparedStatement() {
    }

    DmdbPreparedStatement_bs getRealPstmt() {
        return this.rpstmt;
    }

    void setRealPstmt(DmdbPreparedStatement_bs pstmt, DmdbConnection curConn) {
        this.rpstmt = pstmt;
        super.setRealStmt(pstmt, curConn);
    }

    private void curPoolConnNotify() throws SQLException {
        if (this.rpstmt.getConnection_bs().getMpc() != null) {
            if (this.curPoolConn == null) {
                this.curPoolConn = new DmdbPooledConnection(this.rpstmt.getConnection_bs().getMpc());
            }
            this.curPoolConn.notifyStatementChanged(this, 2);
        }
    }

    public DmdbPreparedStatement(DmdbConnection conn, String sql) throws SQLException {
        this.rpstmt = new DmdbPreparedStatement_bs(conn.getRealConn(), sql);
    }

    public DmdbPreparedStatement(DmdbConnection conn, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.rpstmt = new DmdbPreparedStatement_bs(conn.getRealConn(), sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public synchronized ResultSet executeQuery() throws SQLException {
        DmdbResultSet rs = null;
        try {
            DmdbResultSet_bs rbs = (DmdbResultSet_bs)this.rpstmt.executeQuery();
            if (rbs != null) {
                rs = new DmdbResultSet(rbs, this);
            }
        }
        catch (SQLException e) {
            this.rpstmt.setRealClose(true);
            this.curPoolConnNotify();
            throw e;
        }
        this.setCurResultSet(rs);
        return rs;
    }

    @Override
    public int executeUpdate() throws SQLException {
        return this.rpstmt.executeUpdate();
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        try {
            this.rpstmt.setNull(parameterIndex, sqlType);
        }
        catch (SQLException e) {
            this.curPoolConnNotify();
            throw e;
        }
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        try {
            this.rpstmt.setBoolean(parameterIndex, x);
        }
        catch (SQLException e) {
            this.curPoolConnNotify();
            throw e;
        }
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        try {
            this.rpstmt.setByte(parameterIndex, x);
        }
        catch (SQLException e) {
            this.curPoolConnNotify();
            throw e;
        }
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        try {
            this.rpstmt.setShort(parameterIndex, x);
        }
        catch (SQLException e) {
            this.curPoolConnNotify();
            throw e;
        }
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        try {
            this.rpstmt.setInt(parameterIndex, x);
        }
        catch (SQLException e) {
            this.curPoolConnNotify();
            throw e;
        }
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        try {
            this.rpstmt.setLong(parameterIndex, x);
        }
        catch (SQLException e) {
            this.curPoolConnNotify();
            throw e;
        }
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        try {
            this.rpstmt.setFloat(parameterIndex, x);
        }
        catch (SQLException e) {
            this.curPoolConnNotify();
            throw e;
        }
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        try {
            this.rpstmt.setDouble(parameterIndex, x);
        }
        catch (SQLException e) {
            this.curPoolConnNotify();
            throw e;
        }
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        try {
            this.rpstmt.setBigDecimal(parameterIndex, x);
        }
        catch (SQLException e) {
            this.curPoolConnNotify();
            throw e;
        }
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        try {
            this.rpstmt.setString(parameterIndex, x);
        }
        catch (SQLException e) {
            this.curPoolConnNotify();
            throw e;
        }
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        try {
            this.rpstmt.setBytes(parameterIndex, x);
        }
        catch (SQLException e) {
            this.curPoolConnNotify();
            throw e;
        }
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        try {
            this.rpstmt.setDate(parameterIndex, x);
        }
        catch (SQLException e) {
            this.curPoolConnNotify();
            throw e;
        }
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        try {
            this.rpstmt.setTime(parameterIndex, x);
        }
        catch (SQLException e) {
            this.curPoolConnNotify();
            throw e;
        }
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        try {
            this.rpstmt.setTimestamp(parameterIndex, x);
        }
        catch (SQLException e) {
            this.curPoolConnNotify();
            throw e;
        }
    }

    @Override
    public synchronized void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        try {
            this.rpstmt.setAsciiStream(parameterIndex, x, length);
        }
        catch (SQLException e) {
            this.curPoolConnNotify();
            throw e;
        }
    }

    @Override
    public synchronized void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        try {
            this.rpstmt.setUnicodeStream(parameterIndex, x, length);
        }
        catch (SQLException e) {
            this.curPoolConnNotify();
            throw e;
        }
    }

    @Override
    public synchronized void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        try {
            this.rpstmt.setBinaryStream(parameterIndex, x, length);
        }
        catch (SQLException e) {
            this.curPoolConnNotify();
            throw e;
        }
    }

    @Override
    public synchronized void clearParameters() throws SQLException {
        this.rpstmt.clearParameters();
    }

    @Override
    public synchronized void close() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        this.curPoolConnNotify();
        this.rpstmt.close();
    }

    @Override
    public synchronized void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        try {
            if (x instanceof DmdbRowId) {
                this.rpstmt.setLong(parameterIndex, ((DmdbRowId)x).getValue());
            } else {
                this.rpstmt.setObject(parameterIndex, x, targetSqlType, scale);
            }
        }
        catch (SQLException e) {
            this.curPoolConnNotify();
            throw e;
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        try {
            this.rpstmt.setObject(parameterIndex, x, targetSqlType);
        }
        catch (SQLException e) {
            this.curPoolConnNotify();
            throw e;
        }
    }

    @Override
    public synchronized void setObject(int parameterIndex, Object x) throws SQLException {
        try {
            if (x instanceof DmdbRowId) {
                this.rpstmt.setLong(parameterIndex, ((DmdbRowId)x).getValue());
            } else {
                this.rpstmt.setObject(parameterIndex, x);
            }
        }
        catch (SQLException e) {
            this.curPoolConnNotify();
            throw e;
        }
    }

    @Override
    public synchronized boolean execute() throws SQLException {
        boolean rs = false;
        try {
            rs = this.rpstmt.execute();
        }
        catch (SQLException e) {
            this.rpstmt.setRealClose(true);
            this.curPoolConnNotify();
            throw e;
        }
        return rs;
    }

    @Override
    public void addBatch() throws SQLException {
        try {
            this.rpstmt.addBatch();
        }
        catch (SQLException ex) {
            this.curPoolConnNotify();
            throw ex;
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        try {
            return this.rpstmt.executeBatch();
        }
        catch (SQLException e) {
            this.rpstmt.setRealClose(true);
            this.curPoolConnNotify();
            throw e;
        }
    }

    @Override
    public synchronized void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        try {
            this.rpstmt.setCharacterStream(parameterIndex, reader, length);
        }
        catch (SQLException e) {
            this.curPoolConnNotify();
            throw e;
        }
    }

    @Override
    public void setRef(int i, Ref x) throws SQLException {
        try {
            this.rpstmt.setRef(i, x);
        }
        catch (SQLException e) {
            this.curPoolConnNotify();
            throw e;
        }
    }

    @Override
    public void setBlob(int i, Blob x) throws SQLException {
        try {
            if (x instanceof DmdbBlob) {
                this.rpstmt.setBlob(i, x);
            } else {
                this.rpstmt.setBlob(i, x);
            }
        }
        catch (SQLException e) {
            this.curPoolConnNotify();
            throw e;
        }
    }

    @Override
    public void setClob(int i, Clob x) throws SQLException {
        try {
            if (x instanceof DmdbClob) {
                this.rpstmt.setClob(i, x);
            } else {
                this.rpstmt.setClob(i, x);
            }
        }
        catch (SQLException e) {
            this.curPoolConnNotify();
            throw e;
        }
    }

    @Override
    public void setArray(int i, Array x) throws SQLException {
        try {
            this.rpstmt.setArray(i, x);
        }
        catch (SQLException e) {
            this.curPoolConnNotify();
            throw e;
        }
    }

    @Override
    public synchronized ResultSetMetaData getMetaData() throws SQLException {
        DmdbResultSetMetaData_bs bs;
        block3: {
            try {
                bs = (DmdbResultSetMetaData_bs)this.rpstmt.getMetaData();
                if (bs != null) break block3;
                return null;
            }
            catch (SQLException e) {
                this.curPoolConnNotify();
                throw e;
            }
        }
        return new DmdbResultSetMetaData(bs);
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        try {
            this.rpstmt.setDate(parameterIndex, x, cal);
        }
        catch (SQLException e) {
            this.curPoolConnNotify();
            throw e;
        }
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        try {
            this.rpstmt.setTime(parameterIndex, x, cal);
        }
        catch (SQLException e) {
            this.curPoolConnNotify();
            throw e;
        }
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        try {
            this.rpstmt.setTimestamp(parameterIndex, x, cal);
        }
        catch (SQLException e) {
            this.curPoolConnNotify();
            throw e;
        }
    }

    @Override
    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        try {
            this.rpstmt.setNull(paramIndex, sqlType, typeName);
        }
        catch (SQLException e) {
            this.curPoolConnNotify();
            throw e;
        }
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        try {
            this.rpstmt.setURL(parameterIndex, x);
        }
        catch (SQLException e) {
            this.curPoolConnNotify();
            throw e;
        }
    }

    @Override
    public synchronized ParameterMetaData getParameterMetaData() throws SQLException {
        DmdbParameterMetaData_bs bs;
        block3: {
            try {
                bs = (DmdbParameterMetaData_bs)this.rpstmt.getParameterMetaData();
                if (bs != null) break block3;
                return null;
            }
            catch (SQLException e) {
                this.curPoolConnNotify();
                throw e;
            }
        }
        return new DmdbParameterMetaData(bs);
    }

    public void setINTERVALYM(int i, DmdbIntervalYM ym) throws SQLException {
        try {
            this.rpstmt.setINTERVALYM(i, ym);
        }
        catch (SQLException e) {
            this.curPoolConnNotify();
            throw e;
        }
    }

    public void setINTERVALDT(int i, DmdbIntervalDT dt) throws SQLException {
        try {
            this.rpstmt.setINTERVALDT(i, dt);
        }
        catch (SQLException e) {
            this.curPoolConnNotify();
            throw e;
        }
    }

    public void setTIME(int i, DmdbTime t) throws SQLException {
        try {
            this.rpstmt.setTIME(i, t);
        }
        catch (SQLException e) {
            this.curPoolConnNotify();
            throw e;
        }
    }

    public String getPrintMsg() throws SQLException {
        try {
            return this.rpstmt.getPrintMsg();
        }
        catch (SQLException e) {
            this.curPoolConnNotify();
            throw e;
        }
    }

    public int getSqlType() throws SQLException {
        try {
            return this.rpstmt.getSqlType();
        }
        catch (SQLException e) {
            this.curPoolConnNotify();
            throw e;
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        try {
            this.rpstmt.clearBatch();
        }
        catch (SQLException e) {
            this.curPoolConnNotify();
            throw e;
        }
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        if (x == null) {
            this.rpstmt.setObject(parameterIndex, null);
            return;
        }
        long val = ((DmdbRowId)x).getValue();
        this.setLong(parameterIndex, val);
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.curPoolConnNotify();
        DBError.throwUnsupportedSQLException();
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        this.curPoolConnNotify();
        DBError.throwUnsupportedSQLException();
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        this.curPoolConnNotify();
        DBError.throwUnsupportedSQLException();
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        try {
            this.rpstmt.setCharacterStream(parameterIndex, reader, length);
        }
        catch (SQLException e) {
            this.curPoolConnNotify();
            throw e;
        }
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        try {
            this.rpstmt.setBinaryStream(parameterIndex, inputStream, length);
        }
        catch (SQLException e) {
            this.curPoolConnNotify();
            throw e;
        }
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.curPoolConnNotify();
        DBError.throwUnsupportedSQLException();
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        this.curPoolConnNotify();
        DBError.throwUnsupportedSQLException();
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.rpstmt.setAsciiStream(parameterIndex, x, length);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        try {
            this.rpstmt.setAsciiStream(parameterIndex, x);
        }
        catch (SQLException e) {
            this.curPoolConnNotify();
            throw e;
        }
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.rpstmt.setBinaryStream(parameterIndex, x, length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        try {
            this.rpstmt.setBinaryStream(parameterIndex, x);
        }
        catch (SQLException e) {
            this.curPoolConnNotify();
            throw e;
        }
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.setBinaryStream(parameterIndex, inputStream);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        this.rpstmt.setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        try {
            this.rpstmt.setCharacterStream(parameterIndex, reader);
        }
        catch (SQLException e) {
            this.curPoolConnNotify();
            throw e;
        }
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        this.setCharacterStream(parameterIndex, reader);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        this.curPoolConnNotify();
        DBError.throwUnsupportedSQLException();
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        this.curPoolConnNotify();
        DBError.throwUnsupportedSQLException();
    }
}

