/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.dbaccess.Const;
import java.sql.DriverManager;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class DmdbLog {
    public static final int NONE = 0;
    public static final int ERROR = 1;
    public static final int DEBUG = 2;
    public static final int TRACE = 3;
    public static final int ALL = 4;
    private static final Hashtable CLASSES = new Hashtable();
    private static final Object MUTEX = new Object();
    private static boolean watchAll = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void methodCall(Object source, String method, Object[] args) {
        Object object = MUTEX;
        synchronized (object) {
            if (watchAll || CLASSES.contains(source.getClass().getName())) {
                StringBuffer mesg = new StringBuffer("\nTRACE: ");
                mesg.append(source.toString());
                mesg.append(".");
                mesg.append(method);
                mesg.append("( ");
                int i = 0;
                while (i < args.length - 1) {
                    if (args[i] == null) {
                        mesg.append("null");
                    } else {
                        if (args[i] instanceof String) {
                            mesg.append("\"");
                        }
                        mesg.append(args[i].toString());
                        if (args[i] instanceof String) {
                            mesg.append("\"");
                        }
                    }
                    mesg.append(", ");
                    ++i;
                }
                if (args.length > 0) {
                    if (args[args.length - 1] instanceof String) {
                        mesg.append("\"");
                    }
                    mesg.append(args[args.length - 1]);
                    if (args[args.length - 1] instanceof String) {
                        mesg.append("\"");
                    }
                }
                mesg.append(" )\n");
                if (DriverManager.getLogWriter() == null) {
                    System.out.println(mesg.toString());
                } else {
                    DriverManager.println(mesg.toString());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void msg(Object source, String message) {
        Object object = MUTEX;
        synchronized (object) {
            if (watchAll || CLASSES.contains(source.getClass().getName())) {
                StringBuffer mesg = new StringBuffer("\nTRACE: ");
                mesg.append(source.toString());
                mesg.append(": ");
                mesg.append(message);
                mesg.append("\n");
                if (DriverManager.getLogWriter() == null) {
                    System.out.println(mesg.toString());
                } else {
                    DriverManager.println(mesg.toString());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void returnValue(Object source, String method, Object value) {
        Object object = MUTEX;
        synchronized (object) {
            if (watchAll || CLASSES.contains(source.getClass().getName())) {
                StringBuffer mesg = new StringBuffer("\nTRACE: ");
                mesg.append(source.toString());
                mesg.append(".");
                mesg.append(method);
                mesg.append(": Returning -> ");
                if (value == null) {
                    mesg.append("null");
                } else {
                    mesg.append(value.toString());
                }
                mesg.append("\n");
                if (DriverManager.getLogWriter() == null) {
                    System.out.println(mesg.toString());
                } else {
                    DriverManager.println(mesg.toString());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final void setTraceList(String classList) {
        StringTokenizer tokenizer = new StringTokenizer(classList, ":");
        Object object = MUTEX;
        synchronized (object) {
            watchAll = false;
            if (classList.equals("ALL")) {
                watchAll = true;
            } else {
                while (tokenizer.hasMoreTokens()) {
                    String className = tokenizer.nextToken().trim();
                    if (CLASSES.contains(className)) continue;
                    CLASSES.put(className, className);
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void trace(Object source, String method, String info) {
        if (Const.TRACE_LEVEL >= 3 && (watchAll || CLASSES.contains(source.getClass().getName()))) {
            Object object = MUTEX;
            synchronized (object) {
                StringBuffer mesg = new StringBuffer("\n" + new Timestamp(System.currentTimeMillis()) + "--TRACE: ");
                mesg.append(source.toString());
                mesg.append(".");
                mesg.append(method);
                mesg.append(": ");
                mesg.append(info);
                mesg.append("\n");
                if (DriverManager.getLogWriter() == null) {
                    System.out.println(mesg.toString());
                } else {
                    DriverManager.println(mesg.toString());
                }
            }
        }
    }
}

