/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.dataConvertion.CType2JType;
import dm.jdbc.dataConvertion.Convertion;
import dm.jdbc.dbaccess.Const;
import dm.jdbc.dbaccess.DBError;
import dm.jdbc.desc.ParameterDesc;
import dm.jdbc.driver.DmBinder;
import dm.jdbc.driver.DmdbCSI;
import dm.jdbc.driver.DmdbConnection_bs;
import dm.jdbc.driver.DmdbLog;
import dm.jdbc.driver.DmdbPreparedStatement_bs;
import dm.jdbc.driver.DmdbResultSet_bs;
import dm.jdbc.driver.DmdbStatement_bs;
import dm.jdbc.driver.DmdbType;
import dm.sql.DmdbIntervalDT;
import dm.sql.DmdbIntervalYM;
import dm.sql.DmdbTime;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Map;

public class DmdbCallableStatement_bs
extends DmdbPreparedStatement_bs
implements CallableStatement {
    String m_serverEncoding = null;
    boolean wasNullFlag = false;
    ArrayList colsInfo = null;
    short resultsCount = 0;

    void initializeReuseCallableStmt(DmdbConnection_bs conn, String sql) throws SQLException {
        super.initializeReusePreparedStmt(conn, sql);
        this.type = 2;
        this.m_serverEncoding = conn.getServerEncoding();
    }

    DmdbCallableStatement_bs(DmdbConnection_bs conn, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        super(conn, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        this.type = 2;
        this.m_serverEncoding = conn.getServerEncoding();
    }

    public synchronized void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "registerOutParameter(int, int)", "parameterIndex = " + parameterIndex + ", sqlType = " + sqlType);
        }
        this.regOutParam(parameterIndex, sqlType);
        if (sqlType == 50 || sqlType == -10) {
            this.resultsCount = (short)(this.resultsCount + 1);
        }
    }

    public synchronized void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "registerOutParameter(int, int, int)", "parameterIndex = " + parameterIndex + ", sqlType = " + sqlType + ", scale = " + scale);
        }
        this.regOutParam(parameterIndex, sqlType, scale);
        if (sqlType == 50 || sqlType == -10) {
            this.resultsCount = (short)(this.resultsCount + 1);
        }
    }

    public boolean wasNull() throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "wasNull()", "");
        }
        return this.wasNullFlag;
    }

    public String getString(int parameterIndex) throws SQLException {
        this.checkOutParam(parameterIndex);
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "getString(int)", "parameterIndex = " + parameterIndex);
        }
        if (this.wasNullFlag = this.m_curRow[parameterIndex - 1].getOutNullFlag()) {
            return null;
        }
        ParameterDesc paramDesc = this.m_paramsDesc[parameterIndex - 1];
        byte[] bs = this.getOutValue(this.m_curRow[parameterIndex - 1], paramDesc, true);
        return CType2JType.getString(bs, paramDesc, this.connection, false);
    }

    private byte[] getOutValue(DmBinder dmBinder, ParameterDesc desc, boolean loadLobAll) throws SQLException {
        byte[] val = dmBinder.getOutValue();
        if (val != null && loadLobAll && (desc.getDTypeInfo().getDType() == 12 || desc.getDTypeInfo().getDType() == 19)) {
            if (desc.getLobDesc() == null) {
                DBError.throwSQLException(6007);
            }
            val = Convertion.getBytesFrmLob(val, desc.getDTypeInfo(), desc.getLobDesc(), this.connection, this, dmBinder.isOutValueFromStandby());
        }
        return val;
    }

    public boolean getBoolean(int parameterIndex) throws SQLException {
        this.checkOutParam(parameterIndex);
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "getBoolean(int)", "parameterIndex = " + parameterIndex);
        }
        if (this.wasNullFlag = this.m_curRow[parameterIndex - 1].getOutNullFlag()) {
            return false;
        }
        ParameterDesc desc = this.m_paramsDesc[parameterIndex - 1];
        byte[] bs = this.getOutValue(this.m_curRow[parameterIndex - 1], desc, true);
        return CType2JType.getBoolean(bs, desc, this.connection);
    }

    public byte getByte(int parameterIndex) throws SQLException {
        this.checkOutParam(parameterIndex);
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "getByte(int)", "parameterIndex = " + parameterIndex);
        }
        if (this.wasNullFlag = this.m_curRow[parameterIndex - 1].getOutNullFlag()) {
            return 0;
        }
        ParameterDesc desc = this.m_paramsDesc[parameterIndex - 1];
        byte[] bs = this.getOutValue(this.m_curRow[parameterIndex - 1], desc, true);
        return CType2JType.getByte(bs, desc, this.connection);
    }

    public short getShort(int parameterIndex) throws SQLException {
        this.checkOutParam(parameterIndex);
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "getShort(int)", "parameterIndex = " + parameterIndex);
        }
        if (this.wasNullFlag = this.m_curRow[parameterIndex - 1].getOutNullFlag()) {
            return 0;
        }
        ParameterDesc desc = this.m_paramsDesc[parameterIndex - 1];
        byte[] bs = this.getOutValue(this.m_curRow[parameterIndex - 1], desc, true);
        return CType2JType.getShort(bs, desc, this.connection);
    }

    public int getInt(int parameterIndex) throws SQLException {
        this.checkOutParam(parameterIndex);
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "getInt(int)", "parameterIndex = " + parameterIndex);
        }
        if (this.wasNullFlag = this.m_curRow[parameterIndex - 1].getOutNullFlag()) {
            return 0;
        }
        ParameterDesc desc = this.m_paramsDesc[parameterIndex - 1];
        byte[] bs = this.getOutValue(this.m_curRow[parameterIndex - 1], desc, true);
        return CType2JType.getInt(bs, desc, this.connection);
    }

    public long getLong(int parameterIndex) throws SQLException {
        this.checkOutParam(parameterIndex);
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "getLong(int)", "parameterIndex = " + parameterIndex);
        }
        if (this.wasNullFlag = this.m_curRow[parameterIndex - 1].getOutNullFlag()) {
            return 0L;
        }
        ParameterDesc desc = this.m_paramsDesc[parameterIndex - 1];
        byte[] bs = this.getOutValue(this.m_curRow[parameterIndex - 1], desc, true);
        return CType2JType.getLong(bs, desc, this.connection);
    }

    public float getFloat(int parameterIndex) throws SQLException {
        this.checkOutParam(parameterIndex);
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "getFloat(int)", "parameterIndex = " + parameterIndex);
        }
        if (this.wasNullFlag = this.m_curRow[parameterIndex - 1].getOutNullFlag()) {
            return 0.0f;
        }
        ParameterDesc desc = this.m_paramsDesc[parameterIndex - 1];
        byte[] bs = this.getOutValue(this.m_curRow[parameterIndex - 1], desc, true);
        return CType2JType.getFloat(bs, desc, this.connection);
    }

    public double getDouble(int parameterIndex) throws SQLException {
        this.checkOutParam(parameterIndex);
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "getDouble(int)", "parameterIndex = " + parameterIndex);
        }
        if (this.wasNullFlag = this.m_curRow[parameterIndex - 1].getOutNullFlag()) {
            return 0.0;
        }
        ParameterDesc desc = this.m_paramsDesc[parameterIndex - 1];
        byte[] bs = this.getOutValue(this.m_curRow[parameterIndex - 1], desc, true);
        return CType2JType.getDouble(bs, desc, this.connection);
    }

    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        BigDecimal bd;
        this.checkOutParam(parameterIndex);
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "getBigDecimal(int, int)", "parameterIndex = " + parameterIndex + ", scale = " + scale);
        }
        if ((bd = this.getBigDecimalWithServerDefinedScale(parameterIndex)) == null) {
            return null;
        }
        return bd.setScale(scale, 4);
    }

    public byte[] getBytes(int parameterIndex) throws SQLException {
        this.checkOutParam(parameterIndex);
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "getBytes(int)", "parameterIndex = " + parameterIndex);
        }
        if (this.wasNullFlag = this.m_curRow[parameterIndex - 1].getOutNullFlag()) {
            return null;
        }
        ParameterDesc desc = this.m_paramsDesc[parameterIndex - 1];
        byte[] bs = this.getOutValue(this.m_curRow[parameterIndex - 1], desc, true);
        return CType2JType.getBytes(bs, desc, this.connection);
    }

    public Date getDate(int parameterIndex) throws SQLException {
        this.checkOutParam(parameterIndex);
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "getBytes(int)", "parameterIndex = " + parameterIndex);
        }
        if (this.wasNullFlag = this.m_curRow[parameterIndex - 1].getOutNullFlag()) {
            return null;
        }
        ParameterDesc desc = this.m_paramsDesc[parameterIndex - 1];
        byte[] bs = this.getOutValue(this.m_curRow[parameterIndex - 1], desc, true);
        return CType2JType.getDate(bs, desc, this.connection);
    }

    public Time getTime(int parameterIndex) throws SQLException {
        this.checkOutParam(parameterIndex);
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "getBytes(int)", "parameterIndex = " + parameterIndex);
        }
        if (this.wasNullFlag = this.m_curRow[parameterIndex - 1].getOutNullFlag()) {
            return null;
        }
        ParameterDesc desc = this.m_paramsDesc[parameterIndex - 1];
        byte[] bs = this.getOutValue(this.m_curRow[parameterIndex - 1], desc, true);
        return CType2JType.getTime(bs, desc, this.connection);
    }

    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        this.checkOutParam(parameterIndex);
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "getBytes(int)", "parameterIndex = " + parameterIndex);
        }
        if (this.wasNullFlag = this.m_curRow[parameterIndex - 1].getOutNullFlag()) {
            return null;
        }
        ParameterDesc desc = this.m_paramsDesc[parameterIndex - 1];
        byte[] bs = this.getOutValue(this.m_curRow[parameterIndex - 1], desc, true);
        return CType2JType.getTimestamp(bs, desc, this.connection);
    }

    public Object getObject(int parameterIndex) throws SQLException {
        return this.getObjectInner(parameterIndex, this.connection.getTypeMap());
    }

    public ResultSet getCursor(String parameterName) throws SQLException {
        int parameterIndex = this.getParamIndex(parameterName);
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "getCursor(String)", "parameterName = " + parameterName);
        }
        return this.getCursor(parameterIndex);
    }

    public ResultSet getCursor(int parameterIndex) throws SQLException {
        int sqlType;
        this.checkOutParam(parameterIndex);
        if (!this.m_curRow[parameterIndex - 1].hasSqlType) {
            DBError.throwSQLException(6048);
        }
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "getCursor(int)", "parameterIndex = " + parameterIndex);
        }
        if ((sqlType = this.m_curRow[parameterIndex - 1].sqlType) != 50 && sqlType != -10) {
            DBError.throwSQLException(20006);
        }
        DmdbStatement_bs destStmt = this.m_curRow[parameterIndex - 1].getCursorStmt();
        DmdbCSI.getMoreResult(destStmt, (short)1);
        DmdbResultSet_bs rs = destStmt.getResultSetPrivate(2);
        return rs;
    }

    public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        BigDecimal bd;
        this.checkOutParam(parameterIndex);
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "getBigDecimal(int)", "parameterIndex = " + parameterIndex);
        }
        if ((bd = this.getBigDecimalWithServerDefinedScale(parameterIndex)) == null) {
            return null;
        }
        if (this.m_curRow[parameterIndex - 1].hasSqlScale) {
            int scale = this.m_curRow[parameterIndex - 1].sqlScale;
            return bd.setScale(scale, 4);
        }
        return bd;
    }

    private BigDecimal getBigDecimalWithServerDefinedScale(int parameterIndex) throws SQLException {
        this.wasNullFlag = this.m_curRow[parameterIndex - 1].getOutNullFlag();
        if (this.wasNullFlag) {
            return null;
        }
        ParameterDesc desc = this.m_paramsDesc[parameterIndex - 1];
        byte[] bs = this.getOutValue(this.m_curRow[parameterIndex - 1], desc, true);
        return CType2JType.getBigDecimal(bs, desc, this.connection);
    }

    public Object getObject(int i, Map map) throws SQLException {
        if (map == null) {
            return this.getObject(i);
        }
        return this.getObjectInner(i, map);
    }

    private Object getObjectInner(int parameterIndex, Map map) throws SQLException {
        this.checkOutParam(parameterIndex);
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "getObjectInner(int)", "parameterIndex = " + parameterIndex);
        }
        ParameterDesc desc = this.m_paramsDesc[parameterIndex - 1];
        if (this.connection.getComOra() && DmdbType.isNUMERICtype(DmdbType.dtypeToSqlType(desc.getDType(), desc.getTypeName()))) {
            return this.getBigDecimal(parameterIndex);
        }
        int sqlType = this.m_curRow[parameterIndex - 1].sqlType;
        this.wasNullFlag = this.m_curRow[parameterIndex - 1].getOutNullFlag();
        if (this.wasNullFlag && sqlType != 50 && sqlType != -10) {
            return null;
        }
        if (sqlType == 50 || sqlType == -10) {
            return this.getCursor(parameterIndex);
        }
        byte[] bs = this.getOutValue(this.m_curRow[parameterIndex - 1], desc, false);
        String typeName = this.m_curRow[parameterIndex - 1].getTypeName();
        return CType2JType.getAllBySqlType(sqlType, bs, desc, 0L, this.connection, map, typeName, false);
    }

    public Ref getRef(int i) throws SQLException {
        DBError.throwUnsupportedSQLException();
        return null;
    }

    public Blob getBlob(int i) throws SQLException {
        this.checkOutParam(i);
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "getBlob(int)", "parameterIndex = " + i);
        }
        if (this.wasNullFlag = this.m_curRow[i - 1].getOutNullFlag()) {
            return null;
        }
        ParameterDesc desc = this.m_paramsDesc[i - 1];
        byte[] bs = this.getOutValue(this.m_curRow[i - 1], desc, false);
        return CType2JType.getBlob(bs, desc, this.connection);
    }

    public Clob getClob(int i) throws SQLException {
        this.checkOutParam(i);
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "getClob(int)", "parameterIndex = " + i);
        }
        if (this.wasNullFlag = this.m_curRow[i - 1].getOutNullFlag()) {
            return null;
        }
        ParameterDesc desc = this.m_paramsDesc[i - 1];
        byte[] bs = this.getOutValue(this.m_curRow[i - 1], desc, false);
        return CType2JType.getClob(bs, desc, this.connection);
    }

    public Array getArray(int i) throws SQLException {
        this.checkOutParam(i);
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "getArray(int)", "parameterIndex = " + i);
        }
        if (this.wasNullFlag = this.m_curRow[i - 1].getOutNullFlag()) {
            return null;
        }
        ParameterDesc desc = this.m_paramsDesc[i - 1];
        byte[] bs = this.getOutValue(this.m_curRow[i - 1], desc, false);
        return CType2JType.getArray(bs, desc, this.connection);
    }

    public Date getDate(int parameterIndex, Calendar cal) throws SQLException {
        Date d = this.getDate(parameterIndex);
        if (d == null) {
            return null;
        }
        if (cal == null) {
            cal = Calendar.getInstance();
        }
        cal.clear();
        cal.setTimeInMillis(d.getTime());
        return new Date(cal.getTime().getTime());
    }

    public Time getTime(int parameterIndex, Calendar cal) throws SQLException {
        Time time = this.getTime(parameterIndex);
        if (time == null) {
            return null;
        }
        if (cal == null) {
            cal = Calendar.getInstance();
        }
        cal.clear();
        cal.setTimeInMillis(time.getTime());
        return new Time(cal.getTime().getTime());
    }

    public Timestamp getTimestamp(int parameterIndex, Calendar cal) throws SQLException {
        Timestamp timestamp = this.getTimestamp(parameterIndex);
        if (timestamp == null) {
            return null;
        }
        if (cal == null) {
            cal = Calendar.getInstance();
        }
        cal.clear();
        cal.setTime(timestamp);
        Timestamp xn = new Timestamp(cal.getTimeInMillis());
        int nanos = timestamp.getNanos();
        if (nanos != 0) {
            xn.setNanos(nanos);
        }
        return xn;
    }

    public synchronized void registerOutParameter(int paramIndex, int sqlType, String typeName) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "registerOutParameter(int, int, String)", "parameterIndex = " + paramIndex + ", sqlType = " + sqlType + ", typeName = " + typeName);
        }
        if ((sqlType == 2002 || sqlType == 2000) && typeName != null && this.connection.getTypeMap().get(typeName) != null) {
            this.regOutParam(paramIndex, sqlType, typeName);
        } else {
            this.regOutParam(paramIndex, sqlType);
        }
        if (sqlType == 50 || sqlType == -10) {
            this.resultsCount = (short)(this.resultsCount + 1);
        }
    }

    public synchronized void registerOutParameter(String parameterName, int sqlType) throws SQLException {
        int[] parameterIndex = this.getParamIndex_forPL(parameterName);
        int i = 0;
        while (i < parameterIndex.length) {
            this.registerOutParameter(parameterIndex[i], sqlType);
            ++i;
        }
    }

    public synchronized void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
        int[] parameterIndex = this.getParamIndex_forPL(parameterName);
        int i = 0;
        while (i < parameterIndex.length) {
            this.registerOutParameter(parameterIndex[i], sqlType, scale);
            ++i;
        }
    }

    public synchronized void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
        int[] parameterIndex = this.getParamIndex_forPL(parameterName);
        int i = 0;
        while (i < parameterIndex.length) {
            this.registerOutParameter(parameterIndex[i], sqlType, typeName);
            ++i;
        }
    }

    public URL getURL(int parameterIndex) throws SQLException {
        DBError.throwUnsupportedSQLException();
        return null;
    }

    public void setURL(String parameterName, URL val) throws SQLException {
        DBError.throwUnsupportedSQLException();
    }

    public void setNull(String parameterName, int sqlType) throws SQLException {
        int[] parameterIndex = this.getParamIndex_forPL(parameterName);
        int i = 0;
        while (i < parameterIndex.length) {
            this.setNull(parameterIndex[i], sqlType);
            ++i;
        }
    }

    public void setBoolean(String parameterName, boolean x) throws SQLException {
        int[] parameterIndex = this.getParamIndex_forPL(parameterName);
        int i = 0;
        while (i < parameterIndex.length) {
            this.setBoolean(parameterIndex[i], x);
            ++i;
        }
    }

    public void setByte(String parameterName, byte x) throws SQLException {
        int[] parameterIndex = this.getParamIndex_forPL(parameterName);
        int i = 0;
        while (i < parameterIndex.length) {
            this.setByte(parameterIndex[i], x);
            ++i;
        }
    }

    public void setShort(String parameterName, short x) throws SQLException {
        int[] parameterIndex = this.getParamIndex_forPL(parameterName);
        int i = 0;
        while (i < parameterIndex.length) {
            this.setShort(parameterIndex[i], x);
            ++i;
        }
    }

    public void setInt(String parameterName, int x) throws SQLException {
        int[] parameterIndex = this.getParamIndex_forPL(parameterName);
        int i = 0;
        while (i < parameterIndex.length) {
            this.setInt(parameterIndex[i], x);
            ++i;
        }
    }

    public void setLong(String parameterName, long x) throws SQLException {
        int[] parameterIndex = this.getParamIndex_forPL(parameterName);
        int i = 0;
        while (i < parameterIndex.length) {
            this.setLong(parameterIndex[i], x);
            ++i;
        }
    }

    public void setFloat(String parameterName, float x) throws SQLException {
        int[] parameterIndex = this.getParamIndex_forPL(parameterName);
        int i = 0;
        while (i < parameterIndex.length) {
            this.setFloat(parameterIndex[i], x);
            ++i;
        }
    }

    public void setDouble(String parameterName, double x) throws SQLException {
        int[] parameterIndex = this.getParamIndex_forPL(parameterName);
        int i = 0;
        while (i < parameterIndex.length) {
            this.setDouble(parameterIndex[i], x);
            ++i;
        }
    }

    public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
        int[] parameterIndex = this.getParamIndex_forPL(parameterName);
        int i = 0;
        while (i < parameterIndex.length) {
            this.setBigDecimal(parameterIndex[i], x);
            ++i;
        }
    }

    public void setString(String parameterName, String x) throws SQLException {
        int[] parameterIndex = this.getParamIndex_forPL(parameterName);
        int i = 0;
        while (i < parameterIndex.length) {
            this.setString(parameterIndex[i], x);
            ++i;
        }
    }

    public void setBytes(String parameterName, byte[] x) throws SQLException {
        int[] parameterIndex = this.getParamIndex_forPL(parameterName);
        int i = 0;
        while (i < parameterIndex.length) {
            this.setBytes(parameterIndex[i], x);
            ++i;
        }
    }

    public void setDate(String parameterName, Date x) throws SQLException {
        int[] parameterIndex = this.getParamIndex_forPL(parameterName);
        int i = 0;
        while (i < parameterIndex.length) {
            this.setDate(parameterIndex[i], x);
            ++i;
        }
    }

    public void setTime(String parameterName, Time x) throws SQLException {
        int[] parameterIndex = this.getParamIndex_forPL(parameterName);
        int i = 0;
        while (i < parameterIndex.length) {
            this.setTime(parameterIndex[i], x);
            ++i;
        }
    }

    public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
        int[] parameterIndex = this.getParamIndex_forPL(parameterName);
        int i = 0;
        while (i < parameterIndex.length) {
            this.setTimestamp(parameterIndex[i], x);
            ++i;
        }
    }

    public void setAsciiStream(String parameterName, InputStream x, int length) throws SQLException {
        int[] parameterIndex = this.getParamIndex_forPL(parameterName);
        int i = 0;
        while (i < parameterIndex.length) {
            this.setAsciiStream(parameterIndex[i], x, length);
            ++i;
        }
    }

    public void setAsciiStream(String parameterName, InputStream x, long length) throws SQLException {
        int[] parameterIndex = this.getParamIndex_forPL(parameterName);
        int i = 0;
        while (i < parameterIndex.length) {
            this.setAsciiStream(parameterIndex[i], x, length);
            ++i;
        }
    }

    public void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException {
        int[] parameterIndex = this.getParamIndex_forPL(parameterName);
        int i = 0;
        while (i < parameterIndex.length) {
            this.setBinaryStream(parameterIndex[i], x, length);
            ++i;
        }
    }

    public void setObject(String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
        int[] parameterIndex = this.getParamIndex_forPL(parameterName);
        int i = 0;
        while (i < parameterIndex.length) {
            this.setObject(parameterIndex[i], x, targetSqlType, scale);
            ++i;
        }
    }

    public void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
        int[] parameterIndex = this.getParamIndex_forPL(parameterName);
        int i = 0;
        while (i < parameterIndex.length) {
            this.setObject(parameterIndex[i], x, targetSqlType);
            ++i;
        }
    }

    public void setObject(String parameterName, Object x) throws SQLException {
        int[] parameterIndex = this.getParamIndex_forPL(parameterName);
        int i = 0;
        while (i < parameterIndex.length) {
            this.setObject(parameterIndex[i], x);
            ++i;
        }
    }

    public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
        int[] parameterIndex = this.getParamIndex_forPL(parameterName);
        int i = 0;
        while (i < parameterIndex.length) {
            this.setCharacterStream(parameterIndex[i], reader, length);
            ++i;
        }
    }

    public void setCharacterStream(String parameterName, Reader reader, long length) throws SQLException {
        int[] parameterIndex = this.getParamIndex_forPL(parameterName);
        int i = 0;
        while (i < parameterIndex.length) {
            this.setCharacterStream(parameterIndex[i], reader, length);
            ++i;
        }
    }

    public void setDate(String parameterName, Date x, Calendar cal) throws SQLException {
        int[] parameterIndex = this.getParamIndex_forPL(parameterName);
        int i = 0;
        while (i < parameterIndex.length) {
            this.setDate(parameterIndex[i], x, cal);
            ++i;
        }
    }

    public void setTime(String parameterName, Time x, Calendar cal) throws SQLException {
        int[] parameterIndex = this.getParamIndex_forPL(parameterName);
        int i = 0;
        while (i < parameterIndex.length) {
            this.setTime(parameterIndex[i], x, cal);
            ++i;
        }
    }

    public void setTimestamp(String parameterName, Timestamp x, Calendar cal) throws SQLException {
        int[] parameterIndex = this.getParamIndex_forPL(parameterName);
        int i = 0;
        while (i < parameterIndex.length) {
            this.setTimestamp(parameterIndex[i], x, cal);
            ++i;
        }
    }

    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        int[] parameterIndex = this.getParamIndex_forPL(parameterName);
        int i = 0;
        while (i < parameterIndex.length) {
            this.setNull(parameterIndex[i], sqlType, typeName);
            ++i;
        }
    }

    public String getString(String parameterName) throws SQLException {
        int parameterIndex = this.getParamIndex(parameterName);
        return this.getString(parameterIndex);
    }

    public boolean getBoolean(String parameterName) throws SQLException {
        int parameterIndex = this.getParamIndex(parameterName);
        return this.getBoolean(parameterIndex);
    }

    public byte getByte(String parameterName) throws SQLException {
        int parameterIndex = this.getParamIndex(parameterName);
        return this.getByte(parameterIndex);
    }

    public short getShort(String parameterName) throws SQLException {
        int parameterIndex = this.getParamIndex(parameterName);
        return this.getShort(parameterIndex);
    }

    public int getInt(String parameterName) throws SQLException {
        int parameterIndex = this.getParamIndex(parameterName);
        return this.getInt(parameterIndex);
    }

    public long getLong(String parameterName) throws SQLException {
        int parameterIndex = this.getParamIndex(parameterName);
        return this.getLong(parameterIndex);
    }

    public float getFloat(String parameterName) throws SQLException {
        int parameterIndex = this.getParamIndex(parameterName);
        return this.getFloat(parameterIndex);
    }

    public double getDouble(String parameterName) throws SQLException {
        int parameterIndex = this.getParamIndex(parameterName);
        return this.getDouble(parameterIndex);
    }

    public byte[] getBytes(String parameterName) throws SQLException {
        int parameterIndex = this.getParamIndex(parameterName);
        return this.getBytes(parameterIndex);
    }

    public Date getDate(String parameterName) throws SQLException {
        int parameterIndex = this.getParamIndex(parameterName);
        return this.getDate(parameterIndex);
    }

    public Time getTime(String parameterName) throws SQLException {
        int parameterIndex = this.getParamIndex(parameterName);
        return this.getTime(parameterIndex);
    }

    public Timestamp getTimestamp(String parameterName) throws SQLException {
        int parameterIndex = this.getParamIndex(parameterName);
        return this.getTimestamp(parameterIndex);
    }

    public Object getObject(String parameterName) throws SQLException {
        int parameterIndex = this.getParamIndex(parameterName);
        return this.getObject(parameterIndex);
    }

    public BigDecimal getBigDecimal(String parameterName) throws SQLException {
        int parameterIndex = this.getParamIndex(parameterName);
        return this.getBigDecimal(parameterIndex);
    }

    public Object getObject(String parameterName, Map map) throws SQLException {
        int parameterIndex = this.getParamIndex(parameterName);
        return this.getObject(parameterIndex, map);
    }

    public Ref getRef(String parameterName) throws SQLException {
        DBError.throwUnsupportedSQLException();
        return null;
    }

    public Blob getBlob(String parameterName) throws SQLException {
        int parameterIndex = this.getParamIndex(parameterName);
        return this.getBlob(parameterIndex);
    }

    public Clob getClob(String parameterName) throws SQLException {
        int parameterIndex = this.getParamIndex(parameterName);
        return this.getClob(parameterIndex);
    }

    public Array getArray(String parameterName) throws SQLException {
        int parameterIndex = this.getParamIndex(parameterName);
        return this.getArray(parameterIndex);
    }

    public Date getDate(String parameterName, Calendar cal) throws SQLException {
        int parameterIndex = this.getParamIndex(parameterName);
        return this.getDate(parameterIndex, cal);
    }

    public Time getTime(String parameterName, Calendar cal) throws SQLException {
        int parameterIndex = this.getParamIndex(parameterName);
        return this.getTime(parameterIndex, cal);
    }

    public Timestamp getTimestamp(String parameterName, Calendar cal) throws SQLException {
        int parameterIndex = this.getParamIndex(parameterName);
        return this.getTimestamp(parameterIndex, cal);
    }

    public URL getURL(String parameterName) throws SQLException {
        int parameterIndex = this.getParamIndex(parameterName);
        return this.getURL(parameterIndex);
    }

    public DmdbIntervalYM getINTERVALYM(int i) throws SQLException {
        this.checkOutParam(i);
        this.wasNullFlag = this.m_curRow[i - 1].getOutNullFlag();
        if (this.wasNullFlag) {
            return null;
        }
        ParameterDesc desc = this.m_paramsDesc[i - 1];
        byte[] bs = this.getOutValue(this.m_curRow[i - 1], desc, true);
        return CType2JType.getIntervalYM(bs, desc, this.connection, false);
    }

    public DmdbIntervalYM getINTERVALYM(String s) throws SQLException {
        return this.getINTERVALYM(this.getParamIndex(s));
    }

    public DmdbIntervalDT getINTERVALDT(int i) throws SQLException {
        this.checkOutParam(i);
        this.wasNullFlag = this.m_curRow[i - 1].getOutNullFlag();
        if (this.wasNullFlag) {
            return null;
        }
        ParameterDesc desc = this.m_paramsDesc[i - 1];
        byte[] bs = this.getOutValue(this.m_curRow[i - 1], desc, true);
        return CType2JType.getIntervalDT(bs, desc, this.connection, false);
    }

    public DmdbIntervalDT getINTERVALDT(String s) throws SQLException {
        return this.getINTERVALDT(this.getParamIndex(s));
    }

    public DmdbTime getTIME(int i) throws SQLException {
        this.checkOutParam(i);
        this.wasNullFlag = this.m_curRow[i - 1].getOutNullFlag();
        if (this.wasNullFlag) {
            return null;
        }
        ParameterDesc desc = this.m_paramsDesc[i - 1];
        byte[] bs = this.getOutValue(this.m_curRow[i - 1], desc, true);
        return CType2JType.getDmTime(bs, desc, this.connection, false);
    }

    public DmdbTime getTIME(String s) throws SQLException {
        int index = this.getParamIndex(s);
        return this.getTIME(index);
    }

    public void setTIME(String parameterName, DmdbTime t) throws SQLException {
        int[] parameterIndex = this.getParamIndex_forPL(parameterName);
        int i = 0;
        while (i < parameterIndex.length) {
            this.setTIME(parameterIndex[i], t);
            ++i;
        }
    }

    public void setINTERVALDT(String parameterName, DmdbIntervalDT dt) throws SQLException {
        int[] parameterIndex = this.getParamIndex_forPL(parameterName);
        int i = 0;
        while (i < parameterIndex.length) {
            this.setINTERVALDT(parameterIndex[i], dt);
            ++i;
        }
    }

    public void setINTERVALYM(String parameterName, DmdbIntervalYM ym) throws SQLException {
        int[] parameterIndex = this.getParamIndex_forPL(parameterName);
        int i = 0;
        while (i < parameterIndex.length) {
            this.setINTERVALYM(parameterIndex[i], ym);
            ++i;
        }
    }

    public Reader getCharacterStream(int parameterIndex) throws SQLException {
        this.checkOutParam(parameterIndex);
        this.wasNullFlag = this.m_curRow[parameterIndex - 1].getOutNullFlag();
        if (this.wasNullFlag) {
            return null;
        }
        ParameterDesc desc = this.m_paramsDesc[parameterIndex - 1];
        byte[] bs = this.getOutValue(this.m_curRow[parameterIndex - 1], desc, false);
        return CType2JType.getCharacterStream(bs, desc, this.connection);
    }

    int getParamIndex(String ParamName) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            if (ParamName != null) {
                DmdbLog.trace(this, "getParamIndex(String)", "ParamName = " + ParamName);
            } else {
                DmdbLog.trace(this, "getParamIndex(String)", "ParamName = null");
            }
        }
        int pCount = -1;
        int i = 0;
        while (i < this.m_paramsDesc.length) {
            if (this.m_paramsDesc[i].getName().equalsIgnoreCase(ParamName)) {
                pCount = i;
                break;
            }
            ++i;
        }
        if (pCount == -1) {
            DBError.throwSQLException(6050);
        }
        return pCount + 1;
    }

    int[] getParamIndex_forPL(String ParamName) throws SQLException {
        int[] list = new int[this.m_paramsDesc.length];
        if (Const.TRACE_LEVEL > 0) {
            if (ParamName != null) {
                DmdbLog.trace(this, "getParamIndex(String)", "ParamName = " + ParamName);
            } else {
                DmdbLog.trace(this, "getParamIndex(String)", "ParamName = null");
            }
        }
        int pCount = -1;
        int x = 0;
        int i = 0;
        while (i < this.m_paramsDesc.length) {
            if (this.m_paramsDesc[i].getName().equalsIgnoreCase(ParamName)) {
                list[x] = i + 1;
                pCount = i;
                ++x;
            }
            ++i;
        }
        if (pCount == -1) {
            DBError.throwSQLException(6050);
        }
        int[] paramIndexs = new int[x];
        System.arraycopy(list, 0, paramIndexs, 0, x);
        return paramIndexs;
    }

    public String getPrintMsg() {
        return this.printMsg;
    }

    void resetState() throws SQLException {
        super.resetState();
        this.wasNullFlag = false;
    }

    public synchronized void close() throws SQLException {
        super.close();
        this.wasNullFlag = false;
    }
}

