/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.dbaccess.DBError;
import dm.jdbc.dbaccess.DmMsgSend;
import dm.jdbc.driver.DmBinder;
import dm.jdbc.driver.DmdbPreparedStatement_bs;
import dm.sql.TypeData;
import dm.sql.TypeDescriptor;
import java.sql.Blob;
import java.sql.SQLException;

public class DmBlobBinder
extends DmBinder {
    boolean new_lob_flag = false;

    public DmBlobBinder(DmdbPreparedStatement_bs pstmt) {
        super(pstmt);
        this.new_lob_flag = pstmt.getConnection_bs().getNewLobFlag();
    }

    void init() {
        this.recDType = 12;
        this.recPrec = Integer.MAX_VALUE;
        this.recScale = 0;
    }

    public int bindData(DmMsgSend msg, int irow, int icol, boolean forBatch) throws SQLException {
        Blob blob = (Blob)this.pstmt.getParamObject(irow, icol);
        TypeDescriptor typeDesc = this.paramsDesc[icol].getTypeDescriptor();
        long length = blob.length();
        if (this.destDType == 12 && length > 2048L) {
            return -1;
        }
        byte[] ret = null;
        switch (this.destDType) {
            case 12: {
                ret = blob.getBytes(1L, (int)length);
                if (ret != null) break;
                ret = new byte[]{};
                break;
            }
            case 117: 
            case 119: 
            case 121: 
            case 122: {
                if (typeDesc != null) {
                    byte[] lobBuf = blob.getBytes(1L, (int)length);
                    ret = TypeData.objBlobToBytes(lobBuf, typeDesc);
                    break;
                }
                DBError.throwSQLException(6007);
                break;
            }
            default: {
                DBError.throwSQLException(6007);
            }
        }
        return msg.appendBytesWithLen2(ret, 0, ret.length);
    }

    public int bindLobCyc(DmMsgSend lobMsg, int irow, int icol) throws SQLException {
        Blob lob = (Blob)this.pstmt.getParamObject(irow, icol);
        int maxLen = 16000;
        if ((long)this.offset_var > lob.length()) {
            this.clearVars();
            return 0;
        }
        if (this.offset_var == -1) {
            this.offset_var = 1;
        }
        byte[] ret = lob.getBytes(this.offset_var, maxLen);
        this.offset_var += ret.length;
        return lobMsg.appendOffRowBytes(ret, 0, ret.length, this.new_lob_flag, -1);
    }
}

