/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.desc;

import dm.jdbc.dbaccess.Const;
import dm.jdbc.desc.DmSvcCfg;
import java.util.Locale;

public class GlobalControlCfg {
    private static short m_timeZone = Const.TIME_ZONE_DEFAULT;
    private static long m_switchTimes = 3L;
    private static long m_switchInterv = 200L;
    private static boolean m_enRsCache = false;
    private static int m_rsCacheSize = 20;
    private static int m_rsRefreshFreq = 10;
    private static boolean m_keywordOpen = false;
    private static String[] m_keywordArr = null;
    private static Locale m_language = Locale.getDefault();
    private static boolean m_loginPrimary = true;
    private static boolean m_communicationEncrypt = true;

    static {
        DmSvcCfg svcCfg = new DmSvcCfg();
        svcCfg.initGlobalInfo();
    }

    public static void setKeywordOpen(boolean open) {
        m_keywordOpen = open;
    }

    public static boolean getKeywordOpen() {
        return m_keywordOpen;
    }

    public static void setLanguage(Locale lg) {
        m_language = lg;
    }

    public static Locale getLanguage() {
        return m_language;
    }

    public static void setKeywords(String[] keywords) {
        m_keywordArr = keywords;
    }

    public static String repaceReservedWord(String reservedWord) {
        if (!m_keywordOpen || m_keywordArr == null || reservedWord == null) {
            return reservedWord;
        }
        String strDesWord = "";
        int length = m_keywordArr.length;
        int i = 0;
        while (i < length) {
            strDesWord = m_keywordArr[i];
            if (strDesWord.equalsIgnoreCase(reservedWord)) {
                return "\"" + strDesWord.toUpperCase() + "\"";
            }
            ++i;
        }
        return reservedWord;
    }

    public static void setEnRsCache(boolean enable) {
        m_enRsCache = enable;
    }

    public static boolean getEnRsCache() {
        return m_enRsCache;
    }

    public static void setRsCacheSize(int size) {
        m_rsCacheSize = size;
    }

    public static int getRsCacheSize() {
        return m_rsCacheSize;
    }

    public static void setRsRefreshFreq(int freq) {
        m_rsRefreshFreq = freq;
    }

    public static int getRsRefreshFreq() {
        return m_rsRefreshFreq;
    }

    public static void setTimeZone(short tz) {
        m_timeZone = tz;
    }

    public static short getTimeZone() {
        return m_timeZone;
    }

    public static void setSwitchTimes(long times) {
        m_switchTimes = times;
    }

    public static long getSwitchTimes() {
        return m_switchTimes;
    }

    public static void setSwitchInterv(long interv) {
        m_switchInterv = interv;
    }

    public static long getSwitchInterv() {
        return m_switchInterv;
    }

    public static void setLoginPrimary(boolean loginPrimary) {
        m_loginPrimary = loginPrimary;
    }

    public static boolean getLoginPrimary() {
        return m_loginPrimary;
    }

    public static void setCommunicationEncrypt(boolean communicationEncrypt) {
        m_communicationEncrypt = communicationEncrypt;
    }

    public static boolean getCommunicationEncrypt() {
        return m_communicationEncrypt;
    }
}

