/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.desc;

import dm.jdbc.desc.DmServerInfo;
import dm.jdbc.desc.GlobalControlCfg;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;

public class DmSvcCfg {
    private BufferedReader m_bufdReader = null;
    private InputStream m_inputStream = null;
    private static boolean m_instanced = false;
    private static HashMap svrGroupMap = new HashMap();

    public void initGlobalInfo() {
        block23: {
            if (m_instanced || !this.readCfgValues()) {
                return;
            }
            try {
                try {
                    String line = null;
                    while ((line = this.m_bufdReader.readLine()) != null) {
                        try {
                            String[] pkeys;
                            int freq;
                            int size;
                            long interv;
                            String[] cfgInfo = line.split("=");
                            if (cfgInfo.length < 2) continue;
                            String name = cfgInfo[0].trim();
                            String value = cfgInfo[1].trim();
                            int lbt = value.indexOf("(");
                            int rbt = value.indexOf(")");
                            if (lbt == -1 || rbt == -1 || lbt >= rbt) continue;
                            value = value.substring(lbt + 1, rbt).trim();
                            if (name.equalsIgnoreCase("TIME_ZONE")) {
                                BigDecimal tmp = new BigDecimal(value);
                                short tz = tmp.shortValue();
                                if (-780 >= tz || tz > 780) continue;
                                GlobalControlCfg.setTimeZone(tz);
                                continue;
                            }
                            if (name.equalsIgnoreCase("SWITCH_TIME")) {
                                long times = Long.parseLong(value);
                                if (times <= 0L) continue;
                                GlobalControlCfg.setSwitchTimes(times);
                                continue;
                            }
                            if (name.equalsIgnoreCase("SWITCH_INTERVAL") && (interv = Long.parseLong(value)) > 0L) {
                                GlobalControlCfg.setSwitchInterv(interv);
                            }
                            if (name.equalsIgnoreCase("ENABLE_RS_CACHE")) {
                                boolean enable = !value.equals("0");
                                GlobalControlCfg.setEnRsCache(enable);
                            }
                            if (name.equalsIgnoreCase("RS_CACHE_SIZE") && (size = Integer.parseInt(value)) >= 1 && size <= 65535) {
                                GlobalControlCfg.setRsCacheSize(size);
                            }
                            if (name.equalsIgnoreCase("RS_REFRESH_FREQ") && (freq = Integer.parseInt(value)) >= 0 && freq <= 10000) {
                                GlobalControlCfg.setRsRefreshFreq(freq);
                            }
                            if (name.equalsIgnoreCase("PRIMARY_KEY") && (pkeys = value.split(",")) != null && pkeys.length > 0) {
                                GlobalControlCfg.setKeywordOpen(true);
                                GlobalControlCfg.setKeywords(pkeys);
                            }
                            if (name.equalsIgnoreCase("LANGUAGE")) {
                                if (value.equalsIgnoreCase("cn")) {
                                    GlobalControlCfg.setLanguage(Locale.CHINA);
                                } else if (value.equalsIgnoreCase("tw")) {
                                    GlobalControlCfg.setLanguage(Locale.TAIWAN);
                                } else if (value.equalsIgnoreCase("en")) {
                                    GlobalControlCfg.setLanguage(Locale.US);
                                }
                            }
                            if (name.equalsIgnoreCase("LOGIN_PRIMARY") && value.equals("0")) {
                                GlobalControlCfg.setLoginPrimary(false);
                            }
                            if (!name.equalsIgnoreCase("LOGIN_ENCRYPT") || !value.equals("0")) continue;
                            GlobalControlCfg.setCommunicationEncrypt(false);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                catch (IOException iOException) {
                    this.reset();
                    break block23;
                }
            }
            catch (Throwable throwable) {
                this.reset();
                throw throwable;
            }
            this.reset();
        }
        m_instanced = true;
    }

    public synchronized ArrayList getServerStrct(String svrName) {
        if (this.readCfgValues()) {
            boolean doRead = false;
            doRead = svrGroupMap.size() == 0 ? true : (!svrGroupMap.containsKey(svrName) ? true : System.currentTimeMillis() - ((SvrGroup)svrGroupMap.get(svrName)).getTime() > 20000L);
            if (doRead) {
                ArrayList<DmServerInfo> svrList;
                block22: {
                    svrList = new ArrayList<DmServerInfo>();
                    try {
                        try {
                            String line = null;
                            while ((line = this.m_bufdReader.readLine()) != null) {
                                String[] cfgInfo = line.split("=");
                                if (cfgInfo.length < 2) continue;
                                String name = cfgInfo[0].trim();
                                String value = cfgInfo[1].trim();
                                int lbt = value.indexOf("(");
                                int rbt = value.indexOf(")");
                                if (lbt == -1 || rbt == -1 || lbt >= rbt || !name.equalsIgnoreCase(svrName)) continue;
                                String[] values = (value = value.substring(lbt + 1, rbt).trim()).split(",");
                                if (values != null) {
                                    String[] tmpVals = null;
                                    String tmpName = null;
                                    int tmpPort = 5236;
                                    int i = 0;
                                    while (i < values.length) {
                                        DmServerInfo tmp = null;
                                        int begin = values[i].indexOf("[");
                                        int end = -1;
                                        if (begin != -1) {
                                            end = values[i].indexOf("]", begin);
                                        }
                                        if (end != -1) {
                                            tmpName = values[i].substring(begin + 1, end);
                                            int portIndex = values[i].indexOf(":", end);
                                            if (portIndex != -1) {
                                                tmpPort = Integer.parseInt(values[i].substring(portIndex + 1).trim());
                                                tmp = new DmServerInfo(tmpName, tmpPort);
                                            } else {
                                                tmp = new DmServerInfo(tmpName);
                                            }
                                            svrList.add(tmp);
                                        } else {
                                            tmpVals = values[i].split(":");
                                            if (tmpVals != null) {
                                                tmpName = tmpVals[0].trim();
                                                if (tmpVals.length >= 2) {
                                                    tmpPort = Integer.parseInt(tmpVals[1]);
                                                    tmp = new DmServerInfo(tmpName, tmpPort);
                                                } else {
                                                    tmp = new DmServerInfo(tmpName);
                                                }
                                                svrList.add(tmp);
                                            }
                                        }
                                        ++i;
                                    }
                                    continue;
                                }
                                break;
                            }
                        }
                        catch (IOException ioex) {
                            svrList.clear();
                            this.reset();
                            break block22;
                        }
                    }
                    catch (Throwable throwable) {
                        this.reset();
                        throw throwable;
                    }
                    this.reset();
                }
                if (svrList.size() > 0) {
                    SvrGroup group = new SvrGroup();
                    group.setSvrList(svrList);
                    group.setTime(System.currentTimeMillis());
                    svrGroupMap.put(svrName, group);
                } else if (svrGroupMap.size() > 0 && svrGroupMap.containsKey(svrName)) {
                    svrGroupMap.remove(svrName);
                }
            }
        }
        if (svrGroupMap.size() > 0 && svrGroupMap.containsKey(svrName)) {
            return ((SvrGroup)svrGroupMap.get(svrName)).getSvrList();
        }
        return null;
    }

    private void reset() {
        this.m_bufdReader = null;
        try {
            if (this.m_inputStream != null) {
                this.m_inputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.m_inputStream = null;
    }

    private boolean isJavaVersion14() {
        String strVersion = System.getProperty("java.version");
        return strVersion.indexOf("1.4") != -1;
    }

    private String getFilePath() {
        String filePath = null;
        if (System.getProperty("os.name").startsWith("Win")) {
            filePath = !this.isJavaVersion14() ? System.getenv("SystemRoot") : "C:\\WINDOWS";
            filePath = String.valueOf(filePath) + "\\system32\\dm_svc.conf";
        } else {
            filePath = "/etc/dm_svc.conf";
        }
        return filePath;
    }

    private boolean readCfgValues() {
        boolean read = false;
        String filePath = this.getFilePath();
        if (filePath == null) {
            return read;
        }
        try {
            File file = new File(filePath);
            this.m_inputStream = new FileInputStream(file);
            this.m_bufdReader = new BufferedReader(new InputStreamReader(this.m_inputStream));
            read = true;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return read;
    }

    class SvrGroup {
        private ArrayList svrList = null;
        private long time = 0L;

        SvrGroup() {
        }

        public void setSvrList(ArrayList svrList) {
            this.svrList = svrList;
        }

        public ArrayList getSvrList() {
            return this.svrList;
        }

        public void setTime(long time) {
            this.time = time;
        }

        public long getTime() {
            return this.time;
        }
    }
}

