/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.dbaccess.ssl;

import dm.jdbc.dbaccess.ssl.WrappedFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Properties;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class FullDuplexValidatingFactory
extends WrappedFactory {
    private String algorithm = "SunX509";
    private KeyStore keyStore = null;
    private String keystorePass = "changeit";
    private String keystoreType = "JKS";
    private String protocol = "TLSv1";
    private String keystoreFile = "";
    private String m_curUser = "";

    public FullDuplexValidatingFactory(Properties prop) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyManagementException, CertificateException {
        try {
            this.initKeyStore(prop);
            this.checkUser(prop.getProperty("user"));
            this.initSSLContext();
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (KeyStoreException kse) {
            throw kse;
        }
        catch (NoSuchAlgorithmException nsae) {
            throw nsae;
        }
        catch (UnrecoverableKeyException unreke) {
            throw unreke;
        }
        catch (KeyManagementException kmex) {
            throw kmex;
        }
        catch (CertificateException ce) {
            throw ce;
        }
    }

    private void initKeyStore(Properties prop) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        FileInputStream istream = null;
        try {
            try {
                this.keyStore = KeyStore.getInstance(this.keystoreType);
                this.m_curUser = prop.getProperty("user");
                this.keystorePass = prop.getProperty("sslKeystorePass", this.keystorePass);
                String filePathTemp = prop.getProperty("sslFilesPath");
                this.keystoreFile = this.getKeyStorePath(filePathTemp);
                istream = new FileInputStream(this.keystoreFile);
                this.keyStore.load(istream, this.keystorePass.toCharArray());
            }
            catch (IOException ioe) {
                throw ioe;
            }
            catch (KeyStoreException kse) {
                throw kse;
            }
            catch (NoSuchAlgorithmException nsae) {
                throw nsae;
            }
            catch (CertificateException ce) {
                throw ce;
            }
        }
        finally {
            if (istream != null) {
                istream.close();
            }
        }
    }

    private void checkUser(String user) throws KeyStoreException {
        X509Certificate cert = (X509Certificate)this.keyStore.getCertificate("1");
        String userName = this.findCNname(cert.getSubjectDN().getName());
        if (!userName.equals(user)) {
            throw new KeyStoreException();
        }
    }

    private String findCNname(String strDN) {
        String regstr = "CN=";
        int begin = strDN.indexOf(regstr);
        int end = strDN.indexOf(",", begin);
        return strDN.substring(begin + regstr.length(), end);
    }

    private String getKeyStorePath(String strPath) {
        String strOrgPath = String.valueOf(System.getProperty("DM_HOME")) + File.separator + "bin" + File.separator + "client_ssl" + File.separator + this.m_curUser;
        if (strPath != null && strPath.length() > 0) {
            strOrgPath = strPath;
        }
        return String.valueOf(strOrgPath) + File.separator + ".keystore";
    }

    private void initSSLContext() throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyManagementException {
        try {
            Security.addProvider((Provider)Class.forName("com.sun.net.ssl.internal.ssl.Provider").newInstance());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        SSLContext context = SSLContext.getInstance(this.protocol);
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(this.algorithm);
        keyManagerFactory.init(this.keyStore, this.keystorePass.toCharArray());
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(this.algorithm);
        tmf.init(this.keyStore);
        TrustManager[] tm = tmf.getTrustManagers();
        context.init(keyManagerFactory.getKeyManagers(), tm, new SecureRandom());
        this._factory = context.getSocketFactory();
    }
}

