/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.dbaccess;

import dm.jdbc.dbaccess.Const;
import dm.jdbc.dbaccess.SocketFactory;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.Socket;
import java.net.SocketException;
import java.util.ResourceBundle;

public class StandardSocketFactory
implements SocketFactory {
    protected Socket rawSocket = null;
    protected String host = null;
    protected int port = 0;
    protected int connectTimeout = 0;
    private final ResourceBundle res = Const.res;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public Socket afterHandshake() throws SocketException, IOException {
        return this.rawSocket;
    }

    public Socket beforeHandshake() throws SocketException, IOException {
        return this.rawSocket;
    }

    public Socket connect(String hostStr, String portStr, int timeout) throws SocketException, IOException {
        this.host = hostStr;
        if (portStr != null) {
            this.port = Integer.parseInt(portStr);
        }
        boolean hasConnectTimeoutMethod = false;
        Method connectWithTimeoutMethod = null;
        try {
            Class<?> socketAddressClass = Class.forName("java.net.SocketAddress");
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.net.Socket");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            connectWithTimeoutMethod = clazz.getMethod("connect", socketAddressClass, Integer.TYPE);
            hasConnectTimeoutMethod = true;
        }
        catch (NoClassDefFoundError noClassDefFound) {
            hasConnectTimeoutMethod = false;
        }
        catch (NoSuchMethodException noSuchMethodEx) {
            hasConnectTimeoutMethod = false;
        }
        catch (Throwable catchAll) {
            hasConnectTimeoutMethod = false;
        }
        this.connectTimeout = timeout;
        if (this.host != null) {
            if (!hasConnectTimeoutMethod || this.connectTimeout == 0) {
                this.rawSocket = new Socket(this.host, this.port);
            } else {
                try {
                    Class<?> inetSocketAddressClass = Class.forName("java.net.InetSocketAddress");
                    Class[] classArray = new Class[2];
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = class$1 = Class.forName("java.lang.String");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    classArray[0] = clazz;
                    classArray[1] = Integer.TYPE;
                    Constructor<?> addrConstructor = inetSocketAddressClass.getConstructor(classArray);
                    Object sockAddr = addrConstructor.newInstance(this.host, new Integer(this.port));
                    this.rawSocket = new Socket();
                    connectWithTimeoutMethod.invoke((Object)this.rawSocket, sockAddr, new Integer(this.connectTimeout));
                }
                catch (Throwable t) {
                    throw new SocketException(t.toString());
                }
            }
            try {
                this.rawSocket.setTcpNoDelay(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this.rawSocket;
        }
        throw new SocketException(this.res.getString("error.socket.create"));
    }
}

