/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.dataConvertion;

import dm.jdbc.dataConvertion.CnvtInfo;
import dm.jdbc.dataConvertion.Convertion;
import dm.jdbc.dataConvertion.ReaderToInputStream;
import dm.jdbc.dbaccess.DBError;
import dm.jdbc.desc.ParameterDesc;
import dm.jdbc.innerData.DmdbParamVal;
import dm.sql.ARRAY;
import dm.sql.DmdbDateTime;
import dm.sql.DmdbIntervalDT;
import dm.sql.DmdbIntervalYM;
import dm.sql.DmdbTime;
import dm.sql.DmdbTimeZone;
import dm.sql.STRUCT;
import dm.sql.TypeData;
import dm.sql.TypeDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

public class JType2CType {
    public static byte[] getBytes(DmdbParamVal paramVal, ParameterDesc desc, CnvtInfo cnvtInfo, int len) throws SQLException {
        byte[] ret = null;
        Object readerOrIn = paramVal.getReaderOrInputStream();
        ret = readerOrIn != null ? JType2CType.convert_detail(readerOrIn, paramVal, cnvtInfo.getServerEncoding(), len) : JType2CType.convertWithJType(desc, cnvtInfo, paramVal, len, false);
        return ret;
    }

    public static byte[] getBytes(DmdbParamVal paramVal, ParameterDesc desc, CnvtInfo cnvtInfo) throws SQLException {
        return JType2CType.getBytes(paramVal, desc, cnvtInfo, -1);
    }

    private static byte[] convertWithJType(ParameterDesc paramDesc, CnvtInfo cnvtInfo, DmdbParamVal paramVal, int len, boolean getDtype) throws SQLException {
        int objType = paramVal.getObjType();
        byte[] retArr = null;
        switch (objType) {
            case 0: {
                retArr = JType2CType.Boolean2Ctype(paramDesc, cnvtInfo, paramVal, getDtype);
                break;
            }
            case 1: {
                retArr = JType2CType.Byte2CType(paramDesc, cnvtInfo, paramVal, getDtype);
                break;
            }
            case 2: {
                retArr = JType2CType.Short2CType(paramDesc, cnvtInfo, paramVal, getDtype);
                break;
            }
            case 3: {
                retArr = JType2CType.Integer2CType(paramDesc, cnvtInfo, paramVal, getDtype);
                break;
            }
            case 4: {
                retArr = JType2CType.Long2CType(paramDesc, cnvtInfo, paramVal, getDtype);
                break;
            }
            case 5: {
                retArr = JType2CType.Float2CType(paramDesc, cnvtInfo, paramVal, getDtype);
                break;
            }
            case 6: {
                retArr = JType2CType.Double2CType(paramDesc, cnvtInfo, paramVal, getDtype);
                break;
            }
            case 7: {
                retArr = JType2CType.BigDecimal2CType(paramDesc, cnvtInfo, paramVal, getDtype);
                break;
            }
            case 8: {
                retArr = JType2CType.Date2CType(paramDesc, cnvtInfo, paramVal, getDtype);
                break;
            }
            case 9: {
                retArr = JType2CType.Time2CType(paramDesc, cnvtInfo, paramVal, getDtype);
                break;
            }
            case 10: {
                retArr = JType2CType.TimeStamp2CType(paramDesc, cnvtInfo, paramVal, getDtype);
                break;
            }
            case 11: {
                retArr = JType2CType.dmTime2CType(paramDesc, cnvtInfo, paramVal, getDtype);
                break;
            }
            case 12: {
                retArr = JType2CType.IntervYM2CType(paramDesc, cnvtInfo, paramVal, getDtype);
                break;
            }
            case 13: {
                retArr = JType2CType.IntervDT2CType(paramDesc, cnvtInfo, paramVal, getDtype);
                break;
            }
            case 14: {
                retArr = JType2CType.String2CType(paramDesc, cnvtInfo, paramVal, len, getDtype);
                break;
            }
            case 15: {
                retArr = JType2CType.byteArr2CType(paramDesc, cnvtInfo, paramVal, len, getDtype);
                break;
            }
            case 16: {
                retArr = JType2CType.Blob2CType(paramDesc, cnvtInfo, paramVal, len, getDtype);
                break;
            }
            case 17: {
                retArr = JType2CType.Clob2CType(paramDesc, cnvtInfo, paramVal, len, getDtype);
                break;
            }
            case 18: {
                retArr = JType2CType.Reader2CType(paramDesc, cnvtInfo, paramVal, len, getDtype);
                break;
            }
            case 19: {
                retArr = JType2CType.InputStream2CType(paramDesc, cnvtInfo, paramVal, len, getDtype);
                break;
            }
            case 24: {
                retArr = JType2CType.Null2CType(paramDesc, paramVal, getDtype);
                break;
            }
            case 25: {
                retArr = JType2CType.Object2CType(paramDesc, cnvtInfo, paramVal, len, getDtype);
                break;
            }
            case 20: {
                retArr = JType2CType.Array2CType(paramDesc, paramVal, getDtype);
                break;
            }
            case 21: {
                retArr = JType2CType.Struct2CType(paramDesc, paramVal, getDtype);
                break;
            }
            default: {
                DBError.throwUnsupportedSQLException();
            }
        }
        return retArr;
    }

    public static void ExactParamType(ParameterDesc paramDesc, DmdbParamVal paramVal) throws SQLException {
        byte typeFlag = paramDesc.getTypeFlag();
        if (typeFlag == 1) {
            return;
        }
        JType2CType.convertWithJType(paramDesc, null, paramVal, -1, true);
    }

    private static byte[] convert_detail(Object readerOrIn, DmdbParamVal paramVal, String serverEncoding, int len) throws SQLException {
        byte[] ret = null;
        if (readerOrIn instanceof InputStream) {
            ret = JType2CType.InputStream_bytes((InputStream)readerOrIn, paramVal, len, true);
        } else if (readerOrIn instanceof Reader) {
            ret = JType2CType.Reader_chars((Reader)readerOrIn, paramVal, len, serverEncoding, true);
        } else {
            DBError.throwUnsupportedSQLException();
        }
        return ret;
    }

    private static byte[] Object2CType(ParameterDesc paramDesc, CnvtInfo cnvtInfo, DmdbParamVal paramVal, int len, boolean getDtype) throws SQLException {
        Object value = paramVal.getObjVal();
        if (value == null) {
            paramDesc.setParamRecmdInfo(0, 0, 0);
            return null;
        }
        byte[] ret = null;
        if (value instanceof Boolean) {
            ret = JType2CType.Boolean2Ctype(paramDesc, cnvtInfo, paramVal, getDtype);
        } else if (value instanceof Byte) {
            ret = JType2CType.Byte2CType(paramDesc, cnvtInfo, paramVal, getDtype);
        } else if (value instanceof Short) {
            ret = JType2CType.Short2CType(paramDesc, cnvtInfo, paramVal, getDtype);
        } else if (value instanceof Integer) {
            ret = JType2CType.Integer2CType(paramDesc, cnvtInfo, paramVal, getDtype);
        } else if (value instanceof Long) {
            ret = JType2CType.Long2CType(paramDesc, cnvtInfo, paramVal, getDtype);
        } else if (value instanceof Float) {
            ret = JType2CType.Float2CType(paramDesc, cnvtInfo, paramVal, getDtype);
        } else if (value instanceof Double) {
            ret = JType2CType.Double2CType(paramDesc, cnvtInfo, paramVal, getDtype);
        } else if (value instanceof BigDecimal) {
            ret = JType2CType.BigDecimal2CType(paramDesc, cnvtInfo, paramVal, getDtype);
        } else if (value instanceof Date) {
            ret = JType2CType.Date2CType(paramDesc, cnvtInfo, paramVal, getDtype);
        } else if (value instanceof Timestamp) {
            ret = JType2CType.TimeStamp2CType(paramDesc, cnvtInfo, paramVal, getDtype);
        } else if (value instanceof Time) {
            ret = JType2CType.Time2CType(paramDesc, cnvtInfo, paramVal, getDtype);
        } else if (value instanceof DmdbTime) {
            ret = JType2CType.dmTime2CType(paramDesc, cnvtInfo, paramVal, getDtype);
        } else if (value instanceof DmdbIntervalDT) {
            ret = JType2CType.IntervDT2CType(paramDesc, cnvtInfo, paramVal, getDtype);
        } else if (value instanceof DmdbIntervalYM) {
            ret = JType2CType.IntervYM2CType(paramDesc, cnvtInfo, paramVal, getDtype);
        } else if (value instanceof java.util.Date) {
            java.util.Date udt = (java.util.Date)paramVal.getObjVal();
            Date date = new Date(udt.getTime());
            paramVal.setInValue(date, 8);
            ret = JType2CType.Date2CType(paramDesc, cnvtInfo, paramVal, getDtype);
        } else if (value instanceof String) {
            ret = JType2CType.String2CType(paramDesc, cnvtInfo, paramVal, len, getDtype);
        } else if (value instanceof byte[]) {
            ret = JType2CType.byteArr2CType(paramDesc, cnvtInfo, paramVal, len, getDtype);
        } else if (value instanceof Blob) {
            ret = JType2CType.Blob2CType(paramDesc, cnvtInfo, paramVal, len, getDtype);
        } else if (value instanceof Clob) {
            ret = JType2CType.Clob2CType(paramDesc, cnvtInfo, paramVal, len, getDtype);
        } else if (value instanceof Reader) {
            ret = JType2CType.Reader2CType(paramDesc, cnvtInfo, paramVal, len, getDtype);
        } else if (value instanceof InputStream) {
            ret = JType2CType.InputStream2CType(paramDesc, cnvtInfo, paramVal, len, getDtype);
        } else if (value instanceof ARRAY) {
            ret = JType2CType.Array2CType(paramDesc, paramVal, getDtype);
        } else if (value instanceof STRUCT) {
            ret = JType2CType.Struct2CType(paramDesc, paramVal, getDtype);
        } else if (value instanceof Character) {
            ret = JType2CType.Char2CType(paramDesc, cnvtInfo, paramVal, len, getDtype);
        } else {
            DBError.throwUnsupportedSQLException();
        }
        return ret;
    }

    private static byte[] Char2CType(ParameterDesc paramDesc, CnvtInfo cnvtInfo, DmdbParamVal paramVal, int len, boolean getDtype) throws SQLException {
        if (getDtype) {
            paramDesc.setParamRecmdInfo(0, 1, 0);
            return null;
        }
        char x = ((Character)paramVal.getObjVal()).charValue();
        char[] chars = new char[]{x};
        String value = new String(chars);
        paramVal.setInValue(value, 14);
        return JType2CType.String2CType(paramDesc, cnvtInfo, paramVal, len, getDtype);
    }

    private static byte[] Array2CType(ParameterDesc paramDesc, DmdbParamVal paramVal, boolean getDtype) throws SQLException {
        Object val = paramVal.getObjVal();
        if (!(val instanceof ARRAY)) {
            DBError.throwSQLException(6007);
        }
        TypeDescriptor arrDesc = paramDesc.getTypeDescriptor();
        if (getDtype) {
            paramDesc.setParamRecmdInfo(arrDesc.getDType(), 1, 0);
            return null;
        }
        ARRAY data = (ARRAY)paramVal.getObjVal();
        byte[] tmp = null;
        tmp = arrDesc.getDType() == 122 ? TypeData.sarrayToBytes(data, arrDesc) : TypeData.arrayToBytes(data, arrDesc);
        paramVal.setIsReadOver(true);
        return tmp;
    }

    private static byte[] Struct2CType(ParameterDesc paramDesc, DmdbParamVal paramVal, boolean getDtype) throws SQLException {
        Object val = paramVal.getObjVal();
        if (!(val instanceof STRUCT)) {
            DBError.throwSQLException(6007);
        }
        TypeDescriptor strctDesc = paramDesc.getTypeDescriptor();
        if (getDtype) {
            paramDesc.setParamRecmdInfo(strctDesc.getDType(), 1, 0);
            return null;
        }
        STRUCT data = (STRUCT)paramVal.getObjVal();
        if (strctDesc.getDType() == 119) {
            return TypeData.objToBytes(data, strctDesc);
        }
        return TypeData.recordToBytes(data, strctDesc);
    }

    private static byte[] Null2CType(ParameterDesc paramDesc, DmdbParamVal paramVal, boolean getDtype) {
        if (getDtype) {
            paramDesc.setParamRecmdInfo(0, 0, 0);
        }
        return null;
    }

    private static byte[] Boolean2Ctype(ParameterDesc paramDesc, CnvtInfo cnvtInfo, DmdbParamVal paramVal, boolean getDtype) throws SQLException {
        if (getDtype) {
            paramDesc.setParamRecmdInfo(5, 1, 0);
            return null;
        }
        boolean x = (Boolean)paramVal.getObjVal();
        int value = x ? 1 : 0;
        byte typeFlag = paramDesc.getTypeFlag();
        if (typeFlag != 1) {
            paramVal.setIsReadOver(true);
            return Convertion.booleanToByteArray(x);
        }
        byte[] ret = null;
        int prec = paramDesc.getPrec();
        int dType = paramDesc.getDType();
        int scale = paramDesc.getScale();
        switch (dType) {
            case 13: {
                ret = Convertion.booleanToByteArray(x);
                break;
            }
            case 3: 
            case 5: {
                ret = Convertion.byteToByteArray((byte)value);
                break;
            }
            case 6: {
                ret = Convertion.shortToByteArray((short)value);
                break;
            }
            case 7: {
                ret = Convertion.IntToByteArray(value);
                break;
            }
            case 8: {
                ret = Convertion.longToByteArray(value);
                break;
            }
            case 10: {
                ret = Convertion.floatToByteArray(value);
                break;
            }
            case 11: {
                ret = Convertion.doubleToByteArray(value);
                break;
            }
            case 9: 
            case 24: {
                ret = Convertion.BigDecimalToByteArray(String.valueOf(value), prec, scale);
                break;
            }
            case 0: 
            case 1: {
                ret = JType2CType.String_char_2CType(String.valueOf(value), prec, dType, cnvtInfo.getServerEncoding());
                break;
            }
            case 2: {
                ret = JType2CType.String_varchar_2CType(String.valueOf(value), prec, dType, cnvtInfo.getServerEncoding());
                break;
            }
            case 19: {
                ret = JType2CType.String_longvar_2CType(String.valueOf(value), cnvtInfo.getServerEncoding(), paramVal, -1);
                break;
            }
            default: {
                DBError.throwSQLException(6007);
            }
        }
        paramVal.setIsReadOver(true);
        return ret;
    }

    private static byte[] Byte2CType(ParameterDesc paramDesc, CnvtInfo cnvtInfo, DmdbParamVal paramVal, boolean getDtype) throws SQLException {
        if (getDtype) {
            paramDesc.setParamRecmdInfo(5, 1, 0);
            return null;
        }
        byte x = (Byte)paramVal.getObjVal();
        byte typeFlag = paramDesc.getTypeFlag();
        if (typeFlag != 1) {
            paramVal.setIsReadOver(true);
            return Convertion.byteToByteArray(x);
        }
        byte[] ret = null;
        int prec = paramDesc.getPrec();
        int scale = paramDesc.getScale();
        int dType = paramDesc.getDType();
        switch (dType) {
            case 3: {
                ret = Convertion.byteToByteArray((byte)(x != 0 ? 1 : 0));
                break;
            }
            case 5: {
                ret = Convertion.byteToByteArray(x);
                break;
            }
            case 6: {
                ret = Convertion.shortToByteArray(x);
                break;
            }
            case 7: {
                ret = Convertion.IntToByteArray(x);
                break;
            }
            case 8: {
                ret = Convertion.longToByteArray(x);
                break;
            }
            case 10: {
                ret = Convertion.floatToByteArray(x);
                break;
            }
            case 11: {
                ret = Convertion.doubleToByteArray(x);
                break;
            }
            case 9: 
            case 24: {
                ret = Convertion.BigDecimalToByteArray(String.valueOf(x), prec, scale);
                break;
            }
            case 13: {
                ret = Convertion.booleanToByteArray(x != 0);
                break;
            }
            case 0: 
            case 1: {
                ret = JType2CType.String_char_2CType(String.valueOf(x), prec, dType, cnvtInfo.getServerEncoding());
                break;
            }
            case 2: {
                ret = JType2CType.String_varchar_2CType(String.valueOf(x), prec, dType, cnvtInfo.getServerEncoding());
                break;
            }
            case 19: {
                ret = JType2CType.String_longvar_2CType(String.valueOf(x), cnvtInfo.getServerEncoding(), paramVal, -1);
                break;
            }
            default: {
                DBError.throwSQLException(6007);
            }
        }
        paramVal.setIsReadOver(true);
        return ret;
    }

    private static byte[] Short2CType(ParameterDesc paramDesc, CnvtInfo cnvtInfo, DmdbParamVal paramVal, boolean getDtype) throws SQLException {
        if (getDtype) {
            paramDesc.setParamRecmdInfo(6, 2, 0);
            return null;
        }
        short x = (Short)paramVal.getObjVal();
        byte typeFlag = paramDesc.getTypeFlag();
        if (typeFlag != 1) {
            paramVal.setIsReadOver(true);
            return Convertion.shortToByteArray(x);
        }
        byte[] ret = null;
        int prec = paramDesc.getPrec();
        int scale = paramDesc.getScale();
        int dType = paramDesc.getDType();
        switch (dType) {
            case 6: {
                ret = Convertion.shortToByteArray(x);
                break;
            }
            case 3: {
                if (x > 127 || x < -128) {
                    DBError.throwSQLException(6004);
                }
                ret = Convertion.byteToByteArray((byte)(x != 0 ? 1 : 0));
                break;
            }
            case 5: {
                if (x > 127 || x < -128) {
                    DBError.throwSQLException(6004);
                }
                ret = Convertion.byteToByteArray((byte)x);
                break;
            }
            case 7: {
                ret = Convertion.IntToByteArray(x);
                break;
            }
            case 8: {
                ret = Convertion.longToByteArray(x);
                break;
            }
            case 10: {
                ret = Convertion.floatToByteArray(x);
                break;
            }
            case 11: {
                ret = Convertion.doubleToByteArray(x);
                break;
            }
            case 9: 
            case 24: {
                ret = Convertion.BigDecimalToByteArray(String.valueOf(x), prec, scale);
                break;
            }
            case 13: {
                ret = Convertion.booleanToByteArray(x != 0);
                break;
            }
            case 0: 
            case 1: {
                ret = JType2CType.String_char_2CType(String.valueOf(x), prec, dType, cnvtInfo.getServerEncoding());
                break;
            }
            case 2: {
                ret = JType2CType.String_varchar_2CType(String.valueOf(x), prec, dType, cnvtInfo.getServerEncoding());
                break;
            }
            case 19: {
                ret = JType2CType.String_longvar_2CType(String.valueOf(x), cnvtInfo.getServerEncoding(), paramVal, -1);
                break;
            }
            default: {
                DBError.throwSQLException(6007);
            }
        }
        paramVal.setIsReadOver(true);
        return ret;
    }

    private static byte[] Integer2CType(ParameterDesc paramDesc, CnvtInfo cnvtInfo, DmdbParamVal paramVal, boolean getDtype) throws SQLException {
        if (getDtype) {
            paramDesc.setParamRecmdInfo(7, 4, 0);
            return null;
        }
        int x = (Integer)paramVal.getObjVal();
        byte typeFlag = paramDesc.getTypeFlag();
        if (typeFlag != 1) {
            paramVal.setIsReadOver(true);
            return Convertion.IntToByteArray(x);
        }
        byte[] ret = null;
        int prec = paramDesc.getPrec();
        int scale = paramDesc.getScale();
        int dType = paramDesc.getDType();
        switch (dType) {
            case 7: {
                ret = Convertion.IntToByteArray(x);
                break;
            }
            case 3: {
                if (x > 127 || x < -128) {
                    DBError.throwSQLException(6004);
                }
                ret = Convertion.byteToByteArray((byte)(x != 0 ? 1 : 0));
                break;
            }
            case 5: {
                if (x > 127 || x < -128) {
                    DBError.throwSQLException(6004);
                }
                ret = Convertion.byteToByteArray((byte)x);
                break;
            }
            case 6: {
                if (x > Short.MAX_VALUE || x < Short.MIN_VALUE) {
                    DBError.throwSQLException(6004);
                }
                ret = Convertion.shortToByteArray(x);
                break;
            }
            case 8: {
                ret = Convertion.longToByteArray(x);
                break;
            }
            case 10: {
                ret = Convertion.floatToByteArray(x);
                break;
            }
            case 11: {
                ret = Convertion.doubleToByteArray(x);
                break;
            }
            case 9: 
            case 24: {
                ret = Convertion.BigDecimalToByteArray(String.valueOf(x), prec, scale);
                break;
            }
            case 13: {
                ret = Convertion.booleanToByteArray(x != 0);
                break;
            }
            case 0: 
            case 1: {
                ret = JType2CType.String_char_2CType(String.valueOf(x), prec, dType, cnvtInfo.getServerEncoding());
                break;
            }
            case 2: {
                ret = JType2CType.String_varchar_2CType(String.valueOf(x), prec, dType, cnvtInfo.getServerEncoding());
                break;
            }
            case 19: {
                ret = JType2CType.String_longvar_2CType(String.valueOf(x), cnvtInfo.getServerEncoding(), paramVal, -1);
                break;
            }
            case 17: {
                ret = Convertion.intToBinary(x, prec);
                break;
            }
            default: {
                DBError.throwSQLException(6007);
            }
        }
        paramVal.setIsReadOver(true);
        return ret;
    }

    private static byte[] Long2CType(ParameterDesc paramDesc, CnvtInfo cnvtInfo, DmdbParamVal paramVal, boolean getDtype) throws SQLException {
        if (getDtype) {
            paramDesc.setParamRecmdInfo(8, 8, 0);
            return null;
        }
        long x = (Long)paramVal.getObjVal();
        byte typeFlag = paramDesc.getTypeFlag();
        if (typeFlag != 1) {
            paramVal.setIsReadOver(true);
            return Convertion.longToByteArray(x);
        }
        byte[] ret = null;
        int prec = paramDesc.getPrec();
        int dType = paramDesc.getDType();
        int scale = paramDesc.getScale();
        switch (dType) {
            case 8: {
                ret = Convertion.longToByteArray(x);
                break;
            }
            case 3: {
                if (x > 127L || x < -128L) {
                    DBError.throwSQLException(6004);
                }
                ret = Convertion.byteToByteArray((byte)(x != 0L ? 1 : 0));
                break;
            }
            case 5: {
                if (x > 127L || x < -128L) {
                    DBError.throwSQLException(6004);
                }
                ret = Convertion.byteToByteArray((byte)x);
                break;
            }
            case 6: {
                if (x > 32767L || x < -32768L) {
                    DBError.throwSQLException(6004);
                }
                ret = Convertion.shortToByteArray((int)x);
                break;
            }
            case 7: {
                if (x > Integer.MAX_VALUE || x < Integer.MIN_VALUE) {
                    DBError.throwSQLException(6004);
                }
                ret = Convertion.IntToByteArray((int)x);
                break;
            }
            case 10: {
                ret = Convertion.floatToByteArray(x);
                break;
            }
            case 11: {
                ret = Convertion.doubleToByteArray(x);
                break;
            }
            case 9: 
            case 24: {
                ret = Convertion.BigDecimalToByteArray(String.valueOf(x), prec, scale);
                break;
            }
            case 13: {
                ret = Convertion.booleanToByteArray(x != 0L);
                break;
            }
            case 0: 
            case 1: {
                ret = JType2CType.String_char_2CType(String.valueOf(x), prec, dType, cnvtInfo.getServerEncoding());
                break;
            }
            case 2: {
                ret = JType2CType.String_varchar_2CType(String.valueOf(x), prec, dType, cnvtInfo.getServerEncoding());
                break;
            }
            case 19: {
                ret = JType2CType.String_longvar_2CType(String.valueOf(x), cnvtInfo.getServerEncoding(), paramVal, -1);
                break;
            }
            case 17: {
                ret = Convertion.longToBinary(x, prec);
                break;
            }
            case 16: {
                if (x > 2958463L) {
                    DBError.throwSQLException(-2512);
                }
                ret = Convertion.getBytes(new Date(x * 24L * 60L * 60L * 1000L - 2209017600000L).toString(), cnvtInfo.getServerEncoding());
                break;
            }
            case 15: {
                ret = Convertion.TimeToByteArray(new DmdbTime(String.valueOf(new Time(0L)), scale));
                break;
            }
            case 14: {
                if (x > 2958463L) {
                    DBError.throwSQLException(-2512);
                }
                DmdbDateTime dt = new DmdbDateTime(new Date(x * 24L * 60L * 60L * 1000L - 2209017600000L).toString(), scale, 0);
                ret = Convertion.DateToByteArray(dt);
                break;
            }
            default: {
                DBError.throwSQLException(6007);
            }
        }
        paramVal.setIsReadOver(true);
        return ret;
    }

    private static byte[] Float2CType(ParameterDesc paramDesc, CnvtInfo cnvtInfo, DmdbParamVal paramVal, boolean getDtype) throws SQLException {
        if (getDtype) {
            paramDesc.setParamRecmdInfo(10, 0, 0);
            return null;
        }
        float x = ((Float)paramVal.getObjVal()).floatValue();
        byte typeFlag = paramDesc.getTypeFlag();
        if (typeFlag != 1) {
            paramVal.setIsReadOver(true);
            return Convertion.floatToByteArray(x);
        }
        byte[] ret = null;
        int prec = paramDesc.getPrec();
        int scale = paramDesc.getScale();
        int dType = paramDesc.getDType();
        switch (dType) {
            case 10: {
                ret = Convertion.floatToByteArray(x);
                break;
            }
            case 3: {
                if (x > 127.0f || x < -128.0f) {
                    DBError.throwSQLException(6004);
                }
                ret = Convertion.byteToByteArray((byte)(x != 0.0f ? 1 : 0));
                break;
            }
            case 5: {
                ret = Convertion.byteToByteArray((byte)x);
                break;
            }
            case 6: {
                ret = Convertion.shortToByteArray((short)x);
                break;
            }
            case 7: {
                ret = Convertion.IntToByteArray((int)x);
                break;
            }
            case 8: {
                ret = Convertion.longToByteArray((long)x);
                break;
            }
            case 11: {
                ret = Convertion.doubleToByteArray(x);
                break;
            }
            case 9: 
            case 24: {
                ret = Convertion.BigDecimalToByteArray(String.valueOf(x), prec, scale);
                break;
            }
            case 13: {
                ret = Convertion.booleanToByteArray(x != 0.0f);
                break;
            }
            case 0: 
            case 1: {
                ret = JType2CType.String_char_2CType(String.valueOf(x), prec, dType, cnvtInfo.getServerEncoding());
                break;
            }
            case 2: {
                ret = JType2CType.String_varchar_2CType(String.valueOf(x), prec, dType, cnvtInfo.getServerEncoding());
                break;
            }
            case 19: {
                ret = JType2CType.String_longvar_2CType(String.valueOf(x), cnvtInfo.getServerEncoding(), paramVal, -1);
                break;
            }
            default: {
                DBError.throwSQLException(6007);
            }
        }
        paramVal.setIsReadOver(true);
        return ret;
    }

    private static byte[] Double2CType(ParameterDesc paramDesc, CnvtInfo cnvtInfo, DmdbParamVal paramVal, boolean getDtype) throws SQLException {
        if (getDtype) {
            paramDesc.setParamRecmdInfo(11, 0, 0);
            return null;
        }
        double x = (Double)paramVal.getObjVal();
        byte typeFlag = paramDesc.getTypeFlag();
        if (typeFlag != 1) {
            paramVal.setIsReadOver(true);
            return Convertion.doubleToByteArray(x);
        }
        byte[] ret = null;
        int prec = paramDesc.getPrec();
        int scale = paramDesc.getScale();
        int dType = paramDesc.getDType();
        switch (dType) {
            case 11: {
                ret = Convertion.doubleToByteArray(x);
                break;
            }
            case 3: {
                if (x > 127.0 || x < -128.0) {
                    DBError.throwSQLException(6004);
                }
                ret = Convertion.byteToByteArray((byte)(x != 0.0 ? 1 : 0));
                break;
            }
            case 5: {
                ret = Convertion.byteToByteArray((byte)x);
                break;
            }
            case 6: {
                ret = Convertion.shortToByteArray((short)x);
                break;
            }
            case 7: {
                ret = Convertion.IntToByteArray((int)x);
                break;
            }
            case 8: {
                ret = Convertion.longToByteArray((long)x);
                break;
            }
            case 10: {
                ret = Convertion.floatToByteArray((float)x);
                break;
            }
            case 9: 
            case 24: {
                ret = Convertion.BigDecimalToByteArray(String.valueOf(x), prec, scale);
                break;
            }
            case 13: {
                ret = Convertion.booleanToByteArray(x != 0.0);
                break;
            }
            case 0: 
            case 1: {
                ret = JType2CType.String_char_2CType(String.valueOf(x), prec, dType, cnvtInfo.getServerEncoding());
                break;
            }
            case 2: {
                ret = JType2CType.String_varchar_2CType(String.valueOf(x), prec, dType, cnvtInfo.getServerEncoding());
                break;
            }
            case 19: {
                ret = JType2CType.String_longvar_2CType(String.valueOf(x), cnvtInfo.getServerEncoding(), paramVal, -1);
                break;
            }
            default: {
                DBError.throwSQLException(6007);
            }
        }
        paramVal.setIsReadOver(true);
        return ret;
    }

    private static byte[] BigDecimal2CType(ParameterDesc paramDesc, CnvtInfo cnvtInfo, DmdbParamVal paramVal, boolean getDtype) throws SQLException {
        int dType = paramDesc.getDType();
        int prec = paramDesc.getPrec();
        int scale = paramDesc.getScale();
        if (getDtype) {
            if (dType != 11 && dType != 10) {
                paramDesc.setParamRecmdInfo(9, 0, 0);
            } else {
                paramDesc.setParamRecmdInfo(dType, prec, scale);
            }
            return null;
        }
        BigDecimal x = (BigDecimal)paramVal.getObjVal();
        byte typeFlag = paramDesc.getTypeFlag();
        if (typeFlag != 1 && dType != 11 && dType != 10) {
            paramVal.setIsReadOver(true);
            return Convertion.BigDecimalToByteArray(String.valueOf(x), 0, 0);
        }
        byte[] ret = null;
        switch (dType) {
            case 9: 
            case 24: {
                ret = Convertion.BigDecimalToByteArray(String.valueOf(x), prec, scale);
                break;
            }
            case 3: {
                if (x.byteValue() > 127 || x.byteValue() < -128) {
                    DBError.throwSQLException(6004);
                }
                ret = Convertion.byteToByteArray((byte)(x.byteValue() != 0 ? 1 : 0));
                break;
            }
            case 5: {
                ret = Convertion.byteToByteArray(x.byteValue());
                break;
            }
            case 6: {
                ret = Convertion.shortToByteArray(x.shortValue());
                break;
            }
            case 7: {
                ret = Convertion.IntToByteArray(x.intValue());
                break;
            }
            case 8: {
                ret = Convertion.longToByteArray(x.longValue());
                break;
            }
            case 10: {
                ret = Convertion.floatToByteArray(x.floatValue());
                break;
            }
            case 11: {
                ret = Convertion.doubleToByteArray(x.doubleValue());
                break;
            }
            case 13: {
                boolean b_v = x.equals(new BigDecimal(0.0));
                ret = Convertion.booleanToByteArray(b_v);
                break;
            }
            case 0: 
            case 1: {
                ret = JType2CType.String_char_2CType(String.valueOf(x), prec, dType, cnvtInfo.getServerEncoding());
                break;
            }
            case 2: {
                ret = JType2CType.String_varchar_2CType(String.valueOf(x), prec, dType, cnvtInfo.getServerEncoding());
                break;
            }
            case 19: {
                ret = JType2CType.String_longvar_2CType(String.valueOf(x), cnvtInfo.getServerEncoding(), paramVal, -1);
                break;
            }
            default: {
                DBError.throwSQLException(6007);
            }
        }
        paramVal.setIsReadOver(true);
        return ret;
    }

    private static byte[] Date2CType(ParameterDesc paramDesc, CnvtInfo cnvtInfo, DmdbParamVal paramVal, boolean getDtype) throws SQLException {
        if (getDtype) {
            paramDesc.setParamRecmdInfo(14, 3, 0);
            return null;
        }
        Date x = (Date)paramVal.getObjVal();
        int prec = paramDesc.getPrec();
        int dType = paramDesc.getDType();
        int scale = paramDesc.getScale();
        byte typeFlag = paramDesc.getTypeFlag();
        if (typeFlag != 1) {
            DmdbDateTime dt = new DmdbDateTime(x.toString(), scale, 0);
            paramVal.setIsReadOver(true);
            return Convertion.DateToByteArray(dt);
        }
        byte[] ret = null;
        DmdbDateTime dt = null;
        switch (dType) {
            case 14: {
                dt = new DmdbDateTime(x.toString(), scale, 0);
                ret = Convertion.DateToByteArray(dt);
                break;
            }
            case 16: {
                Timestamp ts = new Timestamp(x.getTime());
                dt = new DmdbDateTime(ts.toString(), scale, 2);
                ret = Convertion.TimeStampToByteArray(dt, dType, scale, cnvtInfo.getDbTz(), cnvtInfo.getTimeZone());
                break;
            }
            case 0: 
            case 1: {
                ret = JType2CType.String_char_2CType(String.valueOf(x), prec, dType, cnvtInfo.getServerEncoding());
                break;
            }
            case 2: {
                ret = JType2CType.String_varchar_2CType(String.valueOf(x), prec, dType, cnvtInfo.getServerEncoding());
                break;
            }
            case 19: {
                ret = JType2CType.String_longvar_2CType(String.valueOf(x), cnvtInfo.getServerEncoding(), paramVal, -1);
                break;
            }
            default: {
                DBError.throwSQLException(6007);
            }
        }
        paramVal.setIsReadOver(true);
        return ret;
    }

    private static byte[] TimeStamp2CType(ParameterDesc paramDesc, CnvtInfo cnvtInfo, DmdbParamVal paramVal, boolean getDtype) throws SQLException {
        if (getDtype) {
            paramDesc.setParamRecmdInfo(16, 8, 0);
            return null;
        }
        Timestamp x = (Timestamp)paramVal.getObjVal();
        int prec = paramDesc.getPrec();
        int dType = paramDesc.getDType();
        int scale = paramDesc.getScale();
        byte typeFlag = paramDesc.getTypeFlag();
        if (typeFlag != 1) {
            DmdbDateTime dt = new DmdbDateTime(x.toString(), scale, 2);
            paramVal.setIsReadOver(true);
            return Convertion.TimeStampToByteArray(dt, 16, scale, cnvtInfo.getDbTz(), cnvtInfo.getTimeZone());
        }
        byte[] ret = null;
        DmdbDateTime dt = null;
        switch (dType) {
            case 14: {
                dt = new DmdbDateTime(new Date(x.getTime()).toString(), scale, 0);
                ret = Convertion.DateToByteArray(dt);
                break;
            }
            case 15: {
                DmdbTime t = new DmdbTime(DmdbDateTime.getTimeFromTimestamp(x), scale);
                ret = Convertion.TimeToByteArray(t);
                break;
            }
            case 16: {
                dt = new DmdbDateTime(x.toString(), scale, 2);
                ret = Convertion.TimeStampToByteArray(dt, dType, scale, cnvtInfo.getDbTz(), cnvtInfo.getTimeZone());
                break;
            }
            case 0: 
            case 1: {
                ret = JType2CType.String_char_2CType(String.valueOf(x), prec, dType, cnvtInfo.getServerEncoding());
                break;
            }
            case 2: {
                ret = JType2CType.String_varchar_2CType(String.valueOf(x), prec, dType, cnvtInfo.getServerEncoding());
                break;
            }
            case 19: {
                ret = JType2CType.String_longvar_2CType(String.valueOf(x), cnvtInfo.getServerEncoding(), paramVal, -1);
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                dt = new DmdbDateTime(x.toString(), scale, 2);
                ret = JType2CType.String_javaObj_2CType(dt.getStringFromTimestamp(x), dType, scale, prec, cnvtInfo);
                break;
            }
            default: {
                DBError.throwSQLException(6007);
            }
        }
        paramVal.setIsReadOver(true);
        return ret;
    }

    private static byte[] Time2CType(ParameterDesc paramDesc, CnvtInfo cnvtInfo, DmdbParamVal paramVal, boolean getDtype) throws SQLException {
        if (getDtype) {
            paramDesc.setParamRecmdInfo(15, 5, 0);
            return null;
        }
        Time x = (Time)paramVal.getObjVal();
        int prec = paramDesc.getPrec();
        int dType = paramDesc.getDType();
        int scale = paramDesc.getScale();
        byte typeFlag = paramDesc.getTypeFlag();
        if (typeFlag != 1) {
            DmdbTime t = new DmdbTime(String.valueOf(x), scale);
            paramVal.setIsReadOver(true);
            return Convertion.TimeToByteArray(t);
        }
        byte[] ret = null;
        switch (dType) {
            case 15: {
                DmdbTime t = new DmdbTime(String.valueOf(x), scale);
                ret = Convertion.TimeToByteArray(t);
                break;
            }
            case 0: 
            case 1: {
                ret = JType2CType.String_char_2CType(String.valueOf(x), prec, dType, cnvtInfo.getServerEncoding());
                break;
            }
            case 2: {
                ret = JType2CType.String_varchar_2CType(String.valueOf(x), prec, dType, cnvtInfo.getServerEncoding());
                break;
            }
            case 19: {
                ret = JType2CType.String_longvar_2CType(String.valueOf(x), cnvtInfo.getServerEncoding(), paramVal, -1);
                break;
            }
            default: {
                DBError.throwSQLException(6007);
            }
        }
        paramVal.setIsReadOver(true);
        return ret;
    }

    private static byte[] dmTime2CType(ParameterDesc paramDesc, CnvtInfo cnvtInfo, DmdbParamVal paramVal, boolean getDtype) throws SQLException {
        if (getDtype) {
            paramDesc.setParamRecmdInfo(15, 5, 0);
            return null;
        }
        DmdbTime t = (DmdbTime)paramVal.getObjVal();
        int dType = paramDesc.getDType();
        int scale = paramDesc.getScale();
        byte typeFlag = paramDesc.getTypeFlag();
        if (typeFlag != 1) {
            paramVal.setIsReadOver(true);
            return Convertion.TimeToByteArray(t);
        }
        byte[] ret = null;
        switch (dType) {
            case 15: {
                ret = Convertion.TimeToByteArray(t);
                break;
            }
            case 16: {
                Timestamp ts = new Timestamp(t.getTime().getTime());
                ts.setNanos(t.getNano());
                DmdbDateTime dt = new DmdbDateTime(t.toString(), scale, 2);
                ret = Convertion.TimeStampToByteArray(dt, dType, scale, cnvtInfo.getDbTz(), cnvtInfo.getTimeZone());
                break;
            }
            default: {
                DmdbParamVal tempVal = paramVal;
                tempVal.setInValue(String.valueOf(paramVal.getObjVal()), 14);
                ret = JType2CType.String2CType(paramDesc, cnvtInfo, paramVal, -1, getDtype);
            }
        }
        paramVal.setIsReadOver(true);
        return ret;
    }

    private static byte[] IntervDT2CType(ParameterDesc paramDesc, CnvtInfo cnvtInfo, DmdbParamVal paramVal, boolean getDtype) throws SQLException {
        DmdbIntervalDT dt = (DmdbIntervalDT)paramVal.getObjVal();
        if (getDtype) {
            if (dt != null) {
                paramDesc.setParamRecmdInfo(21, 0, dt.getPrecForSvr());
            }
            return null;
        }
        int dType = paramDesc.getDType();
        int scale = paramDesc.getScale();
        byte typeFlag = paramDesc.getTypeFlag();
        if (typeFlag != 1) {
            paramVal.setIsReadOver(true);
            return Convertion.InterDtToByteArray(dt);
        }
        byte[] ret = null;
        switch (dType) {
            case 21: {
                ret = Convertion.InterDtToByteArray(dt, scale);
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 12: 
            case 17: 
            case 18: 
            case 19: {
                DmdbParamVal tempVal = paramVal;
                tempVal.setInValue(String.valueOf(paramVal.getObjVal()), 14);
                JType2CType.String2CType(paramDesc, cnvtInfo, tempVal, -1, getDtype);
                break;
            }
            default: {
                DBError.throwSQLException(6007);
            }
        }
        paramVal.setIsReadOver(true);
        return ret;
    }

    private static byte[] IntervYM2CType(ParameterDesc paramDesc, CnvtInfo cnvtInfo, DmdbParamVal paramVal, boolean getDtype) throws SQLException {
        DmdbIntervalYM ym = (DmdbIntervalYM)paramVal.getObjVal();
        if (getDtype) {
            if (ym != null) {
                paramDesc.setParamRecmdInfo(20, 0, ym.getPrecForSvr());
            }
            return null;
        }
        int prec = paramDesc.getPrec();
        int dType = paramDesc.getDType();
        byte typeFlag = paramDesc.getTypeFlag();
        if (typeFlag != 1) {
            paramVal.setIsReadOver(true);
            return Convertion.InterYMToByteArray(ym);
        }
        byte[] ret = null;
        switch (dType) {
            case 20: {
                ret = Convertion.InterYMToByteArray(ym, prec);
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 12: 
            case 17: 
            case 18: 
            case 19: {
                DmdbParamVal tempVal = paramVal;
                tempVal.setInValue(String.valueOf(paramVal.getObjVal()), 14);
                ret = JType2CType.String2CType(paramDesc, cnvtInfo, tempVal, -1, getDtype);
                break;
            }
            default: {
                DBError.throwSQLException(6007);
            }
        }
        paramVal.setIsReadOver(true);
        return ret;
    }

    private static byte[] String2CType(ParameterDesc paramDesc, CnvtInfo cnvtInfo, DmdbParamVal paramVal, int len, boolean getDtype) throws SQLException {
        if (getDtype) {
            paramDesc.setParamRecmdInfo(2, 8188, 0);
            return null;
        }
        String x = (String)paramVal.getObjVal();
        int prec = paramDesc.getPrec();
        int dType = paramDesc.getDType();
        int scale = paramDesc.getScale();
        byte typeFlag = paramDesc.getTypeFlag();
        if (typeFlag != 1) {
            byte[] inValueBytes = Convertion.getBytes(x, cnvtInfo.getServerEncoding());
            paramVal.setIsReadOver(true);
            return inValueBytes;
        }
        byte[] ret = null;
        switch (dType) {
            case 0: 
            case 1: {
                ret = JType2CType.String_char_2CType(x, prec, dType, cnvtInfo.getServerEncoding());
                paramVal.setIsReadOver(true);
                break;
            }
            case 2: {
                ret = JType2CType.String_varchar_2CType(x, prec, dType, cnvtInfo.getServerEncoding());
                paramVal.setIsReadOver(true);
                break;
            }
            case 12: 
            case 17: 
            case 18: {
                ret = JType2CType.String_binary_2CType(x, prec, dType);
                paramVal.setIsReadOver(true);
                break;
            }
            case 19: {
                ret = JType2CType.String_longvar_2CType(x, cnvtInfo.getServerEncoding(), paramVal, len);
                break;
            }
            case 3: {
                byte val = 1;
                if (x.length() > 0) {
                    if (x.charAt(0) == '0' || "false".equalsIgnoreCase(x)) {
                        val = 0;
                    }
                    ret = Convertion.byteToByteArray(val);
                } else {
                    paramVal.setIsNull(true);
                }
                paramVal.setIsReadOver(true);
                break;
            }
            case 5: {
                if (x.trim().length() > 0) {
                    ret = Convertion.byteToByteArray(Byte.parseByte(x.trim()));
                } else {
                    paramVal.setIsNull(true);
                }
                paramVal.setIsReadOver(true);
                break;
            }
            case 6: {
                if (x.trim().length() > 0) {
                    ret = Convertion.shortToByteArray(Short.parseShort(x.trim()));
                } else {
                    paramVal.setIsNull(true);
                }
                paramVal.setIsReadOver(true);
                break;
            }
            case 7: {
                if (x.trim().length() > 0) {
                    ret = Convertion.IntToByteArray(Integer.parseInt(x.trim()));
                } else {
                    paramVal.setIsNull(true);
                }
                paramVal.setIsReadOver(true);
                break;
            }
            case 8: {
                if (x.trim().length() > 0) {
                    ret = Convertion.longToByteArray(Long.parseLong(x.trim()));
                } else {
                    paramVal.setIsNull(true);
                }
                paramVal.setIsReadOver(true);
                break;
            }
            case 10: {
                if (x.trim().length() > 0) {
                    ret = Convertion.floatToByteArray(Float.parseFloat(x.trim()));
                } else {
                    paramVal.setIsNull(true);
                }
                paramVal.setIsReadOver(true);
                break;
            }
            case 11: {
                if (x.trim().length() > 0) {
                    ret = Convertion.doubleToByteArray(Double.parseDouble(x.trim()));
                } else {
                    paramVal.setIsNull(true);
                }
                paramVal.setIsReadOver(true);
                break;
            }
            case 9: 
            case 24: {
                if (x.trim().length() > 0) {
                    ret = Convertion.BigDecimalToByteArray(x, prec, scale);
                } else {
                    paramVal.setIsNull(true);
                }
                paramVal.setIsReadOver(true);
                break;
            }
            case 13: {
                if (x.trim().length() > 0) {
                    boolean b = false;
                    if (!x.trim().equalsIgnoreCase("0") || Boolean.valueOf(x).booleanValue()) {
                        b = true;
                    }
                    ret = Convertion.booleanToByteArray(b);
                } else {
                    paramVal.setIsNull(true);
                }
                paramVal.setIsReadOver(true);
                break;
            }
            case 14: {
                if (x.trim().length() > 0) {
                    DmdbDateTime dt = new DmdbDateTime(x.trim(), scale, 0);
                    ret = Convertion.DateToByteArray(dt);
                } else {
                    paramVal.setIsNull(true);
                }
                paramVal.setIsReadOver(true);
                break;
            }
            case 15: {
                if (x.trim().length() > 0) {
                    DmdbTime t = new DmdbTime(x.trim(), scale);
                    ret = Convertion.TimeToByteArray(t);
                } else {
                    paramVal.setIsNull(true);
                }
                paramVal.setIsReadOver(true);
                break;
            }
            case 16: {
                if (x.trim().length() > 0) {
                    Timestamp ts = DmdbDateTime.getTimestampByString(x.trim(), dType, scale, cnvtInfo.getTimeZone());
                    DmdbDateTime dt = new DmdbDateTime(ts.toString(), scale, 2);
                    ret = Convertion.TimeStampToByteArray(dt, dType, scale, cnvtInfo.getDbTz(), cnvtInfo.getTimeZone());
                } else {
                    paramVal.setIsNull(true);
                }
                paramVal.setIsReadOver(true);
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                if (x.trim().length() > 0) {
                    ret = JType2CType.String_javaObj_2CType(x, dType, scale, prec, cnvtInfo);
                } else {
                    paramVal.setIsNull(true);
                }
                paramVal.setIsReadOver(true);
                break;
            }
            default: {
                DBError.throwSQLException(6007);
            }
        }
        return ret;
    }

    public static byte[] String_char_2CType(String str, int prec, int cType, String serverEncoding) throws SQLException {
        if (str == null) {
            return null;
        }
        byte[] bs = Convertion.getBytes(str, serverEncoding);
        return bs;
    }

    public static byte[] String_varchar_2CType(String str, int prec, int dType, String serverEncoding) throws SQLException {
        byte[] inValueBytes = Convertion.getBytes(str, serverEncoding);
        return inValueBytes;
    }

    private static byte[] String_longvar_2CType(String str, String serverEncoding, DmdbParamVal paramVal, int length) throws SQLException {
        int len = str.length();
        int offset = paramVal.getOffset();
        int readLen = 0;
        if (length <= 0) {
            length = 8000;
        }
        if (len - offset > length) {
            readLen = length;
            paramVal.setIsReadOver(false);
        } else {
            readLen = len - offset;
        }
        String subStr = str.substring(offset, offset + readLen);
        paramVal.setOffset(offset += subStr.length());
        if (offset >= len) {
            paramVal.setIsReadOver(true);
        }
        return Convertion.getBytes(subStr, serverEncoding);
    }

    public static byte[] String_binary_2CType(String str, int prec, int dType) throws SQLException {
        if (dType == 17) {
            return Convertion.stringToBinary(str, prec);
        }
        return Convertion.stringToBinary(str, prec);
    }

    private static byte[] String_javaObj_2CType(String x, int dType, int scale, int prec, CnvtInfo cnvtInfo) throws SQLException {
        byte[] ret = null;
        if ((x = x.trim()).length() > 0) {
            int secPrec = scale & 0xF;
            int loadPrec = scale >> 4 & 0xF;
            switch (dType) {
                case 21: {
                    DmdbIntervalDT dt = new DmdbIntervalDT(x, loadPrec, secPrec);
                    ret = Convertion.InterDtToByteArray(dt, scale);
                    break;
                }
                case 20: {
                    DmdbIntervalYM ym = new DmdbIntervalYM(x, loadPrec);
                    ret = Convertion.InterYMToByteArray(ym, scale);
                    break;
                }
                case 22: 
                case 23: {
                    DmdbTimeZone tz = null;
                    if (dType == 22) {
                        tz = new DmdbTimeZone(x, 1, cnvtInfo.getTimeZone());
                        ret = Convertion.TimeZoneToByteArray(tz);
                        break;
                    }
                    tz = new DmdbTimeZone(x, 2, cnvtInfo.getTimeZone());
                    ret = Convertion.DateTimeZoneToByteArray(tz);
                    break;
                }
                default: {
                    DBError.throwSQLException(6014);
                    break;
                }
            }
        } else {
            ret = null;
        }
        return ret;
    }

    private static byte[] byteArr2CType(ParameterDesc paramDesc, CnvtInfo cnvtInfo, DmdbParamVal paramVal, int len, boolean getDtype) throws SQLException {
        if (getDtype) {
            paramDesc.setParamRecmdInfo(18, 8188, 0);
            return null;
        }
        byte[] x = (byte[])paramVal.getObjVal();
        if (paramVal.getOutDataBound() && paramDesc.getIOType() != 0) {
            return x;
        }
        int prec = paramDesc.getPrec();
        int dType = paramDesc.getDType();
        byte typeFlag = paramDesc.getTypeFlag();
        if (typeFlag != 1) {
            paramVal.setIsReadOver(true);
            return x;
        }
        byte[] bs = null;
        switch (dType) {
            case 17: {
                bs = x;
                paramVal.setIsReadOver(true);
                break;
            }
            case 18: {
                bs = x;
                paramVal.setIsReadOver(true);
                break;
            }
            case 12: 
            case 19: {
                bs = JType2CType.byteArr_longvar_2CType(x, dType, paramVal, len);
                break;
            }
            case 0: 
            case 1: 
            case 2: {
                bs = JType2CType.byteArr_char_2CType(x, prec, dType);
                paramVal.setIsReadOver(true);
                break;
            }
            default: {
                DBError.throwSQLException(6007);
            }
        }
        return bs;
    }

    private static byte[] byteArr_char_2CType(byte[] bs, int prec, int cType) throws SQLException {
        return Convertion.binaryArrToString(bs, prec, cType);
    }

    private static byte[] byteArr_longvar_2CType(byte[] bs, int dType, DmdbParamVal paramVal, int length) throws SQLException {
        int offset = paramVal.getOffset();
        int len = bs.length;
        if (length <= 0) {
            length = 16000;
        }
        int readLen = 0;
        if (len - offset > length) {
            readLen = length;
            paramVal.setIsReadOver(false);
        } else {
            readLen = len - offset;
        }
        byte[] ret = new byte[readLen];
        System.arraycopy(bs, offset, ret, 0, readLen);
        paramVal.setOffset(offset += ret.length);
        if (offset >= len) {
            paramVal.setIsReadOver(true);
        }
        if (dType == 12) {
            return ret;
        }
        return Convertion.binaryArrToString(ret, readLen * 2, dType);
    }

    private static byte[] Blob_getBytes(Blob lob, DmdbParamVal paramVal, int length) throws SQLException {
        long len = lob.length();
        int offSet = paramVal.getOffset();
        if (length <= 0) {
            length = 32000;
        }
        int readLen = 0;
        if (len - (long)offSet > (long)length) {
            readLen = length;
            paramVal.setIsReadOver(false);
        } else {
            readLen = (int)(len - (long)offSet);
        }
        byte[] ret = lob.getBytes(offSet + 1, readLen);
        if (ret != null) {
            offSet += ret.length;
        }
        paramVal.setOffset(offSet);
        if ((long)offSet >= len) {
            paramVal.setIsReadOver(true);
        }
        return ret;
    }

    private static byte[] Blob2CType(ParameterDesc paramDesc, CnvtInfo cnvtInfo, DmdbParamVal paramVal, int len, boolean getDtype) throws SQLException {
        int prec = paramDesc.getPrec();
        if (getDtype) {
            paramDesc.setParamRecmdInfo(12, prec, 0);
            return null;
        }
        Blob lob = (Blob)paramVal.getObjVal();
        int dType = paramDesc.getDType();
        byte typeFlag = paramDesc.getTypeFlag();
        if (typeFlag != 1) {
            return JType2CType.Blob_getBytes(lob, paramVal, len);
        }
        byte[] ret = null;
        switch (dType) {
            case 12: {
                ret = JType2CType.Blob_getBytes(lob, paramVal, len);
                break;
            }
            case 117: 
            case 119: 
            case 121: 
            case 122: {
                TypeDescriptor typeDesc = paramDesc.getTypeDescriptor();
                if (typeDesc != null) {
                    ret = JType2CType.Blob_obj_getBytes(lob, typeDesc);
                    break;
                }
                DBError.throwSQLException(6007);
                break;
            }
            default: {
                DBError.throwSQLException(6007);
            }
        }
        return ret;
    }

    private static byte[] Blob_obj_getBytes(Blob blob, TypeDescriptor desc) throws SQLException {
        long len = blob.length();
        byte[] buf = blob.getBytes(1L, (int)len);
        return TypeData.objBlobToBytes(buf, desc);
    }

    private static byte[] Clob_getBytes(Clob lob, DmdbParamVal paramVal, int length, String serverEncoding) throws SQLException {
        long len = lob.length();
        int offset = paramVal.getOffset();
        if (length <= 0) {
            length = 8000;
        }
        int readLen = 0;
        readLen = len - (long)offset > (long)length ? length : (int)(len - (long)offset);
        String subStr = lob.getSubString(offset + 1, readLen);
        if (subStr != null) {
            offset += subStr.length();
        }
        paramVal.setOffset(offset);
        if ((long)offset >= len) {
            paramVal.setIsReadOver(true);
        }
        return Convertion.getBytes(subStr, serverEncoding);
    }

    private static byte[] Clob2CType(ParameterDesc paramDesc, CnvtInfo cnvtInfo, DmdbParamVal paramVal, int len, boolean getDtype) throws SQLException {
        int prec = paramDesc.getPrec();
        if (getDtype) {
            paramDesc.setParamRecmdInfo(19, prec, 0);
            return null;
        }
        int dType = paramDesc.getDType();
        Clob lob = (Clob)paramVal.getObjVal();
        byte typeFlag = paramDesc.getTypeFlag();
        if (typeFlag != 1) {
            return JType2CType.Clob_getBytes(lob, paramVal, len, cnvtInfo.getServerEncoding());
        }
        byte[] ret = null;
        switch (dType) {
            case 2: 
            case 19: {
                ret = JType2CType.Clob_getBytes(lob, paramVal, len, cnvtInfo.getServerEncoding());
                break;
            }
            default: {
                DBError.throwSQLException(6007);
            }
        }
        return ret;
    }

    private static byte[] InputStream_bytes_exec(InputStream in, int readLen) throws IOException {
        byte[] bs = new byte[readLen];
        int len = in.read(bs, 0, bs.length);
        if (len <= 0) {
            return null;
        }
        byte[] ret = new byte[len];
        System.arraycopy(bs, 0, ret, 0, ret.length);
        return ret;
    }

    private static byte[] InputStream_bytes(InputStream in, DmdbParamVal paramVal, int length, boolean isLob) throws SQLException {
        try {
            boolean isNeedReadComplete = false;
            int readLen = 0;
            if (length <= 0) {
                readLen = 32000;
                isNeedReadComplete = true;
            } else {
                readLen = length;
                if (!paramVal.streamConverted() && paramVal.hasLength() && (long)readLen > paramVal.leftWithLength()) {
                    readLen = (int)paramVal.leftWithLength();
                }
            }
            int retLen = 32000;
            byte[] ret = new byte[retLen];
            int retHasLen = 0;
            byte[] retTemp = null;
            while (!paramVal.getIsReadOver()) {
                if (!isLob && retHasLen > 8188) {
                    DBError.throwSQLException(6067);
                    break;
                }
                byte[] retOnce = JType2CType.InputStream_bytes_exec(in, readLen);
                if (retOnce == null) {
                    paramVal.setIsReadOver(true);
                    break;
                }
                if (retHasLen + retOnce.length > retLen) {
                    retTemp = new byte[retHasLen];
                    System.arraycopy(ret, 0, retTemp, 0, retHasLen);
                    ret = new byte[retHasLen + retLen];
                    System.arraycopy(retTemp, 0, ret, 0, retHasLen);
                    retTemp = null;
                }
                System.arraycopy(retOnce, 0, ret, retHasLen, retOnce.length);
                retHasLen += retOnce.length;
                retOnce = null;
                if (!isNeedReadComplete) break;
            }
            retTemp = new byte[retHasLen];
            System.arraycopy(ret, 0, retTemp, 0, retHasLen);
            if (!paramVal.streamConverted() && paramVal.hasLength()) {
                paramVal.calcReadLen(retHasLen);
            }
            return retTemp;
        }
        catch (IOException e) {
            DBError.throwSQLException(e.toString(), -1);
            return null;
        }
    }

    private static void setRecmdTypeForInputStream(ParameterDesc paramDesc) throws SQLException {
        int dtype = paramDesc.getDType();
        switch (dtype) {
            case 0: 
            case 1: 
            case 2: 
            case 17: 
            case 18: {
                paramDesc.setParamRecmdInfo(18, 8188, 0);
                break;
            }
            case 12: 
            case 19: {
                paramDesc.setParamRecmdInfo(12, Integer.MAX_VALUE, 0);
                break;
            }
            default: {
                DBError.throwSQLException(6007);
            }
        }
    }

    private static byte[] InputStream2CType(ParameterDesc paramDesc, CnvtInfo cnvtInfo, DmdbParamVal paramVal, int len, boolean getDtype) throws SQLException {
        if (getDtype) {
            JType2CType.setRecmdTypeForInputStream(paramDesc);
            return null;
        }
        boolean isLob = JType2CType.checkLobForStream(paramDesc);
        InputStream in = (InputStream)paramVal.getObjVal();
        int dType = paramDesc.getDType();
        byte typeFlag = paramDesc.getTypeFlag();
        if (typeFlag != 1) {
            return JType2CType.InputStream_bytes(in, paramVal, len, isLob);
        }
        byte[] ret = null;
        switch (dType) {
            case 0: 
            case 1: 
            case 2: 
            case 12: 
            case 17: 
            case 18: 
            case 19: 
            case 119: {
                TypeDescriptor clsDesc = paramDesc.getTypeDescriptor();
                if (dType == 119 && clsDesc != null) {
                    isLob = true;
                }
                ret = JType2CType.InputStream_bytes(in, paramVal, len, isLob);
                if (dType != 119 || clsDesc == null) break;
                ret = TypeData.objBlobToBytes(ret, clsDesc);
                break;
            }
            default: {
                DBError.throwSQLException(6007);
            }
        }
        return ret;
    }

    private static byte[] Reader_bytes(Reader reader, DmdbParamVal paramVal, int length, String serverEncoding, boolean isLob) throws SQLException {
        ReaderToInputStream chgTemp = new ReaderToInputStream();
        InputStream in = null;
        in = paramVal.hasLength() ? chgTemp.ReaderTo(reader, serverEncoding, paramVal.getLength()) : chgTemp.ReaderTo(reader, serverEncoding);
        paramVal.setReaderOrInputStream(in);
        return JType2CType.InputStream_bytes(in, paramVal, length, isLob);
    }

    private static String Reader_chars_exec(Reader reader, int readLen) throws IOException {
        char[] chars = new char[readLen];
        int len = reader.read(chars, 0, chars.length);
        if (len <= 0) {
            return null;
        }
        String strRet = new String(chars, 0, len);
        return strRet;
    }

    private static byte[] Reader_chars(Reader reader, DmdbParamVal paramVal, int length, String serverEncoding, boolean isLob) throws SQLException {
        try {
            boolean isNeedReadComplete = false;
            int readLen = 0;
            if (length <= 0) {
                readLen = 8000;
                isNeedReadComplete = true;
            } else {
                readLen = length;
                if (!paramVal.streamConverted() && paramVal.hasLength() && (long)readLen > paramVal.leftWithLength()) {
                    readLen = (int)paramVal.leftWithLength();
                }
            }
            StringBuffer strBuf = new StringBuffer();
            String strTemp = null;
            int hasReadLen = 0;
            while (!paramVal.getIsReadOver()) {
                if (!isLob && hasReadLen > 8188) {
                    DBError.throwSQLException(6067);
                    break;
                }
                strTemp = JType2CType.Reader_chars_exec(reader, readLen);
                if (strTemp == null) {
                    paramVal.setIsReadOver(true);
                    break;
                }
                strBuf.append(strTemp);
                hasReadLen += strTemp.length();
                if (!paramVal.streamConverted() && paramVal.hasLength()) {
                    paramVal.calcReadLen(strTemp.length());
                }
                if (!isNeedReadComplete) break;
            }
            return Convertion.getBytes(strBuf.toString(), serverEncoding);
        }
        catch (IOException e) {
            DBError.throwSQLException(e.toString(), -1);
            return null;
        }
    }

    private static void setRecmdTypeForReader(ParameterDesc paramDesc) throws SQLException {
        int dtype = paramDesc.getDType();
        switch (dtype) {
            case 0: 
            case 1: 
            case 2: 
            case 17: 
            case 18: {
                paramDesc.setParamRecmdInfo(2, 8188, 0);
                break;
            }
            case 12: 
            case 19: {
                paramDesc.setParamRecmdInfo(19, Integer.MAX_VALUE, 0);
                break;
            }
            default: {
                DBError.throwSQLException(6007);
            }
        }
    }

    private static boolean checkLobForStream(ParameterDesc paramDesc) {
        int dtype;
        byte typeFlag = paramDesc.getTypeFlag();
        int n = dtype = typeFlag == 1 ? paramDesc.getDType() : paramDesc.getRecommendDType();
        return dtype == 12 || dtype == 19;
    }

    private static byte[] Reader2CType(ParameterDesc paramDesc, CnvtInfo cnvtInfo, DmdbParamVal paramVal, int len, boolean getDtype) throws SQLException {
        if (getDtype) {
            JType2CType.setRecmdTypeForReader(paramDesc);
            return null;
        }
        Reader reader = (Reader)paramVal.getObjVal();
        int dType = paramDesc.getDType();
        boolean isLob = JType2CType.checkLobForStream(paramDesc);
        byte typeFlag = paramDesc.getTypeFlag();
        if (typeFlag != 1) {
            return JType2CType.Reader_chars(reader, paramVal, len, cnvtInfo.getServerEncoding(), isLob);
        }
        byte[] ret = null;
        switch (dType) {
            case 0: 
            case 1: 
            case 2: 
            case 19: {
                ret = JType2CType.Reader_chars(reader, paramVal, len, cnvtInfo.getServerEncoding(), isLob);
                break;
            }
            case 12: 
            case 17: 
            case 18: {
                ret = JType2CType.Reader_bytes(reader, paramVal, len, cnvtInfo.getServerEncoding(), isLob);
                break;
            }
            default: {
                DBError.throwSQLException(6007);
            }
        }
        return ret;
    }
}

