/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.dataConvertion;

import dm.jdbc.dataConvertion.CnvtInfo;
import dm.jdbc.dataConvertion.Convertion;
import dm.jdbc.dbaccess.DBError;
import dm.jdbc.desc.CommDesc;
import dm.jdbc.desc.DTypeInfo;
import dm.jdbc.desc.LobDesc;
import dm.jdbc.driver.DmdbBlob;
import dm.jdbc.driver.DmdbClob;
import dm.jdbc.driver.DmdbConnection_bs;
import dm.jdbc.driver.DmdbInputStream;
import dm.jdbc.util.UtilBinaryToUnicodeInputStream;
import dm.sql.ARRAY;
import dm.sql.DmdbDateTime;
import dm.sql.DmdbIntervalDT;
import dm.sql.DmdbIntervalYM;
import dm.sql.DmdbSQLInput;
import dm.sql.DmdbTime;
import dm.sql.DmdbTimeZone;
import dm.sql.DmdbTimeZone2Bdta;
import dm.sql.STRUCT;
import dm.sql.TypeData;
import dm.sql.TypeDescriptor;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Map;

public class CType2JType {
    public static Object getAllBySqlType(int sqlType, byte[] val, CommDesc desc, long rowid, DmdbConnection_bs conn, Map map, String typeName, boolean isBdta) throws SQLException {
        switch (sqlType) {
            case -7: 
            case 16: {
                return new Boolean(CType2JType.getBoolean(val, desc, conn));
            }
            case -6: 
            case 4: 
            case 5: {
                return new Integer(CType2JType.getInt(val, desc, conn));
            }
            case -5: {
                return new Long(CType2JType.getLong(val, desc, conn));
            }
            case 2: 
            case 3: {
                return CType2JType.getBigDecimal(val, desc, conn);
            }
            case 7: {
                return new Float(CType2JType.getFloat(val, desc, conn));
            }
            case 6: 
            case 8: {
                double d = CType2JType.getDouble(val, desc, conn);
                if (sqlType == 6) {
                    return new Float(d);
                }
                return new Double(d);
            }
            case -1: 
            case 1: 
            case 12: {
                return CType2JType.getString(val, desc, conn, isBdta);
            }
            case 91: {
                return CType2JType.getDate(val, desc, conn);
            }
            case 92: {
                return CType2JType.getTime(val, desc, conn);
            }
            case 93: {
                return CType2JType.getTimestamp(val, desc, conn);
            }
            case -4: 
            case -3: 
            case -2: {
                return CType2JType.getBytes(val, desc, conn);
            }
            case 2004: {
                return CType2JType.getBlob(val, desc, conn);
            }
            case 2005: {
                return CType2JType.getClob(val, desc, conn);
            }
            case 2003: {
                return CType2JType.getArray_inner(val, desc.getDType(), desc, conn);
            }
            case 2002: {
                STRUCT struct = CType2JType.getStruct_inner(val, desc.getDType(), desc, conn);
                if (typeName != null) {
                    return CType2JType.getStruct_SQLData(map, struct, typeName);
                }
                return struct;
            }
            case 0: 
            case 2000: {
                return CType2JType.getObject(val, desc, conn, map, typeName);
            }
        }
        return CType2JType.getBytes(val, desc, conn);
    }

    public static Object getStruct_SQLData(Map typeMap, STRUCT struct, String typeName) throws SQLException {
        if (typeMap == null || typeMap.size() == 0) {
            return struct;
        }
        Object cls = typeMap.get(typeName);
        if (cls != null) {
            try {
                Object obj = ((Class)cls).newInstance();
                DmdbSQLInput stream = new DmdbSQLInput(typeMap, struct.getAttributes(typeMap));
                ((SQLData)obj).readSQL(stream, typeName);
                return obj;
            }
            catch (Exception e) {
                DBError.throwSQLException(6007);
            }
        }
        return struct;
    }

    private static ARRAY getArray_inner(byte[] val, int dtype, CommDesc desc, DmdbConnection_bs conn) throws SQLException {
        TypeDescriptor arrDesc = desc.getTypeDescriptor();
        if (arrDesc == null) {
            DBError.throwSQLException(6007);
        }
        ARRAY retArr = null;
        switch (dtype) {
            case 12: {
                Blob lob = CType2JType.getBlob(val, desc, conn);
                retArr = (ARRAY)TypeData.objBlobToObj(lob, arrDesc);
                break;
            }
            case 117: {
                retArr = TypeData.bytesToArray(val, null, arrDesc);
                break;
            }
            case 122: {
                retArr = TypeData.bytesToSArray(val, null, arrDesc);
                break;
            }
            case 119: {
                retArr = (ARRAY)TypeData.bytesToObj(val, null, arrDesc);
            }
        }
        return retArr;
    }

    public static ARRAY getArray(byte[] val, CommDesc desc, DmdbConnection_bs conn) throws SQLException {
        int dtype = desc.getDType();
        if (dtype != 117 && dtype != 122 && dtype != 12 && dtype != 119) {
            DBError.throwSQLException(6007);
        }
        return CType2JType.getArray_inner(val, dtype, desc, conn);
    }

    private static STRUCT getStruct_inner(byte[] val, int dtype, CommDesc desc, DmdbConnection_bs conn) throws SQLException {
        STRUCT retStrct = null;
        TypeDescriptor strctDesc = desc.getTypeDescriptor();
        if (strctDesc == null) {
            DBError.throwSQLException(6007);
        }
        switch (dtype) {
            case 12: {
                Blob lob = CType2JType.getBlob(val, desc, conn);
                retStrct = (STRUCT)TypeData.objBlobToObj(lob, strctDesc);
                break;
            }
            case 119: {
                retStrct = (STRUCT)TypeData.bytesToObj(val, null, strctDesc);
                break;
            }
            case 121: {
                retStrct = TypeData.bytesToRecord(val, null, strctDesc);
            }
        }
        return retStrct;
    }

    public static STRUCT getStruct(byte[] val, CommDesc desc, DmdbConnection_bs conn) throws SQLException {
        int dtype = desc.getDType();
        if (dtype != 119 && dtype != 121 && dtype != 12) {
            DBError.throwSQLException(6007);
        }
        return CType2JType.getStruct_inner(val, dtype, desc, conn);
    }

    public static String getString(byte[] val, CommDesc desc, DmdbConnection_bs conn, boolean isBdta) throws SQLException {
        String str = null;
        CnvtInfo cvtInfo = conn.getCnvtInfo();
        DTypeInfo dtype = desc.getDTypeInfo();
        switch (dtype.getDType()) {
            case 0: 
            case 1: 
            case 2: {
                byte[] valInner = CType2JType.checkVarchar2(val, dtype.getDType(), dtype.getPrec());
                str = Convertion.getString(valInner, 0, valInner.length, cvtInfo.getServerEncoding());
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                str = String.valueOf(val[0]);
                break;
            }
            case 6: {
                str = String.valueOf(Convertion.twoByteToShort(val));
                break;
            }
            case 7: {
                str = String.valueOf(Convertion.fourByteToInt(val));
                break;
            }
            case 8: 
            case 24: {
                str = String.valueOf(Convertion.eightByteToLong(val));
                break;
            }
            case 10: {
                str = String.valueOf(Float.intBitsToFloat(Convertion.fourByteToInt(val)));
                break;
            }
            case 11: {
                str = String.valueOf(Double.longBitsToDouble(Convertion.eightByteToLong(val)));
                break;
            }
            case 9: {
                str = String.valueOf(Convertion.bytesToBigDecimal(val, dtype.getScale(), dtype.getPrec()));
                break;
            }
            case 17: 
            case 18: {
                str = Convertion.bytesToHexString(val);
                break;
            }
            case 12: {
                str = Convertion.bytesToHexString(val);
                break;
            }
            case 19: {
                str = Convertion.getString(val, 0, val.length, cvtInfo.getServerEncoding());
                break;
            }
            case 14: {
                DmdbDateTime date = new DmdbDateTime(val, dtype.getDType(), dtype.getScale(), cvtInfo.getDbTz(), cvtInfo.getTimeZone());
                str = date.getDateInString();
                break;
            }
            case 15: {
                DmdbDateTime dt = new DmdbDateTime(val, dtype.getDType(), dtype.getScale(), cvtInfo.getDbTz(), cvtInfo.getTimeZone());
                str = dt.getTimeInString();
                break;
            }
            case 16: {
                DmdbDateTime ts = new DmdbDateTime(val, dtype.getDType(), dtype.getScale(), cvtInfo.getDbTz(), cvtInfo.getTimeZone());
                str = ts.getTimestampInString();
                break;
            }
            case 21: {
                DmdbIntervalDT intvDt = Convertion.bytesToInterDT(val, dtype.getScale());
                str = intvDt.getDTString();
                break;
            }
            case 20: {
                DmdbIntervalYM intvYm = new DmdbIntervalYM(val);
                str = intvYm.getYMString();
                break;
            }
            case 22: {
                if (isBdta) {
                    DmdbTimeZone2Bdta tz = new DmdbTimeZone2Bdta(val, dtype.getScale(), 1);
                    str = tz.getStrFromTZ();
                    break;
                }
                DmdbTimeZone tz = Convertion.bytesToTimeZone(val, dtype.getScale());
                str = tz.getStrFromTZ();
                break;
            }
            case 23: {
                if (isBdta) {
                    DmdbTimeZone2Bdta tz = new DmdbTimeZone2Bdta(val, dtype.getScale(), 2);
                    str = tz.getStrFromTZ();
                    break;
                }
                DmdbTimeZone tz1 = Convertion.bytesToDateTimeZone(val, dtype.getScale());
                str = tz1.getStrFromTZ();
                break;
            }
            default: {
                DBError.throwSQLException(6007);
            }
        }
        return str;
    }

    public static boolean getBoolean(byte[] val, CommDesc desc, DmdbConnection_bs conn) throws SQLException {
        boolean bl = false;
        CnvtInfo cvtInfo = conn.getCnvtInfo();
        DTypeInfo dtype = desc.getDTypeInfo();
        switch (dtype.getDType()) {
            case 3: 
            case 4: 
            case 5: {
                bl = Convertion.bytesToBoolean(val);
                break;
            }
            case 6: {
                if (Convertion.twoByteToShort(val) == 0) {
                    bl = false;
                    break;
                }
                bl = true;
                break;
            }
            case 7: {
                if (Convertion.fourByteToInt(val) == 0) {
                    bl = false;
                    break;
                }
                bl = true;
                break;
            }
            case 8: 
            case 24: {
                if (Convertion.eightByteToLong(val) == 0L) {
                    bl = false;
                    break;
                }
                bl = true;
                break;
            }
            case 10: {
                if ((double)Float.intBitsToFloat(Convertion.fourByteToInt(val)) == 0.0) {
                    bl = false;
                    break;
                }
                bl = true;
                break;
            }
            case 11: {
                if (Double.longBitsToDouble(Convertion.eightByteToLong(val)) == 0.0) {
                    bl = false;
                    break;
                }
                bl = true;
                break;
            }
            case 9: {
                if (Convertion.bytesToBigDecimal(val, dtype.getScale(), dtype.getPrec()).byteValue() == 0) {
                    bl = false;
                    break;
                }
                bl = true;
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 19: {
                String str = "";
                if (dtype.getDType() == 19) {
                    str = Convertion.getString(val, 0, val.length, cvtInfo.getServerEncoding());
                } else {
                    byte[] valInner = CType2JType.checkVarchar2(val, dtype.getDType(), dtype.getPrec());
                    str = Convertion.getString(valInner, 0, valInner.length, cvtInfo.getServerEncoding());
                }
                if (str.length() == 0 || str.charAt(0) == '0') {
                    bl = false;
                    break;
                }
                bl = true;
                break;
            }
            default: {
                DBError.throwSQLException(6007);
            }
        }
        return bl;
    }

    public static byte getByte(byte[] val, CommDesc desc, DmdbConnection_bs conn) throws SQLException {
        CnvtInfo cvtInfo = conn.getCnvtInfo();
        DTypeInfo dtype = desc.getDTypeInfo();
        int type = dtype.getDType();
        switch (type) {
            case 3: 
            case 4: 
            case 5: 
            case 12: {
                if (val == null || val.length == 0) {
                    return 0;
                }
                return val[0];
            }
            case 6: {
                Short tmp = new Short(Convertion.twoByteToShort(val));
                if (tmp < -128 || tmp > 127) {
                    DBError.throwSQLException(6004);
                }
                return tmp.byteValue();
            }
            case 7: {
                Integer tmp = new Integer(Convertion.fourByteToInt(val));
                if (tmp < -128 || tmp > 127) {
                    DBError.throwSQLException(6004);
                }
                return tmp.byteValue();
            }
            case 8: 
            case 24: {
                Long tmp = new Long(Convertion.eightByteToLong(val));
                if (tmp < -128L || tmp > 127L) {
                    DBError.throwSQLException(6004);
                }
                return tmp.byteValue();
            }
            case 10: {
                Float tmp = new Float(Float.intBitsToFloat(Convertion.fourByteToInt(val)));
                if (tmp.floatValue() < -128.0f || tmp.floatValue() > 127.0f) {
                    DBError.throwSQLException(6004);
                }
                return tmp.byteValue();
            }
            case 11: {
                Double tmp = new Double(Double.longBitsToDouble(Convertion.eightByteToLong(val)));
                if (tmp < -128.0 || tmp > 127.0) {
                    DBError.throwSQLException(6004);
                }
                return tmp.byteValue();
            }
            case 9: {
                BigDecimal tmp = Convertion.bytesToBigDecimal(val, dtype.getScale(), dtype.getPrec());
                if (tmp.doubleValue() < -128.0 || tmp.doubleValue() > 127.0) {
                    DBError.throwSQLException(6004);
                }
                return tmp.byteValue();
            }
            case 0: 
            case 1: 
            case 2: 
            case 19: {
                String str = "";
                if (type == 19) {
                    str = Convertion.getString(val, 0, val.length, cvtInfo.getServerEncoding());
                } else {
                    byte[] valInner = CType2JType.checkVarchar2(val, dtype.getDType(), dtype.getPrec());
                    str = Convertion.getString(valInner, 0, valInner.length, cvtInfo.getServerEncoding());
                }
                Double tmp = null;
                try {
                    tmp = Double.valueOf(str.trim());
                }
                catch (Exception e) {
                    DBError.throwSQLException(6007);
                }
                if (tmp < -128.0 || tmp > 127.0) {
                    DBError.throwSQLException(6004);
                }
                return tmp.byteValue();
            }
        }
        DBError.throwSQLException(6007);
        return 0;
    }

    public static short getShort(byte[] val, CommDesc desc, DmdbConnection_bs conn) throws SQLException {
        short result = 0;
        CnvtInfo cvtInfo = conn.getCnvtInfo();
        DTypeInfo dtype = desc.getDTypeInfo();
        int type = dtype.getDType();
        switch (type) {
            case 6: {
                result = Convertion.twoByteToShort(val);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                if (val == null || val.length == 0) {
                    result = 0;
                    break;
                }
                result = val[0];
                break;
            }
            case 7: {
                int tmp1 = Convertion.fourByteToInt(val);
                if (tmp1 < Short.MIN_VALUE || tmp1 > Short.MAX_VALUE) {
                    DBError.throwSQLException(6004);
                }
                result = (short)tmp1;
                break;
            }
            case 8: 
            case 24: {
                long tmp1 = Convertion.eightByteToLong(val);
                if (tmp1 < -32768L || tmp1 > 32767L) {
                    DBError.throwSQLException(6004);
                }
                result = (short)tmp1;
                break;
            }
            case 10: {
                float tmp1 = Float.intBitsToFloat(Convertion.fourByteToInt(val));
                if (tmp1 < -32768.0f || tmp1 > 32767.0f) {
                    DBError.throwSQLException(6004);
                }
                result = (short)tmp1;
                break;
            }
            case 11: {
                double tmp1 = Double.longBitsToDouble(Convertion.eightByteToLong(val));
                if (tmp1 < -32768.0 || tmp1 > 32767.0) {
                    DBError.throwSQLException(6004);
                }
                result = (short)tmp1;
                break;
            }
            case 9: {
                BigDecimal tmp = Convertion.bytesToBigDecimal(val, dtype.getScale(), dtype.getPrec());
                if (tmp.doubleValue() < -32768.0 || tmp.doubleValue() > 32767.0) {
                    DBError.throwSQLException(6004);
                }
                result = tmp.shortValue();
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 19: {
                String str = "";
                if (type == 19) {
                    str = Convertion.getString(val, 0, val.length, cvtInfo.getServerEncoding());
                } else {
                    byte[] valInner = CType2JType.checkVarchar2(val, dtype.getDType(), dtype.getPrec());
                    str = Convertion.getString(valInner, 0, valInner.length, cvtInfo.getServerEncoding());
                }
                Double tmp1 = null;
                try {
                    tmp1 = Double.valueOf(str.trim());
                }
                catch (Exception e) {
                    DBError.throwSQLException(6007);
                }
                if (tmp1 < -32768.0 || tmp1 > 32767.0) {
                    DBError.throwSQLException(6004);
                }
                result = tmp1.shortValue();
                break;
            }
            default: {
                DBError.throwSQLException(6007);
            }
        }
        return result;
    }

    public static int getInt(byte[] val, CommDesc desc, DmdbConnection_bs conn) throws SQLException {
        CnvtInfo cvtInfo = conn.getCnvtInfo();
        DTypeInfo dtype = desc.getDTypeInfo();
        int type = dtype.getDType();
        int result = 0;
        switch (type) {
            case 7: {
                result = Convertion.fourByteToInt(val);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 13: {
                if (val == null || val.length == 0) {
                    result = 0;
                    break;
                }
                result = val[0];
                break;
            }
            case 6: {
                result = Convertion.twoByteToShort(val);
                break;
            }
            case 8: 
            case 24: {
                long tmp1 = Convertion.eightByteToLong(val);
                if (tmp1 < Integer.MIN_VALUE || tmp1 > Integer.MAX_VALUE) {
                    DBError.throwSQLException(6004);
                }
                result = (int)tmp1;
                break;
            }
            case 10: {
                float tmp1 = Float.intBitsToFloat(Convertion.fourByteToInt(val));
                if (tmp1 < -2.1474836E9f || tmp1 > 2.1474836E9f) {
                    DBError.throwSQLException(6004);
                }
                result = (int)tmp1;
                break;
            }
            case 11: {
                double tmp1 = Double.longBitsToDouble(Convertion.eightByteToLong(val));
                if (tmp1 < -2.147483648E9 || tmp1 > 2.147483647E9) {
                    DBError.throwSQLException(6004);
                }
                result = (int)tmp1;
                break;
            }
            case 9: {
                BigDecimal tmp = Convertion.bytesToBigDecimal(val, dtype.getScale(), dtype.getPrec());
                if (tmp.doubleValue() < -2.147483648E9 || tmp.doubleValue() > 2.147483647E9) {
                    DBError.throwSQLException(6004);
                }
                result = tmp.intValue();
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 19: {
                String str = "";
                if (type == 19) {
                    str = Convertion.getString(val, 0, val.length, cvtInfo.getServerEncoding());
                } else {
                    byte[] valInner = CType2JType.checkVarchar2(val, dtype.getDType(), dtype.getPrec());
                    str = Convertion.getString(valInner, 0, valInner.length, cvtInfo.getServerEncoding());
                }
                Double tmp1 = null;
                try {
                    tmp1 = Double.valueOf(str.trim());
                }
                catch (Exception e) {
                    DBError.throwSQLException(6007);
                }
                if (tmp1 < -2.147483648E9 || tmp1 > 2.147483647E9) {
                    DBError.throwSQLException(6004);
                }
                result = tmp1.intValue();
                break;
            }
            case 17: 
            case 18: {
                result = Convertion.bytesToInt(val);
                break;
            }
            default: {
                DBError.throwSQLException(6007);
            }
        }
        return result;
    }

    public static long getLong(byte[] val, CommDesc desc, DmdbConnection_bs conn) throws SQLException {
        CnvtInfo cvtInfo = conn.getCnvtInfo();
        DTypeInfo dtype = desc.getDTypeInfo();
        int type = dtype.getDType();
        long result = 0L;
        switch (type) {
            case 8: 
            case 24: {
                result = Convertion.eightByteToLong(val);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                if (val == null || val.length == 0) {
                    result = 0L;
                    break;
                }
                result = val[0];
                break;
            }
            case 6: {
                result = Convertion.twoByteToShort(val);
                break;
            }
            case 7: {
                result = Convertion.fourByteToInt(val);
                break;
            }
            case 10: {
                result = (long)Float.intBitsToFloat(Convertion.fourByteToInt(val));
                break;
            }
            case 11: {
                result = (long)Double.longBitsToDouble(Convertion.eightByteToLong(val));
                break;
            }
            case 9: {
                BigDecimal tmp = Convertion.bytesToBigDecimal(val, dtype.getScale(), dtype.getPrec());
                if (tmp.doubleValue() < -9.223372036854776E18 || tmp.doubleValue() > 9.223372036854776E18) {
                    DBError.throwSQLException(6004);
                }
                result = tmp.longValue();
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 19: {
                String str = "";
                if (type == 19) {
                    str = Convertion.getString(val, 0, val.length, cvtInfo.getServerEncoding());
                } else {
                    byte[] valInner = CType2JType.checkVarchar2(val, dtype.getDType(), dtype.getPrec());
                    str = Convertion.getString(valInner, 0, valInner.length, cvtInfo.getServerEncoding());
                }
                Double tmp1 = null;
                try {
                    tmp1 = Double.valueOf(str.trim());
                }
                catch (Exception e) {
                    DBError.throwSQLException(6007);
                }
                if (tmp1 < -9.223372036854776E18 || tmp1 > 9.223372036854776E18) {
                    DBError.throwSQLException(6004);
                }
                result = tmp1.longValue();
                break;
            }
            case 17: 
            case 18: {
                result = Convertion.bytesToInt(val);
                break;
            }
            default: {
                DBError.throwSQLException(6007);
            }
        }
        return result;
    }

    public static float getFloat(byte[] val, CommDesc desc, DmdbConnection_bs conn) throws SQLException {
        CnvtInfo cvtInfo = conn.getCnvtInfo();
        DTypeInfo dtype = desc.getDTypeInfo();
        int type = dtype.getDType();
        float flt = 0.0f;
        switch (type) {
            case 10: {
                flt = Float.intBitsToFloat(Convertion.fourByteToInt(val));
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                if (val == null || val.length == 0) {
                    return 0.0f;
                }
                flt = val[0];
                break;
            }
            case 6: {
                flt = Convertion.twoByteToShort(val);
                break;
            }
            case 7: {
                flt = Convertion.fourByteToInt(val);
                break;
            }
            case 8: 
            case 24: {
                flt = Convertion.eightByteToLong(val);
                break;
            }
            case 11: {
                flt = (float)Double.longBitsToDouble(Convertion.eightByteToLong(val));
                break;
            }
            case 9: {
                BigDecimal tmp = Convertion.bytesToBigDecimal(val, dtype.getScale(), dtype.getPrec());
                flt = tmp.floatValue();
                if (flt != Float.NEGATIVE_INFINITY && flt != Float.POSITIVE_INFINITY) break;
                DBError.throwSQLException(6004);
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 19: {
                String str = "";
                if (type == 19) {
                    str = Convertion.getString(val, 0, val.length, cvtInfo.getServerEncoding());
                } else {
                    byte[] valInner = CType2JType.checkVarchar2(val, dtype.getDType(), dtype.getPrec());
                    str = Convertion.getString(valInner, 0, valInner.length, cvtInfo.getServerEncoding());
                }
                BigDecimal tmp1 = null;
                try {
                    tmp1 = new BigDecimal(str.trim());
                }
                catch (Exception e) {
                    DBError.throwSQLException(6007);
                }
                flt = tmp1.floatValue();
                if (flt != Float.NEGATIVE_INFINITY && flt != Float.POSITIVE_INFINITY) break;
                DBError.throwSQLException(6004);
                break;
            }
            default: {
                DBError.throwSQLException(6007);
            }
        }
        return flt;
    }

    public static double getDouble(byte[] val, CommDesc desc, DmdbConnection_bs conn) throws SQLException {
        CnvtInfo cvtInfo = conn.getCnvtInfo();
        DTypeInfo dtype = desc.getDTypeInfo();
        double dbl = 0.0;
        int type = dtype.getDType();
        switch (type) {
            case 11: {
                dbl = Double.longBitsToDouble(Convertion.eightByteToLong(val));
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                if (val == null || val.length == 0) {
                    return 0.0;
                }
                dbl = val[0];
                break;
            }
            case 6: {
                dbl = Convertion.twoByteToShort(val);
                break;
            }
            case 7: {
                dbl = Convertion.fourByteToInt(val);
                break;
            }
            case 8: 
            case 24: {
                dbl = Convertion.eightByteToLong(val);
                break;
            }
            case 10: {
                dbl = Float.intBitsToFloat(Convertion.fourByteToInt(val));
                break;
            }
            case 9: {
                BigDecimal tmp = Convertion.bytesToBigDecimal(val, dtype.getScale(), dtype.getPrec());
                dbl = tmp.doubleValue();
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 19: {
                String str = "";
                if (type == 19) {
                    str = Convertion.getString(val, 0, val.length, cvtInfo.getServerEncoding());
                } else {
                    byte[] valInner = CType2JType.checkVarchar2(val, dtype.getDType(), dtype.getPrec());
                    str = Convertion.getString(valInner, 0, valInner.length, cvtInfo.getServerEncoding());
                }
                try {
                    dbl = Double.valueOf(str.trim());
                }
                catch (Exception e) {
                    DBError.throwSQLException(6007);
                }
                break;
            }
            default: {
                DBError.throwSQLException(6007);
            }
        }
        return dbl;
    }

    public static BigDecimal getBigDecimal(byte[] val, CommDesc desc, DmdbConnection_bs conn) throws SQLException {
        CnvtInfo cvtInfo = conn.getCnvtInfo();
        DTypeInfo dtype = desc.getDTypeInfo();
        BigDecimal dec = null;
        int type = dtype.getDType();
        switch (type) {
            case 9: {
                dec = Convertion.bytesToBigDecimal(val, dtype.getScale(), dtype.getPrec());
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                dec = new BigDecimal(BigInteger.valueOf(val[0]));
                break;
            }
            case 6: {
                dec = new BigDecimal(BigInteger.valueOf(Convertion.twoByteToShort(val)));
                break;
            }
            case 7: {
                dec = new BigDecimal(BigInteger.valueOf(Convertion.fourByteToInt(val)));
                break;
            }
            case 8: 
            case 24: {
                long value = Convertion.eightByteToLong(val);
                dec = new BigDecimal(BigInteger.valueOf(value));
                break;
            }
            case 10: {
                dec = new BigDecimal(Float.intBitsToFloat(Convertion.fourByteToInt(val)));
                break;
            }
            case 11: {
                dec = new BigDecimal(Double.longBitsToDouble(Convertion.eightByteToLong(val)));
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 19: {
                String str = "";
                if (type == 19) {
                    str = Convertion.getString(val, 0, val.length, cvtInfo.getServerEncoding());
                } else {
                    byte[] valInner = CType2JType.checkVarchar2(val, dtype.getDType(), dtype.getPrec());
                    str = Convertion.getString(valInner, 0, valInner.length, cvtInfo.getServerEncoding());
                }
                try {
                    dec = new BigDecimal(str.trim());
                }
                catch (Exception e) {
                    DBError.throwSQLException(6007);
                }
                break;
            }
            default: {
                DBError.throwSQLException(6007);
            }
        }
        return dec;
    }

    public static byte[] getBytes(byte[] val, CommDesc desc, DmdbConnection_bs conn) throws SQLException {
        DTypeInfo dtype = desc.getDTypeInfo();
        int type = dtype.getDType();
        return val;
    }

    public static Date getDate(byte[] val, CommDesc desc, DmdbConnection_bs conn) throws SQLException {
        CnvtInfo cvtInfo = conn.getCnvtInfo();
        DTypeInfo dtype = desc.getDTypeInfo();
        int type = dtype.getDType();
        int scale = dtype.getScale();
        DmdbDateTime dt = new DmdbDateTime(val, type, scale, cvtInfo.getDbTz(), cvtInfo.getTimeZone());
        switch (type) {
            case 14: {
                return dt.getDate();
            }
            case 16: 
            case 23: {
                return new Date(dt.getTimestamp().getTime());
            }
            case 0: 
            case 1: 
            case 2: 
            case 19: {
                String str = "";
                if (type == 19) {
                    str = Convertion.getString(val, 0, val.length, cvtInfo.getServerEncoding());
                } else {
                    byte[] valInner = CType2JType.checkVarchar2(val, dtype.getDType(), dtype.getPrec());
                    str = Convertion.getString(valInner, 0, valInner.length, cvtInfo.getServerEncoding());
                }
                return DmdbDateTime.getDateByString(str.trim());
            }
        }
        DBError.throwSQLException(6007);
        return null;
    }

    public static Time getTime(byte[] val, CommDesc desc, DmdbConnection_bs conn) throws SQLException {
        CnvtInfo cvtInfo = conn.getCnvtInfo();
        DTypeInfo dtype = desc.getDTypeInfo();
        int type = dtype.getDType();
        int scale = dtype.getScale();
        DmdbDateTime dt = new DmdbDateTime(val, type, scale, cvtInfo.getDbTz(), cvtInfo.getTimeZone());
        switch (type) {
            case 15: 
            case 22: {
                return dt.getTime();
            }
            case 16: 
            case 23: {
                return new Time(dt.getTimestamp().getTime());
            }
            case 0: 
            case 1: 
            case 2: 
            case 19: {
                String str = "";
                if (type == 19) {
                    str = Convertion.getString(val, 0, val.length, cvtInfo.getServerEncoding());
                } else {
                    byte[] valInner = CType2JType.checkVarchar2(val, dtype.getDType(), dtype.getPrec());
                    str = Convertion.getString(valInner, 0, valInner.length, cvtInfo.getServerEncoding());
                }
                DmdbTime dt1 = new DmdbTime(str.trim(), scale);
                return dt1.getTime();
            }
        }
        DBError.throwSQLException(6007);
        return null;
    }

    public static DmdbTime getDmTime(byte[] val, CommDesc desc, DmdbConnection_bs conn, boolean isBdta) throws SQLException {
        DTypeInfo dtype = desc.getDTypeInfo();
        CnvtInfo cvtInfo = conn.getCnvtInfo();
        int type = dtype.getDType();
        int scale = dtype.getScale();
        DmdbDateTime dt = new DmdbDateTime(val, type, scale, cvtInfo.getDbTz(), cvtInfo.getTimeZone());
        String str = "";
        switch (type) {
            case 15: {
                return new DmdbTime(val, scale);
            }
            case 16: {
                Timestamp ts = dt.getTimestamp();
                str = String.valueOf(ts);
                return new DmdbTime(str, scale);
            }
        }
        str = CType2JType.getString(val, desc, conn, isBdta);
        return new DmdbTime(str, scale);
    }

    public static Timestamp getTimestamp(byte[] val, CommDesc desc, DmdbConnection_bs conn) throws SQLException {
        CnvtInfo cvtInfo = conn.getCnvtInfo();
        DTypeInfo dtype = desc.getDTypeInfo();
        int type = dtype.getDType();
        int scale = dtype.getScale();
        DmdbDateTime dt = new DmdbDateTime(val, type, scale, cvtInfo.getDbTz(), cvtInfo.getTimeZone());
        switch (type) {
            case 16: 
            case 23: {
                return dt.getTimestamp();
            }
            case 14: {
                return new Timestamp(dt.getDate().getTime());
            }
            case 15: 
            case 22: {
                DmdbTime dt1 = new DmdbTime(val, scale);
                return dt1.getTimestamp();
            }
            case 0: 
            case 1: 
            case 2: 
            case 19: {
                String str = "";
                if (type == 19) {
                    str = Convertion.getString(val, 0, val.length, cvtInfo.getServerEncoding());
                } else {
                    byte[] valInner = CType2JType.checkVarchar2(val, dtype.getDType(), dtype.getPrec());
                    str = Convertion.getString(valInner, 0, valInner.length, cvtInfo.getServerEncoding());
                }
                return DmdbDateTime.getTimestampByString(str.trim(), type, scale, cvtInfo.getTimeZone());
            }
        }
        DBError.throwSQLException(6007);
        return null;
    }

    public static InputStream getAsciiStream(byte[] val, CommDesc desc, DmdbConnection_bs conn) throws SQLException {
        CnvtInfo cvtInfo = conn.getCnvtInfo();
        DTypeInfo dtype = desc.getDTypeInfo();
        LobDesc lobInfo = desc.getLobDesc();
        int type = dtype.getDType();
        int prec = dtype.getPrec();
        boolean fromRowSetFlag = false;
        switch (type) {
            case 17: 
            case 18: {
                return new DmdbInputStream(val, false, cvtInfo.getServerEncoding());
            }
            case 12: {
                Blob blob = CType2JType.get_blob_value(val, lobInfo, conn, !desc.isReadOnly());
                return new DmdbInputStream(blob, fromRowSetFlag, conn.getServerEncoding());
            }
            case 19: {
                Clob clob = CType2JType.get_clob_value(val, lobInfo, conn, !desc.isReadOnly());
                return new DmdbInputStream(clob, fromRowSetFlag, conn.getServerEncoding());
            }
            case 0: 
            case 1: 
            case 2: {
                byte[] valInner = CType2JType.checkVarchar2(val, type, prec);
                return new DmdbInputStream(valInner, false, cvtInfo.getServerEncoding());
            }
        }
        DBError.throwSQLException(6016);
        return null;
    }

    public static InputStream getUnicodeStream(byte[] val, CommDesc desc, DmdbConnection_bs conn) throws SQLException {
        DTypeInfo dtype = desc.getDTypeInfo();
        LobDesc lobInfo = desc.getLobDesc();
        InputStream in = null;
        int type = dtype.getDType();
        boolean fromRowSetFlag = false;
        switch (type) {
            case 12: 
            case 17: 
            case 18: {
                if (type == 12) {
                    Blob blob = CType2JType.get_blob_value(val, lobInfo, conn, !desc.isReadOnly());
                    in = new DmdbInputStream(blob, fromRowSetFlag, conn.getServerEncoding());
                } else {
                    String str = Convertion.bytesToHexString(val);
                    in = new ByteArrayInputStream(str.getBytes());
                }
                return new UtilBinaryToUnicodeInputStream(in);
            }
            case 19: {
                Clob clob = CType2JType.get_clob_value(val, lobInfo, conn, !desc.isReadOnly());
                in = new DmdbInputStream(clob, fromRowSetFlag, conn.getServerEncoding());
                return new UtilBinaryToUnicodeInputStream(in);
            }
            case 0: 
            case 1: 
            case 2: {
                byte[] valInner = CType2JType.checkVarchar2(val, type, dtype.getPrec());
                in = new ByteArrayInputStream(valInner);
                return new UtilBinaryToUnicodeInputStream(in);
            }
        }
        DBError.throwSQLException(6016);
        return null;
    }

    public static InputStream getBinaryStream(byte[] val, CommDesc desc, DmdbConnection_bs conn) throws SQLException {
        CnvtInfo cvtInfo = conn.getCnvtInfo();
        DTypeInfo dtype = desc.getDTypeInfo();
        LobDesc lobInfo = desc.getLobDesc();
        int type = dtype.getDType();
        boolean fromRowSetFlag = false;
        switch (type) {
            case 17: 
            case 18: {
                return new DmdbInputStream(val, fromRowSetFlag, cvtInfo.getServerEncoding());
            }
            case 12: {
                Blob blob = CType2JType.get_blob_value(val, lobInfo, conn, !desc.isReadOnly());
                return new DmdbInputStream(blob, fromRowSetFlag, conn.getServerEncoding());
            }
            case 19: {
                Clob clob = CType2JType.get_clob_value(val, lobInfo, conn, !desc.isReadOnly());
                return new DmdbInputStream(clob, fromRowSetFlag, conn.getServerEncoding());
            }
            case 0: 
            case 1: {
                byte[] valInner = CType2JType.checkVarchar2(val, type, dtype.getPrec());
                return new DmdbInputStream(valInner, fromRowSetFlag, cvtInfo.getServerEncoding());
            }
        }
        DBError.throwSQLException(6016);
        return null;
    }

    public static Object getObject(byte[] val, CommDesc desc, DmdbConnection_bs conn, Map map, String typeName) throws SQLException {
        CnvtInfo cvtInfo = conn.getCnvtInfo();
        DTypeInfo dtype = desc.getDTypeInfo();
        LobDesc lobInfo = desc.getLobDesc();
        int type = dtype.getDType();
        int scale = dtype.getScale();
        int prec = dtype.getPrec();
        switch (type) {
            case 3: 
            case 4: {
                return new Boolean(Convertion.bytesToBoolean(val));
            }
            case 5: 
            case 6: 
            case 7: {
                int tmp = 0;
                tmp = type == 5 ? val[0] : (type == 6 ? Convertion.twoByteToShort(val) : Convertion.fourByteToInt(val));
                return new Integer(tmp);
            }
            case 8: 
            case 24: {
                return new Long(Convertion.eightByteToLong(val));
            }
            case 9: {
                return Convertion.bytesToBigDecimal(val, scale, prec);
            }
            case 10: {
                return new Float(Float.intBitsToFloat(Convertion.fourByteToInt(val)));
            }
            case 11: {
                return new Double(Double.longBitsToDouble(Convertion.eightByteToLong(val)));
            }
            case 14: {
                return Convertion.bytesToDate(val, scale, cvtInfo.getDbTz(), cvtInfo.getTimeZone());
            }
            case 15: {
                return Convertion.bytesToTime(val, scale, cvtInfo.getDbTz(), cvtInfo.getTimeZone());
            }
            case 16: {
                return Convertion.bytesToTimeStamp(val, scale, cvtInfo.getDbTz(), cvtInfo.getTimeZone());
            }
            case 17: 
            case 18: {
                return val;
            }
            case 12: {
                Blob blob = CType2JType.get_blob_value(val, lobInfo, conn, !desc.isReadOnly());
                if (desc.isComplexType()) {
                    TypeDescriptor typedesc = desc.getTypeDescriptor();
                    if (typedesc != null) {
                        return CType2JType.getComplexObj_from_blob(blob, typedesc);
                    }
                    DBError.throwSQLException(6007);
                    return null;
                }
                if (desc.getTypeName().equalsIgnoreCase("LONGVARBINARY")) {
                    long length = blob.length();
                    return blob.getBytes(1L, (int)length);
                }
                return blob;
            }
            case 0: 
            case 1: 
            case 2: {
                byte[] valInner = CType2JType.checkVarchar2(val, type, dtype.getPrec());
                return Convertion.getString(valInner, 0, val.length, cvtInfo.getServerEncoding());
            }
            case 19: {
                Clob clob = CType2JType.get_clob_value(val, lobInfo, conn, !desc.isReadOnly());
                if (desc.getTypeName().equalsIgnoreCase("LONGVARCHAR")) {
                    long length = clob.length();
                    return clob.getSubString(1L, (int)length);
                }
                return clob;
            }
            case 20: {
                return new DmdbIntervalYM(val);
            }
            case 21: {
                return Convertion.bytesToInterDT(val, scale);
            }
            case 117: 
            case 122: {
                return CType2JType.getArray_inner(val, dtype.getDType(), desc, conn);
            }
            case 119: 
            case 121: {
                STRUCT struct = CType2JType.getStruct_inner(val, dtype.getDType(), desc, conn);
                if (typeName != null) {
                    return CType2JType.getStruct_SQLData(map, struct, typeName);
                }
                return struct;
            }
        }
        DBError.throwSQLException(6007);
        return null;
    }

    private static Object getComplexObj_from_blob(Blob blob, TypeDescriptor desc) throws SQLException {
        return TypeData.objBlobToObj(blob, desc);
    }

    public static Reader getCharacterStream(byte[] val, CommDesc desc, DmdbConnection_bs conn) throws SQLException {
        CnvtInfo cvtInfo = conn.getCnvtInfo();
        DTypeInfo dtype = desc.getDTypeInfo();
        LobDesc lobInfo = desc.getLobDesc();
        int type = dtype.getDType();
        switch (type) {
            case 17: 
            case 18: {
                return new BufferedReader(new InputStreamReader(new ByteArrayInputStream(val)));
            }
            case 12: {
                Blob blob1 = CType2JType.get_blob_value(val, lobInfo, conn, !desc.isReadOnly());
                if (blob1 == null) {
                    return null;
                }
                return ((DmdbBlob)blob1).getCharacterStream();
            }
            case 19: {
                Clob clob1 = CType2JType.get_clob_value(val, lobInfo, conn, !desc.isReadOnly());
                return clob1.getCharacterStream();
            }
            case 0: 
            case 1: 
            case 2: {
                byte[] valInner = CType2JType.checkVarchar2(val, type, dtype.getPrec());
                String str = Convertion.getString(valInner, 0, val.length, cvtInfo.getServerEncoding());
                return new StringReader(str);
            }
        }
        DBError.throwSQLException(6016);
        return null;
    }

    public static Blob getBlob(byte[] val, CommDesc desc, DmdbConnection_bs conn) throws SQLException {
        int dType = desc.getDTypeInfo().getDType();
        if (dType != 12) {
            DBError.throwSQLException(6016);
        }
        LobDesc lobInfo = desc.getLobDesc();
        return CType2JType.get_blob_value(val, lobInfo, conn, !desc.isReadOnly());
    }

    public static Clob getClob(byte[] val, CommDesc desc, DmdbConnection_bs conn) throws SQLException {
        int dType = desc.getDTypeInfo().getDType();
        if (dType != 19) {
            DBError.throwSQLException(6016);
        }
        LobDesc lobInfo = desc.getLobDesc();
        return CType2JType.get_clob_value(val, lobInfo, conn, !desc.isReadOnly());
    }

    public static DmdbIntervalDT getIntervalDT(byte[] val, CommDesc desc, DmdbConnection_bs conn, boolean isBdta) throws SQLException {
        DTypeInfo dtype = desc.getDTypeInfo();
        int type = dtype.getDType();
        int scale = dtype.getScale();
        switch (type) {
            case 21: {
                return Convertion.bytesToInterDT(val, scale);
            }
        }
        return new DmdbIntervalDT(CType2JType.getString(val, desc, conn, isBdta));
    }

    public static DmdbIntervalYM getIntervalYM(byte[] val, CommDesc desc, DmdbConnection_bs conn, boolean isBdta) throws SQLException {
        DTypeInfo dtype = desc.getDTypeInfo();
        int scale = dtype.getScale();
        int type = dtype.getDType();
        switch (type) {
            case 20: {
                return new DmdbIntervalYM(val);
            }
        }
        return new DmdbIntervalYM(CType2JType.getString(val, desc, conn, isBdta), scale);
    }

    private static Blob get_blob_value(byte[] bs, LobDesc lobInfo, DmdbConnection_bs conn, boolean updatable) throws SQLException {
        DmdbBlob ret = null;
        if (lobInfo != null) {
            ret = new DmdbBlob(bs, lobInfo, conn, updatable);
            if (lobInfo.getLobMode() == 2 && ret != null && !ret.isValueInRow()) {
                int nblob_inrow_hdr_size = ret.nblob_inrow_hdr_size(conn.getNewLobFlag());
                byte[] tmp = ret.getBytesOffRow(1L, ret.getLobLen());
                byte[] value = new byte[nblob_inrow_hdr_size + tmp.length];
                System.arraycopy(ret.m_value, 0, value, 0, nblob_inrow_hdr_size);
                System.arraycopy(tmp, 0, value, nblob_inrow_hdr_size, tmp.length);
                ret.m_value = value;
            }
        } else {
            ret = new DmdbBlob(bs, conn);
        }
        return ret;
    }

    private static Clob get_clob_value(byte[] bs, LobDesc lobInfo, DmdbConnection_bs conn, boolean updatable) throws SQLException {
        DmdbClob ret = null;
        if (lobInfo != null) {
            ret = new DmdbClob(bs, lobInfo, conn, updatable);
            if (lobInfo.getLobMode() == 2 && ret != null && !ret.isValueInRow()) {
                int nblob_inrow_hdr_size = ret.nblob_inrow_hdr_size(conn.getNewLobFlag());
                byte[] tmp = ret.getBytesOffRow(1L, ret.getLobLen());
                byte[] value = new byte[nblob_inrow_hdr_size + tmp.length];
                System.arraycopy(ret.m_value, 0, value, 0, nblob_inrow_hdr_size);
                System.arraycopy(tmp, 0, value, nblob_inrow_hdr_size, tmp.length);
                ret.m_value = value;
            }
        } else {
            ret = new DmdbClob(bs, conn);
        }
        return ret;
    }

    public static byte[] checkVarchar2(byte[] val, int dType, int prec) {
        byte[] retBs = null;
        if (dType == 1) {
            retBs = new byte[prec];
            System.arraycopy(val, 0, retBs, 0, val.length);
            int i = val.length;
            while (i < retBs.length) {
                retBs[i] = 32;
                ++i;
            }
        } else {
            retBs = val;
        }
        return retBs;
    }
}

