/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc3.utils;

import com.sybase.jdbcx.CharsetConverter;
import java.io.CharConversionException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;

public class NioConverter
implements CharsetConverter {
    private String _encoding = null;
    private Charset _charset;
    private CharsetDecoder _decoder;
    private CharsetEncoder _encoder;

    public void setEncoding(String string) throws UnsupportedCharsetException, IllegalCharsetNameException {
        this._encoding = string;
        this._charset = Charset.forName(string);
    }

    public byte[] fromUnicode(String string) throws CharConversionException {
        if (this._encoding == null) {
            return string.getBytes();
        }
        byte[] byArray = null;
        try {
            this._encoder = this._charset.newEncoder();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            ByteBuffer byteBuffer = this._encoder.encode(CharBuffer.wrap(string));
            byArray = new byte[byteBuffer.limit()];
            byteBuffer.get(byArray);
        }
        catch (CharacterCodingException characterCodingException) {
            CharConversionException charConversionException = new CharConversionException(characterCodingException.toString());
            charConversionException.initCause(characterCodingException);
            throw charConversionException;
        }
        catch (IllegalStateException illegalStateException) {
            throw new CharConversionException(illegalStateException.toString());
        }
        return byArray;
    }

    public String toUnicode(byte[] byArray) throws CharConversionException {
        if (this._encoding == null) {
            return new String(byArray);
        }
        String string = null;
        this._decoder = this._charset.newDecoder();
        try {
            string = this._decoder.decode(ByteBuffer.wrap(byArray)).toString();
        }
        catch (CharacterCodingException characterCodingException) {
            CharConversionException charConversionException = new CharConversionException(characterCodingException.toString());
            charConversionException.initCause(characterCodingException);
            throw charConversionException;
        }
        catch (IllegalStateException illegalStateException) {
            throw new CharConversionException(illegalStateException.toString());
        }
        return string;
    }
}

