/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc3.jdbc;

import com.sybase.jdbc3.jdbc.DynamicClassLoader;
import com.sybase.jdbc3.jdbc.ErrorMessage;
import com.sybase.jdbc3.jdbc.LoaderConnection;
import com.sybase.jdbc3.jdbc.Protocol;
import com.sybase.jdbc3.jdbc.SybConnection;
import com.sybase.jdbc3.jdbc.SybDebug;
import com.sybase.jdbc3.jdbc.SybJndiProvider;
import com.sybase.jdbc3.jdbc.SybKey;
import com.sybase.jdbc3.jdbc.SybProperty;
import com.sybase.jdbc3.jdbc.SybUrlManager;
import com.sybase.jdbc3.jdbc.SybUrlProvider;
import com.sybase.jdbcx.Debug;
import com.sybase.jdbcx.SybMessageHandler;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Enumeration;
import java.util.Properties;

public class SybDriver
implements com.sybase.jdbcx.SybDriver {
    protected static final int HIGHEST_JCONNECT_VERSION = 6;
    public static final int DEFAULT_DRIVER_VERSION = 6;
    protected int _version = 6;
    private transient SybMessageHandler _msgHandler;
    static /* synthetic */ Class class$java$sql$DriverManager;

    public SybDriver() {
        this.registerWithDriverManager();
    }

    public final Connection connect(String string, Properties properties) throws SQLException {
        SQLWarning sQLWarning;
        SybProperty sybProperty = new SybProperty(properties, this._version);
        SybUrlManager sybUrlManager = new SybUrlManager(string, properties, sybProperty);
        SybUrlProvider sybUrlProvider = sybUrlManager.getUrlProvider();
        if (sybUrlProvider == null) {
            return null;
        }
        SybConnection sybConnection = new SybConnection(sybUrlProvider, string);
        if (this._msgHandler != null) {
            sybConnection.setSybMessageHandler(this._msgHandler);
        }
        if ((sQLWarning = sybProperty.getWarnings()) != null) {
            sybConnection.handleSQLE(sQLWarning);
        }
        return sybConnection;
    }

    public boolean acceptsURL(String string) throws SQLException {
        SybUrlManager sybUrlManager;
        SybUrlProvider sybUrlProvider;
        int n = string.indexOf(47);
        if (n != -1) {
            string = string.substring(0, n);
        }
        if ((sybUrlProvider = (sybUrlManager = new SybUrlManager(string, null, null)).getUrlProvider()) == null) {
            return false;
        }
        if (sybUrlProvider instanceof SybJndiProvider) {
            return true;
        }
        Protocol protocol = sybUrlProvider.getProtocol();
        return protocol != null;
    }

    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        int n;
        DriverPropertyInfo[] driverPropertyInfoArray = new DriverPropertyInfo[55];
        SybProperty sybProperty = new SybProperty(properties, this._version);
        if (string != null && (n = string.indexOf(63)) > 0 && n++ < string.length()) {
            sybProperty.parsePropertyString(string.substring(n));
        }
        for (n = 0; n < 55; ++n) {
            driverPropertyInfoArray[n] = new DriverPropertyInfo(SybProperty.PROPNAME[n], null == sybProperty._propValue[n] ? null : sybProperty._propValue[n].toString());
            driverPropertyInfoArray[n].required = false;
            driverPropertyInfoArray[n].description = sybProperty.getPropertyDescription(SybProperty.PROPNAME[n]);
        }
        driverPropertyInfoArray[3].required = true;
        driverPropertyInfoArray[4].required = true;
        driverPropertyInfoArray[11].value = "";
        driverPropertyInfoArray[10].value = driverPropertyInfoArray[10].value + "\n\nConfidential property of Sybase, Inc.\nCopyright 1997, 2004\nSybase, Inc.  All rights reserved.\nUnpublished rights reserved under U.S. copyright laws.\nThis software contains confidential and trade secret information of Sybase,\nInc.  Use, duplication or disclosure of the software and documentation by\nthe U.S. Government is subject to restrictions set forth in a license\nagreement between the Government and Sybase, Inc. or other written\nagreement specifying the Government's rights to use the software and any\napplicable FAR provisions, for example, FAR 52.227-19.\n\nSybase, Inc. One Sybase Drive, Dublin, CA 94568\n";
        return driverPropertyInfoArray;
    }

    public int getMajorVersion() {
        return 6;
    }

    public int getMinorVersion() {
        return 0;
    }

    public boolean jdbcCompliant() {
        return false;
    }

    public void setVersion(int n) throws SQLException {
        switch (n) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                this._version = n;
                return;
            }
            case 0: {
                this._version = 6;
                return;
            }
        }
        ErrorMessage.raiseError("JZ0D6", "" + n);
    }

    public final void setKey(SybKey sybKey) throws SQLException {
    }

    public void setSybMessageHandler(SybMessageHandler sybMessageHandler) {
        this._msgHandler = sybMessageHandler;
    }

    public SybMessageHandler getSybMessageHandler() {
        return this._msgHandler;
    }

    public void setMessageHandler(SybMessageHandler sybMessageHandler) {
        this.setSybMessageHandler(sybMessageHandler);
    }

    public SybMessageHandler getMessageHandler() {
        return this.getSybMessageHandler();
    }

    public final Debug getDebug() {
        return new SybDebug();
    }

    public final void setRemotePassword(String string, String string2, Properties properties) {
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = SybProperty.PROPNAME[9];
        String string4 = properties.getProperty(string3);
        if (string4 != null) {
            stringBuffer.append(string4);
        }
        stringBuffer.append(',');
        if (string != null) {
            stringBuffer.append(SybDriver.escapeSpecialCharacters(string));
        }
        stringBuffer.append(',');
        if (string2 != null) {
            stringBuffer.append(SybDriver.escapeSpecialCharacters(string2));
        }
        properties.put(string3, stringBuffer.toString());
    }

    private static StringBuffer escapeSpecialCharacters(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        char c = '\u0000';
        for (int i = 0; i < n; ++i) {
            c = string.charAt(i);
            if (c == '\\' || c == ',') {
                stringBuffer.append('\\');
            }
            stringBuffer.append(c);
        }
        return stringBuffer;
    }

    public com.sybase.jdbcx.DynamicClassLoader getClassLoader(String string, Properties properties) {
        LoaderConnection loaderConnection = new LoaderConnection(this, string, properties);
        DynamicClassLoader dynamicClassLoader = new DynamicClassLoader(loaderConnection);
        return dynamicClassLoader;
    }

    protected final SybConnection connect(String string, SybUrlProvider sybUrlProvider) throws SQLException {
        SQLWarning sQLWarning;
        SybConnection sybConnection = this.createConnection(string, sybUrlProvider);
        if (this._msgHandler != null) {
            sybConnection.setSybMessageHandler(this._msgHandler);
        }
        if ((sQLWarning = sybUrlProvider.getSybProperty().getWarnings()) != null) {
            sybConnection.handleSQLE(sQLWarning);
        }
        return sybConnection;
    }

    protected final Connection connect(SybUrlProvider sybUrlProvider) throws SQLException {
        return this.connect(null, sybUrlProvider);
    }

    protected SybConnection createConnection(String string, SybUrlProvider sybUrlProvider) throws SQLException {
        Protocol protocol;
        SybConnection sybConnection = null;
        if (sybUrlProvider != null && (protocol = sybUrlProvider.getProtocol()) != null) {
            sybConnection = new SybConnection(sybUrlProvider, string);
        }
        return sybConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerWithDriverManager() {
        try {
            Class clazz = class$java$sql$DriverManager == null ? (class$java$sql$DriverManager = SybDriver.class$("java.sql.DriverManager")) : class$java$sql$DriverManager;
            synchronized (clazz) {
                DriverManager.registerDriver(this);
                Enumeration<Driver> enumeration = DriverManager.getDrivers();
                while (enumeration.hasMoreElements()) {
                    Driver driver = enumeration.nextElement();
                    if (!(driver instanceof com.sybase.jdbcx.SybDriver) || driver == this) continue;
                    DriverManager.deregisterDriver(driver);
                }
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        SybDriver sybDriver = new SybDriver();
    }
}

