/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc3.jdbc;

import com.sybase.jdbc3.jdbc.ErrorMessage;
import com.sybase.jdbc3.jdbc.MetaDataAccessor;
import com.sybase.jdbc3.jdbc.ProtocolContext;
import com.sybase.jdbc3.jdbc.SybCallableStatement;
import com.sybase.jdbc3.jdbc.SybConnection;
import com.sybase.jdbc3.jdbc.SybLiteral;
import com.sybase.jdbc3.jdbc.SybPreparedStatement;
import com.sybase.jdbc3.jdbc.SybStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Hashtable;

public class MdaManager {
    protected int _prependDBName;
    public static final int MDA_VERSION_REQUEST = 0;
    public static final int MDA_JDBC_FULL_REQUEST = 1;
    public static final int MDA_JDBC_MINIMAL_REQUEST = 2;
    private static final String FUNCTIONCALL = "FUNCTIONCALL";
    public static final String CONNECTCONFIG = "CONNECTCONFIG";
    public static final String SET_CATALOG = "SET_CATALOG";
    public static final String GET_CATALOG = "GET_CATALOG";
    public static final String COLUMNTYPENAME = "COLUMNTYPENAME";
    public static final String GET_AUTOCOMMIT = "GET_AUTOCOMMIT";
    public static final String SET_AUTOCOMMIT_ON = "SET_AUTOCOMMIT_ON";
    public static final String SET_AUTOCOMMIT_OFF = "SET_AUTOCOMMIT_OFF";
    public static final String BEGIN_TRAN = "BEGIN_TRAN";
    public static final String SET_ISOLATION = "SET_ISOLATION";
    public static final String GET_ISOLATION = "GET_ISOLATION";
    public static final String SET_ROWCOUNT = "SET_ROWCOUNT";
    public static final String GET_READONLY = "GET_READONLY";
    public static final String SET_READONLY_TRUE = "SET_READONLY_TRUE";
    public static final String SET_READONLY_FALSE = "SET_READONLY_FALSE";
    public static final String ISREADONLY = "ISREADONLY";
    public static final String MDAVERSION = "MDAVERSION";
    public static final String PREPEND_DB_NAME = "PREPEND_DB_NAME";
    public static final String MAXLONGVARCHARLENGTH = "MAXLONGVARCHARLENGTH";
    public static final String MAXLONGVARBINARYLENGTH = "MAXLONGVARBINARYLENGTH";
    public static final int BASELINE_VERSION = 0;
    public static final int MDA_VER_COMPLIANT = 4;
    public static final int HIGHEST_VERSION = 7;
    public static final int OUTERJOIN_VERSION = 1;
    public static final String DEFAULT_CHARSET = "DEFAULT_CHARSET";
    private SybConnection _conn;
    private Hashtable _functionMapTable = null;
    private Hashtable _metaDataAccess = null;
    protected int _version;
    protected int _requestedVersion;
    public static final int NOT_SET = -1;
    private int _maxLongvarcharLength = -1;
    private int _maxLongvarbinaryLength = -1;

    MdaManager(SybConnection sybConnection, ProtocolContext protocolContext) throws SQLException {
        this(sybConnection, 7, protocolContext);
    }

    MdaManager(SybConnection sybConnection, int n, ProtocolContext protocolContext) throws SQLException {
        this._conn = sybConnection;
        this._version = 0;
        this._requestedVersion = n;
        this._conn._protocol.getSendLock(protocolContext);
        try {
            this.loadMetaData(protocolContext);
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            try {
                preparedStatement = this.getMetaDataAccessor(MDAVERSION, protocolContext);
                resultSet = preparedStatement.executeQuery();
                resultSet.next();
                this._version = resultSet.getInt(1);
                resultSet.close();
            }
            catch (SQLException sQLException) {
                if ("JZ0F2".equals(sQLException.getSQLState())) {
                    throw sQLException;
                }
                this.checkForConnectTimeoutEx(sQLException);
            }
            try {
                preparedStatement = this.getMetaDataAccessor(PREPEND_DB_NAME, protocolContext);
                resultSet = preparedStatement.executeQuery();
                resultSet.next();
                this._prependDBName = resultSet.getInt(1);
                preparedStatement.close();
            }
            catch (SQLException sQLException) {
                if ("JZ0F2".equals(sQLException.getSQLState())) {
                    throw sQLException;
                }
                this.checkForConnectTimeoutEx(sQLException);
                this._prependDBName = 0;
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        finally {
            this._conn._protocol.freeSendLock(protocolContext);
        }
        if (this._version == 0 || this._requestedVersion >= 4 && this._version < this._requestedVersion) {
            try {
                ErrorMessage.raiseWarning("010SL");
            }
            catch (SQLWarning sQLWarning) {
                this._conn.handleSQLE(sQLWarning);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String getFunctionMap(String string, ProtocolContext protocolContext) throws SQLException {
        Object object;
        if (this._functionMapTable == null) {
            this._functionMapTable = new Hashtable();
            object = null;
            try {
                object = this.getMetaDataAccessor(FUNCTIONCALL, protocolContext);
                ResultSet resultSet = object.executeQuery();
                while (resultSet.next()) {
                    String string2 = resultSet.getString(1).trim();
                    String string3 = resultSet.getString(2).trim();
                    this._functionMapTable.put(string2, string3);
                }
                resultSet.close();
            }
            catch (SQLException sQLException) {
                if ("JZ0F2".equals(sQLException.getSQLState())) {
                    this._functionMapTable = null;
                    throw sQLException;
                }
                ErrorMessage.raiseError("JZ0SH");
            }
            finally {
                if (object != null) {
                    object.close();
                }
            }
        }
        object = (String)this._functionMapTable.get(string);
        return object;
    }

    public PreparedStatement getMetaDataAccessor(String string, ProtocolContext protocolContext) throws SQLException {
        return this.getMetaDataAccessor(string, "", protocolContext);
    }

    public PreparedStatement getMetaDataAccessor(String string, String string2, ProtocolContext protocolContext) throws SQLException {
        return this.getMetaDataAccessor(string, string2, null, protocolContext);
    }

    public PreparedStatement getMetaDataAccessor(String string, String string2, String string3, ProtocolContext protocolContext) throws SQLException {
        MetaDataAccessor metaDataAccessor;
        if (this._metaDataAccess == null) {
            ErrorMessage.raiseError("JZ0SJ");
        }
        if ((metaDataAccessor = (MetaDataAccessor)this._metaDataAccess.get(string)) == null) {
            ErrorMessage.raiseError("JZ0SJ");
        }
        if (metaDataAccessor._queryType == 3) {
            ErrorMessage.raiseWarning("010SK", string);
        }
        PreparedStatement preparedStatement = null;
        switch (metaDataAccessor._queryType) {
            case 1: {
                if (string3 != null && this._prependDBName == 1) {
                    preparedStatement = this._conn.prepareCall("{call " + string3 + ".." + metaDataAccessor._query + "}" + string2);
                    break;
                }
                preparedStatement = this._conn.prepareCall("{call " + metaDataAccessor._query + "}" + string2);
                break;
            }
            case 2: {
                preparedStatement = this._conn.prepareStatement(metaDataAccessor._query + string2, false);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                preparedStatement = new SybLiteral(metaDataAccessor._query, metaDataAccessor._queryType);
                break;
            }
            default: {
                ErrorMessage.raiseError("JZ0SJ");
            }
        }
        if (!(preparedStatement instanceof SybLiteral)) {
            SybStatement sybStatement = (SybStatement)((Object)preparedStatement);
            sybStatement._context.setSponsor(protocolContext);
        }
        return preparedStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadMetaData(ProtocolContext protocolContext) throws SQLException {
        if (this._metaDataAccess == null) {
            this._metaDataAccess = new Hashtable();
        }
        SybStatement sybStatement = null;
        try {
            ResultSet resultSet;
            long l = 0L;
            sybStatement = (SybCallableStatement)this._conn.prepareCall("{call sp_mda(?,?)}");
            if (this._conn.okToThrowLoginTimeoutException()) {
                l = this._conn.getLoginTimeRemaining();
                if (l > 0L) {
                    l = l / 1000L + 1L;
                    sybStatement.setQueryTimeout((int)l);
                } else if (l < 0L) {
                    ErrorMessage.raiseError("JZ00M");
                }
            }
            ((SybCallableStatement)sybStatement)._context.setSponsor(protocolContext);
            ((SybPreparedStatement)sybStatement).setInt(1, 1);
            ((SybPreparedStatement)sybStatement).setInt(2, this._requestedVersion);
            try {
                resultSet = ((SybCallableStatement)sybStatement).executeQuery();
            }
            catch (SQLException sQLException) {
                if ("JZ0F2".equals(sQLException.getSQLState())) {
                    throw sQLException;
                }
                this.checkForConnectTimeoutEx(sQLException);
                if (sybStatement != null) {
                    sybStatement.close();
                }
                sybStatement = (SybCallableStatement)this._conn.prepareCall("{call dba.sp_mda(?,?)}");
                if (l > 0L) {
                    l = l / 1000L + 1L;
                    sybStatement.setQueryTimeout((int)l);
                }
                ((SybCallableStatement)sybStatement)._context.setSponsor(protocolContext);
                ((SybPreparedStatement)sybStatement).setInt(1, 1);
                ((SybPreparedStatement)sybStatement).setInt(2, this._requestedVersion);
                resultSet = ((SybCallableStatement)sybStatement).executeQuery();
            }
            while (resultSet.next()) {
                String string = resultSet.getString(1).trim();
                int n = resultSet.getInt(2);
                String string2 = resultSet.getString(3);
                MetaDataAccessor metaDataAccessor = new MetaDataAccessor(n, string2);
                this._metaDataAccess.put(string, metaDataAccessor);
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            if ("JZ0F2".equals(sQLException.getSQLState())) {
                throw sQLException;
            }
            this.checkForConnectTimeoutEx(sQLException);
            ErrorMessage.raiseError("JZ0SJ");
        }
        finally {
            if (sybStatement != null) {
                sybStatement.close();
            }
        }
    }

    private void checkForConnectTimeoutEx(SQLException sQLException) throws SQLException {
        if (!this._conn.okToThrowLoginTimeoutException()) {
            return;
        }
        for (SQLException sQLException2 = sQLException; sQLException2 != null; sQLException2 = sQLException2.getNextException()) {
            if (!"JZ00M".equals(sQLException2.getSQLState())) continue;
            throw sQLException;
        }
    }

    public int getMaxLongvarcharLength(ProtocolContext protocolContext) throws SQLException {
        block3: {
            if (this._maxLongvarcharLength == -1) {
                this._maxLongvarcharLength = Integer.MAX_VALUE;
                try {
                    PreparedStatement preparedStatement = this.getMetaDataAccessor(MAXLONGVARCHARLENGTH, protocolContext);
                    ResultSet resultSet = null;
                    resultSet = preparedStatement.executeQuery();
                    resultSet.next();
                    this._maxLongvarcharLength = resultSet.getInt(1);
                    preparedStatement.close();
                }
                catch (SQLException sQLException) {
                    if ("JZ0SJ".equals(sQLException.getSQLState())) break block3;
                    throw sQLException;
                }
            }
        }
        return this._maxLongvarcharLength;
    }

    public int getMaxLongvarbinaryLength(ProtocolContext protocolContext) throws SQLException {
        block3: {
            if (this._maxLongvarbinaryLength == -1) {
                this._maxLongvarbinaryLength = Integer.MAX_VALUE;
                try {
                    PreparedStatement preparedStatement = this.getMetaDataAccessor(MAXLONGVARBINARYLENGTH, protocolContext);
                    ResultSet resultSet = null;
                    resultSet = preparedStatement.executeQuery();
                    resultSet.next();
                    this._maxLongvarbinaryLength = resultSet.getInt(1);
                    preparedStatement.close();
                }
                catch (SQLException sQLException) {
                    if ("JZ0SJ".equals(sQLException.getSQLState())) break block3;
                    throw sQLException;
                }
            }
        }
        return this._maxLongvarbinaryLength;
    }
}

