package com.lkx;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.lkx.util.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

import com.lkx.model.PhoneModel;

/**
 * @author likaixuan
 */
@Controller
public class TestController {
	
	@GetMapping(value = "/")
	public String ss1(){
		return "index";
	}
	
	@PostMapping(value = "/test")
	@ResponseBody
	public static List<PhoneModel> testImport(MultipartFile file) throws Exception{

		List<PhoneModel> list = ExcelUtil.readXls(file.getBytes(), PhoneModel.class);
		return list;
	}

	/**
	 * 注解测试
	 * @param file
	 * @return
	 * @throws Exception
	 */
	@PostMapping(value = "/test2")
	@ResponseBody
	public List<PhoneModel> testImport2() throws Exception{
		List<PhoneModel> list = ExcelUtil.readXls("D://test.xlsx", PhoneModel.class);

		return list;
	}


	/**
	 * 注解测试
	 * @param file
	 * @return
	 * @throws Exception
	 */
	@PostMapping(value = "/test1")
	@ResponseBody
	public List<PhoneModel> testImport1(MultipartFile file) throws Exception{
		List<PhoneModel> list = ExcelUtil.readXls(file.getBytes(), PhoneModel.class);

		return list;
	}

	@GetMapping(value = "/export")
	public void testExport(HttpServletResponse response) throws Exception{
		 
		List<PhoneModel> list = new ArrayList<>();
		for(int i=0;i<10;i++){
			PhoneModel model = new PhoneModel();
			model.setNum((i+1));
			model.setColor("金色"+i);
			model.setPhoneName("苹果"+i+"S");
			model.setPrice(i);
			model.setSj(new Date());
			list.add(model);
		}
		ExcelUtil.exportExcelOutputStream(response,list,PhoneModel.class,"");
		ExcelUtil.exportExcelOutputStream(response,list,PhoneModel.class,"测试Excel导出","素剑步青尘");

	}

	@GetMapping(value = "/exportSheet")
	public void testExportSheet(HttpServletResponse response2) throws Exception{


		List<PhoneModel> list = new ArrayList<>();
		for(int i=0;i<10;i++){
			PhoneModel model = new PhoneModel();
			model.setNum((i+1));
			model.setColor("金色"+i);
			model.setPhoneName("苹果"+i+"S");
			model.setPrice(i);
			model.setSj(new Date());
			list.add(model);
		}

		List<PhoneModel> list2 = new ArrayList<>();
		for(int i=0;i<20;i++){
			PhoneModel model = new PhoneModel();
			model.setNum((i+1));
			model.setColor("金色d "+i);
			model.setPhoneName("苹果d "+i+"S");
			model.setPrice(i);
			model.setSj(new Date());
			list2.add(model);
		}


		ExcelParam excelParam = new ExcelParam();
		excelParam.setSheetName("hello1");
		excelParam.setClazz(PhoneModel.class);
		excelParam.setList(list);
		excelParam.setWaterMark("hello1");

		ExcelParam excelParam1 = new ExcelParam();
		excelParam1.setSheetName("口苦扣扣");
		excelParam1.setClazz(PhoneModel.class);
		excelParam1.setList(list2);
		excelParam1.setWaterMark("口苦扣扣");

		ExcelParamAbstract excelParamAbstract = new ExcelParamAbstract() {
			@Override
			public List<ExcelParam> getList() {

				List<ExcelParam> excelParamList = new ArrayList<>();
				excelParamList.add(excelParam);
				excelParamList.add(excelParam1);
				return excelParamList;
			}

			@Override
			public HttpServletResponse getResponse() {
				return 	response2;
			}
		};
		ExcelUtil.exportExcelOutputStream(excelParamAbstract);
	}

	/**
	 * 导出带表头
	 */
	@GetMapping(value = "/exportHeader")
	public void testExportHeader(HttpServletResponse response) throws Exception{

		List<PhoneModel> list = new ArrayList<>();
		for(int i=0;i<10;i++){
			PhoneModel model = new PhoneModel();
			model.setColor("金色"+i);
			model.setPhoneName("苹果"+i+"S");
			model.setPrice(i);
			model.setSj(new Date());
			list.add(model);
		}
		ExcelUtil.exportExcelOutputStream(response,list,PhoneModel.class,"导出标题多萨法撒旦法带表头",true);

		ExcelParam excelParam = new ExcelParam();
		excelParam.setWaterMark("水印文字");
		excelParam.setRowNumIndex(2);//从表头的第二行开始读取
		excelParam.setHeaderName("要设置的表头文字");

		//读取
		ExcelUtilBase.getResult(excelParam);
		//导出
		ExcelUtilBase.commonExportExcel(excelParam);

	}

	/**
	 * 模版导出
	 */
	@GetMapping(value = "/exportTemplate")
	public void exportTemplate(HttpServletResponse response){
		PhoneModel model = new PhoneModel();
		model.setColor("金色");
		model.setPhoneName("苹果12 S");
		model.setPrice(9999);
		model.setSj(new Date());
		ExcelUtil.templateWrite(response,"E:\\新建XLSX 工作表.xlsx",model,"ce测试时");
	}
	
	@GetMapping(value = "/json")
	@ResponseBody
	public BizResult<PhoneModel> ss(){
		
		List<PhoneModel> list = new ArrayList<>();
		
		
		PhoneModel model = new PhoneModel();
		model.setColor("土豪金");
		model.setPhoneName("ipone X");
		model.setSj(new Date());
		
		list.add(model);
		
		BizResult<PhoneModel> result = new BizResult<>();
		result.setCode("0");
		result.setData(model);
		result.setList(list);
		
		return result;
	}


//		@RequestMapping("index")
//		public String index(HttpServletRequest request, HttpServletResponse response) {
//
//			/**
//			 * context 为以html样式导出到word文档里
//			 */
//			String context = ExportUtil.txt2String(new File("E:\\143.txt"));
//			ExportUtil.write(context);
//			/**
//			 * 创建工具类实例
//			 */
//			ExportUtil exportUtil = new ExportUtil();
//
//			/**
//			 * 调用~~~ 导出word成功
//			 */
//			exportUtil.exportWord(request, response, context);
//
//			return "index";
//		}
	
}
