"""
Django settings for melting_potlist project.

Generated by 'django-admin startproject' using Django 3.0.1.

For more information on this file, see
https://docs.djangoproject.com/en/3.0/topics/settings/

For the full list of settings and their values, see
https://docs.djangoproject.com/en/3.0/ref/settings/
"""

import os
from datetime import timedelta

import django_yamlconf
from pathlib import Path
from django.utils.log import DEFAULT_LOGGING

# Build paths inside the project like this: BASE_DIR / "..."
BASE_DIR = Path(os.path.dirname(os.path.dirname(os.path.abspath(__file__))))

# Quick-start development settings - unsuitable for production
# See https://docs.djangoproject.com/en/3.0/howto/deployment/checklist/

# SECURITY WARNING: don't run with debug turned on in production!
DEBUG = False
# Enables fake login without Discord OAuth, don't turn on in production either!
ENABLE_FAKE_LOGIN = False

ALLOWED_HOSTS = []

# Application definition

INSTALLED_APPS = [
    "channels",
    "whitenoise.runserver_nostatic",
    "django.contrib.admin",
    "django.contrib.auth",
    "django.contrib.contenttypes",
    "django.contrib.sessions",
    "django.contrib.messages",
    "django.contrib.staticfiles",
    "django.contrib.humanize",
    "django_yamlconf",
    "rest_framework",
    "widget_tweaks",
    "django_vite",
    "django_user_agents",
    "apps.core",
    "apps.discord_login",
    "apps.user_profile",
    "apps.api",
    "apps.websocket_sync",
]

MIDDLEWARE = [
    "django.middleware.security.SecurityMiddleware",
    "whitenoise.middleware.WhiteNoiseMiddleware",
    "django.contrib.sessions.middleware.SessionMiddleware",
    "django.middleware.common.CommonMiddleware",
    "django.middleware.csrf.CsrfViewMiddleware",
    "django.contrib.auth.middleware.AuthenticationMiddleware",
    "django.contrib.messages.middleware.MessageMiddleware",
    "django.middleware.clickjacking.XFrameOptionsMiddleware",
    "django_user_agents.middleware.UserAgentMiddleware",
    "apps.core.middlewares.ExtendUserSession",
]

ROOT_URLCONF = "melting_potlist.urls"

TEMPLATES = [
    {
        "BACKEND": "django.template.backends.django.DjangoTemplates",
        "DIRS": [],
        "APP_DIRS": True,
        "OPTIONS": {
            "context_processors": [
                "django.template.context_processors.debug",
                "django.template.context_processors.request",
                "django.contrib.auth.context_processors.auth",
                "django.contrib.messages.context_processors.messages",
                "apps.core.context_processors.discord_user",
            ],
        },
    },
]

ASGI_APPLICATION = "melting_potlist.asgi.application"

# Channel Layers
# https://channels.readthedocs.io/en/stable/topics/channel_layers.html
CHANNEL_LAYERS = {"default": {"BACKEND": "channels.layers.InMemoryChannelLayer"}}

# Database
# https://docs.djangoproject.com/en/3.0/ref/settings/#databases

DATABASES = {
    "default": {
        "ENGINE": "django.db.backends.sqlite3",
        "NAME": os.path.join(BASE_DIR, "db.sqlite3"),
    }
}

# https://docs.djangoproject.com/fr/2.2/topics/cache/
CACHES = {"default": {"BACKEND": "django.core.cache.backends.locmem.LocMemCache"}}
USER_AGENTS_CACHE = "default"

# Password validation
# https://docs.djangoproject.com/en/3.0/ref/settings/#auth-password-validators

AUTH_PASSWORD_VALIDATORS = [
    {
        "NAME": "django.contrib.auth.password_validation.UserAttributeSimilarityValidator",
    },
    {
        "NAME": "django.contrib.auth.password_validation.MinimumLengthValidator",
    },
    {
        "NAME": "django.contrib.auth.password_validation.CommonPasswordValidator",
    },
    {
        "NAME": "django.contrib.auth.password_validation.NumericPasswordValidator",
    },
]

# Django Rest Framework
REST_FRAMEWORK = {
    "DEFAULT_AUTHENTICATION_CLASSES": [
        "rest_framework.authentication.SessionAuthentication",
    ],
    "DEFAULT_PERMISSION_CLASSES": [
        "rest_framework.permissions.IsAuthenticated",
    ],
}

# Internationalization
# https://docs.djangoproject.com/en/3.0/topics/i18n/

LANGUAGE_CODE = "en-us"

TIME_ZONE = "UTC"

USE_I18N = True

USE_L10N = True

USE_TZ = True

# Static files (CSS, JavaScript, Images)
# https://docs.djangoproject.com/en/3.0/howto/static-files/

STATICFILES_STORAGE = "whitenoise.storage.CompressedManifestStaticFilesStorage"

STATIC_URL = "/content/"

DJANGO_VITE_ASSETS_PATH = BASE_DIR / "vue_components" / "dist"

STATICFILES_DIRS = [
    BASE_DIR / "static",
    DJANGO_VITE_ASSETS_PATH,
]

STATIC_ROOT = BASE_DIR / "staticfiles"

WEBPACK_LOADER = {
    "DEFAULT": {
        "CACHE": DEBUG,
        "BUNDLE_DIR_NAME": "/bundles/",
        "STATS_FILE": os.path.join(BASE_DIR, "vue_components", "webpack-stats.json"),
    }
}

AUTHENTICATION_BACKENDS = [
    "apps.discord_login.backends.DiscordBackend",
]

LOGIN_REDIRECT_URL = "/"
LOGOUT_REDIRECT_URL = "/"
LOGIN_URL = "/discord/login"

SESSION_COOKIE_AGE = timedelta(days=120).total_seconds()

# Send error logs trough emails (with overrideable default config)
EMAIL_BACKEND = "django.core.mail.backends.smtp.EmailBackend"
EMAIL_USE_TLS: True
EMAIL_USE_SSL: False
LOGGING = DEFAULT_LOGGING

VERSION = "2.0.1"

# Allows token scope to not match requested scope
os.environ.setdefault("OAUTHLIB_RELAX_TOKEN_SCOPE", "1")

django_yamlconf.load()
