# Generated by Django 3.2.6 on 2021-11-23 22:32

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone


class Migration(migrations.Migration):
    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("discord_login", "0001_initial"),
        ("user_profile", "0005_alter_ids_to_big_auto_field"),
    ]

    operations = [
        migrations.CreateModel(
            name="DynamicPlaylist",
            fields=[
                ("id", models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("date_generated", models.DateTimeField(default=django.utils.timezone.now)),
                ("title", models.TextField(default="Unnamed dynamic playlist")),
                ("groups", models.ManyToManyField(related_name="dynamic_playlists", to="discord_login.DiscordGuild")),
            ],
        ),
        migrations.CreateModel(
            name="UserTrackListenStats",
            fields=[
                ("id", models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("date_last_listened", models.DateTimeField(default=django.utils.timezone.now)),
                ("listen_count", models.IntegerField(default=1)),
                (
                    "listener",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="user_track_listen_stats",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "user_track",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="user_track_listen_stats",
                        to="user_profile.usertrack",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="DynamicPlaylistUser",
            fields=[
                ("id", models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("is_author", models.BooleanField(default=False)),
                ("is_active", models.BooleanField(default=True)),
                ("played_in_rotation", models.BooleanField(default=False)),
                (
                    "dynamic_playlist",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="dynamic_playlist_users",
                        to="user_profile.dynamicplaylist",
                    ),
                ),
                ("user", models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name="DynamicPlaylistTrack",
            fields=[
                ("id", models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("played", models.DateTimeField(default=django.utils.timezone.now)),
                (
                    "dynamic_playlist",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="dynamic_playlist_tracks",
                        to="user_profile.dynamicplaylist",
                    ),
                ),
                ("track", models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to="user_profile.usertrack")),
            ],
        ),
        migrations.AddField(
            model_name="dynamicplaylist",
            name="tracks",
            field=models.ManyToManyField(
                related_name="dynamic_playlists",
                through="user_profile.DynamicPlaylistTrack",
                to="user_profile.UserTrack",
            ),
        ),
        migrations.AddField(
            model_name="dynamicplaylist",
            name="users",
            field=models.ManyToManyField(
                related_name="dynamic_playlists",
                through="user_profile.DynamicPlaylistUser",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name="usertrack",
            name="listeners",
            field=models.ManyToManyField(
                related_name="listened_tracks", through="user_profile.UserTrackListenStats", to=settings.AUTH_USER_MODEL
            ),
        ),
        migrations.AddConstraint(
            model_name="usertracklistenstats",
            constraint=models.UniqueConstraint(fields=("user_track", "listener"), name="unique_user_track_listener"),
        ),
        migrations.AddConstraint(
            model_name="dynamicplaylistuser",
            constraint=models.UniqueConstraint(
                fields=("user", "dynamic_playlist"), name="unique_user_dynamic_playlist"
            ),
        ),
    ]
