namespace cpp cc.service.plugin

service PluginService
{
  /**
   * Returns a list of active plugins which are loaded from shared object
   */
  list<string> getPlugins()

  /**
   * Returns a list of generated Thrift javascript plugins from install web directory
   *
   * These JS files are generated by Thrift and NOT defined as Dojo modules.
   * Therefore they cannot be bundled into layers by the Dojo Build System and must be loaded separately.
   */
  list<string> getThriftPlugins()

  /**
   * Returns a list of custom javascript plugins from install web directory
   *
   * These JS files are defined as Dojo modules and can be bundled into layers by the Dojo Build System.
   */
  list<string> getWebPlugins()
  
  /**
   * Returns a list of css plugins from install web directory
   */
  list<string> getWebStylePlugins()
}
