/*
 * Decompiled with CFR 0.152.
 */
package com.j256.simplemagic.types;

import com.j256.simplemagic.entries.MagicFormatter;
import com.j256.simplemagic.entries.MagicMatcher;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringType
implements MagicMatcher {
    private static final Pattern TYPE_PATTERN = Pattern.compile("[^/]+(/\\d+)?(/[BbcwWt]*)?");
    private static final String EMPTY = "";

    public Object convertTestString(String typeStr, String testStr) {
        Matcher matcher = TYPE_PATTERN.matcher(typeStr);
        if (!matcher.matches()) {
            return new TestInfo(this.preProcessPattern(testStr), false, false, false, 0);
        }
        int maxOffset = 0;
        String lengthStr = matcher.group(1);
        if (lengthStr != null && lengthStr.length() > 1) {
            try {
                maxOffset = Integer.decode(lengthStr.substring(1));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid format for search length: " + testStr);
            }
        }
        boolean compactWhiteSpace = false;
        boolean optionalWhiteSpace = false;
        boolean caseInsensitive = false;
        String flagsStr = matcher.group(2);
        if (flagsStr != null) {
            block7: for (char ch : flagsStr.toCharArray()) {
                switch (ch) {
                    case 'B': {
                        compactWhiteSpace = true;
                        continue block7;
                    }
                    case 'b': {
                        optionalWhiteSpace = true;
                        continue block7;
                    }
                    case 'c': {
                        caseInsensitive = true;
                        continue block7;
                    }
                }
            }
        }
        String processedPattern = this.preProcessPattern(testStr);
        return new TestInfo(processedPattern, compactWhiteSpace, optionalWhiteSpace, caseInsensitive, maxOffset);
    }

    public Object extractValueFromBytes(int offset, byte[] bytes) {
        return EMPTY;
    }

    public Object isMatch(Object testValue, Long andValue, boolean unsignedType, Object extractedValue, MagicMatcher.MutableOffset mutableOffset, byte[] bytes) {
        return this.findOffsetMatch((TestInfo)testValue, mutableOffset.offset, mutableOffset, bytes);
    }

    public void renderValue(StringBuilder sb, Object extractedValue, MagicFormatter formatter) {
        formatter.format(sb, extractedValue);
    }

    public byte[] getStartingBytes(Object testValue) {
        return ((TestInfo)testValue).getStartingBytes();
    }

    protected String findOffsetMatch(TestInfo info, int offset, MagicMatcher.MutableOffset mutableOffset, byte[] bytes) {
        int targetPos = offset;
        boolean lastMagicCompactWhitespace = false;
        for (int magicPos = 0; magicPos < info.pattern.length(); ++magicPos) {
            char magicCh = info.pattern.charAt(magicPos);
            if (targetPos >= bytes.length) {
                return null;
            }
            char targetCh = (char)(bytes[targetPos] & 0xFF);
            ++targetPos;
            if (magicCh == targetCh) {
                if (!info.compactWhiteSpace) continue;
                lastMagicCompactWhitespace = Character.isWhitespace(magicCh);
                continue;
            }
            if ((lastMagicCompactWhitespace || info.optionalWhiteSpace) && Character.isWhitespace(targetCh)) {
                while (targetPos < bytes.length) {
                    targetCh = (char)(bytes[targetPos] & 0xFF);
                    ++targetPos;
                    if (Character.isWhitespace(targetCh)) continue;
                }
                if (magicCh == targetCh) {
                    if (!info.compactWhiteSpace) continue;
                    lastMagicCompactWhitespace = Character.isWhitespace(magicCh);
                    continue;
                }
            }
            if (info.caseInsensitive && Character.isLowerCase(magicCh) && magicCh == Character.toLowerCase(targetCh)) continue;
            return null;
        }
        char[] chars = new char[targetPos - offset];
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = (char)(bytes[offset + i] & 0xFF);
        }
        mutableOffset.offset = targetPos;
        return new String(chars);
    }

    private String preProcessPattern(String pattern) {
        int index = pattern.indexOf(92);
        if (index < 0) {
            return pattern;
        }
        StringBuilder sb = new StringBuilder();
        block9: for (int pos = 0; pos < pattern.length(); ++pos) {
            char ch = pattern.charAt(pos);
            if (ch != '\\') {
                sb.append(ch);
                continue;
            }
            if (pos + 1 >= pattern.length()) {
                sb.append(ch);
                break;
            }
            ch = pattern.charAt(++pos);
            switch (ch) {
                case 'b': {
                    sb.append('\b');
                    continue block9;
                }
                case 'f': {
                    sb.append('\f');
                    continue block9;
                }
                case 'n': {
                    sb.append('\n');
                    continue block9;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': {
                    int len = 3;
                    if (pos + len <= pattern.length()) {
                        int octal = this.radixCharsToChar(pattern, pos, len, 8);
                        if (octal < 0) continue block9;
                        sb.append((char)octal);
                        pos += len - 1;
                        continue block9;
                    }
                    if (ch == '0') {
                        sb.append('\u0000');
                        continue block9;
                    }
                    sb.append(ch);
                    continue block9;
                }
                case 'r': {
                    sb.append('\r');
                    continue block9;
                }
                case 't': {
                    sb.append('\t');
                    continue block9;
                }
                case 'x': {
                    int len = 2;
                    if (pos + len < pattern.length()) {
                        int hex = this.radixCharsToChar(pattern, pos + 1, len, 16);
                        if (hex < 0) continue block9;
                        sb.append((char)hex);
                        pos += len;
                        continue block9;
                    }
                    sb.append(ch);
                    continue block9;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    private int radixCharsToChar(String pattern, int pos, int len, int radix) {
        if (pos + len > pattern.length()) {
            return -1;
        }
        int val = 0;
        for (int i = 0; i < len; ++i) {
            int digit = Character.digit(pattern.charAt(pos + i), radix);
            if (digit < 0) {
                return -1;
            }
            val = val * radix + digit;
        }
        return val;
    }

    protected static class TestInfo {
        final String pattern;
        final boolean compactWhiteSpace;
        final boolean optionalWhiteSpace;
        final boolean caseInsensitive;
        final int maxOffset;

        public TestInfo(String pattern, boolean compactWhiteSpace, boolean optionalWhiteSpace, boolean caseInsensitive, int maxOffset) {
            this.pattern = pattern;
            this.compactWhiteSpace = compactWhiteSpace;
            this.optionalWhiteSpace = optionalWhiteSpace;
            this.caseInsensitive = caseInsensitive;
            this.maxOffset = maxOffset;
        }

        public byte[] getStartingBytes() {
            if (this.pattern.length() < 4) {
                return null;
            }
            return new byte[]{(byte)this.pattern.charAt(0), (byte)this.pattern.charAt(1), (byte)this.pattern.charAt(2), (byte)this.pattern.charAt(3)};
        }

        public String toString() {
            return this.pattern;
        }
    }
}

