/*
 * Decompiled with CFR 0.152.
 */
package com.j256.simplemagic.types;

import com.j256.simplemagic.entries.MagicFormatter;
import com.j256.simplemagic.entries.MagicMatcher;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexType
implements MagicMatcher {
    private static final Pattern TYPE_PATTERN = Pattern.compile("[^/]+(/[cs]*)?");
    private static final String EMPTY = "";

    public Object convertTestString(String typeStr, String testStr) {
        String flagsStr;
        Matcher matcher = TYPE_PATTERN.matcher(typeStr);
        PatternInfo patternInfo = new PatternInfo();
        if (matcher.matches() && (flagsStr = matcher.group(1)) != null && flagsStr.length() > 1) {
            for (char ch : flagsStr.toCharArray()) {
                if (ch == 'c') {
                    patternInfo.patternFlags |= 2;
                    continue;
                }
                if (ch != 's') continue;
                patternInfo.updateOffsetStart = true;
            }
        }
        patternInfo.pattern = Pattern.compile(".*(" + testStr + ").*", patternInfo.patternFlags);
        return patternInfo;
    }

    public Object extractValueFromBytes(int offset, byte[] bytes) {
        return EMPTY;
    }

    public Object isMatch(Object testValue, Long andValue, boolean unsignedType, Object extractedValue, MagicMatcher.MutableOffset mutableOffset, byte[] bytes) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(bytes)));
        String line = null;
        int bytesOffset = 0;
        for (int i = 0; i <= mutableOffset.offset; ++i) {
            try {
                line = reader.readLine();
                if (line == null) {
                    return null;
                }
                if (i >= mutableOffset.offset) continue;
                bytesOffset += line.length() + 1;
                continue;
            }
            catch (IOException e) {
                return null;
            }
        }
        if (line == null) {
            return null;
        }
        PatternInfo patternInfo = (PatternInfo)testValue;
        Matcher matcher = patternInfo.pattern.matcher(line);
        if (matcher.matches()) {
            mutableOffset.offset = bytesOffset + matcher.end(1);
            return matcher.group(1);
        }
        return null;
    }

    public void renderValue(StringBuilder sb, Object extractedValue, MagicFormatter formatter) {
        formatter.format(sb, extractedValue);
    }

    public byte[] getStartingBytes(Object testValue) {
        return null;
    }

    private static class PatternInfo {
        int patternFlags;
        boolean updateOffsetStart;
        Pattern pattern;

        private PatternInfo() {
        }
    }
}

