/*
 * Decompiled with CFR 0.152.
 */
package com.j256.simplemagic.types;

import com.j256.simplemagic.endian.EndianType;
import com.j256.simplemagic.entries.MagicFormatter;
import com.j256.simplemagic.types.IntegerType;
import java.text.SimpleDateFormat;
import java.util.Date;

public class LocalDateType
extends IntegerType {
    protected final ThreadLocal<SimpleDateFormat> dateFormat = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
        }
    };

    public LocalDateType(EndianType endianType) {
        super(endianType);
    }

    public void renderValue(StringBuilder sb, Object extractedValue, MagicFormatter formatter) {
        long val = (Long)extractedValue;
        Date date = this.dateFromExtractedValue(val);
        SimpleDateFormat format = this.dateFormat.get();
        this.assisgnTimeZone(format);
        formatter.format(sb, format.format(date));
    }

    protected Date dateFromExtractedValue(long val) {
        return new Date(val *= 1000L);
    }

    protected void assisgnTimeZone(SimpleDateFormat format) {
    }
}

