/*
 * Decompiled with CFR 0.152.
 */
package com.j256.simplemagic.entries;

public class NumberOperator {
    final TestOperator operator;
    final long value;

    public NumberOperator(String test) {
        TestOperator op = TestOperator.fromTest(test);
        if (op == null) {
            op = TestOperator.DEFAULT_OPERATOR;
        } else {
            test = test.substring(1);
        }
        this.operator = op;
        try {
            this.value = Long.decode(test);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Could not parse long from: '" + test + "'");
        }
    }

    public NumberOperator(TestOperator operator, long value) {
        this.operator = operator;
        this.value = value;
    }

    public boolean isMatch(Long andValue, boolean unsignedType, long extractedValue) {
        if (andValue != null) {
            extractedValue &= andValue.longValue();
        }
        return this.operator.doTest(extractedValue, this.value);
    }

    public long getValue() {
        return this.value;
    }

    public String toString() {
        return (Object)((Object)this.operator) + ", value " + this.value;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TestOperator {
        EQUALS('='){

            public boolean doTest(long extractedValue, long testValue) {
                return extractedValue == testValue;
            }
        }
        ,
        NOT_EQUALS('!'){

            public boolean doTest(long extractedValue, long testValue) {
                return extractedValue != testValue;
            }
        }
        ,
        GREATER_THAN('>'){

            public boolean doTest(long extractedValue, long testValue) {
                return extractedValue > testValue;
            }
        }
        ,
        LESS_THAN('<'){

            public boolean doTest(long extractedValue, long testValue) {
                return extractedValue < testValue;
            }
        }
        ,
        AND_ALL_SET('&'){

            public boolean doTest(long extractedValue, long testValue) {
                return (extractedValue & testValue) == testValue;
            }
        }
        ,
        AND_ALL_CLEARED('^'){

            public boolean doTest(long extractedValue, long testValue) {
                return (extractedValue & testValue) == 0L;
            }
        }
        ,
        NEGATE('~'){

            public boolean doTest(long extractedValue, long testValue) {
                return false;
            }
        };

        public static final TestOperator DEFAULT_OPERATOR;
        private final char prefixChar;

        private TestOperator(char prefixChar) {
            this.prefixChar = prefixChar;
        }

        public abstract boolean doTest(long var1, long var3);

        public static TestOperator fromTest(String testStr) {
            if (testStr.length() == 0) {
                return null;
            }
            char first = testStr.charAt(0);
            for (TestOperator operator : TestOperator.values()) {
                if (operator.prefixChar != first) continue;
                return operator;
            }
            return null;
        }

        static {
            DEFAULT_OPERATOR = EQUALS;
        }
    }
}

