/*
 * Decompiled with CFR 0.152.
 */
package com.j256.simplemagic.endian;

import com.j256.simplemagic.endian.EndianConverter;

public class BigEndianConverter
implements EndianConverter {
    BigEndianConverter() {
    }

    public Long convertNumber(int offset, byte[] bytes, int size) {
        return this.convertNumber(offset, bytes, size, 8, 255);
    }

    public Long convertId3(int offset, byte[] bytes, int size) {
        return this.convertNumber(offset, bytes, size, 7, 127);
    }

    public byte[] convertToByteArray(long value, int size) {
        byte[] result = new byte[size];
        for (int i = size - 1; i >= 0; --i) {
            result[i] = (byte)(value & 0xFFL);
            value >>= 8;
        }
        return result;
    }

    private Long convertNumber(int offset, byte[] bytes, int size, int shift, int mask) {
        if (offset + size > bytes.length) {
            return null;
        }
        long value = 0L;
        for (int i = offset; i < offset + size; ++i) {
            value = value << shift | (long)(bytes[i] & mask);
        }
        return value;
    }
}

