/*
 * Decompiled with CFR 0.152.
 */
package no.uio.ifi.asp.scanner;

import java.util.EnumSet;
import no.uio.ifi.asp.scanner.TokenKind;

public class Token {
    public TokenKind kind;
    public String name;
    public String stringLit;
    public long integerLit;
    public double floatLit;
    public int lineNum;

    Token(TokenKind k) {
        this(k, 0);
    }

    Token(TokenKind k, int lNum) {
        this.kind = k;
        this.lineNum = lNum;
    }

    void checkResWords() {
        if (this.kind != TokenKind.nameToken) {
            return;
        }
        for (TokenKind tk : EnumSet.range(TokenKind.andToken, TokenKind.yieldToken)) {
            if (!this.name.equals(tk.image)) continue;
            this.kind = tk;
            break;
        }
    }

    public String showInfo() {
        String t = (Object)((Object)this.kind) + " token";
        if (this.lineNum > 0) {
            t = t + " on line " + this.lineNum;
        }
        switch (this.kind) {
            case floatToken: {
                t = t + ": " + this.floatLit;
                break;
            }
            case integerToken: {
                t = t + ": " + this.integerLit;
                break;
            }
            case nameToken: {
                t = t + ": " + this.name;
                break;
            }
            case stringToken: {
                t = this.stringLit.indexOf(34) >= 0 ? t + ": '" + this.stringLit + "'" : t + ": \"" + this.stringLit + '\"';
            }
        }
        return t;
    }

    public String toString() {
        return this.kind.toString();
    }
}

