/*
 * Decompiled with CFR 0.152.
 */
package no.uio.ifi.asp.scanner;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Stack;
import no.uio.ifi.asp.main.Main;
import no.uio.ifi.asp.scanner.Token;
import no.uio.ifi.asp.scanner.TokenKind;

public class Scanner {
    private LineNumberReader sourceFile = null;
    private String curFileName;
    private ArrayList<Token> curLineTokens = new ArrayList();
    private Stack<Integer> indents = new Stack();
    private final int TABDIST = 4;

    public Scanner(String fileName) {
        this.curFileName = fileName;
        this.indents.push(0);
        try {
            this.sourceFile = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(fileName), "UTF-8"));
        }
        catch (IOException e) {
            this.scannerError("Cannot read " + fileName + "!");
        }
    }

    private void scannerError(String message) {
        String m = "Asp scanner error";
        if (this.curLineNum() > 0) {
            m = m + " on line " + this.curLineNum();
        }
        m = m + ": " + message;
        Main.error(m);
    }

    public Token curToken() {
        while (this.curLineTokens.isEmpty()) {
            this.readNextLine();
        }
        return this.curLineTokens.get(0);
    }

    public void readNextToken() {
        if (!this.curLineTokens.isEmpty()) {
            this.curLineTokens.remove(0);
        }
    }

    private void readNextLine() {
        this.curLineTokens.clear();
        String line = null;
        try {
            line = this.sourceFile.readLine();
            if (line == null) {
                this.sourceFile.close();
                this.sourceFile = null;
            } else {
                Main.log.noteSourceLine(this.curLineNum(), line);
            }
        }
        catch (IOException e) {
            this.sourceFile = null;
            this.scannerError("Unspecified I/O error!");
        }
        if (line == null) {
            Iterator<Object> e = this.indents.iterator();
            while (e.hasNext()) {
                int n = (Integer)e.next();
                if (n <= 0) continue;
                this.curLineTokens.add(new Token(TokenKind.dedentToken, this.curLineNum()));
            }
            this.curLineTokens.add(new Token(TokenKind.eofToken, this.curLineNum()));
            for (Token t : this.curLineTokens) {
                Main.log.noteToken(t);
            }
            return;
        }
        if ((line = this.expandLeadingTabs(line)) == "" || line.charAt(0) == '#') {
            return;
        }
        this.determineIndentLevel(line);
        char[] lineChars = line.toCharArray();
        int i = 0;
        while (i < lineChars.length) {
            if (lineChars[i] == ' ') {
                ++i;
                continue;
            }
            if (lineChars[i] == '#') break;
            i = this.isLetterAZ(lineChars[i]) ? this.handleName(lineChars, i) : (this.isDigit(lineChars[i]) ? this.handleNumber(lineChars, i) : (lineChars[i] == '\"' || lineChars[i] == '\'' ? this.handleStringLiteral(lineChars, i) : this.checkDelimitersAndOperators(lineChars, i)));
            ++i;
        }
        if (this.curLineTokens.isEmpty()) {
            return;
        }
        this.curLineTokens.add(new Token(TokenKind.newLineToken, this.curLineNum()));
        for (Token t : this.curLineTokens) {
            Main.log.noteToken(t);
        }
    }

    private int checkDelimitersAndOperators(char[] lineChars, int i) {
        Token token = new Token(TokenKind.nameToken, this.curLineNum());
        token.name = "" + lineChars[i];
        for (TokenKind tk : EnumSet.range(TokenKind.astToken, TokenKind.semicolonToken)) {
            if (i + 1 >= lineChars.length || !(token.name + lineChars[i + 1]).equals(tk.image)) continue;
            token.kind = tk;
            this.curLineTokens.add(token);
            int n = ++i;
            ++i;
            return n;
        }
        for (TokenKind tk : EnumSet.range(TokenKind.astToken, TokenKind.semicolonToken)) {
            if (!token.name.equals(tk.image)) continue;
            token.kind = tk;
            this.curLineTokens.add(token);
            return i;
        }
        if (token.kind == TokenKind.nameToken) {
            String error = "Illegal character: '" + lineChars[i] + "'!";
            this.scannerError(error);
        }
        return i;
    }

    private int handleNumber(char[] lineChars, int i) {
        Token token;
        String error;
        String number = "";
        char start = lineChars[i];
        int startindex = i;
        do {
            if (lineChars[i] == '.' && number.contains(".")) {
                error = "Illegal float literal: " + number + "!";
                this.scannerError(error);
            }
            number = number + lineChars[i];
        } while ((++i < lineChars.length && this.isDigit(lineChars[i]) && (start != '0' || number.contains(".")) || i + 1 < lineChars.length && lineChars[i] == '.' && this.isDigit(lineChars[i + 1])) && i < lineChars.length);
        if (i < lineChars.length && lineChars[i] == '.') {
            number = number + lineChars[i];
        }
        if (number.endsWith(".")) {
            error = "Illegal float literal: " + number + "!";
            this.scannerError(error);
        }
        if (number.contains(".")) {
            token = new Token(TokenKind.floatToken, this.curLineNum());
            token.floatLit = Double.parseDouble(number);
        } else {
            token = new Token(TokenKind.integerToken, this.curLineNum());
            token.integerLit = Long.parseLong(number);
        }
        this.curLineTokens.add(token);
        return startindex + number.length() - 1;
    }

    private int handleName(char[] lineChars, int i) {
        String word = "";
        while (i < lineChars.length && (this.isLetterAZ(lineChars[i]) || this.isDigit(lineChars[i]))) {
            word = word + lineChars[i];
            ++i;
        }
        Token token = new Token(TokenKind.nameToken, this.curLineNum());
        token.name = word;
        token.checkResWords();
        this.curLineTokens.add(token);
        return --i;
    }

    private int handleStringLiteral(char[] lineChars, int i) {
        char start = lineChars[i];
        if (++i >= lineChars.length) {
            this.scannerError("String literal not terminated!");
        }
        String string = "";
        while (i < lineChars.length && lineChars[i] != start) {
            string = string + lineChars[i];
            ++i;
        }
        if (i >= lineChars.length && lineChars[i - 1] != start) {
            this.scannerError("String literal not terminated!");
        }
        Token token = new Token(TokenKind.stringToken, this.curLineNum());
        token.stringLit = string;
        this.curLineTokens.add(token);
        return i;
    }

    private void determineIndentLevel(String line) {
        int n = this.findIndent(line);
        if (n == line.length() || line.charAt(n) == '#') {
            return;
        }
        if (n > this.indents.peek()) {
            this.indents.push(n);
            this.curLineTokens.add(new Token(TokenKind.indentToken, this.curLineNum()));
        }
        while (n < this.indents.peek()) {
            this.indents.pop();
            this.curLineTokens.add(new Token(TokenKind.dedentToken, this.curLineNum()));
        }
        if (n != this.indents.peek()) {
            this.scannerError("Indentation error!");
        }
    }

    public int curLineNum() {
        return this.sourceFile != null ? this.sourceFile.getLineNumber() : 0;
    }

    private int findIndent(String s) {
        int indent;
        for (indent = 0; indent < s.length() && s.charAt(indent) == ' '; ++indent) {
        }
        return indent;
    }

    private String expandLeadingTabs(String s) {
        String newS = "";
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\t') {
                while ((newS = newS + " ").length() % 4 > 0) {
                }
                continue;
            }
            if (c == ' ') {
                newS = newS + " ";
                continue;
            }
            newS = newS + s.substring(i);
            break;
        }
        return newS;
    }

    private boolean isLetterAZ(char c) {
        return 'A' <= c && c <= 'Z' || 'a' <= c && c <= 'z' || c == '_';
    }

    private boolean isDigit(char c) {
        return '0' <= c && c <= '9';
    }

    public boolean isCompOpr() {
        TokenKind k = this.curToken().kind;
        return false;
    }

    public boolean isFactorPrefix() {
        TokenKind k = this.curToken().kind;
        return false;
    }

    public boolean isFactorOpr() {
        TokenKind k = this.curToken().kind;
        return false;
    }

    public boolean isTermOpr() {
        TokenKind k = this.curToken().kind;
        return false;
    }

    public boolean anyEqualToken() {
        for (Token t : this.curLineTokens) {
            if (t.kind == TokenKind.equalToken) {
                return true;
            }
            if (t.kind != TokenKind.semicolonToken) continue;
            return false;
        }
        return false;
    }
}

