/*
 * Decompiled with CFR 0.152.
 */
package no.uio.ifi.asp.runtime;

import java.util.ArrayList;
import no.uio.ifi.asp.main.Main;
import no.uio.ifi.asp.parser.AspSyntax;

public abstract class RuntimeValue {
    protected abstract String typeName();

    public String showInfo() {
        return this.toString();
    }

    public boolean getBoolValue(String what, AspSyntax where) {
        RuntimeValue.runtimeError("Type error: " + what + " is not a Boolean!", where);
        return false;
    }

    public double getFloatValue(String what, AspSyntax where) {
        RuntimeValue.runtimeError("Type error: " + what + " is not a float!", where);
        return 0.0;
    }

    public long getIntValue(String what, AspSyntax where) {
        RuntimeValue.runtimeError("Type error: " + what + " is not an integer!", where);
        return 0L;
    }

    public String getStringValue(String what, AspSyntax where) {
        RuntimeValue.runtimeError("Type error: " + what + " is not a text string!", where);
        return null;
    }

    public RuntimeValue evalAdd(RuntimeValue v, AspSyntax where) {
        RuntimeValue.runtimeError("'+' undefined for " + this.typeName() + "!", where);
        return null;
    }

    public RuntimeValue evalDivide(RuntimeValue v, AspSyntax where) {
        RuntimeValue.runtimeError("'/' undefined for " + this.typeName() + "!", where);
        return null;
    }

    public RuntimeValue evalEqual(RuntimeValue v, AspSyntax where) {
        RuntimeValue.runtimeError("'==' undefined for " + this.typeName() + "!", where);
        return null;
    }

    public RuntimeValue evalGreater(RuntimeValue v, AspSyntax where) {
        RuntimeValue.runtimeError("'>' undefined for " + this.typeName() + "!", where);
        return null;
    }

    public RuntimeValue evalGreaterEqual(RuntimeValue v, AspSyntax where) {
        RuntimeValue.runtimeError("'>=' undefined for " + this.typeName() + "!", where);
        return null;
    }

    public RuntimeValue evalIntDivide(RuntimeValue v, AspSyntax where) {
        RuntimeValue.runtimeError("'//' undefined for " + this.typeName() + "!", where);
        return null;
    }

    public RuntimeValue evalLen(AspSyntax where) {
        RuntimeValue.runtimeError("'len' undefined for " + this.typeName() + "!", where);
        return null;
    }

    public RuntimeValue evalLess(RuntimeValue v, AspSyntax where) {
        RuntimeValue.runtimeError("'<' undefined for " + this.typeName() + "!", where);
        return null;
    }

    public RuntimeValue evalLessEqual(RuntimeValue v, AspSyntax where) {
        RuntimeValue.runtimeError("'<=' undefined for " + this.typeName() + "!", where);
        return null;
    }

    public RuntimeValue evalModulo(RuntimeValue v, AspSyntax where) {
        RuntimeValue.runtimeError("'%' undefined for " + this.typeName() + "!", where);
        return null;
    }

    public RuntimeValue evalMultiply(RuntimeValue v, AspSyntax where) {
        RuntimeValue.runtimeError("'*' undefined for " + this.typeName() + "!", where);
        return null;
    }

    public RuntimeValue evalNegate(AspSyntax where) {
        RuntimeValue.runtimeError("Unary '-' undefined for " + this.typeName() + "!", where);
        return null;
    }

    public RuntimeValue evalNot(AspSyntax where) {
        RuntimeValue.runtimeError("'not' undefined for " + this.typeName() + "!", where);
        return null;
    }

    public RuntimeValue evalNotEqual(RuntimeValue v, AspSyntax where) {
        RuntimeValue.runtimeError("'!=' undefined for " + this.typeName() + "!", where);
        return null;
    }

    public RuntimeValue evalPositive(AspSyntax where) {
        RuntimeValue.runtimeError("Unary '+' undefined for " + this.typeName() + "!", where);
        return null;
    }

    public RuntimeValue evalSubscription(RuntimeValue v, AspSyntax where) {
        RuntimeValue.runtimeError("Subscription '[...]' undefined for " + this.typeName() + "!", where);
        return null;
    }

    public RuntimeValue evalSubtract(RuntimeValue v, AspSyntax where) {
        RuntimeValue.runtimeError("'-' undefined for " + this.typeName() + "!", where);
        return null;
    }

    public static void runtimeError(String message, int lNum) {
        Main.error("Asp runtime error on line " + lNum + ": " + message);
    }

    public static void runtimeError(String message, AspSyntax where) {
        RuntimeValue.runtimeError(message, where.lineNum);
    }

    public void evalAssignElem(RuntimeValue inx, RuntimeValue val, AspSyntax where) {
        RuntimeValue.runtimeError("Assigning to an element not allowed for " + this.typeName() + "!", where);
    }

    public RuntimeValue evalFuncCall(ArrayList<RuntimeValue> actualParams, AspSyntax where) {
        RuntimeValue.runtimeError("'Function call (...)' undefined for " + this.typeName() + "!", where);
        return null;
    }
}

