/*
 * Decompiled with CFR 0.152.
 */
package no.uio.ifi.asp.runtime;

import no.uio.ifi.asp.parser.AspSyntax;
import no.uio.ifi.asp.runtime.RuntimeBoolValue;
import no.uio.ifi.asp.runtime.RuntimeIntValue;
import no.uio.ifi.asp.runtime.RuntimeNoneValue;
import no.uio.ifi.asp.runtime.RuntimeValue;

public class RuntimeStringValue
extends RuntimeValue {
    String stringValue;

    public RuntimeStringValue(String v) {
        this.stringValue = v;
    }

    @Override
    protected String typeName() {
        return "string";
    }

    public String toString() {
        return this.stringValue;
    }

    @Override
    public String showInfo() {
        return "'" + this.stringValue + "'";
    }

    @Override
    public long getIntValue(String what, AspSyntax where) {
        try {
            long l = Long.parseLong(this.stringValue);
            return l;
        }
        catch (NumberFormatException e) {
            RuntimeStringValue.runtimeError("Cannot convert '" + this.stringValue + "' to " + what, where);
            return 0L;
        }
    }

    @Override
    public double getFloatValue(String what, AspSyntax where) {
        try {
            double d = Double.parseDouble(this.stringValue);
            return d;
        }
        catch (NumberFormatException e) {
            RuntimeStringValue.runtimeError("Cannot convert '" + this.stringValue + "' to " + what, where);
            return 0.0;
        }
    }

    @Override
    public RuntimeValue evalLen(AspSyntax where) {
        RuntimeIntValue v = new RuntimeIntValue(this.stringValue.length());
        return v;
    }

    @Override
    public boolean getBoolValue(String what, AspSyntax where) {
        return this.stringValue != "";
    }

    @Override
    public RuntimeValue evalNot(AspSyntax where) {
        return new RuntimeBoolValue(this.stringValue == "");
    }

    @Override
    public RuntimeValue evalAdd(RuntimeValue v, AspSyntax where) {
        if (v instanceof RuntimeStringValue) {
            return new RuntimeStringValue(this.stringValue + v.toString());
        }
        RuntimeStringValue.runtimeError("Type error for +.", where);
        return null;
    }

    @Override
    public RuntimeValue evalMultiply(RuntimeValue v, AspSyntax where) {
        if (v instanceof RuntimeIntValue) {
            String retString = "";
            long v2 = v.getIntValue(" operand", where);
            int i = 0;
            while ((long)i < v2) {
                retString = retString + this.stringValue;
                ++i;
            }
            return new RuntimeStringValue(retString);
        }
        RuntimeStringValue.runtimeError("Type error for *.", where);
        return null;
    }

    @Override
    public RuntimeValue evalLess(RuntimeValue v, AspSyntax where) {
        if (v instanceof RuntimeStringValue) {
            return new RuntimeBoolValue(this.stringValue.compareTo(v.toString()) < 0);
        }
        RuntimeStringValue.runtimeError("Type error for <.", where);
        return null;
    }

    @Override
    public RuntimeValue evalGreater(RuntimeValue v, AspSyntax where) {
        if (v instanceof RuntimeStringValue) {
            return new RuntimeBoolValue(this.stringValue.compareTo(v.toString()) > 0);
        }
        RuntimeStringValue.runtimeError("Type error for >.", where);
        return null;
    }

    @Override
    public RuntimeValue evalEqual(RuntimeValue v, AspSyntax where) {
        if (v instanceof RuntimeStringValue) {
            return new RuntimeBoolValue(this.stringValue.equals(v.toString()));
        }
        if (v instanceof RuntimeNoneValue) {
            return new RuntimeBoolValue(false);
        }
        RuntimeStringValue.runtimeError("Type error for ==.", where);
        return null;
    }

    @Override
    public RuntimeValue evalGreaterEqual(RuntimeValue v, AspSyntax where) {
        if (v instanceof RuntimeStringValue) {
            return new RuntimeBoolValue(this.stringValue.compareTo(v.toString()) >= 0);
        }
        RuntimeStringValue.runtimeError("Type error for >=.", where);
        return null;
    }

    @Override
    public RuntimeValue evalLessEqual(RuntimeValue v, AspSyntax where) {
        if (v instanceof RuntimeStringValue) {
            return new RuntimeBoolValue(this.stringValue.compareTo(v.toString()) <= 0);
        }
        RuntimeStringValue.runtimeError("Type error for <=.", where);
        return null;
    }

    @Override
    public RuntimeValue evalNotEqual(RuntimeValue v, AspSyntax where) {
        if (v instanceof RuntimeStringValue) {
            return new RuntimeBoolValue(this.stringValue != v.toString());
        }
        if (v instanceof RuntimeNoneValue) {
            return new RuntimeBoolValue(true);
        }
        RuntimeStringValue.runtimeError("Type error for !=.", where);
        return null;
    }
}

