/*
 * Decompiled with CFR 0.152.
 */
package no.uio.ifi.asp.runtime;

import java.util.ArrayList;
import no.uio.ifi.asp.parser.AspSyntax;
import no.uio.ifi.asp.runtime.RuntimeBoolValue;
import no.uio.ifi.asp.runtime.RuntimeIntValue;
import no.uio.ifi.asp.runtime.RuntimeNoneValue;
import no.uio.ifi.asp.runtime.RuntimeValue;

public class RuntimeListValue
extends RuntimeValue {
    public ArrayList<RuntimeValue> list = new ArrayList();

    public RuntimeListValue(ArrayList<RuntimeValue> list) {
        this.list = list;
    }

    @Override
    protected String typeName() {
        return "list";
    }

    public String toString() {
        return this.list.toString();
    }

    @Override
    public String showInfo() {
        String retStr = "[";
        Boolean b = false;
        for (RuntimeValue v : this.list) {
            if (b.booleanValue()) {
                retStr = retStr + ", ";
            }
            retStr = retStr + v.showInfo();
            b = true;
        }
        retStr = retStr + "]";
        return retStr;
    }

    @Override
    public RuntimeValue evalLen(AspSyntax where) {
        RuntimeIntValue v = new RuntimeIntValue(this.list.size());
        return v;
    }

    @Override
    public RuntimeValue evalSubscription(RuntimeValue v, AspSyntax where) {
        if (v instanceof RuntimeIntValue) {
            RuntimeValue ret = this.list.get((int)v.getIntValue("[...] operand", where));
            return ret;
        }
        RuntimeListValue.runtimeError("A list index must be an integer!", where);
        return null;
    }

    @Override
    public RuntimeValue evalMultiply(RuntimeValue v, AspSyntax where) {
        if (v instanceof RuntimeIntValue) {
            ArrayList<RuntimeValue> retList = new ArrayList<RuntimeValue>();
            long v2 = v.getIntValue(" operand", where);
            int i = 0;
            while ((long)i < v2) {
                retList.addAll(this.list);
                ++i;
            }
            return new RuntimeListValue(retList);
        }
        RuntimeListValue.runtimeError("Type error for *.", where);
        return null;
    }

    @Override
    public RuntimeValue evalEqual(RuntimeValue v, AspSyntax where) {
        if (v instanceof RuntimeNoneValue) {
            return new RuntimeBoolValue(false);
        }
        RuntimeListValue.runtimeError("Type error for ==.", where);
        return null;
    }

    @Override
    public RuntimeValue evalNotEqual(RuntimeValue v, AspSyntax where) {
        if (v instanceof RuntimeNoneValue) {
            return new RuntimeBoolValue(true);
        }
        RuntimeListValue.runtimeError("Type error for !=.", where);
        return null;
    }

    @Override
    public void evalAssignElem(RuntimeValue inx, RuntimeValue value, AspSyntax where) {
        int index;
        if (!(inx instanceof RuntimeIntValue)) {
            RuntimeListValue.runtimeError("Index is not an integer!", where);
        }
        if ((index = (int)inx.getIntValue("integer", where)) < this.list.size()) {
            this.list.set(index, value);
        } else {
            RuntimeListValue.runtimeError("Index out of bounds.", where);
        }
    }
}

