/*
 * Decompiled with CFR 0.152.
 */
package no.uio.ifi.asp.runtime;

import java.util.ArrayList;
import java.util.Scanner;
import no.uio.ifi.asp.parser.AspSyntax;
import no.uio.ifi.asp.runtime.RuntimeFloatValue;
import no.uio.ifi.asp.runtime.RuntimeFunc;
import no.uio.ifi.asp.runtime.RuntimeIntValue;
import no.uio.ifi.asp.runtime.RuntimeListValue;
import no.uio.ifi.asp.runtime.RuntimeNoneValue;
import no.uio.ifi.asp.runtime.RuntimeScope;
import no.uio.ifi.asp.runtime.RuntimeStringValue;
import no.uio.ifi.asp.runtime.RuntimeValue;

public class RuntimeLibrary
extends RuntimeScope {
    private Scanner keyboard = new Scanner(System.in);

    public RuntimeLibrary() {
        this.assign("len", new RuntimeFunc("len"){

            @Override
            public RuntimeValue evalFuncCall(ArrayList<RuntimeValue> actualParams, AspSyntax where) {
                RuntimeLibrary.this.checkNumParams(actualParams, 1, "len", where);
                return actualParams.get(0).evalLen(where);
            }
        });
        this.assign("print", new RuntimeFunc("print"){

            @Override
            public RuntimeValue evalFuncCall(ArrayList<RuntimeValue> actualParams, AspSyntax where) {
                for (int i = 0; i < actualParams.size(); ++i) {
                    if (i > 0) {
                        System.out.print(" ");
                    }
                    System.out.print(actualParams.get(i).toString());
                }
                System.out.println();
                return new RuntimeNoneValue();
            }
        });
        this.assign("input", new RuntimeFunc("input"){

            @Override
            public RuntimeValue evalFuncCall(ArrayList<RuntimeValue> actualParams, AspSyntax where) {
                RuntimeLibrary.this.checkNumParams(actualParams, 1, "input", where);
                System.out.println(actualParams.get(0).toString());
                String input = RuntimeLibrary.this.keyboard.nextLine();
                RuntimeStringValue v = new RuntimeStringValue(input);
                return v;
            }
        });
        this.assign("float", new RuntimeFunc("float"){

            @Override
            public RuntimeValue evalFuncCall(ArrayList<RuntimeValue> actualParams, AspSyntax where) {
                RuntimeLibrary.this.checkNumParams(actualParams, 1, "float", where);
                Double d = actualParams.get(0).getFloatValue("float", where);
                RuntimeFloatValue v = new RuntimeFloatValue(d);
                return v;
            }
        });
        this.assign("int", new RuntimeFunc("int"){

            @Override
            public RuntimeValue evalFuncCall(ArrayList<RuntimeValue> actualParams, AspSyntax where) {
                RuntimeLibrary.this.checkNumParams(actualParams, 1, "int", where);
                long l = actualParams.get(0).getIntValue("int", where);
                RuntimeIntValue v = new RuntimeIntValue(l);
                return v;
            }
        });
        this.assign("str", new RuntimeFunc("str"){

            @Override
            public RuntimeValue evalFuncCall(ArrayList<RuntimeValue> actualParams, AspSyntax where) {
                RuntimeLibrary.this.checkNumParams(actualParams, 1, "str", where);
                String s = actualParams.get(0).toString();
                RuntimeStringValue v = new RuntimeStringValue(s);
                return v;
            }
        });
        this.assign("range", new RuntimeFunc("range"){

            @Override
            public RuntimeValue evalFuncCall(ArrayList<RuntimeValue> actualParams, AspSyntax where) {
                RuntimeLibrary.this.checkNumParams(actualParams, 2, "range", where);
                ArrayList<RuntimeValue> numbers = new ArrayList<RuntimeValue>();
                long start = actualParams.get(0).getIntValue("int", where);
                long end = actualParams.get(1).getIntValue("int", where);
                for (long i = start; i < end; ++i) {
                    RuntimeIntValue v = new RuntimeIntValue(i);
                    numbers.add(v);
                }
                RuntimeListValue list = new RuntimeListValue(numbers);
                return list;
            }
        });
    }

    private void checkNumParams(ArrayList<RuntimeValue> actArgs, int nCorrect, String id, AspSyntax where) {
        if (actArgs.size() != nCorrect) {
            RuntimeValue.runtimeError("Wrong number of parameters to " + id + "!", where);
        }
    }
}

