/*
 * Decompiled with CFR 0.152.
 */
package no.uio.ifi.asp.runtime;

import no.uio.ifi.asp.parser.AspSyntax;
import no.uio.ifi.asp.runtime.RuntimeBoolValue;
import no.uio.ifi.asp.runtime.RuntimeFloatValue;
import no.uio.ifi.asp.runtime.RuntimeNoneValue;
import no.uio.ifi.asp.runtime.RuntimeValue;

public class RuntimeIntValue
extends RuntimeValue {
    long intValue;

    public RuntimeIntValue(long v) {
        this.intValue = v;
    }

    @Override
    protected String typeName() {
        return "long";
    }

    public String toString() {
        return "" + this.intValue;
    }

    @Override
    public boolean getBoolValue(String what, AspSyntax where) {
        return this.intValue != 0L;
    }

    @Override
    public long getIntValue(String what, AspSyntax where) {
        return this.intValue;
    }

    @Override
    public double getFloatValue(String what, AspSyntax where) {
        return this.intValue;
    }

    @Override
    public RuntimeValue evalNot(AspSyntax where) {
        return new RuntimeBoolValue(this.intValue == 0L);
    }

    @Override
    public RuntimeValue evalAdd(RuntimeValue v, AspSyntax where) {
        if (v instanceof RuntimeIntValue) {
            return new RuntimeIntValue(this.intValue + v.getIntValue("+ operand", where));
        }
        if (v instanceof RuntimeFloatValue) {
            return new RuntimeFloatValue((double)this.intValue + v.getFloatValue("+ operand", where));
        }
        RuntimeIntValue.runtimeError("Type error for +.", where);
        return null;
    }

    @Override
    public RuntimeValue evalSubtract(RuntimeValue v, AspSyntax where) {
        if (v instanceof RuntimeIntValue) {
            return new RuntimeIntValue(this.intValue - v.getIntValue("+ operand", where));
        }
        if (v instanceof RuntimeFloatValue) {
            return new RuntimeFloatValue((double)this.intValue - v.getFloatValue("+ operand", where));
        }
        RuntimeIntValue.runtimeError("Type error for -.", where);
        return null;
    }

    @Override
    public RuntimeValue evalNegate(AspSyntax where) {
        return new RuntimeIntValue(this.intValue * -1L);
    }

    @Override
    public RuntimeValue evalPositive(AspSyntax where) {
        return new RuntimeIntValue(this.intValue);
    }

    @Override
    public RuntimeValue evalMultiply(RuntimeValue v, AspSyntax where) {
        if (v instanceof RuntimeIntValue) {
            return new RuntimeIntValue(this.intValue * v.getIntValue("* operand", where));
        }
        if (v instanceof RuntimeFloatValue) {
            return new RuntimeFloatValue((double)this.intValue * v.getFloatValue("* operand", where));
        }
        RuntimeIntValue.runtimeError("Type error for *.", where);
        return null;
    }

    @Override
    public RuntimeValue evalDivide(RuntimeValue v, AspSyntax where) {
        if (v instanceof RuntimeIntValue) {
            return new RuntimeFloatValue((double)this.intValue / v.getFloatValue("/ operand", where));
        }
        if (v instanceof RuntimeFloatValue) {
            return new RuntimeFloatValue((double)this.intValue / v.getFloatValue("/ operand", where));
        }
        RuntimeIntValue.runtimeError("Type error for /.", where);
        return null;
    }

    @Override
    public RuntimeValue evalModulo(RuntimeValue v, AspSyntax where) {
        if (v instanceof RuntimeIntValue) {
            return new RuntimeIntValue(Math.floorMod(this.intValue, v.getIntValue("% operand", where)));
        }
        if (v instanceof RuntimeFloatValue) {
            return new RuntimeFloatValue((double)this.intValue - v.getFloatValue("- operand", where) * Math.floor((double)this.intValue / v.getFloatValue("/ operand", where)));
        }
        RuntimeIntValue.runtimeError("Type error for %.", where);
        return null;
    }

    @Override
    public RuntimeValue evalIntDivide(RuntimeValue v, AspSyntax where) {
        if (v instanceof RuntimeIntValue) {
            return new RuntimeIntValue(Math.floorDiv(this.intValue, v.getIntValue("// operand", where)));
        }
        if (v instanceof RuntimeFloatValue) {
            return new RuntimeFloatValue(Math.floor((double)this.intValue / v.getFloatValue("/ operand", where)));
        }
        RuntimeIntValue.runtimeError("Type error for //.", where);
        return null;
    }

    @Override
    public RuntimeValue evalLess(RuntimeValue v, AspSyntax where) {
        if (v instanceof RuntimeIntValue) {
            return new RuntimeBoolValue(this.intValue < v.getIntValue("< operand", where));
        }
        if (v instanceof RuntimeFloatValue) {
            return new RuntimeBoolValue((double)this.intValue < v.getFloatValue("< operand", where));
        }
        RuntimeIntValue.runtimeError("Type error for <.", where);
        return null;
    }

    @Override
    public RuntimeValue evalGreater(RuntimeValue v, AspSyntax where) {
        if (v instanceof RuntimeIntValue) {
            return new RuntimeBoolValue(this.intValue > v.getIntValue("> operand", where));
        }
        if (v instanceof RuntimeFloatValue) {
            return new RuntimeBoolValue((double)this.intValue > v.getFloatValue("> operand", where));
        }
        RuntimeIntValue.runtimeError("Type error for >.", where);
        return null;
    }

    @Override
    public RuntimeValue evalEqual(RuntimeValue v, AspSyntax where) {
        if (v instanceof RuntimeIntValue) {
            return new RuntimeBoolValue(this.intValue == v.getIntValue("== operand", where));
        }
        if (v instanceof RuntimeFloatValue) {
            return new RuntimeBoolValue((double)this.intValue == v.getFloatValue("== operand", where));
        }
        if (v instanceof RuntimeNoneValue) {
            return new RuntimeBoolValue(false);
        }
        RuntimeIntValue.runtimeError("Type error for ==.", where);
        return null;
    }

    @Override
    public RuntimeValue evalGreaterEqual(RuntimeValue v, AspSyntax where) {
        if (v instanceof RuntimeIntValue) {
            return new RuntimeBoolValue(this.intValue >= v.getIntValue(">= operand", where));
        }
        if (v instanceof RuntimeFloatValue) {
            return new RuntimeBoolValue((double)this.intValue >= v.getFloatValue(">= operand", where));
        }
        RuntimeIntValue.runtimeError("Type error for >=.", where);
        return null;
    }

    @Override
    public RuntimeValue evalLessEqual(RuntimeValue v, AspSyntax where) {
        if (v instanceof RuntimeIntValue) {
            return new RuntimeBoolValue(this.intValue <= v.getIntValue("<= operand", where));
        }
        if (v instanceof RuntimeFloatValue) {
            return new RuntimeBoolValue((double)this.intValue <= v.getFloatValue("<= operand", where));
        }
        RuntimeIntValue.runtimeError("Type error for <=.", where);
        return null;
    }

    @Override
    public RuntimeValue evalNotEqual(RuntimeValue v, AspSyntax where) {
        if (v instanceof RuntimeIntValue) {
            return new RuntimeBoolValue(this.intValue != v.getIntValue("!= operand", where));
        }
        if (v instanceof RuntimeFloatValue) {
            return new RuntimeBoolValue((double)this.intValue != v.getFloatValue("!= operand", where));
        }
        RuntimeIntValue.runtimeError("Type error for !=.", where);
        return null;
    }
}

