/*
 * Decompiled with CFR 0.152.
 */
package no.uio.ifi.asp.runtime;

import java.util.ArrayList;
import no.uio.ifi.asp.parser.AspFuncDef;
import no.uio.ifi.asp.parser.AspSyntax;
import no.uio.ifi.asp.runtime.RuntimeNoneValue;
import no.uio.ifi.asp.runtime.RuntimeReturnValue;
import no.uio.ifi.asp.runtime.RuntimeScope;
import no.uio.ifi.asp.runtime.RuntimeValue;

public class RuntimeFunc
extends RuntimeValue {
    AspFuncDef def;
    RuntimeScope defScope;
    String name;

    public RuntimeFunc(String s) {
        this.name = s;
    }

    public RuntimeFunc(AspFuncDef def, RuntimeScope defScope) {
        this.name = def.aNameList.get((int)0).name;
        this.def = def;
        this.defScope = defScope;
    }

    public String toString() {
        return this.name;
    }

    @Override
    protected String typeName() {
        return "func";
    }

    @Override
    public RuntimeValue evalFuncCall(ArrayList<RuntimeValue> actualParams, AspSyntax where) {
        if (this.def.aNameList.size() - 1 != actualParams.size()) {
            RuntimeFunc.runtimeError("Wrong number of parameters calling " + this.name, where);
        }
        RuntimeScope scope = new RuntimeScope(this.defScope);
        for (int i = 1; i < this.def.aNameList.size(); ++i) {
            scope.assign(this.def.aNameList.get((int)i).name, actualParams.get(i - 1));
        }
        try {
            this.def.aSuite.eval(scope);
        }
        catch (RuntimeReturnValue rrv) {
            return rrv.value;
        }
        return new RuntimeNoneValue();
    }
}

