/*
 * Decompiled with CFR 0.152.
 */
package no.uio.ifi.asp.runtime;

import no.uio.ifi.asp.parser.AspSyntax;
import no.uio.ifi.asp.runtime.RuntimeBoolValue;
import no.uio.ifi.asp.runtime.RuntimeIntValue;
import no.uio.ifi.asp.runtime.RuntimeNoneValue;
import no.uio.ifi.asp.runtime.RuntimeValue;

public class RuntimeFloatValue
extends RuntimeValue {
    double floatValue;

    public RuntimeFloatValue(double v) {
        this.floatValue = v;
    }

    @Override
    protected String typeName() {
        return "double";
    }

    public String toString() {
        return "" + this.floatValue;
    }

    @Override
    public boolean getBoolValue(String what, AspSyntax where) {
        return this.floatValue != 0.0;
    }

    @Override
    public double getFloatValue(String what, AspSyntax where) {
        return this.floatValue;
    }

    @Override
    public long getIntValue(String what, AspSyntax where) {
        return (long)this.floatValue;
    }

    @Override
    public RuntimeValue evalNot(AspSyntax where) {
        return new RuntimeBoolValue(this.floatValue == 0.0);
    }

    @Override
    public RuntimeValue evalAdd(RuntimeValue v, AspSyntax where) {
        if (v instanceof RuntimeIntValue) {
            return new RuntimeFloatValue(this.floatValue + (double)v.getIntValue("+ operand", where));
        }
        if (v instanceof RuntimeFloatValue) {
            return new RuntimeFloatValue(this.floatValue + v.getFloatValue("+ operand", where));
        }
        RuntimeFloatValue.runtimeError("Type error for +.", where);
        return null;
    }

    @Override
    public RuntimeValue evalSubtract(RuntimeValue v, AspSyntax where) {
        if (v instanceof RuntimeIntValue) {
            return new RuntimeFloatValue(this.floatValue - (double)v.getIntValue("- operand", where));
        }
        if (v instanceof RuntimeFloatValue) {
            return new RuntimeFloatValue(this.floatValue - v.getFloatValue("- operand", where));
        }
        RuntimeFloatValue.runtimeError("Type error for -.", where);
        return null;
    }

    @Override
    public RuntimeValue evalNegate(AspSyntax where) {
        return new RuntimeFloatValue(this.floatValue * -1.0);
    }

    @Override
    public RuntimeValue evalPositive(AspSyntax where) {
        return new RuntimeFloatValue(this.floatValue);
    }

    @Override
    public RuntimeValue evalMultiply(RuntimeValue v, AspSyntax where) {
        if (v instanceof RuntimeIntValue) {
            return new RuntimeFloatValue(this.floatValue * (double)v.getIntValue("* operand", where));
        }
        if (v instanceof RuntimeFloatValue) {
            return new RuntimeFloatValue(this.floatValue * v.getFloatValue("* operand", where));
        }
        RuntimeFloatValue.runtimeError("Type error for *.", where);
        return null;
    }

    @Override
    public RuntimeValue evalDivide(RuntimeValue v, AspSyntax where) {
        if (v instanceof RuntimeIntValue) {
            return new RuntimeFloatValue(this.floatValue / (double)v.getIntValue("/ operand", where));
        }
        if (v instanceof RuntimeFloatValue) {
            return new RuntimeFloatValue(this.floatValue / v.getFloatValue("/ operand", where));
        }
        RuntimeFloatValue.runtimeError("Type error for /.", where);
        return null;
    }

    @Override
    public RuntimeValue evalModulo(RuntimeValue v, AspSyntax where) {
        if (v instanceof RuntimeIntValue) {
            return new RuntimeFloatValue(this.floatValue - (double)v.getIntValue("- operand", where) * Math.floor(this.floatValue / (double)v.getIntValue("/ operand", where)));
        }
        if (v instanceof RuntimeFloatValue) {
            return new RuntimeFloatValue(this.floatValue - v.getFloatValue("- operand", where) * Math.floor(this.floatValue / v.getFloatValue("/ operand", where)));
        }
        RuntimeFloatValue.runtimeError("Type error for %.", where);
        return null;
    }

    @Override
    public RuntimeValue evalIntDivide(RuntimeValue v, AspSyntax where) {
        if (v instanceof RuntimeIntValue) {
            return new RuntimeFloatValue(Math.floor(this.floatValue / (double)v.getIntValue("/ operand", where)));
        }
        if (v instanceof RuntimeFloatValue) {
            return new RuntimeFloatValue(Math.floor(this.floatValue / v.getFloatValue("/ operand", where)));
        }
        RuntimeFloatValue.runtimeError("Type error for //.", where);
        return null;
    }

    @Override
    public RuntimeValue evalLess(RuntimeValue v, AspSyntax where) {
        if (v instanceof RuntimeIntValue) {
            return new RuntimeBoolValue(this.floatValue < (double)v.getIntValue("< operand", where));
        }
        if (v instanceof RuntimeFloatValue) {
            return new RuntimeBoolValue(this.floatValue < v.getFloatValue("< operand", where));
        }
        RuntimeFloatValue.runtimeError("Type error for <.", where);
        return null;
    }

    @Override
    public RuntimeValue evalGreater(RuntimeValue v, AspSyntax where) {
        if (v instanceof RuntimeIntValue) {
            return new RuntimeBoolValue(this.floatValue > (double)v.getIntValue("> operand", where));
        }
        if (v instanceof RuntimeFloatValue) {
            return new RuntimeBoolValue(this.floatValue > v.getFloatValue("> operand", where));
        }
        RuntimeFloatValue.runtimeError("Type error for >.", where);
        return null;
    }

    @Override
    public RuntimeValue evalEqual(RuntimeValue v, AspSyntax where) {
        if (v instanceof RuntimeIntValue) {
            return new RuntimeBoolValue(this.floatValue == (double)v.getIntValue("== operand", where));
        }
        if (v instanceof RuntimeFloatValue) {
            return new RuntimeBoolValue(this.floatValue == v.getFloatValue("== operand", where));
        }
        if (v instanceof RuntimeNoneValue) {
            return new RuntimeBoolValue(false);
        }
        RuntimeFloatValue.runtimeError("Type error for ==.", where);
        return null;
    }

    @Override
    public RuntimeValue evalGreaterEqual(RuntimeValue v, AspSyntax where) {
        if (v instanceof RuntimeIntValue) {
            return new RuntimeBoolValue(this.floatValue >= (double)v.getIntValue(">= operand", where));
        }
        if (v instanceof RuntimeFloatValue) {
            return new RuntimeBoolValue(this.floatValue >= v.getFloatValue(">= operand", where));
        }
        RuntimeFloatValue.runtimeError("Type error for >=.", where);
        return null;
    }

    @Override
    public RuntimeValue evalLessEqual(RuntimeValue v, AspSyntax where) {
        if (v instanceof RuntimeIntValue) {
            return new RuntimeBoolValue(this.floatValue <= (double)v.getIntValue("<= operand", where));
        }
        if (v instanceof RuntimeFloatValue) {
            return new RuntimeBoolValue(this.floatValue <= v.getFloatValue("<= operand", where));
        }
        RuntimeFloatValue.runtimeError("Type error for <=.", where);
        return null;
    }

    @Override
    public RuntimeValue evalNotEqual(RuntimeValue v, AspSyntax where) {
        if (v instanceof RuntimeIntValue) {
            return new RuntimeBoolValue(this.floatValue != (double)v.getIntValue("!= operand", where));
        }
        if (v instanceof RuntimeFloatValue) {
            return new RuntimeBoolValue(this.floatValue != v.getFloatValue("!= operand", where));
        }
        RuntimeFloatValue.runtimeError("Type error for !=.", where);
        return null;
    }
}

