/*
 * Decompiled with CFR 0.152.
 */
package no.uio.ifi.asp.runtime;

import java.util.HashMap;
import no.uio.ifi.asp.parser.AspSyntax;
import no.uio.ifi.asp.runtime.RuntimeBoolValue;
import no.uio.ifi.asp.runtime.RuntimeIntValue;
import no.uio.ifi.asp.runtime.RuntimeNoneValue;
import no.uio.ifi.asp.runtime.RuntimeStringValue;
import no.uio.ifi.asp.runtime.RuntimeValue;

public class RuntimeDictValue
extends RuntimeValue {
    HashMap<String, RuntimeValue> dict = new HashMap();

    public RuntimeDictValue(HashMap<String, RuntimeValue> dict) {
        this.dict = dict;
    }

    @Override
    protected String typeName() {
        return "dict";
    }

    public String toString() {
        return this.dict.toString();
    }

    @Override
    public RuntimeValue evalLen(AspSyntax where) {
        RuntimeIntValue v = new RuntimeIntValue(this.dict.size());
        return v;
    }

    @Override
    public RuntimeValue evalSubscription(RuntimeValue v, AspSyntax where) {
        if (v instanceof RuntimeStringValue) {
            RuntimeValue value = this.dict.get(v.toString());
            return value;
        }
        RuntimeDictValue.runtimeError("Type error for [...].", where);
        return null;
    }

    @Override
    public RuntimeValue evalEqual(RuntimeValue v, AspSyntax where) {
        if (v instanceof RuntimeNoneValue) {
            return new RuntimeBoolValue(false);
        }
        RuntimeDictValue.runtimeError("Type error for ==.", where);
        return null;
    }

    @Override
    public RuntimeValue evalNotEqual(RuntimeValue v, AspSyntax where) {
        if (v instanceof RuntimeNoneValue) {
            return new RuntimeBoolValue(true);
        }
        RuntimeDictValue.runtimeError("Type error for !=.", where);
        return null;
    }

    @Override
    public void evalAssignElem(RuntimeValue inx, RuntimeValue value, AspSyntax where) {
        if (!(inx instanceof RuntimeStringValue)) {
            RuntimeDictValue.runtimeError("Index is not an text string!", where);
        }
        String index = inx.toString();
        this.dict.put(index, value);
    }
}

