/*
 * Decompiled with CFR 0.152.
 */
package no.uio.ifi.asp.runtime;

import no.uio.ifi.asp.parser.AspSyntax;
import no.uio.ifi.asp.runtime.RuntimeNoneValue;
import no.uio.ifi.asp.runtime.RuntimeValue;

public class RuntimeBoolValue
extends RuntimeValue {
    boolean boolValue;

    public RuntimeBoolValue(boolean v) {
        this.boolValue = v;
    }

    @Override
    protected String typeName() {
        return "boolean";
    }

    public String toString() {
        return this.boolValue ? "True" : "False";
    }

    @Override
    public boolean getBoolValue(String what, AspSyntax where) {
        return this.boolValue;
    }

    @Override
    public RuntimeValue evalEqual(RuntimeValue v, AspSyntax where) {
        if (v instanceof RuntimeNoneValue) {
            return new RuntimeBoolValue(false);
        }
        RuntimeBoolValue.runtimeError("Type error for ==.", where);
        return null;
    }

    @Override
    public RuntimeValue evalNot(AspSyntax where) {
        return new RuntimeBoolValue(!this.boolValue);
    }

    @Override
    public RuntimeValue evalNotEqual(RuntimeValue v, AspSyntax where) {
        if (v instanceof RuntimeNoneValue) {
            return new RuntimeBoolValue(true);
        }
        RuntimeBoolValue.runtimeError("Type error for !=.", where);
        return null;
    }
}

