/*
 * Decompiled with CFR 0.152.
 */
package no.uio.ifi.asp.parser;

import no.uio.ifi.asp.parser.AspCompoundStmt;
import no.uio.ifi.asp.parser.AspExpr;
import no.uio.ifi.asp.parser.AspName;
import no.uio.ifi.asp.parser.AspSuite;
import no.uio.ifi.asp.runtime.RuntimeListValue;
import no.uio.ifi.asp.runtime.RuntimeReturnValue;
import no.uio.ifi.asp.runtime.RuntimeScope;
import no.uio.ifi.asp.runtime.RuntimeValue;
import no.uio.ifi.asp.scanner.Scanner;
import no.uio.ifi.asp.scanner.TokenKind;

public class AspForStmt
extends AspCompoundStmt {
    AspName aName;
    AspExpr aExpr;
    AspSuite aSuite;

    public AspForStmt(int n) {
        super(n);
    }

    public static AspForStmt parse(Scanner s) {
        AspForStmt.enterParser("for stmt");
        AspForStmt forstmt = new AspForStmt(s.curLineNum());
        AspForStmt.skip(s, TokenKind.forToken);
        forstmt.aName = AspName.parse(s);
        AspForStmt.skip(s, TokenKind.inToken);
        forstmt.aExpr = AspExpr.parse(s);
        AspForStmt.skip(s, TokenKind.colonToken);
        forstmt.aSuite = AspSuite.parse(s);
        AspForStmt.leaveParser("for stmt");
        return forstmt;
    }

    @Override
    public void prettyPrint() {
        AspForStmt.prettyWrite("for ");
        this.aName.prettyPrint();
        AspForStmt.prettyWrite(" in ");
        this.aExpr.prettyPrint();
        AspForStmt.prettyWrite(":");
        this.aSuite.prettyPrint();
    }

    @Override
    public RuntimeValue eval(RuntimeScope curScope) throws RuntimeReturnValue {
        RuntimeListValue v = null;
        try {
            v = (RuntimeListValue)this.aExpr.eval(curScope);
        }
        catch (ClassCastException e) {
            RuntimeValue.runtimeError("For loop range is not a list!", this);
        }
        int i = 1;
        for (RuntimeValue rv : v.list) {
            this.trace("for #" + i + ": " + this.aName.name + " = " + rv.showInfo());
            curScope.assign(this.aName.name, rv);
            this.aSuite.eval(curScope);
            ++i;
        }
        return v;
    }
}

