/*
 * Decompiled with CFR 0.152.
 */
package no.uio.ifi.asp.parser;

import java.util.ArrayList;
import no.uio.ifi.asp.parser.AspExpr;
import no.uio.ifi.asp.parser.AspName;
import no.uio.ifi.asp.parser.AspSmallStmt;
import no.uio.ifi.asp.parser.AspSubscription;
import no.uio.ifi.asp.runtime.RuntimeReturnValue;
import no.uio.ifi.asp.runtime.RuntimeScope;
import no.uio.ifi.asp.runtime.RuntimeValue;
import no.uio.ifi.asp.scanner.Scanner;
import no.uio.ifi.asp.scanner.TokenKind;

public class AspAssignment
extends AspSmallStmt {
    ArrayList<AspSubscription> aSubList = new ArrayList();
    AspName aname;
    AspExpr aexp;

    public AspAssignment(int n) {
        super(n);
    }

    public static AspAssignment parse(Scanner s) {
        AspAssignment.enterParser("assignment");
        AspAssignment aAssgn = new AspAssignment(s.curLineNum());
        aAssgn.aname = AspName.parse(s);
        while (s.curToken().kind == TokenKind.leftBracketToken) {
            aAssgn.aSubList.add(AspSubscription.parse(s));
        }
        AspAssignment.skip(s, TokenKind.equalToken);
        aAssgn.aexp = AspExpr.parse(s);
        AspAssignment.leaveParser("assignment");
        return aAssgn;
    }

    @Override
    public void prettyPrint() {
        this.aname.prettyPrint();
        for (AspSubscription as : this.aSubList) {
            as.prettyPrint();
        }
        AspAssignment.prettyWrite(" = ");
        this.aexp.prettyPrint();
    }

    @Override
    public RuntimeValue eval(RuntimeScope curScope) throws RuntimeReturnValue {
        RuntimeValue expr = this.aexp.eval(curScope);
        if (this.aSubList.size() != 0) {
            RuntimeValue list = this.aname.eval(curScope);
            RuntimeValue index = this.aSubList.get(0).eval(curScope);
            for (int i = 1; i < this.aSubList.size(); ++i) {
                list = list.evalSubscription(index, this);
                index = this.aSubList.get(i).eval(curScope);
            }
            this.trace(this.aname.name + "[" + index.showInfo() + "] = " + expr.showInfo());
            list.evalAssignElem(index, expr, this);
        } else {
            curScope.assign(this.aname.name, expr);
            this.trace(this.aname.name + " = " + expr.showInfo());
        }
        return expr;
    }
}

