/*
 * Decompiled with CFR 0.152.
 */
package no.uio.ifi.asp.main;

import no.uio.ifi.asp.main.LogFile;
import no.uio.ifi.asp.parser.AspExpr;
import no.uio.ifi.asp.parser.AspProgram;
import no.uio.ifi.asp.parser.AspSyntax;
import no.uio.ifi.asp.runtime.RuntimeLibrary;
import no.uio.ifi.asp.runtime.RuntimeReturnValue;
import no.uio.ifi.asp.runtime.RuntimeScope;
import no.uio.ifi.asp.runtime.RuntimeValue;
import no.uio.ifi.asp.scanner.Scanner;
import no.uio.ifi.asp.scanner.TokenKind;

public class Main {
    public static final String version = "2019-08-08";
    public static LogFile log = null;

    public static void main(String[] arg) {
        String fileName = null;
        String baseFilename = null;
        boolean testExpr = false;
        boolean testParser = false;
        boolean testScanner = false;
        boolean logE = false;
        boolean logP = false;
        boolean logS = false;
        boolean logY = false;
        System.out.println("This is the IN2030 Asp interpreter (2019-08-08)");
        System.out.println("Implemented by Rune Hille runehi@student.mn.uio.no and Enxhi Salaj enxhis@student.mn.uio.no");
        for (int i = 0; i < arg.length; ++i) {
            String a = arg[i];
            if (a.equals("-logE")) {
                logE = true;
                continue;
            }
            if (a.equals("-logP")) {
                logP = true;
                continue;
            }
            if (a.equals("-logS")) {
                logS = true;
                continue;
            }
            if (a.equals("-logY")) {
                logY = true;
                continue;
            }
            if (a.equals("-testexpr")) {
                testExpr = true;
                continue;
            }
            if (a.equals("-testparser")) {
                testParser = true;
                continue;
            }
            if (a.equals("-testscanner")) {
                testScanner = true;
                continue;
            }
            if (a.startsWith("-")) {
                Main.usage();
                continue;
            }
            if (fileName != null) {
                Main.usage();
                continue;
            }
            fileName = a;
        }
        if (fileName == null) {
            Main.usage();
        }
        if ((baseFilename = fileName).endsWith(".asp")) {
            baseFilename = baseFilename.substring(0, baseFilename.length() - 4);
        } else if (baseFilename.endsWith(".py")) {
            baseFilename = baseFilename.substring(0, baseFilename.length() - 3);
        }
        log = new LogFile(baseFilename + ".log");
        if (logE || testExpr) {
            Main.log.doLogEval = true;
        }
        if (logP || testParser) {
            Main.log.doLogParser = true;
        }
        if (logS || testScanner) {
            Main.log.doLogScanner = true;
        }
        if (logY || testExpr || testParser) {
            Main.log.doLogPrettyPrint = true;
        }
        Scanner s = new Scanner(fileName);
        if (testScanner) {
            Main.doTestScanner(s);
        } else if (testParser) {
            Main.doTestParser(s);
        } else if (testExpr) {
            Main.doTestExpr(s);
        } else {
            Main.doRunInterpreter(s);
        }
        if (log != null) {
            log.finish();
        }
        System.exit(0);
    }

    private static void doTestScanner(Scanner s) {
        do {
            s.readNextToken();
        } while (s.curToken().kind != TokenKind.eofToken);
    }

    private static void doTestParser(Scanner s) {
        AspProgram prog = AspProgram.parse(s);
        log.prettyWriteLn();
        prog.prettyPrint();
    }

    private static void doTestExpr(Scanner s) {
        RuntimeScope emptyScope = new RuntimeScope();
        while (s.curToken().kind != TokenKind.eofToken) {
            AspExpr e = AspExpr.parse(s);
            AspSyntax.skip(s, TokenKind.newLineToken);
            e.prettyPrint();
            log.prettyWriteLn(" ==>");
            try {
                RuntimeValue res = e.eval(emptyScope);
                log.traceEval(res.showInfo(), e);
            }
            catch (RuntimeReturnValue rrv) {
                Main.panic("Uncaught return exception!");
            }
        }
    }

    private static void doRunInterpreter(Scanner s) {
        AspProgram prog = AspProgram.parse(s);
        if (Main.log.doLogPrettyPrint) {
            log.prettyWriteLn();
            prog.prettyPrint();
        }
        RuntimeLibrary lib = new RuntimeLibrary();
        RuntimeScope globals = new RuntimeScope(lib);
        try {
            prog.eval(globals);
        }
        catch (RuntimeReturnValue rrv) {
            Main.panic("Uncaught return exception!");
        }
    }

    public static void error(String message) {
        System.out.println();
        System.err.println(message);
        if (log != null) {
            log.noteError(message);
        }
        System.exit(1);
    }

    public static void panic(String message, int lineNum) {
        String m = "*** ASP PANIC";
        if (lineNum > 0) {
            m = m + " ON LINE " + lineNum;
        }
        Main.error(m + " ***: " + message);
    }

    public static void panic(String message) {
        Main.panic(message, 0);
    }

    private static void usage() {
        Main.error("Usage: java -jar asp.jar [-log{E|P|S|Y}] [-test{expr|parser|scanner}] file");
    }
}

