/*
 * Decompiled with CFR 0.152.
 */
package no.uio.ifi.asp.main;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import no.uio.ifi.asp.main.Main;
import no.uio.ifi.asp.parser.AspSyntax;
import no.uio.ifi.asp.scanner.Token;

public class LogFile {
    public boolean doLogEval = false;
    public boolean doLogParser = false;
    public boolean doLogPrettyPrint = false;
    public boolean doLogScanner = false;
    private String logFileName;
    private int nLogLines = 0;
    private int parseLevel = 0;
    private String prettyLine = "";
    private int prettyIndentation = 0;

    public LogFile(String fname) {
        this.logFileName = fname;
    }

    public void finish() {
        if (this.prettyLine.length() > 0) {
            this.prettyWriteLn();
        }
    }

    private void writeLogLine(String data) {
        try {
            PrintWriter log = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.logFileName, this.nLogLines > 0), "UTF-8"));
            log.println(data);
            ++this.nLogLines;
            log.close();
        }
        catch (IOException e) {
            Main.error("Asp error: Cannot create log file " + this.logFileName + "!");
        }
    }

    public void noteError(String message) {
        if (this.nLogLines > 0) {
            this.writeLogLine(message);
        }
    }

    public void noteSourceLine(int lineNum, String line) {
        if (this.doLogParser || this.doLogScanner) {
            this.writeLogLine(String.format("%4d: %s", lineNum, line));
        }
    }

    public void noteToken(Token tok) {
        if (this.doLogScanner) {
            this.writeLogLine("Scanner: " + tok.showInfo());
        }
    }

    public void enterParser(String nonTerm) {
        this.writeParseInfo(nonTerm);
        ++this.parseLevel;
    }

    public void leaveParser(String nonTerm) {
        --this.parseLevel;
        this.writeParseInfo("/" + nonTerm);
    }

    private void writeParseInfo(String nonTerm) {
        if (!this.doLogParser) {
            return;
        }
        String indent = "";
        for (int i = 1; i <= this.parseLevel; ++i) {
            indent = indent + "  ";
        }
        this.writeLogLine(indent + "<" + nonTerm + ">");
    }

    public void traceEval(String message, AspSyntax what) {
        if (this.doLogEval) {
            this.writeLogLine("Trace line " + what.lineNum + ": " + message);
        }
    }

    public void prettyWrite(String s) {
        if (this.prettyLine.equals("")) {
            for (int i = 1; i <= this.prettyIndentation; ++i) {
                this.prettyLine = this.prettyLine + "  ";
            }
        }
        this.prettyLine = this.prettyLine + s;
    }

    public void prettyWriteLn(String s) {
        this.prettyWrite(s);
        this.prettyWriteLn();
    }

    public void prettyWriteLn() {
        if (this.doLogPrettyPrint) {
            this.writeLogLine(this.prettyLine);
        }
        this.prettyLine = "";
    }

    public void prettyIndent() {
        ++this.prettyIndentation;
    }

    public void prettyDedent() {
        --this.prettyIndentation;
    }
}

